/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers;

import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.BukkitCaptionKeys;
import com.minekube.connect.shadow.cloud.commandframework.captions.CaptionVariable;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.ParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MaterialArgument<C>
extends CommandArgument<C, Material> {
    protected MaterialArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new MaterialParser(), defaultValue, Material.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Material> of(@NonNull String name) {
        return MaterialArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Material> optional(@NonNull String name) {
        return MaterialArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Material> optional(@NonNull String name, @NonNull Material material) {
        return MaterialArgument.newBuilder(name).asOptionalWithDefault(material.name().toLowerCase()).build();
    }

    public static final class MaterialParser<C>
    implements ArgumentParser<C, Material> {
        @Override
        public @NonNull ArgumentParseResult<Material> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(MaterialParser.class, commandContext));
            }
            try {
                Material material = Material.valueOf((String)input.toUpperCase());
                inputQueue.remove();
                return ArgumentParseResult.success(material);
            }
            catch (IllegalArgumentException exception) {
                return ArgumentParseResult.failure(new MaterialParseException(input, commandContext));
            }
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> completions = new ArrayList<String>();
            for (Material value : Material.values()) {
                completions.add(value.name().toLowerCase());
            }
            return completions;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Material> {
        private Builder(@NonNull String name) {
            super(Material.class, name);
        }

        @Override
        public @NonNull CommandArgument<C, Material> build() {
            return new MaterialArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class MaterialParseException
    extends ParserException {
        private static final long serialVersionUID = 1615554107385965610L;
        private final String input;

        public MaterialParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(MaterialParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_MATERIAL, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

