/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.bukkit.internal;

import com.minekube.connect.shadow.cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import com.minekube.connect.shadow.com.google.common.annotations.Beta;
import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;

@Beta
public final class MinecraftArgumentTypes {
    private static final Constructor<?> MINECRAFT_KEY_CONSTRUCTOR;
    private static final Method ARGUMENT_REGISTRY_GET_BY_KEY_METHOD;
    private static final Field ARGUMENT_REGISTRY_ENTRY_CLASS_FIELD;

    private MinecraftArgumentTypes() {
    }

    public static Class<? extends ArgumentType<?>> getClassByKey(@NonNull NamespacedKey key) throws IllegalArgumentException {
        try {
            Object minecraftKey = MINECRAFT_KEY_CONSTRUCTOR.newInstance(key.getNamespace(), key.getKey());
            Object entry = ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.invoke(null, minecraftKey);
            if (entry == null) {
                throw new IllegalArgumentException(key.toString());
            }
            Class argument = (Class)ARGUMENT_REGISTRY_ENTRY_CLASS_FIELD.get(entry);
            return argument;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> argumentRegistry;
            Class<?> minecraftKey;
            if (CraftBukkitReflection.findMCClass("resources.ResourceLocation") != null) {
                minecraftKey = CraftBukkitReflection.needMCClass("resources.ResourceLocation");
                argumentRegistry = CraftBukkitReflection.needMCClass("commands.synchronization.ArgumentTypes");
            } else {
                minecraftKey = CraftBukkitReflection.needNMSClassOrElse("MinecraftKey", "net.minecraft.resources.MinecraftKey");
                argumentRegistry = CraftBukkitReflection.needNMSClassOrElse("ArgumentRegistry", "net.minecraft.commands.synchronization.ArgumentRegistry");
            }
            MINECRAFT_KEY_CONSTRUCTOR = minecraftKey.getConstructor(String.class, String.class);
            MINECRAFT_KEY_CONSTRUCTOR.setAccessible(true);
            ARGUMENT_REGISTRY_GET_BY_KEY_METHOD = Arrays.stream(argumentRegistry.getDeclaredMethods()).filter(method -> method.getParameterCount() == 1).filter(method -> minecraftKey.equals(method.getParameterTypes()[0])).findFirst().orElseThrow(NoSuchMethodException::new);
            ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.setAccessible(true);
            Class<?> argumentRegistryEntry = ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.getReturnType();
            ARGUMENT_REGISTRY_ENTRY_CLASS_FIELD = Arrays.stream(argumentRegistryEntry.getDeclaredFields()).filter(field -> field.getType() == Class.class).findFirst().orElseThrow(NoSuchFieldException::new);
            ARGUMENT_REGISTRY_ENTRY_CLASS_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

