/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.bukkit;

import com.minekube.connect.shadow.cloud.commandframework.Command;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.StaticArgument;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.BukkitCommand;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.BukkitCommandManager;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.CloudCommodoreManager;
import com.minekube.connect.shadow.cloud.commandframework.internal.CommandRegistrationHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.help.GenericCommandHelpTopic;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private final Map<CommandArgument<?, ?>, org.bukkit.command.Command> registeredCommands = new HashMap();
    private final Set<String> recognizedAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, org.bukkit.command.Command> bukkitCommands;
    private BukkitCommandManager<C> bukkitCommandManager;
    private CommandMap commandMap;

    BukkitPluginRegistrationHandler() {
    }

    final void initialize(@NonNull BukkitCommandManager<C> bukkitCommandManager) throws Exception {
        Map bukkitCommands;
        Method getCommandMap = Bukkit.getServer().getClass().getDeclaredMethod("getCommandMap", new Class[0]);
        getCommandMap.setAccessible(true);
        this.commandMap = (CommandMap)getCommandMap.invoke((Object)Bukkit.getServer(), new Object[0]);
        Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommands.setAccessible(true);
        this.bukkitCommands = bukkitCommands = (Map)knownCommands.get(this.commandMap);
        this.bukkitCommandManager = bukkitCommandManager;
        Bukkit.getHelpMap().registerHelpTopicFactory(BukkitCommand.class, GenericCommandHelpTopic::new);
    }

    @Override
    public final boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument<?, ?> commandArgument = command.getArguments().get(0);
        if (!(this.bukkitCommandManager.getCommandRegistrationHandler() instanceof CloudCommodoreManager) && this.registeredCommands.containsKey(commandArgument)) {
            return false;
        }
        String label = commandArgument.getName();
        String namespacedLabel = this.getNamespacedLabel(label);
        ArrayList<String> aliases = new ArrayList<String>(((StaticArgument)commandArgument).getAlternativeAliases());
        BukkitCommand bukkitCommand = new BukkitCommand(label, aliases, command, commandArgument, this.bukkitCommandManager);
        if (this.bukkitCommandManager.getSetting(CommandManager.ManagerSettings.OVERRIDE_EXISTING_COMMANDS)) {
            this.bukkitCommands.remove(label);
            aliases.forEach(alias -> this.bukkitCommands.remove(alias));
        }
        HashSet<String> newAliases = new HashSet<String>();
        for (String alias2 : aliases) {
            String namespacedAlias = this.getNamespacedLabel(alias2);
            newAliases.add(namespacedAlias);
            if (this.bukkitCommandOrAliasExists(alias2)) continue;
            newAliases.add(alias2);
        }
        if (!this.bukkitCommandExists(label)) {
            newAliases.add(label);
        }
        newAliases.add(namespacedLabel);
        this.commandMap.register(label, this.bukkitCommandManager.getOwningPlugin().getName().toLowerCase(), bukkitCommand);
        this.recognizedAliases.addAll(newAliases);
        if (this.bukkitCommandManager.getSplitAliases()) {
            newAliases.forEach(alias -> this.registerExternal((String)alias, command, bukkitCommand));
        }
        this.registeredCommands.put(commandArgument, bukkitCommand);
        return true;
    }

    private @NonNull String getNamespacedLabel(@NonNull String label) {
        return String.format("%s:%s", this.bukkitCommandManager.getOwningPlugin().getName(), label).toLowerCase();
    }

    public boolean isRecognized(@NonNull String alias) {
        return this.recognizedAliases.contains(alias);
    }

    protected void registerExternal(@NonNull String label, @NonNull Command<?> command, @NonNull BukkitCommand<C> bukkitCommand) {
    }

    private boolean bukkitCommandExists(String commandLabel) {
        org.bukkit.command.Command existingCommand = this.bukkitCommands.get(commandLabel);
        if (existingCommand == null) {
            return false;
        }
        if (existingCommand instanceof PluginIdentifiableCommand) {
            return existingCommand.getLabel().equals(commandLabel) && !((PluginIdentifiableCommand)existingCommand).getPlugin().getName().equalsIgnoreCase(this.bukkitCommandManager.getOwningPlugin().getName());
        }
        return existingCommand.getLabel().equals(commandLabel);
    }

    private boolean bukkitCommandOrAliasExists(String commandLabel) {
        org.bukkit.command.Command command = this.bukkitCommands.get(commandLabel);
        if (command instanceof PluginIdentifiableCommand) {
            return !((PluginIdentifiableCommand)command).getPlugin().getName().equalsIgnoreCase(this.bukkitCommandManager.getOwningPlugin().getName());
        }
        return command != null;
    }
}

