/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.arguments.standard;

import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.captions.CaptionVariable;
import com.minekube.connect.shadow.cloud.commandframework.captions.StandardCaptionKeys;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.ParserException;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UUIDArgument<C>
extends CommandArgument<C, UUID> {
    private UUIDArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new UUIDParser(), defaultValue, UUID.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, UUID> of(@NonNull String name) {
        return UUIDArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name) {
        return UUIDArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name, @NonNull UUID defaultUUID) {
        return UUIDArgument.newBuilder(name).asOptionalWithDefault(defaultUUID.toString()).build();
    }

    public static final class UUIDParser<C>
    implements ArgumentParser<C, UUID> {
        @Override
        public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(UUIDParser.class, commandContext));
            }
            try {
                UUID uuid = UUID.fromString(input);
                inputQueue.remove();
                return ArgumentParseResult.success(uuid);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new UUIDParseException(input, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, UUID> {
        private Builder(@NonNull String name) {
            super(UUID.class, name);
        }

        public @NonNull UUIDArgument<C> build() {
            return new UUIDArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class UUIDParseException
    extends ParserException {
        private static final long serialVersionUID = 6399602590976540023L;
        private final String input;

        public UUIDParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input));
            this.input = input;
        }

        public String getInput() {
            return this.input;
        }
    }
}

