/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.arguments.standard;

import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StringArrayArgument<C>
extends CommandArgument<C, String[]> {
    private StringArrayArgument(boolean required, @NonNull String name, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new StringArrayParser(), "", TypeToken.get(String[].class), suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull StringArrayArgument<C> of(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(true, name, suggestionsProvider, ArgumentDescription.empty());
    }

    public static <C> @NonNull StringArrayArgument<C> optional(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(false, name, suggestionsProvider, ArgumentDescription.empty());
    }

    public static final class StringArrayParser<C>
    implements ArgumentParser<C, String[]> {
        @Override
        public @NonNull ArgumentParseResult<String @NonNull []> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String[] result = new String[inputQueue.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = inputQueue.remove();
            }
            return ArgumentParseResult.success(result);
        }
    }
}

