/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.arguments.standard;

import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.captions.CaptionVariable;
import com.minekube.connect.shadow.cloud.commandframework.captions.StandardCaptionKeys;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.ParserException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CharArgument<C>
extends CommandArgument<C, Character> {
    private CharArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new CharacterParser(), defaultValue, Character.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Character> of(@NonNull String name) {
        return CharArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Character> optional(@NonNull String name) {
        return CharArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Character> optional(@NonNull String name, @NonNull String defaultNum) {
        return CharArgument.newBuilder(name).asOptionalWithDefault(defaultNum).build();
    }

    public static final class CharacterParser<C>
    implements ArgumentParser<C, Character> {
        @Override
        public @NonNull ArgumentParseResult<Character> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(CharacterParser.class, commandContext));
            }
            if (input.length() != 1) {
                return ArgumentParseResult.failure(new CharParseException(input, commandContext));
            }
            return ArgumentParseResult.success(Character.valueOf(input.charAt(0)));
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Character> {
        private Builder(@NonNull String name) {
            super(Character.class, name);
        }

        public @NonNull CharArgument<C> build() {
            return new CharArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class CharParseException
    extends ParserException {
        private static final long serialVersionUID = 6458851071584278854L;
        private final String input;

        public CharParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(CharacterParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

