/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.arguments;

import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.CommandTree;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandSuggestionEngine;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.execution.preprocessor.CommandPreprocessingContext;
import com.minekube.connect.shadow.cloud.commandframework.internal.CommandInputTokenizer;
import com.minekube.connect.shadow.cloud.commandframework.services.State;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DelegatingCommandSuggestionEngine<C>
implements CommandSuggestionEngine<C> {
    private static final List<String> SINGLE_EMPTY_SUGGESTION = Collections.unmodifiableList(Collections.singletonList(""));
    private final CommandManager<C> commandManager;
    private final CommandTree<C> commandTree;

    DelegatingCommandSuggestionEngine(@NonNull CommandManager<C> commandManager, @NonNull CommandTree<C> commandTree) {
        this.commandManager = commandManager;
        this.commandTree = commandTree;
    }

    @Override
    public @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> context, @NonNull String input) {
        @NonNull LinkedList<@NonNull String> inputQueue = new CommandInputTokenizer(input).tokenize();
        context.store("__raw_input__", new LinkedList<String>(inputQueue));
        List suggestions = this.commandManager.preprocessContext(context, inputQueue) == State.ACCEPTED ? (List)this.commandManager.getCommandSuggestionProcessor().apply(new CommandPreprocessingContext<C>(context, inputQueue), this.commandTree.getSuggestions(context, inputQueue)) : Collections.emptyList();
        if (this.commandManager.getSetting(CommandManager.ManagerSettings.FORCE_SUGGESTION) && suggestions.isEmpty()) {
            return SINGLE_EMPTY_SUGGESTION;
        }
        return suggestions;
    }
}

