/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.arguments;

import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.Command;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.arguments.DelegatingSuggestionsProvider;
import com.minekube.connect.shadow.cloud.commandframework.arguments.StaticArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ParserParameters;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.keys.CloudKey;
import com.minekube.connect.shadow.cloud.commandframework.keys.CloudKeyHolder;
import com.minekube.connect.shadow.cloud.commandframework.keys.SimpleCloudKey;
import com.minekube.connect.shadow.io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CommandArgument<C, T>
implements Comparable<CommandArgument<?, ?>>,
CloudKeyHolder<T> {
    private static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z0-9\\-_]+");
    private final CloudKey<T> key;
    private final boolean required;
    private final String name;
    private final ArgumentParser<C, T> parser;
    private final String defaultValue;
    private final TypeToken<T> valueType;
    private final BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider;
    private final Collection<BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors;
    private final ArgumentDescription defaultDescription;
    private boolean argumentRegistered = false;
    private Command<C> owningCommand;

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull TypeToken<T> valueType, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        this.required = required;
        this.name = Objects.requireNonNull(name, "Name may not be null");
        if (!NAME_PATTERN.asPredicate().test(name)) {
            throw new IllegalArgumentException("Name must be alphanumeric");
        }
        this.parser = Objects.requireNonNull(parser, "Parser may not be null");
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.suggestionsProvider = suggestionsProvider == null ? CommandArgument.buildDefaultSuggestionsProvider(this) : suggestionsProvider;
        this.defaultDescription = Objects.requireNonNull(defaultDescription, "Default description may not be null");
        this.argumentPreprocessors = new LinkedList<BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>>>(argumentPreprocessors);
        this.key = SimpleCloudKey.of(this.name, this.valueType);
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull TypeToken<T> valueType, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        this(required, name, parser, defaultValue, valueType, suggestionsProvider, ArgumentDescription.empty(), argumentPreprocessors);
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull TypeToken<T> valueType, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        this(required, name, parser, defaultValue, valueType, suggestionsProvider, Collections.emptyList());
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull TypeToken<T> valueType, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        this(required, name, parser, defaultValue, valueType, suggestionsProvider, defaultDescription, Collections.emptyList());
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull Class<T> valueType, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        this(required, name, parser, defaultValue, TypeToken.get(valueType), suggestionsProvider);
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull String defaultValue, @NonNull Class<T> valueType, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        this(required, name, parser, defaultValue, TypeToken.get(valueType), suggestionsProvider, defaultDescription);
    }

    public CommandArgument(boolean required, @NonNull String name, @NonNull ArgumentParser<C, T> parser, @NonNull Class<T> valueType) {
        this(required, name, parser, "", valueType, null);
    }

    private static <C> @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> buildDefaultSuggestionsProvider(@NonNull CommandArgument<C, ?> argument) {
        return new DelegatingSuggestionsProvider<C>(argument.getName(), argument.getParser());
    }

    public static <C, T> @NonNull Builder<C, T> ofType(@NonNull TypeToken<T> clazz, @NonNull String name) {
        return new Builder(clazz, name);
    }

    public static <C, T> @NonNull Builder<@NonNull C, @NonNull T> ofType(@NonNull Class<T> clazz, @NonNull String name) {
        return new Builder(TypeToken.get(clazz), name);
    }

    @Override
    public final @NonNull CloudKey<T> getKey() {
        return this.key;
    }

    public boolean isRequired() {
        return this.required;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull ArgumentParser<C, T> getParser() {
        return this.parser;
    }

    public final @NonNull String toString() {
        return String.format("%s{name=%s}", this.getClass().getSimpleName(), this.name);
    }

    public @NonNull CommandArgument<C, T> addPreprocessor(@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<String>, @NonNull ArgumentParseResult<Boolean>> preprocessor) {
        this.argumentPreprocessors.add(preprocessor);
        return this;
    }

    public @NonNull ArgumentParseResult<Boolean> preprocess(@NonNull CommandContext<C> context, @NonNull Queue<String> input) {
        for (BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>> preprocessor : this.argumentPreprocessors) {
            ArgumentParseResult<Boolean> result = preprocessor.apply(context, input);
            if (!result.getFailure().isPresent()) continue;
            return result;
        }
        return ArgumentParseResult.success(true);
    }

    public @Nullable Command<C> getOwningCommand() {
        return this.owningCommand;
    }

    public void setOwningCommand(@NonNull Command<C> owningCommand) {
        if (this.owningCommand != null) {
            throw new IllegalStateException("Cannot replace owning command");
        }
        this.owningCommand = owningCommand;
    }

    public final @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> getSuggestionsProvider() {
        return this.suggestionsProvider;
    }

    public final @NonNull ArgumentDescription getDefaultDescription() {
        return this.defaultDescription;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandArgument that = (CommandArgument)o;
        return this.isRequired() == that.isRequired() && Objects.equals(this.getName(), that.getName());
    }

    public final int hashCode() {
        return Objects.hash(this.isRequired(), this.getName());
    }

    @Override
    public final int compareTo(@NonNull CommandArgument<?, ?> o) {
        if (this instanceof StaticArgument) {
            if (o instanceof StaticArgument) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o instanceof StaticArgument) {
            return 1;
        }
        return 0;
    }

    public @NonNull String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return !this.isRequired() && !this.getDefaultValue().isEmpty();
    }

    public @NonNull TypeToken<T> getValueType() {
        return this.valueType;
    }

    public @NonNull CommandArgument<C, T> copy() {
        Builder<C, T> builder = CommandArgument.ofType(this.valueType, this.name);
        builder = builder.withSuggestionsProvider(this.suggestionsProvider);
        builder = builder.withParser(this.parser);
        builder = this.isRequired() ? builder.asRequired() : (this.defaultValue.isEmpty() ? builder.asOptional() : builder.asOptionalWithDefault(this.defaultValue));
        builder = builder.withDefaultDescription(this.defaultDescription);
        return builder.build();
    }

    public boolean isArgumentRegistered() {
        return this.argumentRegistered;
    }

    public void setArgumentRegistered() {
        this.argumentRegistered = true;
    }

    public static class Builder<C, T> {
        private final TypeToken<T> valueType;
        private final String name;
        private CommandManager<C> manager;
        private boolean required = true;
        private ArgumentParser<C, T> parser;
        private String defaultValue = "";
        private BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider;
        private @NonNull ArgumentDescription defaultDescription = ArgumentDescription.empty();
        private final Collection<BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors = new LinkedList<BiFunction<CommandContext<C>, String, ArgumentParseResult<Boolean>>>();

        protected Builder(@NonNull TypeToken<T> valueType, @NonNull String name) {
            this.valueType = valueType;
            this.name = name;
        }

        protected Builder(@NonNull Class<T> valueType, @NonNull String name) {
            this(TypeToken.get(valueType), name);
        }

        public @NonNull Builder<@NonNull C, @NonNull T> manager(@NonNull CommandManager<C> manager) {
            this.manager = manager;
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> asRequired() {
            this.required = true;
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> asOptional() {
            this.required = false;
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> asOptionalWithDefault(@NonNull String defaultValue) {
            this.defaultValue = defaultValue;
            this.required = false;
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> withParser(@NonNull ArgumentParser<@NonNull C, @NonNull T> parser) {
            this.parser = Objects.requireNonNull(parser, "Parser may not be null");
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> withSuggestionsProvider(@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider) {
            this.suggestionsProvider = suggestionsProvider;
            return this;
        }

        public @NonNull Builder<@NonNull C, @NonNull T> withDefaultDescription(@NonNull ArgumentDescription defaultDescription) {
            this.defaultDescription = Objects.requireNonNull(defaultDescription, "Default description may not be null");
            return this;
        }

        public @NonNull CommandArgument<@NonNull C, @NonNull T> build() {
            if (this.parser == null && this.manager != null) {
                this.parser = this.manager.getParserRegistry().createParser(this.valueType, ParserParameters.empty()).orElse(null);
            }
            if (this.parser == null) {
                this.parser = (c, i) -> ArgumentParseResult.failure(new UnsupportedOperationException("No parser was specified"));
            }
            if (this.suggestionsProvider == null) {
                this.suggestionsProvider = new DelegatingSuggestionsProvider<C>(this.name, this.parser);
            }
            return new CommandArgument<C, T>(this.required, this.name, this.parser, this.defaultValue, this.valueType, this.suggestionsProvider, this.defaultDescription);
        }

        protected final @NonNull String getName() {
            return this.name;
        }

        protected final boolean isRequired() {
            return this.required;
        }

        protected final @NonNull ArgumentParser<@NonNull C, @NonNull T> getParser() {
            return this.parser;
        }

        protected final @NonNull String getDefaultValue() {
            return this.defaultValue;
        }

        protected final @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> getSuggestionsProvider() {
            return this.suggestionsProvider;
        }

        protected final @NonNull ArgumentDescription getDefaultDescription() {
            return this.defaultDescription;
        }

        protected final @NonNull TypeToken<T> getValueType() {
            return this.valueType;
        }
    }

    public static abstract class TypedBuilder<C, T, B extends Builder<C, T>>
    extends Builder<C, T> {
        protected TypedBuilder(@NonNull TypeToken<T> valueType, @NonNull String name) {
            super(valueType, name);
        }

        protected TypedBuilder(@NonNull Class<T> valueType, @NonNull String name) {
            super(valueType, name);
        }

        protected final B self() {
            return (B)this;
        }

        public @NonNull B manager(@NonNull CommandManager<C> manager) {
            super.manager(manager);
            return this.self();
        }

        public @NonNull B asRequired() {
            super.asRequired();
            return this.self();
        }

        public @NonNull B asOptional() {
            super.asOptional();
            return this.self();
        }

        public @NonNull B asOptionalWithDefault(@NonNull String defaultValue) {
            super.asOptionalWithDefault(defaultValue);
            return this.self();
        }

        public @NonNull B withParser(@NonNull ArgumentParser<@NonNull C, @NonNull T> parser) {
            super.withParser(parser);
            return this.self();
        }

        @Override
        public @NonNull Builder<@NonNull C, @NonNull T> withSuggestionsProvider(@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider) {
            super.withSuggestionsProvider(suggestionsProvider);
            return this.self();
        }
    }
}

