/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework;

import com.minekube.connect.shadow.cloud.commandframework.Command;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.CommandTree;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.StaticArgument;
import com.minekube.connect.shadow.cloud.commandframework.meta.CommandMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandHelpHandler<C> {
    private final CommandManager<C> commandManager;
    private final Predicate<Command<C>> commandPredicate;

    CommandHelpHandler(@NonNull CommandManager<C> commandManager, @NonNull Predicate<Command<C>> commandPredicate) {
        this.commandManager = commandManager;
        this.commandPredicate = commandPredicate;
    }

    public @NonNull List<@NonNull VerboseHelpEntry<C>> getAllCommands() {
        ArrayList<VerboseHelpEntry<C>> syntaxHints = new ArrayList<VerboseHelpEntry<C>>();
        for (Command<C> command : this.commandManager.getCommands()) {
            if (!this.commandPredicate.test(command)) continue;
            List<CommandArgument<C, ?>> arguments = command.getArguments();
            String description = command.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, "");
            syntaxHints.add(new VerboseHelpEntry(command, this.commandManager.getCommandSyntaxFormatter().apply(arguments, null), description));
        }
        syntaxHints.sort(Comparator.comparing(VerboseHelpEntry::getSyntaxString));
        return syntaxHints;
    }

    public @NonNull List<@NonNull String> getLongestSharedChains() {
        ArrayList<String> chains = new ArrayList<String>();
        this.commandManager.getCommandTree().getRootNodes().forEach(node -> chains.add(Objects.requireNonNull((CommandArgument)node.getValue()).getName() + this.commandManager.getCommandSyntaxFormatter().apply(Collections.emptyList(), node)));
        chains.sort(String::compareTo);
        return chains;
    }

    public @NonNull HelpTopic<C> queryHelp(@NonNull String query) {
        return this.queryHelp(null, query);
    }

    public @NonNull HelpTopic<C> queryHelp(@Nullable C recipient, @NonNull String query) {
        List<VerboseHelpEntry<C>> commands = this.getAllCommands();
        commands.removeIf(command -> recipient != null && !this.commandManager.hasPermission(recipient, command.getCommand().getCommandPermission()));
        if (query.replace(" ", "").isEmpty()) {
            return new IndexHelpTopic(commands);
        }
        String[] queryFragments = query.split(" ");
        String rootFragment = queryFragments[0];
        LinkedList<Command<C>> availableCommands = new LinkedList<Command<C>>();
        HashSet<String> availableCommandLabels = new HashSet<String>();
        boolean exactMatch = false;
        for (VerboseHelpEntry<C> verboseHelpEntry : commands) {
            Command<C> command2 = verboseHelpEntry.getCommand();
            StaticArgument staticArgument = (StaticArgument)command2.getArguments().get(0);
            for (String string : staticArgument.getAliases()) {
                if (!string.toLowerCase(Locale.ENGLISH).startsWith(rootFragment.toLowerCase(Locale.ENGLISH))) continue;
                availableCommands.add(command2);
                availableCommandLabels.add(staticArgument.getName());
                break;
            }
            for (String string : staticArgument.getAliases()) {
                if (!string.equalsIgnoreCase(rootFragment)) continue;
                exactMatch = true;
                break;
            }
            if (!rootFragment.equalsIgnoreCase(staticArgument.getName())) continue;
            availableCommandLabels.clear();
            availableCommands.clear();
            availableCommandLabels.add(staticArgument.getName());
            availableCommands.add(command2);
            break;
        }
        if (availableCommands.isEmpty()) {
            return new IndexHelpTopic(Collections.emptyList());
        }
        if (!exactMatch || availableCommandLabels.size() > 1) {
            ArrayList<VerboseHelpEntry> syntaxHints = new ArrayList<VerboseHelpEntry>();
            for (Command command2 : availableCommands) {
                List arguments = command2.getArguments();
                String description = command2.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, "");
                syntaxHints.add(new VerboseHelpEntry(command2, this.commandManager.getCommandSyntaxFormatter().apply(arguments, null), description));
            }
            syntaxHints.sort(Comparator.comparing(VerboseHelpEntry::getSyntaxString));
            syntaxHints.removeIf(command -> recipient != null && !this.commandManager.hasPermission(recipient, command.getCommand().getCommandPermission()));
            return new IndexHelpTopic(syntaxHints);
        }
        CommandTree.Node<CommandArgument<C, ?>> node = this.commandManager.getCommandTree().getNamedNode((String)availableCommandLabels.iterator().next());
        LinkedList linkedList = new LinkedList();
        CommandTree.Node<CommandArgument<C, ?>> head = node;
        int index = 0;
        block4: while (head != null && this.isNodeVisible(head)) {
            linkedList.add(head.getValue());
            if (head.getValue() != null && head.getValue().getOwningCommand() != null && (head.isLeaf() || ++index == queryFragments.length) && (recipient == null || this.commandManager.hasPermission(recipient, head.getValue().getOwningCommand().getCommandPermission()))) {
                return new VerboseHelpTopic(head.getValue().getOwningCommand());
            }
            if (head.getChildren().size() == 1) {
                head = head.getChildren().get(0);
                continue;
            }
            if (index < queryFragments.length) {
                CommandTree.Node<CommandArgument<C, ?>> potentialVariable = null;
                for (CommandTree.Node<CommandArgument<C, ?>> node2 : head.getChildren()) {
                    if (!(node2.getValue() instanceof StaticArgument)) {
                        if (node2.getValue() == null) continue;
                        potentialVariable = node2;
                        continue;
                    }
                    StaticArgument childArgument = (StaticArgument)node2.getValue();
                    for (String childAlias : childArgument.getAliases()) {
                        if (!childAlias.equalsIgnoreCase(queryFragments[index])) continue;
                        head = node2;
                        continue block4;
                    }
                }
                if (potentialVariable != null) {
                    head = potentialVariable;
                    continue;
                }
            }
            String currentDescription = this.commandManager.getCommandSyntaxFormatter().apply(linkedList, null);
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (CommandTree.Node<CommandArgument<C, ?>> child : head.getChildren()) {
                if (!this.isNodeVisible(child)) continue;
                LinkedList traversedNodesSub = new LinkedList(linkedList);
                if (recipient != null && child.getValue() != null && child.getValue().getOwningCommand() != null && !this.commandManager.hasPermission(recipient, child.getValue().getOwningCommand().getCommandPermission())) continue;
                traversedNodesSub.add(child.getValue());
                linkedList2.add(this.commandManager.getCommandSyntaxFormatter().apply(traversedNodesSub, child));
            }
            return new MultiHelpTopic(currentDescription, linkedList2);
        }
        return new IndexHelpTopic(Collections.emptyList());
    }

    private boolean isNodeVisible( @NonNull CommandTree.Node<CommandArgument<C, ?>> node) {
        Command<C> owningCommand;
        CommandArgument<C, ?> argument = node.getValue();
        if (argument != null && (owningCommand = argument.getOwningCommand()) != null && this.commandPredicate.test(owningCommand)) {
            return true;
        }
        for (CommandTree.Node<CommandArgument<C, ?>> childNode : node.getChildren()) {
            if (!this.isNodeVisible(childNode)) continue;
            return true;
        }
        return false;
    }

    public static final class VerboseHelpEntry<C> {
        private final Command<C> command;
        private final String syntaxString;
        private final String description;

        private VerboseHelpEntry(@NonNull Command<C> command, @NonNull String syntaxString, @NonNull String description) {
            this.command = command;
            this.syntaxString = syntaxString;
            this.description = description;
        }

        public @NonNull Command<C> getCommand() {
            return this.command;
        }

        public @NonNull String getSyntaxString() {
            return this.syntaxString;
        }

        public @NonNull String getDescription() {
            return this.description;
        }
    }

    public static interface HelpTopic<C> {
    }

    public static final class IndexHelpTopic<C>
    implements HelpTopic<C> {
        private final List<VerboseHelpEntry<C>> entries;

        private IndexHelpTopic(@NonNull List<@NonNull VerboseHelpEntry<C>> entries) {
            this.entries = entries;
        }

        public @NonNull List<@NonNull VerboseHelpEntry<C>> getEntries() {
            return this.entries;
        }

        public boolean isEmpty() {
            return this.getEntries().isEmpty();
        }
    }

    public static final class VerboseHelpTopic<C>
    implements HelpTopic<C> {
        private final Command<C> command;
        private final String description;

        private VerboseHelpTopic(@NonNull Command<C> command) {
            this.command = command;
            String shortDescription = command.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, "No description");
            this.description = command.getCommandMeta().getOrDefault(CommandMeta.LONG_DESCRIPTION, shortDescription);
        }

        public @NonNull Command<C> getCommand() {
            return this.command;
        }

        public @NonNull String getDescription() {
            return this.description;
        }
    }

    public static final class MultiHelpTopic<C>
    implements HelpTopic<C> {
        private final String longestPath;
        private final List<String> childSuggestions;

        private MultiHelpTopic(@NonNull String longestPath, @NonNull List<@NonNull String> childSuggestions) {
            this.longestPath = longestPath;
            this.childSuggestions = childSuggestions;
        }

        public @NonNull String getLongestPath() {
            return this.longestPath;
        }

        public @NonNull List<@NonNull String> getChildSuggestions() {
            return this.childSuggestions;
        }
    }
}

