/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.register;

import com.google.rpc.Status;
import com.minekube.connect.api.SimpleConnectApi;
import com.minekube.connect.api.inject.PlatformInjector;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.network.netty.LocalSession;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.tunnel.Tunneler;
import com.minekube.connect.util.Utils;
import com.minekube.connect.util.backoff.ExponentialBackOff;
import com.minekube.connect.watch.SessionProposal;
import com.minekube.connect.watch.WatchClient;
import com.minekube.connect.watch.Watcher;
import java.io.IOException;
import java.time.Duration;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocket;

public class WatcherRegister {
    @Inject
    private WatchClient watchClient;
    @Inject
    private Tunneler tunneler;
    @Inject
    private PlatformInjector platformInjector;
    @Inject
    private ConnectLogger logger;
    @Inject
    private SimpleConnectApi api;
    private WebSocket ws;
    private ExponentialBackOff backOffPolicy;
    private final AtomicBoolean started = new AtomicBoolean();
    private Timer timer;
    private TimerTask retryTask;

    @Inject
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.backOffPolicy = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxElapsedTimeMillis(Integer.MAX_VALUE).setMaxIntervalMillis(300000).setMultiplier(1.5).build();
            this.watch();
        }
    }

    public void resetBackOff() {
        this.backOffPolicy.reset();
    }

    public void stop() {
        if (this.ws != null) {
            if (this.started.compareAndSet(true, false)) {
                this.logger.info("Stopped watching for sessions", new Object[0]);
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (this.retryTask != null) {
                this.retryTask.cancel();
                this.retryTask = null;
            }
            this.ws.close(1000, "watcher stopped");
            this.ws = null;
        }
    }

    private void retry() {
        if (this.started.get()) {
            long millis;
            if (this.retryTask != null) {
                this.retryTask.cancel();
            }
            if (this.timer == null) {
                this.timer = new Timer();
            }
            try {
                millis = this.backOffPolicy.nextBackOffMillis();
                if (millis == -1L) {
                    this.stop();
                    return;
                }
            }
            catch (IOException e) {
                this.logger.error("nextBackOffMillis error", e, new Object[0]);
                return;
            }
            this.retryTask = new TimerTask();
            this.logger.info("Trying to reconnect in {}...", Utils.humanReadableFormat(Duration.ofMillis(millis)));
            this.timer.schedule((java.util.TimerTask)this.retryTask, millis);
        }
    }

    private void watch() {
        if (this.ws != null) {
            this.ws.close(1000, "watcher is reconnecting");
        }
        this.ws = this.watchClient.watch(new WatcherImpl());
    }

    private class TimerTask
    extends java.util.TimerTask {
        private TimerTask() {
        }

        @Override
        public void run() {
            if (WatcherRegister.this.started.get()) {
                WatcherRegister.this.watch();
            }
        }
    }

    private class WatcherImpl
    implements Watcher {
        private Timer resetBackOffTimer;

        private WatcherImpl() {
        }

        @Override
        public void onOpen() {
            WatcherRegister.this.logger.translatedInfo("connect.watch.started", new Object[0]);
            this.startResetBackOffTimer();
        }

        @Override
        public void onProposal(SessionProposal proposal) {
            if (proposal.getSession().getTunnelServiceAddr().isEmpty()) {
                WatcherRegister.this.logger.info("Got session proposal with empty tunnel service address from WatchService, rejecting it", new Object[0]);
                proposal.reject(Status.newBuilder().setCode(3).setMessage("tunnel service address must not be empty").build());
                return;
            }
            if (proposal.getSession().getPlayer().getAddr().isEmpty()) {
                WatcherRegister.this.logger.info("Got session proposal with empty player address from WatchService, rejecting it", new Object[0]);
                proposal.reject(Status.newBuilder().setCode(3).setMessage("player address must not be empty").build());
                return;
            }
            if (WatcherRegister.this.logger.isDebug()) {
                WatcherRegister.this.logger.debug("Received {}", proposal);
            }
            if (proposal.getState() != SessionProposal.State.ACCEPTED) {
                return;
            }
            new LocalSession(WatcherRegister.this.logger, WatcherRegister.this.api, WatcherRegister.this.tunneler, WatcherRegister.this.platformInjector.getServerSocketAddress(), proposal).connect();
        }

        @Override
        public void onError(Throwable t) {
            WatcherRegister.this.logger.error("Connection error with WatchService: " + t + (t.getCause() == null ? "" : " (cause: " + t.getCause().toString() + ")"), new Object[0]);
            this.cancelResetBackOffTimer();
            WatcherRegister.this.retry();
        }

        @Override
        public void onCompleted() {
            this.cancelResetBackOffTimer();
            WatcherRegister.this.retry();
        }

        void startResetBackOffTimer() {
            if (this.resetBackOffTimer != null) {
                this.resetBackOffTimer.cancel();
            }
            this.resetBackOffTimer = new Timer();
            this.resetBackOffTimer.schedule((java.util.TimerTask)new TimerTask(){

                @Override
                public void run() {
                    if (WatcherRegister.this.started.get()) {
                        WatcherRegister.this.resetBackOff();
                    }
                }
            }, Duration.ofSeconds(10L).toMillis());
        }

        void cancelResetBackOffTimer() {
            if (this.resetBackOffTimer != null) {
                this.resetBackOffTimer.cancel();
                this.resetBackOffTimer = null;
            }
        }
    }
}

