/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.register;

import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.platform.command.ConnectCommand;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.Injector;
import com.minekube.connect.shadow.com.google.inject.Key;
import java.util.Set;

public final class CommandRegister {
    private final CommandManager<UserAudience> commandManager;
    private final ConnectConfig config;
    private final Injector guice;

    @Inject
    public CommandRegister(Injector guice) {
        this.commandManager = guice.getInstance(new Key<CommandManager<UserAudience>>(){});
        this.config = guice.getInstance(ConnectConfig.class);
        this.guice = guice;
    }

    @Inject
    public void registerCommands(Set<ConnectCommand> foundCommands) {
        for (ConnectCommand command : foundCommands) {
            this.guice.injectMembers(command);
            if (!command.shouldRegister(this.config)) continue;
            this.commandManager.command(command.buildCommand(this.commandManager));
        }
    }
}

