/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.pluginmessage;

import com.minekube.connect.SpigotPlugin;
import com.minekube.connect.api.player.ConnectPlayer;
import com.minekube.connect.skin.SkinApplier;
import com.minekube.connect.skin.SkinData;
import com.minekube.connect.util.ClassNames;
import com.minekube.connect.util.ReflectionUtils;
import com.minekube.connect.util.SpigotVersionSpecificMethods;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class SpigotSkinApplier
implements SkinApplier {
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private final SpigotPlugin plugin;

    public SpigotSkinApplier(SpigotVersionSpecificMethods versionSpecificMethods, SpigotPlugin plugin) {
        this.versionSpecificMethods = versionSpecificMethods;
        this.plugin = plugin;
    }

    @Override
    public void applySkin(ConnectPlayer connectPlayer, SkinData skinData) {
        this.applySkin0(connectPlayer, skinData, true);
    }

    private void applySkin0(ConnectPlayer connectPlayer, SkinData skinData, boolean firstTry) {
        Player player = Bukkit.getPlayer((UUID)connectPlayer.getUniqueId());
        if (player == null) {
            if (firstTry) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applySkin0(connectPlayer, skinData, false), 10000L);
            }
            return;
        }
        GameProfile profile = (GameProfile)ReflectionUtils.castedInvoke(player, ClassNames.GET_PROFILE_METHOD, new Object[0]);
        if (profile == null) {
            throw new IllegalStateException("The GameProfile cannot be null! " + player.getName());
        }
        PropertyMap properties = profile.getProperties();
        properties.removeAll((Object)"textures");
        Property property = new Property("textures", skinData.getValue(), skinData.getSignature());
        properties.put((Object)"textures", (Object)property);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.equals(player) || !p.canSee(player)) continue;
                this.versionSpecificMethods.hideAndShowPlayer(p, player);
                this.versionSpecificMethods.hideAndShowPlayer(p, player);
            }
        });
    }
}

