/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.player.audience;

import com.minekube.connect.platform.command.CommandUtil;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.player.audience.ProfileAudience;
import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProfileAudienceArgument
extends CommandArgument<UserAudience, ProfileAudience> {
    private ProfileAudienceArgument(@NonNull String name, ProfileAudienceParser parser) {
        super(true, name, parser, ProfileAudience.class);
    }

    public static ProfileAudienceArgument of(String name, boolean allowUuid, boolean allowOffline) {
        return new ProfileAudienceArgument(name, new ProfileAudienceParser(allowUuid, allowOffline));
    }

    public static ProfileAudienceArgument ofOnline(String name) {
        return ProfileAudienceArgument.of(name, false, false);
    }

    public static ProfileAudienceArgument ofOnline(String name, boolean allowUuid) {
        return ProfileAudienceArgument.of(name, allowUuid, false);
    }

    public static ProfileAudienceArgument of(String name, boolean allowOffline) {
        return ProfileAudienceArgument.of(name, false, allowOffline);
    }

    public static final class ProfileAudienceParser
    implements ArgumentParser<UserAudience, ProfileAudience> {
        private final boolean allowUuid;
        private final boolean allowOffline;

        @Override
        public @NonNull ArgumentParseResult<ProfileAudience> parse(@NonNull CommandContext<@NonNull UserAudience> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            ProfileAudience profileAudience;
            Object player;
            CommandUtil commandUtil = (CommandUtil)commandContext.get("CommandUtil");
            String input = inputQueue.poll();
            if (input == null || input.length() < 3) {
                return ArgumentParseResult.failure(new NullPointerException("Expected player name/UUID"));
            }
            if (input.startsWith("\"")) {
                if (input.endsWith("\"")) {
                    input = input.substring(1);
                    input = input.substring(0, input.length() - 1);
                } else {
                    StringBuilder builder = new StringBuilder(input);
                    while (!inputQueue.isEmpty()) {
                        String string = inputQueue.remove();
                        builder.append(' ').append(string);
                        if (!string.endsWith("\"")) continue;
                        break;
                    }
                    if (builder.lastIndexOf("\"") != builder.length() - 1) {
                        return ArgumentParseResult.failure(new InvalidPlayerIdentifierException("Malformed string provided; no end quotes found!"));
                    }
                    builder.deleteCharAt(0);
                    builder.deleteCharAt(builder.length() - 1);
                    input = builder.toString();
                }
            }
            if (input.length() > 16) {
                if (!this.allowUuid) {
                    return ArgumentParseResult.failure(new InvalidPlayerIdentifierException("UUID is not allowed here"));
                }
                if (input.length() != 32 && input.length() != 36) {
                    return ArgumentParseResult.failure(new InvalidPlayerIdentifierException("Expected player name/UUID"));
                }
                try {
                    player = commandUtil.getPlayerByUuid(UUID.fromString(input));
                    profileAudience = commandUtil.getProfileAudience(player, this.allowOffline);
                }
                catch (IllegalArgumentException ignored) {
                    return ArgumentParseResult.failure(new InvalidPlayerIdentifierException("Invalid UUID '" + input + "'"));
                }
            } else {
                player = commandUtil.getPlayerByUsername(input);
                profileAudience = commandUtil.getProfileAudience(player, this.allowOffline);
            }
            if (profileAudience == null) {
                return ArgumentParseResult.failure(new InvalidPlayerIdentifierException("Invalid player '" + input + "'"));
            }
            return ArgumentParseResult.success(profileAudience);
        }

        @Override
        public @NonNull List<String> suggestions(@NonNull CommandContext<UserAudience> commandContext, @NonNull String input) {
            CommandUtil commandUtil = (CommandUtil)commandContext.get("CommandUtil");
            String trimmedInput = input.trim();
            if (trimmedInput.isEmpty()) {
                return ImmutableList.copyOf(commandUtil.getOnlineUsernames());
            }
            String lowercaseInput = input.toLowerCase(Locale.ROOT);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String player : commandUtil.getOnlineUsernames()) {
                if (!player.toLowerCase(Locale.ROOT).startsWith(lowercaseInput)) continue;
                builder.add(player);
            }
            return builder.build();
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public ProfileAudienceParser(boolean allowUuid, boolean allowOffline) {
            this.allowUuid = allowUuid;
            this.allowOffline = allowOffline;
        }
    }

    public static final class InvalidPlayerIdentifierException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -6500019324607183855L;

        public InvalidPlayerIdentifierException(@NonNull String message) {
            super(message);
        }

        @Override
        public @NonNull Throwable fillInStackTrace() {
            return this;
        }
    }
}

