/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.player;

import com.minekube.connect.platform.command.CommandUtil;
import com.minekube.connect.platform.command.TranslatableMessage;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UserAudience {
    private final @NonNull UUID uuid;
    private final @NonNull String username;
    private final @NonNull String locale;
    private final @NonNull Object source;
    private final @NonNull CommandUtil commandUtil;

    public UserAudience(@NonNull UUID uuid, @NonNull String username, @NonNull String locale, @NonNull Object source2, @NonNull CommandUtil commandUtil) {
        this.uuid = Objects.requireNonNull(uuid);
        this.username = username;
        this.locale = Objects.requireNonNull(locale);
        this.source = Objects.requireNonNull(source2);
        this.commandUtil = Objects.requireNonNull(commandUtil);
    }

    public boolean hasPermission(@NonNull String permission) {
        return this.commandUtil.hasPermission(this.source(), permission);
    }

    public void sendMessage(String message) {
        this.commandUtil.sendMessage(this.source(), message);
    }

    public void sendMessage(TranslatableMessage message, Object ... args2) {
        this.sendMessage(this.translateMessage(message, args2));
    }

    public void disconnect(@NonNull String reason) {
        this.commandUtil.kickPlayer(this.source(), reason);
    }

    public void disconnect(TranslatableMessage message, Object ... args2) {
        this.disconnect(this.translateMessage(message, args2));
    }

    public String translateMessage(TranslatableMessage message, Object ... args2) {
        return this.commandUtil.translateMessage(this.locale(), message, args2);
    }

    public @NonNull UUID uuid() {
        return this.uuid;
    }

    public @NonNull String username() {
        return this.username;
    }

    public @NonNull String locale() {
        return this.locale;
    }

    public @NonNull Object source() {
        return this.source;
    }

    public @NonNull CommandUtil commandUtil() {
        return this.commandUtil;
    }

    public static class ConsoleAudience
    extends UserAudience {
        public ConsoleAudience(@NonNull Object source2, @NonNull CommandUtil commandUtil) {
            super(new UUID(0L, 0L), "CONSOLE", "en_us", source2, commandUtil);
        }
    }

    public static class PlayerAudience
    extends UserAudience {
        private final boolean online;

        public PlayerAudience(@NonNull UUID uuid, @NonNull String username, @NonNull String locale, @NonNull Object source2, @NonNull CommandUtil commandUtil, boolean online) {
            super(uuid, username, locale, source2, commandUtil);
            this.online = online;
        }

        public boolean online() {
            return this.online;
        }
    }
}

