/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.platform.command;

import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.platform.command.TranslatableMessage;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.player.audience.ProfileAudience;
import com.minekube.connect.util.LanguageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CommandUtil {
    protected final LanguageManager manager;
    protected final ConnectApi api;

    public abstract @NonNull UserAudience getUserAudience(@NonNull Object var1);

    public @Nullable ProfileAudience getProfileAudience(@NonNull Object source2, boolean allowOffline) {
        Objects.requireNonNull(source2);
        if (source2 instanceof UUID) {
            return allowOffline ? new ProfileAudience((UUID)source2, null) : null;
        }
        if (source2 instanceof String) {
            return allowOffline ? new ProfileAudience(null, (String)source2) : null;
        }
        return new ProfileAudience(this.getUuidFromSource(source2), this.getUsernameFromSource(source2));
    }

    protected abstract String getUsernameFromSource(@NonNull Object var1);

    protected abstract UUID getUuidFromSource(@NonNull Object var1);

    protected abstract Collection<?> getOnlinePlayers();

    public @NonNull Collection<String> getOnlineUsernames() {
        ArrayList<String> usernames = new ArrayList<String>();
        this.getOnlinePlayers().forEach(this::getUsernameFromSource);
        return usernames;
    }

    public abstract Object getPlayerByUuid(@NonNull UUID var1);

    public abstract Object getPlayerByUsername(@NonNull String var1);

    public abstract boolean hasPermission(Object var1, String var2);

    public Collection<Object> getOnlinePlayersWithPermission(String permission) {
        ArrayList<Object> players = new ArrayList<Object>();
        for (Object player : this.getOnlinePlayers()) {
            if (!this.hasPermission(player, permission)) continue;
            players.add(player);
        }
        return players;
    }

    public abstract void sendMessage(Object var1, String var2);

    public abstract void kickPlayer(Object var1, String var2);

    public String translateMessage(String locale, TranslatableMessage message, Object ... args2) {
        return message.translateMessage(this.manager, locale, args2);
    }

    protected CommandUtil(LanguageManager manager, ConnectApi api) {
        this.manager = manager;
        this.api = api;
    }
}

