/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.network.netty;

import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.tunnel.TunnelConn;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;

class TunnelHandler
implements TunnelConn.Handler {
    private final ConnectLogger logger;
    private final Channel downstreamServerConn;

    @Override
    public void onReceive(byte[] data) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        this.downstreamServerConn.writeAndFlush((Object)buf);
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable(t);
        if (status.getCode() == Status.Code.CANCELLED) {
            return;
        }
        this.logger.error("Connection error with TunnelService: " + t + (t.getCause() == null ? "" : " (cause: " + t.getCause().toString() + ")"), new Object[0]);
    }

    @Override
    public void onClose() {
        this.downstreamServerConn.close();
    }

    public TunnelHandler(ConnectLogger logger, Channel downstreamServerConn) {
        this.logger = logger;
        this.downstreamServerConn = downstreamServerConn;
    }
}

