/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.network.netty;

import com.minekube.connect.api.SimpleConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.api.player.Auth;
import com.minekube.connect.api.player.ConnectPlayer;
import com.minekube.connect.api.player.GameProfile;
import com.minekube.connect.network.netty.ChannelWrapper;
import com.minekube.connect.network.netty.LocalChannelInboundHandler;
import com.minekube.connect.network.netty.LocalChannelWithSessionContext;
import com.minekube.connect.network.netty.LocalChannelWrapper;
import com.minekube.connect.player.ConnectPlayerImpl;
import com.minekube.connect.shadow.com.google.common.base.Preconditions;
import com.minekube.connect.tunnel.TunnelConn;
import com.minekube.connect.tunnel.Tunneler;
import com.minekube.connect.watch.SessionProposal;
import io.grpc.protobuf.StatusProto;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import minekube.connect.v1alpha1.WatchServiceOuterClass;
import org.jetbrains.annotations.NotNull;

public final class LocalSession {
    private static final int CONNECTION_TIMEOUT = (int)Duration.ofSeconds(30L).toMillis();
    private static DefaultEventLoopGroup DEFAULT_EVENT_LOOP_GROUP;
    private static PreferredDirectByteBufAllocator PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR;
    private final ConnectLogger logger;
    private final SimpleConnectApi api;
    private final Tunneler tunneler;
    private final SocketAddress targetAddress;
    private final SessionProposal sessionProposal;
    private final AtomicBoolean connectOnce = new AtomicBoolean();

    private static ConnectPlayer fromProto(WatchServiceOuterClass.Session s2) {
        WatchServiceOuterClass.Player p = s2.getPlayer();
        return new ConnectPlayerImpl(s2.getId(), new GameProfile(p.getProfile().getName(), UUID.fromString(p.getProfile().getId()), p.getProfile().getPropertiesList().stream().map(property -> new GameProfile.Property(property.getName(), property.getValue(), property.getSignature())).collect(Collectors.toList())), new Auth(s2.getAuth().getPassthrough()), "");
    }

    public static Optional<Context> context(Channel channel) {
        if (channel instanceof ChannelWrapper) {
            return Optional.of(((ChannelWrapper)channel).getContext());
        }
        if (channel instanceof LocalChannelWrapper) {
            return Optional.of(((LocalChannelWrapper)channel).wrapper().getContext());
        }
        return Optional.empty();
    }

    public static void context(Channel channel, Consumer<Context> ifPresent) {
        LocalSession.context(channel).ifPresent(ifPresent);
    }

    public void connect() {
        if (this.sessionProposal.getState() != SessionProposal.State.ACCEPTED) {
            throw new IllegalStateException("Session proposal has already been rejected.");
        }
        if (!this.connectOnce.compareAndSet(false, true)) {
            throw new IllegalStateException("Connection has already been connected.");
        }
        final Context context = new Context(LocalSession.fromProto(this.sessionProposal.getSession()), LocalSession.createAddress(this.sessionProposal.getSession().getPlayer().getAddr()), this.sessionProposal);
        if (DEFAULT_EVENT_LOOP_GROUP == null) {
            DEFAULT_EVENT_LOOP_GROUP = new DefaultEventLoopGroup();
        }
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.channel(LocalChannelWithSessionContext.class)).handler((ChannelHandler)new ChannelInitializer<LocalChannelWithSessionContext>(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                LocalSession.this.exceptionCaught(cause);
                super.exceptionCaught(ctx, cause);
            }

            public void initChannel(@NotNull LocalChannelWithSessionContext channel) {
                channel.setContext(context);
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("connect-tunnel", (ChannelHandler)new LocalChannelInboundHandler(context, LocalSession.this.logger, LocalSession.this.tunneler, LocalSession.this.api));
            }
        })).group((EventLoopGroup)DEFAULT_EVENT_LOOP_GROUP)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)CONNECTION_TIMEOUT);
        if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR != null) {
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR);
        }
        this.logger.debug("Connecting {} to local downstream server {}", context.player.getUsername(), this.targetAddress);
        bootstrap.remoteAddress(this.targetAddress).connect().addListener(future -> {
            if (!future.isSuccess()) {
                this.exceptionCaught(future.cause());
                return;
            }
            this.api.addPlayer(context.player);
        });
    }

    private void exceptionCaught(Throwable cause) {
        cause.printStackTrace();
        this.sessionProposal.reject(StatusProto.fromThrowable(cause));
    }

    public static void createDirectByteBufAllocator() {
        if (PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR == null) {
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = new PreferredDirectByteBufAllocator();
            PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR.updateAllocator(ByteBufAllocator.DEFAULT);
        }
    }

    private static InetSocketAddress createAddress(String addr) {
        Preconditions.checkNotNull(addr, "player address must not be null");
        Preconditions.checkArgument(!addr.isEmpty(), "player address must not be empty");
        InetSocketAddress address = new InetSocketAddress(addr, 0);
        Preconditions.checkArgument(!address.isUnresolved(), "invalid player address (must not contain a port): %s", (Object)addr);
        return address;
    }

    public LocalSession(ConnectLogger logger, SimpleConnectApi api, Tunneler tunneler, SocketAddress targetAddress, SessionProposal sessionProposal) {
        this.logger = logger;
        this.api = api;
        this.tunneler = tunneler;
        this.targetAddress = targetAddress;
        this.sessionProposal = sessionProposal;
    }

    static {
        PREFERRED_DIRECT_BYTE_BUF_ALLOCATOR = null;
    }

    public static class Context {
        @NotNull
        final ConnectPlayer player;
        @NotNull
        final InetSocketAddress spoofedAddress;
        @NotNull
        final SessionProposal sessionProposal;
        AtomicReference<TunnelConn> tunnelConn = new AtomicReference<Object>(null);

        private Context(@NotNull ConnectPlayer player, @NotNull InetSocketAddress spoofedAddress, @NotNull SessionProposal sessionProposal) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            if (spoofedAddress == null) {
                throw new NullPointerException("spoofedAddress is marked non-null but is null");
            }
            if (sessionProposal == null) {
                throw new NullPointerException("sessionProposal is marked non-null but is null");
            }
            this.player = player;
            this.spoofedAddress = spoofedAddress;
            this.sessionProposal = sessionProposal;
        }

        @NotNull
        public ConnectPlayer getPlayer() {
            return this.player;
        }

        @NotNull
        public InetSocketAddress getSpoofedAddress() {
            return this.spoofedAddress;
        }

        @NotNull
        public SessionProposal getSessionProposal() {
            return this.sessionProposal;
        }

        public AtomicReference<TunnelConn> getTunnelConn() {
            return this.tunnelConn;
        }
    }
}

