/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.network.netty;

import com.google.rpc.Status;
import com.minekube.connect.api.SimpleConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.network.netty.LocalSession;
import com.minekube.connect.network.netty.TunnelHandler;
import com.minekube.connect.tunnel.TunnelConn;
import com.minekube.connect.tunnel.Tunneler;
import io.grpc.protobuf.StatusProto;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.jetbrains.annotations.NotNull;

public class LocalChannelInboundHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final String FORCE_TUNNEL_SERVICE_ADDR = System.getenv("CONNECT_FORCE_TUNNEL_SERVICE_ADDR");
    private final LocalSession.Context context;
    private final ConnectLogger logger;
    private final Tunneler tunneler;
    private final SimpleConnectApi api;
    private TunnelConn tunnelConn;

    public static void onChannelClosed(LocalSession.Context context, SimpleConnectApi api, ConnectLogger logger) {
        try {
            TunnelConn tunnelConn = context.getTunnelConn().getAndSet(null);
            if (tunnelConn != null) {
                tunnelConn.close();
            }
            if (api.setPendingRemove(context.getPlayer()) && !context.getPlayer().getUsername().isEmpty()) {
                logger.translatedInfo("connect.ingame.disconnect_name", context.getPlayer().getUsername());
            }
            Status reason = Status.newBuilder().setCode(2).setMessage("local connection closed").build();
            LocalChannelInboundHandler.rejectProposal(context, reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void rejectProposal(LocalSession.Context context, Status reason) {
        TunnelConn tunnelConn = context.getTunnelConn().get();
        if (tunnelConn == null || !tunnelConn.opened()) {
            context.getSessionProposal().reject(reason);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LocalChannelInboundHandler.rejectProposal(this.context, StatusProto.fromThrowable(cause));
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }

    private String tunnelSvcAddr() {
        if (FORCE_TUNNEL_SERVICE_ADDR != null && !FORCE_TUNNEL_SERVICE_ADDR.isEmpty()) {
            return FORCE_TUNNEL_SERVICE_ADDR;
        }
        return this.context.getSessionProposal().getSession().getTunnelServiceAddr();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.tunnelConn = this.tunneler.tunnel(this.tunnelSvcAddr(), this.context.getSessionProposal().getSession().getId(), new TunnelHandler(this.logger, ctx.channel()));
        this.context.tunnelConn.set(this.tunnelConn);
        super.channelActive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) {
        byte[] data = ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes(), (boolean)false);
        this.tunnelConn.write(data);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        LocalChannelInboundHandler.onChannelClosed(this.context, this.api, this.logger);
        super.channelInactive(ctx);
    }

    public LocalChannelInboundHandler(LocalSession.Context context, ConnectLogger logger, Tunneler tunneler, SimpleConnectApi api) {
        this.context = context;
        this.logger = logger;
        this.tunneler = tunneler;
        this.api = api;
    }
}

