/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.module;

import com.minekube.connect.SpigotPlugin;
import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.inject.CommonPlatformInjector;
import com.minekube.connect.inject.spigot.SpigotInjector;
import com.minekube.connect.listener.SpigotListenerRegistration;
import com.minekube.connect.logger.JavaUtilConnectLogger;
import com.minekube.connect.platform.command.CommandUtil;
import com.minekube.connect.platform.listener.ListenerRegistration;
import com.minekube.connect.platform.util.PlatformUtils;
import com.minekube.connect.pluginmessage.SpigotSkinApplier;
import com.minekube.connect.shadow.com.google.inject.AbstractModule;
import com.minekube.connect.shadow.com.google.inject.Provides;
import com.minekube.connect.shadow.com.google.inject.Singleton;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.skin.SkinApplier;
import com.minekube.connect.util.LanguageManager;
import com.minekube.connect.util.ReflectionUtils;
import com.minekube.connect.util.SpigotCommandUtil;
import com.minekube.connect.util.SpigotPlatformUtils;
import com.minekube.connect.util.SpigotVersionSpecificMethods;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public final class SpigotPlatformModule
extends AbstractModule {
    private final SpigotPlugin plugin;

    @Override
    protected void configure() {
        this.bind(PlatformUtils.class).to(SpigotPlatformUtils.class);
    }

    @Provides
    @Singleton
    public JavaPlugin javaPlugin() {
        return this.plugin;
    }

    @Provides
    @Singleton
    public ConnectLogger logger(LanguageManager languageManager) {
        return new JavaUtilConnectLogger(this.plugin.getLogger(), languageManager);
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(ConnectApi api, SpigotVersionSpecificMethods versionSpecificMethods, LanguageManager languageManager) {
        return new SpigotCommandUtil(languageManager, this.plugin.getServer(), api, versionSpecificMethods, this.plugin);
    }

    @Provides
    @Singleton
    public ListenerRegistration<Listener> listenerRegistration() {
        return new SpigotListenerRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector(ConnectLogger logger) {
        boolean isViaVersion;
        String VIAVERSION_DOWNLOAD_URL = "https://ci.viaversion.com/job/ViaVersion/";
        boolean bl = isViaVersion = Bukkit.getPluginManager().getPlugin("ViaVersion") != null;
        if (isViaVersion && ReflectionUtils.getClassSilently("com.viaversion.viaversion.api.ViaManager") == null) {
            logger.warn("The plugin version of ViaVersion is too old, please install the latest release from {}", "https://ci.viaversion.com/job/ViaVersion/");
            isViaVersion = false;
        }
        return new SpigotInjector(logger, isViaVersion);
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "packet_handler";
    }

    @Provides
    @Named(value="platformName")
    public String platformName() {
        return "Spigot";
    }

    @Provides
    @Singleton
    public SkinApplier skinApplier(SpigotVersionSpecificMethods versionSpecificMethods) {
        return new SpigotSkinApplier(versionSpecificMethods, this.plugin);
    }

    @Provides
    @Singleton
    public SpigotVersionSpecificMethods versionSpecificMethods() {
        return new SpigotVersionSpecificMethods(this.plugin);
    }

    public SpigotPlatformModule(SpigotPlugin plugin) {
        this.plugin = plugin;
    }
}

