/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.module;

import com.minekube.connect.SpigotPlugin;
import com.minekube.connect.command.util.Permission;
import com.minekube.connect.module.CommandModule;
import com.minekube.connect.platform.command.CommandUtil;
import com.minekube.connect.player.ConnectCommandPreprocessor;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.BukkitCommandManager;
import com.minekube.connect.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import com.minekube.connect.shadow.com.google.inject.Provides;
import com.minekube.connect.shadow.com.google.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class SpigotCommandModule
extends CommandModule {
    private final SpigotPlugin plugin;

    @Override
    protected void configure() {
        super.configure();
        this.registerPermissions();
    }

    @Provides
    @Singleton
    public CommandManager<UserAudience> commandManager(CommandUtil commandUtil) {
        BukkitCommandManager<UserAudience> commandManager = new BukkitCommandManager<UserAudience>((Plugin)this.plugin, CommandExecutionCoordinator.simpleCoordinator(), commandUtil::getUserAudience, audience -> (CommandSender)audience.source());
        commandManager.registerCommandPreProcessor(new ConnectCommandPreprocessor(commandUtil));
        return commandManager;
    }

    private void registerPermissions() {
        PluginManager manager = Bukkit.getPluginManager();
        for (Permission permission : Permission.values()) {
            if (manager.getPermission(permission.get()) != null) continue;
            PermissionDefault defaultValue = PermissionDefault.getByName((String)permission.defaultValue().name());
            manager.addPermission(new org.bukkit.permissions.Permission(permission.get(), defaultValue));
        }
    }

    public SpigotCommandModule(SpigotPlugin plugin) {
        this.plugin = plugin;
    }
}

