/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.module;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.api.SimpleConnectApi;
import com.minekube.connect.api.inject.PlatformInjector;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.api.packet.PacketHandlers;
import com.minekube.connect.config.ConfigHolder;
import com.minekube.connect.config.ConfigLoader;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.inject.CommonPlatformInjector;
import com.minekube.connect.packet.PacketHandlersImpl;
import com.minekube.connect.platform.util.PlatformUtils;
import com.minekube.connect.shadow.com.google.common.base.Preconditions;
import com.minekube.connect.shadow.com.google.inject.AbstractModule;
import com.minekube.connect.shadow.com.google.inject.Provides;
import com.minekube.connect.shadow.com.google.inject.Singleton;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.util.HttpUtils;
import com.minekube.connect.util.LanguageManager;
import com.minekube.connect.util.Metrics;
import com.minekube.connect.util.Utils;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class CommonModule
extends AbstractModule {
    private final Path dataDirectory;

    @Override
    protected void configure() {
        this.bind(ConnectApi.class).to(SimpleConnectApi.class);
        this.bind(PlatformInjector.class).to(CommonPlatformInjector.class);
        this.bind(PacketHandlers.class).to(PacketHandlersImpl.class);
        this.bind(PacketHandlersImpl.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    @Named(value="dataDirectory")
    public Path dataDirectory() {
        return this.dataDirectory;
    }

    @Provides
    @Singleton
    public ConfigHolder configHolder() {
        return new ConfigHolder();
    }

    @Provides
    @Singleton
    public ConfigLoader configLoader(@Named(value="configClass") Class<? extends ConnectConfig> configClass, ConnectLogger logger, ConfigLoader.EndpointNameGenerator endpointNameGenerator) {
        return new ConfigLoader(this.dataDirectory, configClass, endpointNameGenerator, logger);
    }

    @Provides
    @Singleton
    public LanguageManager languageLoader(ConfigHolder configHolder, ConnectLogger logger) {
        return new LanguageManager(configHolder, logger);
    }

    @Provides
    @Singleton
    @Named(value="defaultHttpClient")
    public OkHttpClient defaultOkHttpClient() {
        return HttpUtils.defaultOkHttpClient();
    }

    @Provides
    @Singleton
    @Named(value="connectHttpClient")
    public OkHttpClient connectOkHttpClient(@Named(value="defaultHttpClient") OkHttpClient defaultOkHttpClient, PlatformUtils platformUtils, @Named(value="platformName") String implementationName, ConnectApi api) throws IOException {
        Path tokenFile = this.dataDirectory.resolve("token.json");
        Optional<String> token = Token.load(tokenFile);
        if (!token.isPresent()) {
            String t = Token.generate();
            Token.save(tokenFile, t);
            token = Optional.of(t);
        }
        String apiToken = token.get();
        return defaultOkHttpClient.newBuilder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + apiToken).addHeader("Connect-TotalPlayers", String.valueOf(platformUtils.getPlayerCount())).addHeader("Connect-Players", String.valueOf(api.getPlayerCount())).addHeader("Connect-AuthType", platformUtils.authType().name()).addHeader("Connect-Platform", implementationName).addHeader("Connect-Platform", platformUtils.serverImplementationName()).addHeader("Connect-MCVersion", platformUtils.minecraftVersion()).addHeader("Connect-JavaVersion", Metrics.JAVA_VERSION).addHeader("Connect-osName", Metrics.OS_NAME).addHeader("Connect-osArch", Metrics.OS_ARCH).addHeader("Connect-osVersion", Metrics.OS_VERSION).addHeader("Connect-coreCount", String.valueOf(Metrics.CORE_COUNT)).build())).build();
    }

    public CommonModule(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    private static class Token {
        @SerializedName(value="token")
        final String token;

        static Optional<String> load(Path tokenFile) throws IOException {
            if (Files.exists(tokenFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(tokenFile);){
                    Optional<String> optional = Optional.ofNullable((Token)new Gson().fromJson((Reader)reader, Token.class)).map(t -> t.token);
                    return optional;
                }
            }
            return Optional.empty();
        }

        static void save(Path tokenFile, String token) throws IOException {
            Preconditions.checkNotNull(tokenFile);
            Preconditions.checkNotNull(token);
            tokenFile.toFile().getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(tokenFile.toFile());){
                new Gson().toJson((Object)new Token(token), (Appendable)writer);
            }
        }

        static String generate() {
            return "T-" + Utils.randomSecureString(20);
        }

        public Token(String token) {
            this.token = token;
        }
    }
}

