/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.logger;

import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.util.LanguageManager;
import com.minekube.connect.util.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JavaUtilConnectLogger
implements ConnectLogger {
    private final Logger logger;
    private final LanguageManager languageManager;
    private Level originLevel;

    @Override
    public void error(String message, Object ... args2) {
        this.logger.severe(MessageFormatter.format(message, args2));
    }

    @Override
    public void error(String message, Throwable throwable, Object ... args2) {
        this.logger.log(Level.SEVERE, MessageFormatter.format(message, args2), throwable);
    }

    @Override
    public void warn(String message, Object ... args2) {
        this.logger.warning(MessageFormatter.format(message, args2));
    }

    @Override
    public void info(String message, Object ... args2) {
        this.logger.info(MessageFormatter.format(message, args2));
    }

    @Override
    public void translatedInfo(String message, Object ... args2) {
        this.logger.info(this.languageManager.getLogString(message, args2));
    }

    @Override
    public void debug(String message, Object ... args2) {
        this.logger.fine(MessageFormatter.format(message, args2));
    }

    @Override
    public void trace(String message, Object ... args2) {
        this.logger.finer(MessageFormatter.format(message, args2));
    }

    @Override
    public void enableDebug() {
        this.originLevel = this.logger.getLevel();
        this.logger.setLevel(Level.ALL);
    }

    @Override
    public void disableDebug() {
        if (this.originLevel != null) {
            this.logger.setLevel(this.originLevel);
        }
    }

    @Override
    public boolean isDebug() {
        return this.logger.getLevel() == Level.ALL;
    }

    public JavaUtilConnectLogger(Logger logger, LanguageManager languageManager) {
        this.logger = logger;
        this.languageManager = languageManager;
    }
}

