/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.listener;

import com.minekube.connect.api.SimpleConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.api.player.ConnectPlayer;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.util.LanguageManager;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public final class SpigotListener
implements Listener {
    @Inject
    private SimpleConnectApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private ConnectLogger logger;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(PlayerLoginEvent event) {
        UUID uniqueId = event.getPlayer().getUniqueId();
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        ConnectPlayer player = this.api.getPlayer(uniqueId);
        if (player != null) {
            this.logger.translatedInfo("connect.ingame.login_name", player.getUsername(), player.getUniqueId());
            this.languageManager.loadLocale(player.getLanguageTag());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }
}

