/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.inject.spigot;

import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.inject.CommonPlatformInjector;
import com.minekube.connect.inject.spigot.CustomList;
import com.minekube.connect.network.netty.LocalServerChannelWrapper;
import com.minekube.connect.network.netty.LocalSession;
import com.minekube.connect.util.ClassNames;
import com.minekube.connect.util.ReflectionUtils;
import com.viaversion.viaversion.bukkit.handlers.BukkitChannelInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SpigotInjector
extends CommonPlatformInjector {
    private final ConnectLogger logger;
    private final boolean isViaVersion;
    private CustomList allServerChannels;
    private Object serverConnection;
    private boolean injected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inject() throws Exception {
        if (this.isInjected()) {
            return true;
        }
        if (this.getServerConnection() != null) {
            for (Field field : this.serverConnection.getClass().getDeclaredFields()) {
                CustomList newList;
                if (field.getType() != List.class) continue;
                field.setAccessible(true);
                ParameterizedType parameterType = (ParameterizedType)field.getGenericType();
                Type listType = parameterType.getActualTypeArguments()[0];
                if (listType != ChannelFuture.class) continue;
                CustomList customList = newList = new CustomList((List)field.get(this.serverConnection)){

                    @Override
                    public void onAdd(Object object) {
                        try {
                            SpigotInjector.this.injectClient((ChannelFuture)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                synchronized (customList) {
                    for (Object object : newList) {
                        try {
                            this.injectClient((ChannelFuture)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                this.allServerChannels = newList;
                this.initializeLocalChannel();
                field.set(this.serverConnection, newList);
                this.injected = true;
                return true;
            }
        }
        return false;
    }

    public void injectClient(ChannelFuture future) {
        try {
            future.channel().pipeline().remove("connect-init");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        future.channel().pipeline().addFirst("connect-init", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                super.channelRead(ctx, msg);
                Channel channel = (Channel)msg;
                LocalSession.context(channel).filter(context -> !context.getPlayer().getAuth().isPassthrough()).ifPresent($ -> channel.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) {
                        SpigotInjector.this.injectAddonsCall(channel, false);
                        SpigotInjector.this.addInjectedClient(channel);
                    }
                }}));
            }
        });
    }

    public Object getServerConnection() throws IllegalAccessException, InvocationTargetException {
        if (this.serverConnection != null) {
            return this.serverConnection;
        }
        Class<?> minecraftServer = ClassNames.MINECRAFT_SERVER;
        Object minecraftServerInstance = ReflectionUtils.invokeStatic(minecraftServer, "getServer");
        for (Method method : minecraftServer.getDeclaredMethods()) {
            if (!ClassNames.SERVER_CONNECTION.equals(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            this.serverConnection = method.invoke(minecraftServerInstance, new Object[0]);
        }
        return this.serverConnection;
    }

    private void initializeLocalChannel() throws Exception {
        ChannelFuture listeningChannel = null;
        Iterator iterator2 = this.allServerChannels.iterator();
        if (iterator2.hasNext()) {
            Object o = iterator2.next();
            listeningChannel = (ChannelFuture)o;
        }
        if (listeningChannel == null) {
            throw new RuntimeException("Unable to find listening channel!");
        }
        final ChannelInitializer<Channel> childHandler = this.getChildHandler(listeningChannel);
        final Method initChannel = childHandler.getClass().getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                initChannel.invoke((Object)childHandler, ch);
            }
        }).group((EventLoopGroup)new DefaultEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("Connect Spigot connection thread", 10))).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.allServerChannels.add(channelFuture);
        this.localChannel = channelFuture;
        this.serverSocketAddress = channelFuture.channel().localAddress();
        this.workAroundWeirdBug();
    }

    private ChannelInitializer<Channel> getChildHandler(ChannelFuture listeningChannel) {
        List names = listeningChannel.channel().pipeline().names();
        ChannelInitializer childHandler = null;
        for (String name : names) {
            ChannelHandler handler = listeningChannel.channel().pipeline().get(name);
            try {
                Field childHandlerField = handler.getClass().getDeclaredField("childHandler");
                childHandlerField.setAccessible(true);
                childHandler = (ChannelInitializer)childHandlerField.get(handler);
                if (!this.isViaVersion || !(childHandler instanceof BukkitChannelInitializer)) break;
                childHandler = ((BukkitChannelInitializer)childHandler).getOriginal();
                break;
            }
            catch (Exception e) {
                if (!this.logger.isDebug()) continue;
                this.logger.debug("The handler " + name + " isn't a ChannelInitializer. THIS ERROR IS SAFE TO IGNORE!", new Object[0]);
            }
        }
        if (childHandler == null) {
            throw new RuntimeException();
        }
        return childHandler;
    }

    @Override
    public void shutdown() {
        if (this.allServerChannels != null) {
            this.allServerChannels.remove(this.localChannel);
            this.allServerChannels = null;
        }
        super.shutdown();
    }

    private void workAroundWeirdBug() {
        this.connectAndClose();
    }

    private void connectAndClose() {
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(this.serverSocketAddress).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(@NonNull ChannelHandlerContext ctx) {
                        ctx.close();
                    }
                }});
            }
        })).group((EventLoopGroup)new DefaultEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("Geyser Spigot workAroundWeirdBug thread", 10)))).connect().syncUninterruptibly();
    }

    public SpigotInjector(ConnectLogger logger, boolean isViaVersion) {
        this.logger = logger;
        this.isViaVersion = isViaVersion;
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }
}

