/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.inject;

import com.minekube.connect.api.inject.InjectorAddon;
import com.minekube.connect.api.inject.PlatformInjector;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonPlatformInjector
implements PlatformInjector {
    protected ChannelFuture localChannel;
    protected SocketAddress serverSocketAddress;
    private final Set<Channel> injectedClients = new HashSet<Channel>();
    private final Map<Class<?>, InjectorAddon> addons = new HashMap();

    public void shutdown() {
        if (this.localChannel != null && this.localChannel.channel().isOpen()) {
            try {
                this.localChannel.channel().close().sync();
                this.localChannel = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.localChannel != null) {
            this.localChannel = null;
        }
    }

    protected boolean addInjectedClient(Channel channel) {
        return this.injectedClients.add(channel);
    }

    public boolean removeInjectedClient(Channel channel) {
        return this.injectedClients.remove(channel);
    }

    @Override
    public boolean addAddon(InjectorAddon addon) {
        return this.addons.putIfAbsent(addon.getClass(), addon) == null;
    }

    @Override
    public <T extends InjectorAddon> T removeAddon(Class<T> addon) {
        return (T)this.addons.remove(addon);
    }

    public void injectAddonsCall(Channel channel, boolean proxyToServer) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onInject(channel, proxyToServer);
        }
    }

    public void channelClosedCall(Channel channel) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onChannelClosed(channel);
        }
    }

    public void removeAddonsCall(Channel channel) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onRemoveInject(channel);
        }
    }

    @Override
    public SocketAddress getServerSocketAddress() {
        return this.serverSocketAddress;
    }

    protected Set<Channel> getInjectedClients() {
        return this.injectedClients;
    }
}

