/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.config;

import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.config.ProxyConnectConfig;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.UUID;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.geysermc.configutils.ConfigUtilities;
import org.geysermc.configutils.file.codec.PathFileCodec;
import org.geysermc.configutils.file.template.ResourceTemplateReader;
import org.geysermc.configutils.updater.change.Changes;

public final class ConfigLoader {
    private final Path dataFolder;
    private final Class<? extends ConnectConfig> configClass;
    private final EndpointNameGenerator endpointNameGenerator;
    private final ConnectLogger logger;

    private static void fixPlaceholderIssue(Path path) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset).replace("${metrics.uuid}", UUID.randomUUID().toString());
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
    }

    public <T extends ConnectConfig> T load() {
        String templateFile = "config.yml";
        if (ProxyConnectConfig.class.isAssignableFrom(this.configClass)) {
            templateFile = "proxy-" + templateFile;
        }
        ConfigUtilities utilities = ConfigUtilities.builder().fileCodec(PathFileCodec.of(this.dataFolder)).configFile("config.yml").templateReader(ResourceTemplateReader.of(this.getClass())).template(templateFile).changes(Changes.builder().version(1, Changes.versionBuilder()).build()).definePlaceholder("metrics.uuid", UUID::randomUUID).definePlaceholder("endpoint", this.endpointNameGenerator::get).postInitializeCallbackArgument(this).saveConfigAutomatically(true).build();
        try {
            File config = new File(this.dataFolder.toFile(), "config.yml");
            if (config.exists()) {
                ConfigLoader.fixPlaceholderIssue(config.toPath());
            } else {
                utilities.executeOn(this.configClass);
            }
            ConfigLoader.fixPlaceholderIssue(config.toPath());
            return (T)utilities.executeOn(this.configClass);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to load the config! Try to delete the config file if this error persists", throwable);
        }
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public Class<? extends ConnectConfig> getConfigClass() {
        return this.configClass;
    }

    public EndpointNameGenerator getEndpointNameGenerator() {
        return this.endpointNameGenerator;
    }

    public ConnectLogger getLogger() {
        return this.logger;
    }

    public ConfigLoader(Path dataFolder, Class<? extends ConnectConfig> configClass, EndpointNameGenerator endpointNameGenerator, ConnectLogger logger) {
        this.dataFolder = dataFolder;
        this.configClass = configClass;
        this.endpointNameGenerator = endpointNameGenerator;
        this.logger = logger;
    }

    public static class EndpointNameGenerator {
        private static final String URL = "https://randomname.minekube.net";
        private final OkHttpClient client;

        @Inject
        public EndpointNameGenerator(@Named(value="defaultHttpClient") OkHttpClient client) {
            this.client = client.newBuilder().callTimeout(Duration.ofSeconds(5L)).build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String get() {
            String name;
            Request req = new Request.Builder().url(URL).build();
            try (Response res = this.client.newCall(req).execute();){
                if (res.code() != 200) {
                    String string = this.fallback();
                    return string;
                }
                try (ResponseBody body = res.body();){
                    assert (body != null);
                    name = body.string();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = this.fallback();
                    if (res == null) return string;
                    res.close();
                    return string;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return this.fallback();
            }
            if (!name.isEmpty()) return name;
            return this.fallback();
        }

        String fallback() {
            return Utils.randomString(5);
        }
    }
}

