/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.command.util;

import com.minekube.connect.command.util.PermissionDefault;

public enum Permission {
    COMMAND_MAIN("connect.command.connect", PermissionDefault.TRUE),
    COMMAND_MAIN_FIREWALL(COMMAND_MAIN, "firewall", PermissionDefault.OP),
    COMMAND_LINK("connect.command.linkaccount", PermissionDefault.TRUE),
    COMMAND_UNLINK("connect.command.unlinkaccount", PermissionDefault.TRUE),
    COMMAND_WHITELIST("connect.command.fwhitelist", PermissionDefault.OP),
    NEWS_RECEIVE("connect.news.receive", PermissionDefault.OP);

    private final String permission;
    private final PermissionDefault defaultValue;

    private Permission(String permission, PermissionDefault defaultValue) {
        this.permission = permission;
        this.defaultValue = defaultValue;
    }

    private Permission(Permission parent, String child, PermissionDefault defaultValue) {
        this(parent.get() + "." + child, defaultValue);
    }

    public String get() {
        return this.permission;
    }

    public PermissionDefault defaultValue() {
        return this.defaultValue;
    }
}

