/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.command.main;

import com.minekube.connect.command.main.FirewallCheckSubcommand;
import com.minekube.connect.command.util.Permission;
import com.minekube.connect.platform.command.ConnectCommand;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.shadow.cloud.commandframework.ArgumentDescription;
import com.minekube.connect.shadow.cloud.commandframework.Command;
import com.minekube.connect.shadow.cloud.commandframework.CommandManager;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import java.util.Locale;
import java.util.function.Consumer;

public final class MainCommand
implements ConnectCommand {
    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder<UserAudience> builder = commandManager.commandBuilder("connect", ArgumentDescription.of("A set of Minekube-Connect related actions in one command"), new String[0]).senderType(UserAudience.class).permission(Permission.COMMAND_MAIN.get()).handler(this::execute);
        for (SubCommand subCommand : SubCommand.VALUES) {
            commandManager.command(builder.literal(subCommand.name().toLowerCase(Locale.ROOT), subCommand.description).permission(subCommand.permission.get()).handler(subCommand.executor::accept));
        }
        return builder.build();
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        StringBuilder helpMessage = new StringBuilder("Available subcommands are:\n");
        for (SubCommand subCommand : SubCommand.VALUES) {
            if (!context.getSender().hasPermission(subCommand.permission.get())) continue;
            helpMessage.append('\n').append('\u00a7').append('b').append(subCommand.name().toLowerCase(Locale.ROOT)).append('\u00a7').append("f - ").append('\u00a7').append('7').append(subCommand.description);
        }
        context.getSender().sendMessage(helpMessage.toString());
    }

    static enum SubCommand {
        FIREWALL("Check if your outgoing firewall allows Floodgate to work properly", Permission.COMMAND_MAIN_FIREWALL, FirewallCheckSubcommand::executeFirewall);

        static final SubCommand[] VALUES;
        final String description;
        final Permission permission;
        final Consumer<CommandContext<UserAudience>> executor;

        private SubCommand(String description, Permission permission, Consumer<CommandContext<UserAudience>> executor) {
            this.description = description;
            this.permission = permission;
            this.executor = executor;
        }

        static {
            VALUES = SubCommand.values();
        }
    }
}

