/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.command.main;

import com.google.gson.JsonElement;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.types.tuples.Pair;
import com.minekube.connect.util.HttpUtils;
import com.minekube.connect.util.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;

final class FirewallCheckSubcommand {
    private FirewallCheckSubcommand() {
    }

    static void executeFirewall(CommandContext<UserAudience> context) {
        UserAudience sender = context.getSender();
        FirewallCheckSubcommand.executeChecks(FirewallCheckSubcommand.globalApiCheck(sender)).whenComplete((response, $) -> sender.sendMessage(String.format("\u00a7eThe checks have finished. %s/%s were successful", response.getFirst(), (Integer)response.getFirst() + (Integer)response.getSecond())));
    }

    private static BooleanSupplier globalApiCheck(UserAudience sender) {
        return FirewallCheckSubcommand.executeFirewallText(sender, "global api", () -> {
            HttpUtils.HttpResponse<JsonElement> response = HttpUtils.get("https://api.geysermc.org/health", JsonElement.class);
            if (!response.isCodeOk()) {
                throw new IllegalStateException(String.format("Didn't receive an 'ok' http code. Got: %s, response: %s", response.getHttpCode(), response.getResponse()));
            }
        });
    }

    private static BooleanSupplier executeFirewallText(UserAudience sender, String name, Runnable runnable2) {
        return () -> {
            sender.sendMessage("\u00a7eTesting " + name + "...");
            try {
                runnable2.run();
                sender.sendMessage("\u00a7aWas able to connect to " + name + "!");
                return true;
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to connect:");
                sender.sendMessage(Utils.getStackTrace(e));
                return false;
            }
        };
    }

    private static CompletableFuture<Pair<Integer, Integer>> executeChecks(BooleanSupplier ... checks) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicInteger okCount = new AtomicInteger();
            AtomicInteger failCount = new AtomicInteger();
            for (BooleanSupplier check2 : checks) {
                if (check2.getAsBoolean()) {
                    okCount.getAndIncrement();
                    continue;
                }
                failCount.getAndIncrement();
            }
            return Pair.of(okCount.get(), failCount.get());
        });
    }
}

