/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.api;

import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.api.player.ConnectPlayer;
import com.minekube.connect.shadow.com.google.common.cache.Cache;
import com.minekube.connect.shadow.com.google.common.cache.CacheBuilder;
import com.minekube.connect.shadow.com.google.common.collect.ImmutableSet;
import com.minekube.connect.shadow.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SimpleConnectApi
implements ConnectApi {
    private final Map<UUID, ConnectPlayer> players = Maps.newConcurrentMap();
    private final Cache<UUID, ConnectPlayer> pendingRemove = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();
    private final ConnectLogger logger;

    @Override
    public Collection<ConnectPlayer> getPlayers() {
        return ImmutableSet.copyOf(this.players.values());
    }

    @Override
    public int getPlayerCount() {
        return this.players.size();
    }

    @Override
    public boolean isConnectPlayer(UUID uuid) {
        return this.getPlayer(uuid) != null;
    }

    @Override
    public ConnectPlayer getPlayer(UUID uuid) {
        ConnectPlayer player = this.players.get(uuid);
        if (player != null) {
            return player;
        }
        return this.getPendingRemovePlayer(uuid);
    }

    public ConnectPlayer addPlayer(ConnectPlayer player) {
        return this.players.put(player.getUniqueId(), player);
    }

    public boolean setPendingRemove(ConnectPlayer player) {
        this.pendingRemove.put(player.getUniqueId(), player);
        return this.players.remove(player.getUniqueId(), player);
    }

    public void playerRemoved(UUID uuid) {
        this.pendingRemove.invalidate(uuid);
        this.players.remove(uuid);
    }

    private ConnectPlayer getPendingRemovePlayer(UUID uuid) {
        return this.pendingRemove.getIfPresent(uuid);
    }

    public SimpleConnectApi(ConnectLogger logger) {
        this.logger = logger;
    }
}

