/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.addon.data;

import com.google.gson.Gson;
import com.minekube.connect.SpigotPlugin;
import com.minekube.connect.addon.data.CommonDataHandler;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.network.netty.LocalSession;
import com.minekube.connect.util.ClassNames;
import com.minekube.connect.util.ProxyUtils;
import com.minekube.connect.util.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.util.function.UnaryOperator;

public final class SpigotDataHandler
extends CommonDataHandler {
    private final LocalSession.Context sessionCtx;
    private final String packetHandlerName;
    private static final Gson GSON = new Gson();

    public SpigotDataHandler(LocalSession.Context sessionCtx, String packetHandlerName, ConnectConfig config) {
        super(config);
        this.sessionCtx = sessionCtx;
        this.packetHandlerName = packetHandlerName;
    }

    private void removeSelf() {
        this.ctx.pipeline().remove((ChannelHandler)this);
    }

    @Override
    public boolean channelRead(Object packet) throws Exception {
        if (ClassNames.HANDSHAKE_PACKET.isInstance(packet)) {
            if (ProxyUtils.isBungeeData()) {
                String hostname = (String)ReflectionUtils.getCastedValue(packet, ClassNames.HANDSHAKE_HOST);
                ReflectionUtils.setValue(packet, ClassNames.HANDSHAKE_HOST, (Object)this.createBungeeForwardingAddress(hostname));
                if (!SpigotPlugin.isProtocolSupport()) {
                    this.removeSelf();
                }
                return true;
            }
            return true;
        }
        if (ClassNames.LOGIN_START_PACKET.isInstance(packet)) {
            ChannelHandler networkManager = this.ctx.channel().pipeline().get(this.packetHandlerName);
            Object packetListener = ClassNames.PACKET_LISTENER.get(networkManager);
            ReflectionUtils.setValue((Object)networkManager, "spoofedUUID", (Object)this.sessionCtx.getPlayer().getUniqueId());
            if (!ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
                this.removeSelf();
                return false;
            }
            if (ProxyUtils.isVelocitySupport()) {
                ReflectionUtils.setValue(packetListener, ClassNames.VELOCITY_LOGIN_MESSAGE_ID, (Object)0);
            }
            GameProfile gameProfile = new GameProfile(this.sessionCtx.getPlayer().getUniqueId(), this.sessionCtx.getPlayer().getUsername());
            if (ClassNames.IS_PRE_1_20_2) {
                Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
                ReflectionUtils.setValue(packetListener, ClassNames.LOGIN_PROFILE, (Object)gameProfile);
                ClassNames.INIT_UUID.invoke(packetListener, new Object[0]);
                ClassNames.FIRE_LOGIN_EVENTS.invoke(loginHandler, new Object[0]);
            } else if (!ClassNames.IS_POST_LOGIN_HANDLER) {
                Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
                ClassNames.FIRE_LOGIN_EVENTS_GAME_PROFILE.invoke(loginHandler, gameProfile);
            } else {
                ClassNames.CALL_PLAYER_PRE_LOGIN_EVENTS.invoke(packetListener, gameProfile);
                ClassNames.START_CLIENT_VERIFICATION.invoke(packetListener, gameProfile);
            }
            this.removeSelf();
            return false;
        }
        return true;
    }

    private String createBungeeForwardingAddress(String virtualHost) {
        StringBuilder data = new StringBuilder().append(virtualHost).append('\u0000').append(this.getPlayerRemoteAddressAsString()).append('\u0000').append(this.sessionCtx.getPlayer().getUniqueId().toString().replaceAll("-", "")).append('\u0000');
        GSON.toJson(UnaryOperator.identity().apply(this.sessionCtx.getPlayer().getGameProfile().getProperties()), (Appendable)data);
        return data.toString();
    }

    private String getPlayerRemoteAddressAsString() {
        String addr = ((InetSocketAddress)this.ctx.channel().remoteAddress()).getAddress().getHostAddress();
        int ipv6ScopeIdx = addr.indexOf(37);
        if (ipv6ScopeIdx == -1) {
            return addr;
        }
        return addr.substring(0, ipv6ScopeIdx);
    }
}

