/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.addon;

import com.minekube.connect.addon.debug.ChannelInDebugHandler;
import com.minekube.connect.addon.debug.ChannelOutDebugHandler;
import com.minekube.connect.api.inject.InjectorAddon;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.util.Utils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.atomic.AtomicInteger;

public final class DebugAddon
implements InjectorAddon {
    @Inject
    private ConnectConfig config;
    @Inject
    private ConnectLogger logger;
    @Inject
    @Named(value="platformName")
    private String platformName;
    @Inject
    @Named(value="packetEncoder")
    private String packetEncoder;
    @Inject
    @Named(value="packetDecoder")
    private String packetDecoder;

    @Override
    public void onInject(Channel channel, boolean toServer) {
        this.logger.info("Successfully called onInject. To server? " + toServer, new Object[0]);
        AtomicInteger packetCount = new AtomicInteger();
        channel.pipeline().addBefore(this.packetEncoder, "connect_debug_out", (ChannelHandler)new ChannelOutDebugHandler(this.platformName, toServer, packetCount, this.logger)).addBefore(this.packetDecoder, "connect_debug_in", (ChannelHandler)new ChannelInDebugHandler(this.platformName, toServer, packetCount, this.logger));
    }

    @Override
    public void onRemoveInject(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        Utils.removeHandler(pipeline, "connect_debug_out");
        Utils.removeHandler(pipeline, "connect_debug_in");
    }

    @Override
    public boolean shouldInject() {
        return this.config.isDebug();
    }
}

