/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect;

import com.minekube.connect.SpigotPlatform;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.module.PaperListenerModule;
import com.minekube.connect.module.ServerCommonModule;
import com.minekube.connect.module.SpigotAddonModule;
import com.minekube.connect.module.SpigotCommandModule;
import com.minekube.connect.module.SpigotListenerModule;
import com.minekube.connect.module.SpigotPlatformModule;
import com.minekube.connect.module.WatcherModule;
import com.minekube.connect.shadow.com.google.inject.Guice;
import com.minekube.connect.shadow.com.google.inject.Injector;
import com.minekube.connect.util.ReflectionUtils;
import com.minekube.connect.util.SpigotProtocolSupportHandler;
import com.minekube.connect.util.SpigotProtocolSupportListener;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SpigotPlugin
extends JavaPlugin {
    private SpigotPlatform platform;
    private Injector injector;

    public void onLoad() {
        long ctm = System.currentTimeMillis();
        this.injector = Guice.createInjector(new ServerCommonModule(this.getDataFolder().toPath()), new SpigotPlatformModule(this));
        this.platform = this.injector.getInstance(SpigotPlatform.class);
        long endCtm = System.currentTimeMillis();
        this.injector.getInstance(ConnectLogger.class).translatedInfo("connect.core.finish", endCtm - ctm);
    }

    public void onEnable() {
        boolean usePaperListener = ReflectionUtils.getClassSilently("com.destroystokyo.paper.event.profile.PreFillProfileEvent") != null;
        this.platform.enable(new SpigotCommandModule(this), new SpigotAddonModule(), usePaperListener ? new PaperListenerModule() : new SpigotListenerModule(), new WatcherModule());
        if (SpigotPlugin.isProtocolSupport()) {
            this.injector.getInstance(SpigotProtocolSupportHandler.class);
            SpigotProtocolSupportListener.registerHack((Plugin)this);
        }
    }

    public static boolean isProtocolSupport() {
        return Bukkit.getServer().getPluginManager().getPlugin("ProtocolSupport") != null;
    }

    public void onDisable() {
        this.platform.disable();
    }
}

