/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect;

import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.api.InstanceHolder;
import com.minekube.connect.api.inject.PlatformInjector;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.api.packet.PacketHandlers;
import com.minekube.connect.config.ConfigHolder;
import com.minekube.connect.config.ConfigLoader;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.inject.CommonPlatformInjector;
import com.minekube.connect.module.ConfigLoadedModule;
import com.minekube.connect.module.PostInitializeModule;
import com.minekube.connect.register.WatcherRegister;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.Injector;
import com.minekube.connect.shadow.com.google.inject.Module;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.tunnel.Tunneler;
import com.minekube.connect.util.Metrics;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class ConnectPlatform {
    private static final String DOMAIN_SUFFIX = ".play.minekube.net";
    private static final UUID KEY = UUID.randomUUID();
    private final ConnectApi api;
    private final PlatformInjector injector;
    private final ConnectLogger logger;
    private ConnectConfig config;
    private Injector guice;

    @Inject
    public ConnectPlatform(ConnectApi api, PlatformInjector platformInjector, ConnectLogger logger, Injector guice) {
        this.api = api;
        this.injector = platformInjector;
        this.logger = logger;
        this.guice = guice;
    }

    @Inject
    public void init(@Named(value="dataDirectory") Path dataDirectory, ConfigLoader configLoader, ConfigHolder configHolder, PacketHandlers packetHandlers) {
        if (!Files.isDirectory(dataDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(dataDirectory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                this.logger.error("Failed to create the data folder", exception, new Object[0]);
                throw new RuntimeException("Failed to create the data folder", exception);
            }
        }
        this.config = configLoader.load();
        if (this.config.isDebug()) {
            this.logger.enableDebug();
            this.logger.debug("Debug mode enabled", new Object[0]);
        }
        configHolder.set(this.config);
        this.guice = this.guice.createChildInjector(new ConfigLoadedModule(this.config));
        InstanceHolder.set(this.api, this.injector, packetHandlers, KEY);
    }

    public boolean enable(Module ... postInitializeModules) {
        if (this.injector == null) {
            this.logger.error("Failed to find the platform injector!", new Object[0]);
            return false;
        }
        try {
            if (!this.injector.inject()) {
                this.logger.error("Failed to inject the packet listener!", new Object[0]);
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.error("Failed to inject the packet listener!", exception, new Object[0]);
            return false;
        }
        this.guice = this.guice.createChildInjector(new PostInitializeModule(postInitializeModules));
        this.guice.getInstance(Metrics.class);
        this.logger.info("Endpoint name: " + this.config.getEndpoint(), new Object[0]);
        if (this.config.getSuperEndpoints() != null && !this.config.getSuperEndpoints().isEmpty()) {
            this.logger.info("Super endpoints: " + String.join((CharSequence)", ", this.config.getSuperEndpoints()), new Object[0]);
        }
        this.logger.info("Your public address: " + this.config.getEndpoint() + DOMAIN_SUFFIX, new Object[0]);
        return true;
    }

    public boolean disable() {
        this.guice.getInstance(WatcherRegister.class).stop();
        this.guice.getInstance(Tunneler.class).close();
        this.guice.getInstance(CommonPlatformInjector.class).shutdown();
        return true;
    }

    public boolean isProxy() {
        return this.config.isProxy();
    }
}

