/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import io.netty.buffer.ByteBuf;

public record Instrument(Holder<SoundEvent> soundEvent, int useDuration, float range) {
    public static final HolderType<Instrument> TYPE = new HolderType<Instrument>(){

        @Override
        public Instrument readDirect(ByteBuf buffer) {
            Object soundEvent = Types.SOUND_EVENT.read(buffer);
            int useDuration = Types.VAR_INT.readPrimitive(buffer);
            float range = buffer.readFloat();
            return new Instrument((Holder<SoundEvent>)soundEvent, useDuration, range);
        }

        @Override
        public void writeDirect(ByteBuf buffer, Instrument value) {
            Types.SOUND_EVENT.write(buffer, value.soundEvent());
            Types.VAR_INT.writePrimitive(buffer, value.useDuration());
            buffer.writeFloat(value.range());
        }
    };
}

