/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.FoodEffect;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.Types1_21;
import io.netty.buffer.ByteBuf;

public record FoodProperties(int nutrition, float saturationModifier, boolean canAlwaysEat, float eatSeconds, Item usingConvertsTo, FoodEffect[] possibleEffects) {
    public static final Type<FoodProperties> TYPE1_20_5 = new Type<FoodProperties>(FoodProperties.class){

        @Override
        public FoodProperties read(ByteBuf buffer) {
            int nutrition = Types.VAR_INT.readPrimitive(buffer);
            float saturationModifier = buffer.readFloat();
            boolean canAlwaysEat = buffer.readBoolean();
            float eatSeconds = buffer.readFloat();
            FoodEffect[] possibleEffects = (FoodEffect[])FoodEffect.ARRAY_TYPE.read(buffer);
            return new FoodProperties(nutrition, saturationModifier, canAlwaysEat, eatSeconds, null, possibleEffects);
        }

        @Override
        public void write(ByteBuf buffer, FoodProperties value) {
            Types.VAR_INT.writePrimitive(buffer, value.nutrition);
            buffer.writeFloat(value.saturationModifier);
            buffer.writeBoolean(value.canAlwaysEat);
            buffer.writeFloat(value.eatSeconds);
            FoodEffect.ARRAY_TYPE.write(buffer, value.possibleEffects);
        }
    };
    public static final Type<FoodProperties> TYPE1_21 = new Type<FoodProperties>(FoodProperties.class){

        @Override
        public FoodProperties read(ByteBuf buffer) {
            int nutrition = Types.VAR_INT.readPrimitive(buffer);
            float saturationModifier = buffer.readFloat();
            boolean canAlwaysEat = buffer.readBoolean();
            float eatSeconds = buffer.readFloat();
            Item usingConvertsTo = (Item)Types1_21.OPTIONAL_ITEM.read(buffer);
            FoodEffect[] possibleEffects = (FoodEffect[])FoodEffect.ARRAY_TYPE.read(buffer);
            return new FoodProperties(nutrition, saturationModifier, canAlwaysEat, eatSeconds, usingConvertsTo, possibleEffects);
        }

        @Override
        public void write(ByteBuf buffer, FoodProperties value) {
            Types.VAR_INT.writePrimitive(buffer, value.nutrition);
            buffer.writeFloat(value.saturationModifier);
            buffer.writeBoolean(value.canAlwaysEat);
            buffer.writeFloat(value.eatSeconds);
            Types1_21.OPTIONAL_ITEM.write(buffer, value.usingConvertsTo);
            FoodEffect.ARRAY_TYPE.write(buffer, value.possibleEffects);
        }
    };
}

