/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.entities.storage.EntityObjectData;
import com.viaversion.viabackwards.api.entities.storage.EntityReplacement;
import com.viaversion.viabackwards.api.entities.storage.WrappedEntityData;
import com.viaversion.viabackwards.api.rewriters.EntityRewriterBase;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.ObjectType;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_9;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class LegacyEntityRewriter<C extends ClientboundPacketType, T extends BackwardsProtocol<C, ?, ?, ?>>
extends EntityRewriterBase<C, T> {
    private final Map<ObjectType, EntityReplacement> objectTypes = new HashMap<ObjectType, EntityReplacement>();

    protected LegacyEntityRewriter(T protocol) {
        this(protocol, (EntityDataType)EntityDataTypes1_9.STRING, (EntityDataType)EntityDataTypes1_9.BOOLEAN);
    }

    protected LegacyEntityRewriter(T protocol, EntityDataType displayType, EntityDataType displayVisibilityType) {
        super(protocol, displayType, 2, displayVisibilityType, 3);
    }

    protected EntityObjectData mapObjectType(ObjectType oldObjectType, ObjectType replacement, int data) {
        EntityObjectData entData = new EntityObjectData((BackwardsProtocol)this.protocol, oldObjectType.getType().name(), oldObjectType.getId(), replacement.getId(), data);
        this.objectTypes.put(oldObjectType, entData);
        return entData;
    }

    protected @Nullable EntityReplacement getObjectData(ObjectType type) {
        return this.objectTypes.get(type);
    }

    protected void registerRespawn(C packetType) {
        ((BackwardsProtocol)this.protocol).registerClientbound((ClientboundPacketType)packetType, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    ClientWorld clientWorld = (ClientWorld)wrapper.user().get(ClientWorld.class);
                    clientWorld.setEnvironment(((Integer)wrapper.get((Type)Types.INT, 0)).intValue());
                });
            }
        });
    }

    protected void registerJoinGame(C packetType, final EntityType playerType) {
        ((BackwardsProtocol)this.protocol).registerClientbound((ClientboundPacketType)packetType, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    ClientWorld clientChunks = (ClientWorld)wrapper.user().get(ClientWorld.class);
                    clientChunks.setEnvironment(((Integer)wrapper.get((Type)Types.INT, 1)).intValue());
                    LegacyEntityRewriter.this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Types.INT, 0), playerType);
                });
            }
        });
    }

    public void registerSetEntityData(C packetType, final Type<List<EntityData>> dataType, final Type<List<EntityData>> mappedDataType) {
        ((BackwardsProtocol)this.protocol).registerClientbound((ClientboundPacketType)packetType, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                if (dataType != null) {
                    this.map(dataType, mappedDataType);
                } else {
                    this.map(mappedDataType);
                }
                this.handler(wrapper -> {
                    List entityDataList = (List)wrapper.get(mappedDataType, 0);
                    LegacyEntityRewriter.this.handleEntityData((Integer)wrapper.get((Type)Types.VAR_INT, 0), entityDataList, wrapper.user());
                });
            }
        });
    }

    public void registerSetEntityData(C packetType, Type<List<EntityData>> dataType) {
        this.registerSetEntityData(packetType, null, dataType);
    }

    protected PacketHandler getMobSpawnRewriter(Type<List<EntityData>> dataType, IdSetter idSetter) {
        return wrapper -> {
            int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
            EntityType type = this.tracker(wrapper.user()).entityType(entityId);
            List entityDataList = (List)wrapper.get(dataType, 0);
            this.handleEntityData(entityId, entityDataList, wrapper.user());
            EntityReplacement entityReplacement = this.entityDataForType(type);
            if (entityReplacement != null) {
                idSetter.setId(wrapper, entityReplacement.replacementId());
                if (entityReplacement.hasBaseData()) {
                    entityReplacement.defaultData().createData(new WrappedEntityData(entityDataList));
                }
            }
        };
    }

    public PacketHandler getMobSpawnRewriter(Type<List<EntityData>> dataType) {
        return this.getMobSpawnRewriter(dataType, (wrapper, id) -> wrapper.set((Type)Types.UNSIGNED_BYTE, 0, (Object)((short)id)));
    }

    public PacketHandler getMobSpawnRewriter1_11(Type<List<EntityData>> dataType) {
        return this.getMobSpawnRewriter(dataType, (wrapper, id) -> wrapper.set((Type)Types.VAR_INT, 1, (Object)id));
    }

    protected PacketHandler getObjectTrackerHandler() {
        return wrapper -> this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Types.VAR_INT, 0), this.objectTypeFromId(((Byte)wrapper.get((Type)Types.BYTE, 0)).byteValue()));
    }

    protected PacketHandler getTrackerAndDataHandler(Type<List<EntityData>> dataType, EntityType entityType) {
        return wrapper -> {
            this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Types.VAR_INT, 0), entityType);
            List entityDataList = (List)wrapper.get(dataType, 0);
            this.handleEntityData((Integer)wrapper.get((Type)Types.VAR_INT, 0), entityDataList, wrapper.user());
        };
    }

    protected PacketHandler getObjectRewriter(Function<Byte, ObjectType> objectGetter) {
        return wrapper -> {
            ObjectType type = (ObjectType)objectGetter.apply((Byte)wrapper.get((Type)Types.BYTE, 0));
            if (type == null) {
                ((BackwardsProtocol)this.protocol).getLogger().warning("Could not find entity type " + wrapper.get((Type)Types.BYTE, 0));
                return;
            }
            EntityReplacement data = this.getObjectData(type);
            if (data != null) {
                wrapper.set((Type)Types.BYTE, 0, (Object)((byte)data.replacementId()));
                if (data.objectData() != -1) {
                    wrapper.set((Type)Types.INT, 0, (Object)data.objectData());
                }
            }
        };
    }

    @Deprecated
    protected void addTrackedEntity(PacketWrapper wrapper, int entityId, EntityType type) {
        this.tracker(wrapper.user()).addEntity(entityId, type);
    }

    @FunctionalInterface
    protected static interface IdSetter {
        public void setId(PacketWrapper var1, int var2);
    }
}

