/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.CEConfig;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.actions.ActionGroup;
import ce.ajneb97.model.actions.ActionType;
import ce.ajneb97.model.actions.CEAction;
import ce.ajneb97.model.verify.CEError;
import ce.ajneb97.model.verify.CEErrorAction;
import ce.ajneb97.model.verify.CEErrorCondition;
import ce.ajneb97.model.verify.CEErrorEventType;
import ce.ajneb97.model.verify.CEErrorRandomVariable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class VerifyManager {
    private ConditionalEvents plugin;
    private ArrayList<CEError> errors;

    public VerifyManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.errors = new ArrayList();
    }

    public void sendVerification(Player player) {
        player.sendMessage(MessagesManager.getColoredMessage("&f&l- - - - - - - - &b&lEVENTS VERIFY &f&l- - - - - - - -"));
        player.sendMessage(MessagesManager.getColoredMessage(""));
        if (this.errors.isEmpty()) {
            player.sendMessage(MessagesManager.getColoredMessage("&aThere are no errors in your events ;)"));
        } else {
            player.sendMessage(MessagesManager.getColoredMessage("&e&oHover on the errors to see more information."));
            for (CEError error : this.errors) {
                error.sendMessage(player);
            }
        }
        player.sendMessage(MessagesManager.getColoredMessage(""));
        player.sendMessage(MessagesManager.getColoredMessage("&f&l- - - - - - - - &b&lEVENTS VERIFY &f&l- - - - - - - -"));
    }

    public void verifyEvents() {
        this.errors = new ArrayList();
        ArrayList<CEEvent> events = this.plugin.getEventsManager().getEvents();
        for (CEEvent event : events) {
            this.verifyEvent(event);
        }
        ArrayList<CEConfig> ceConfigs = this.plugin.getConfigsManager().getEventConfigs();
        for (CEConfig ceConfig : ceConfigs) {
            FileConfiguration config = ceConfig.getConfig();
            if (!config.contains("Events")) {
                return;
            }
            for (String key : config.getConfigurationSection("Events").getKeys(false)) {
                String eventType = config.getString("Events." + key + ".type");
                try {
                    EventType.valueOf(eventType.toUpperCase());
                }
                catch (Exception e) {
                    this.errors.add(new CEErrorEventType(key, eventType));
                }
                String pathActions = "Events." + key + ".actions";
                if (!config.contains(pathActions)) continue;
                for (String groupName : config.getConfigurationSection(pathActions).getKeys(false)) {
                    String path = pathActions + "." + groupName;
                    List actionsList = config.getStringList(path);
                    for (int i = 0; i < actionsList.size(); ++i) {
                        String replace;
                        String action;
                        String actionOriginal = action = (String)actionsList.get(i);
                        if (action.startsWith("to_all: ")) {
                            action = action.replace("to_all: ", "");
                        } else if (action.startsWith("to_target: ")) {
                            action = action.replace("to_target: ", "");
                        } else if (action.startsWith("to_world: ")) {
                            action = action.replace("to_world: ", "");
                            replace = action.substring(0, action.indexOf(":") + 2);
                            action = action.replace(replace, "");
                        } else if (action.startsWith("to_range: ")) {
                            action = action.replace("to_range: ", "");
                            replace = action.substring(0, action.indexOf(":") + 2);
                            action = action.replace(replace, "");
                        } else if (action.startsWith("to_condition: ")) {
                            action = action.replace("to_condition: ", "");
                            replace = action.substring(0, action.indexOf(":") + 2);
                            action = action.replace(replace, "");
                        } else if (action.startsWith("to_player: ")) {
                            action = action.replace("to_player: ", "");
                            replace = action.substring(0, action.indexOf(":") + 2);
                            action = action.replace(replace, "");
                        }
                        try {
                            String actionTypeText = action.equalsIgnoreCase("close_inventory") || action.equalsIgnoreCase("clear_inventory") ? action : action.substring(0, action.indexOf(":"));
                            if (this.plugin.getApiManager().getApiAction(actionTypeText) != null) continue;
                            ActionType.valueOf(actionTypeText.toUpperCase());
                            continue;
                        }
                        catch (Exception e) {
                            this.errors.add(new CEErrorAction(key, actionOriginal, i + 1, groupName));
                        }
                    }
                }
            }
        }
    }

    public void verifyEvent(CEEvent event) {
        List<String> conditions = event.getConditions();
        for (int i = 0; i < conditions.size(); ++i) {
            if (!this.verifyCondition(conditions.get(i))) {
                this.errors.add(new CEErrorCondition(event.getName(), conditions.get(i), i + 1));
            }
            if (this.verifyRandomVariable(conditions.get(i))) continue;
            this.errors.add(new CEErrorRandomVariable(event.getName(), conditions.get(i)));
        }
        List<ActionGroup> actionGroups = event.getActionGroups();
        for (ActionGroup actionGroup : actionGroups) {
            List<CEAction> actions = actionGroup.getActions();
            for (CEAction action : actions) {
                if (this.verifyRandomVariable(action.getActionLine())) continue;
                this.errors.add(new CEErrorRandomVariable(event.getName(), action.getActionLine()));
            }
        }
    }

    private boolean verifyRandomVariable(String line) {
        for (int c = 0; c < line.length(); ++c) {
            String[] sep;
            int lastPos;
            int startPos;
            if (line.charAt(c) != '%' || (startPos = c + 1) >= line.length() || (lastPos = line.indexOf(37, c + 1)) == -1 || line.charAt(startPos) == ' ' || line.charAt(lastPos - 1) == ' ') continue;
            String variable = line.substring(startPos, lastPos);
            if (variable.startsWith("random_") && !variable.startsWith("random_player") && (sep = variable.split("_")).length != 3) {
                return false;
            }
            c = lastPos;
        }
        return true;
    }

    public boolean verifyCondition(String line) {
        String[] sepExecute = line.split(" execute ");
        String[] sepOr = sepExecute[0].split(" or ");
        for (int i = 0; i < sepOr.length; ++i) {
            String[] sep = sepOr[i].split(" ");
            if (sep.length < 3) {
                return false;
            }
            if (sep[1].equals("!=") || sep[1].equals("==") || sep[1].equals(">=") || sep[1].equals("<=") || sep[1].equals(">") || sep[1].equals("<") || sep[1].equals("equals") || sep[1].equals("!equals") || sep[1].equals("contains") || sep[1].equals("!contains") || sep[1].equals("startsWith") || sep[1].equals("!startsWith") || sep[1].equals("equalsIgnoreCase") || sep[1].equals("!equalsIgnoreCase")) continue;
            return false;
        }
        return true;
    }
}

