/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.CEConfig;
import ce.ajneb97.utils.OtherUtils;
import java.io.File;
import java.util.ArrayList;

public class DataFolderConfigManager {
    protected ArrayList<CEConfig> configs;
    protected ConditionalEvents plugin;
    private String folderName;

    public DataFolderConfigManager(ConditionalEvents plugin, String folderName) {
        this.plugin = plugin;
        this.folderName = folderName;
        this.configs = new ArrayList();
    }

    public void configure() {
        this.createFolder();
        this.reloadConfigs();
    }

    public void reloadConfigs() {
        this.configs = new ArrayList();
        this.registerConfigs();
    }

    public void createFolder() {
        try {
            File folder = new File(this.plugin.getDataFolder() + File.separator + this.folderName);
            if (!folder.exists()) {
                folder.mkdirs();
                this.createExample();
            }
        }
        catch (SecurityException e) {
            Object folder = null;
        }
    }

    public void createExample() {
        String pathName = "more_events.yml";
        CEConfig config = new CEConfig(pathName, this.plugin, this.folderName);
        config.registerConfig();
    }

    public void saveConfigs() {
        for (int i = 0; i < this.configs.size(); ++i) {
            this.configs.get(i).saveConfig();
        }
    }

    public void registerConfigs() {
        String path = this.plugin.getDataFolder() + File.separator + this.folderName;
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String pathName;
            String ext;
            if (!listOfFiles[i].isFile() || !(ext = OtherUtils.getFileExtension(pathName = listOfFiles[i].getName())).equals("yml")) continue;
            CEConfig config = new CEConfig(pathName, this.plugin, this.folderName);
            config.registerConfig();
            this.configs.add(config);
        }
    }

    public ArrayList<CEConfig> getConfigs() {
        return this.configs;
    }

    public boolean fileAlreadyRegistered(String pathName) {
        for (int i = 0; i < this.configs.size(); ++i) {
            if (!this.configs.get(i).getPath().equals(pathName)) continue;
            return true;
        }
        return false;
    }

    public CEConfig getConfig(String pathName) {
        for (int i = 0; i < this.configs.size(); ++i) {
            if (!this.configs.get(i).getPath().equals(pathName)) continue;
            return this.configs.get(i);
        }
        return null;
    }

    public boolean registerConfig(String pathName) {
        if (!this.fileAlreadyRegistered(pathName)) {
            CEConfig config = new CEConfig(pathName, this.plugin, this.folderName);
            config.registerConfig();
            this.configs.add(config);
            return true;
        }
        return false;
    }
}

