import{s as St,o as Xt,n as At}from"../chunks/scheduler.36a0863c.js";import{S as Nt,i as Yt,g as l,s as i,u,A as Ft,h as n,f as t,c as o,j as d,v as m,y as r,k as p,o as c,a,w as f,d as g,t as y,x as M}from"../chunks/index.d0f7a4c4.js";import{T as Qt}from"../chunks/Tip.4c7d7eb1.js";import{I as we}from"../chunks/IconCopyLink.bc5fad79.js";import{C as v}from"../chunks/CodeBlock.69433f87.js";function Dt(Ue){let h,W="Echa un vistazo a la documentación de <code>pipeline()</code> para obtener una lista completa de tareas admitidas.";return{c(){h=l("p"),h.innerHTML=W},l(j){h=n(j,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1daerre"&&(h.innerHTML=W)},m(j,he){a(j,h,he)},p:At,d(j){j&&t(h)}}}function Kt(Ue){let h,W,j,he,x,T,ye,_,pt,de,ut="Pipelines para inferencia",be,B,mt='Un <code>pipeline()</code> simplifica el uso de cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para la inferencia en una variedad de tareas como la generación de texto, la segmentación de imágenes y la clasificación de audio. Incluso si no tienes experiencia con una modalidad específica o no comprendes el código que alimenta los modelos, ¡aún puedes usarlos con el <code>pipeline()</code>! Este tutorial te enseñará a:',Te,H,ft="<li>Utilizar un <code>pipeline()</code> para inferencia.</li> <li>Utilizar un tokenizador o modelo específico.</li> <li>Utilizar un <code>pipeline()</code> para tareas de audio y visión.</li>",ke,k,Je,$,J,Me,E,rt,ue,gt="Uso del pipeline",Ze,V,yt="Si bien cada tarea tiene un <code>pipeline()</code> asociado, es más sencillo usar la abstracción general <code>pipeline()</code> que contiene todos los pipelines de tareas específicas. El <code>pipeline()</code> carga automáticamente un modelo predeterminado y un tokenizador con capacidad de inferencia para tu tarea.",Ce,q,Mt="<li>Comienza creando un <code>pipeline()</code> y específica una tarea de inferencia:</li>",Ge,z,Ie,Z,jt="<li>Pasa tu texto de entrada al <code>pipeline()</code>:</li>",We,L,_e,R,vt="Si tienes más de una entrada, pásala como una lista:",Be,P,He,S,xt="Cualquier parámetro adicional para tu tarea también se puede incluir en el <code>pipeline()</code>. La tarea <code>text-generation</code> tiene un método <code>generate()</code> con varios parámetros para controlar la salida. Por ejemplo, si deseas generar más de una salida, defínelo en el parámetro <code>num_return_sequences</code>:",Ee,X,Ve,w,C,je,A,ct,me,$t="Selecciona un modelo y un tokenizador",qe,N,wt='El <code>pipeline()</code> acepta cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Hay etiquetas en el Model Hub que te permiten filtrar por el modelo que te gustaría utilizar para tu tarea. Una vez que hayas elegido un modelo apropiado, cárgalo con la clase <code>AutoModelFor</code> y <code>AutoTokenizer</code> correspondientes. Por ejemplo, carga la clase <code>AutoModelForCausalLM</code> para una tarea de modelado de lenguaje causal:',ze,Y,Le,F,Ut="Crea un <code>pipeline()</code> para tu tarea y específica el modelo y el tokenizador que cargaste:",Re,Q,Pe,D,bt="Pasa tu texto de entrada a <code>pipeline()</code> para generar algo de texto:",Se,K,Xe,U,G,ve,O,ht,fe,Tt="Pipeline de audio",Ae,ee,kt="La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.",Ne,te,Jt='Por ejemplo, clasifiquemos la emoción de un breve fragmento del famoso discurso de John F. Kennedy <a href="https://en.wikipedia.org/wiki/We_choose_to_go_to_the_Moon" rel="nofollow">“We choose to go to the Moon”</a>. Encuentra un modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para reconocimiento de emociones en el Model Hub y cárgalo en el <code>pipeline()</code>:',Ye,se,Fe,ae,Zt="Pasa el archivo de audio al <code>pipeline()</code>:",Qe,le,De,b,I,xe,ne,dt,ge,Ct="Pipeline de visión",Ke,ie,Gt="Finalmente, utilizar un <code>pipeline()</code> para tareas de visión es prácticamente igual.",Oe,oe,It="Específica tu tarea de visión y pasa tu imagen al clasificador. La imagen puede ser un enlace o una ruta local a la imagen. Por ejemplo, ¿qué especie de gato se muestra a continuación?",et,pe,Wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',tt,re,st,$e,at;return _=new we({}),k=new Qt({props:{$$slots:{default:[Dt]},$$scope:{ctx:Ue}}}),E=new we({}),z=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`}}),L=new v({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`}}),P=new v({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`}}),X=new v({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`}}),A=new we({}),Y=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`}}),Q=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`}}),K=new v({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`}}),O=new we({}),se=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`}}),le=new v({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`}}),ne=new we({}),re=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`}}),{c(){h=l("meta"),W=i(),j=l("p"),he=i(),x=l("h1"),T=l("a"),ye=l("span"),u(_.$$.fragment),pt=i(),de=l("span"),de.textContent=ut,be=i(),B=l("p"),B.innerHTML=mt,Te=i(),H=l("ul"),H.innerHTML=ft,ke=i(),u(k.$$.fragment),Je=i(),$=l("h2"),J=l("a"),Me=l("span"),u(E.$$.fragment),rt=i(),ue=l("span"),ue.textContent=gt,Ze=i(),V=l("p"),V.innerHTML=yt,Ce=i(),q=l("ol"),q.innerHTML=Mt,Ge=i(),u(z.$$.fragment),Ie=i(),Z=l("ol"),Z.innerHTML=jt,We=i(),u(L.$$.fragment),_e=i(),R=l("p"),R.textContent=vt,Be=i(),u(P.$$.fragment),He=i(),S=l("p"),S.innerHTML=xt,Ee=i(),u(X.$$.fragment),Ve=i(),w=l("h3"),C=l("a"),je=l("span"),u(A.$$.fragment),ct=i(),me=l("span"),me.textContent=$t,qe=i(),N=l("p"),N.innerHTML=wt,ze=i(),u(Y.$$.fragment),Le=i(),F=l("p"),F.innerHTML=Ut,Re=i(),u(Q.$$.fragment),Pe=i(),D=l("p"),D.innerHTML=bt,Se=i(),u(K.$$.fragment),Xe=i(),U=l("h2"),G=l("a"),ve=l("span"),u(O.$$.fragment),ht=i(),fe=l("span"),fe.textContent=Tt,Ae=i(),ee=l("p"),ee.innerHTML=kt,Ne=i(),te=l("p"),te.innerHTML=Jt,Ye=i(),u(se.$$.fragment),Fe=i(),ae=l("p"),ae.innerHTML=Zt,Qe=i(),u(le.$$.fragment),De=i(),b=l("h2"),I=l("a"),xe=l("span"),u(ne.$$.fragment),dt=i(),ge=l("span"),ge.textContent=Ct,Ke=i(),ie=l("p"),ie.innerHTML=Gt,Oe=i(),oe=l("p"),oe.textContent=It,et=i(),pe=l("p"),pe.innerHTML=Wt,tt=i(),u(re.$$.fragment),st=i(),$e=l("p"),this.h()},l(e){const s=Ft("svelte-1phssyn",document.head);h=n(s,"META",{name:!0,content:!0}),s.forEach(t),W=o(e),j=n(e,"P",{}),d(j).forEach(t),he=o(e),x=n(e,"H1",{class:!0});var ce=d(x);T=n(ce,"A",{id:!0,class:!0,href:!0});var _t=d(T);ye=n(_t,"SPAN",{});var Bt=d(ye);m(_.$$.fragment,Bt),Bt.forEach(t),_t.forEach(t),pt=o(ce),de=n(ce,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-oksvic"&&(de.textContent=ut),ce.forEach(t),be=o(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1k5gyag"&&(B.innerHTML=mt),Te=o(e),H=n(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-7f1ymp"&&(H.innerHTML=ft),ke=o(e),m(k.$$.fragment,e),Je=o(e),$=n(e,"H2",{class:!0});var lt=d($);J=n(lt,"A",{id:!0,class:!0,href:!0});var Ht=d(J);Me=n(Ht,"SPAN",{});var Et=d(Me);m(E.$$.fragment,Et),Et.forEach(t),Ht.forEach(t),rt=o(lt),ue=n(lt,"SPAN",{"data-svelte-h":!0}),r(ue)!=="svelte-1rqprbn"&&(ue.textContent=gt),lt.forEach(t),Ze=o(e),V=n(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-gjt1nl"&&(V.innerHTML=yt),Ce=o(e),q=n(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-yki1ef"&&(q.innerHTML=Mt),Ge=o(e),m(z.$$.fragment,e),Ie=o(e),Z=n(e,"OL",{start:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1e6diuh"&&(Z.innerHTML=jt),We=o(e),m(L.$$.fragment,e),_e=o(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-wgq0wk"&&(R.textContent=vt),Be=o(e),m(P.$$.fragment,e),He=o(e),S=n(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-183jawq"&&(S.innerHTML=xt),Ee=o(e),m(X.$$.fragment,e),Ve=o(e),w=n(e,"H3",{class:!0});var nt=d(w);C=n(nt,"A",{id:!0,class:!0,href:!0});var Vt=d(C);je=n(Vt,"SPAN",{});var qt=d(je);m(A.$$.fragment,qt),qt.forEach(t),Vt.forEach(t),ct=o(nt),me=n(nt,"SPAN",{"data-svelte-h":!0}),r(me)!=="svelte-2loqlm"&&(me.textContent=$t),nt.forEach(t),qe=o(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1sfnia5"&&(N.innerHTML=wt),ze=o(e),m(Y.$$.fragment,e),Le=o(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-15my78f"&&(F.innerHTML=Ut),Re=o(e),m(Q.$$.fragment,e),Pe=o(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1qfapyh"&&(D.innerHTML=bt),Se=o(e),m(K.$$.fragment,e),Xe=o(e),U=n(e,"H2",{class:!0});var it=d(U);G=n(it,"A",{id:!0,class:!0,href:!0});var zt=d(G);ve=n(zt,"SPAN",{});var Lt=d(ve);m(O.$$.fragment,Lt),Lt.forEach(t),zt.forEach(t),ht=o(it),fe=n(it,"SPAN",{"data-svelte-h":!0}),r(fe)!=="svelte-ve5nm8"&&(fe.textContent=Tt),it.forEach(t),Ae=o(e),ee=n(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-q0unz9"&&(ee.innerHTML=kt),Ne=o(e),te=n(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-5ycnhq"&&(te.innerHTML=Jt),Ye=o(e),m(se.$$.fragment,e),Fe=o(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1nrtv5e"&&(ae.innerHTML=Zt),Qe=o(e),m(le.$$.fragment,e),De=o(e),b=n(e,"H2",{class:!0});var ot=d(b);I=n(ot,"A",{id:!0,class:!0,href:!0});var Rt=d(I);xe=n(Rt,"SPAN",{});var Pt=d(xe);m(ne.$$.fragment,Pt),Pt.forEach(t),Rt.forEach(t),dt=o(ot),ge=n(ot,"SPAN",{"data-svelte-h":!0}),r(ge)!=="svelte-1azo6mg"&&(ge.textContent=Ct),ot.forEach(t),Ke=o(e),ie=n(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1na9ujt"&&(ie.innerHTML=Gt),Oe=o(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-j2gvop"&&(oe.textContent=It),et=o(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1bks2jw"&&(pe.innerHTML=Wt),tt=o(e),m(re.$$.fragment,e),st=o(e),$e=n(e,"P",{}),d($e).forEach(t),this.h()},h(){p(h,"name","hf:doc:metadata"),p(h,"content",JSON.stringify(Ot)),p(T,"id","pipelines-para-inferencia"),p(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(T,"href","#pipelines-para-inferencia"),p(x,"class","relative group"),p(J,"id","uso-del-pipeline"),p(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(J,"href","#uso-del-pipeline"),p($,"class","relative group"),p(Z,"start","2"),p(C,"id","selecciona-un-modelo-y-un-tokenizador"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#selecciona-un-modelo-y-un-tokenizador"),p(w,"class","relative group"),p(G,"id","pipeline-de-audio"),p(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(G,"href","#pipeline-de-audio"),p(U,"class","relative group"),p(I,"id","pipeline-de-visin"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#pipeline-de-visin"),p(b,"class","relative group")},m(e,s){c(document.head,h),a(e,W,s),a(e,j,s),a(e,he,s),a(e,x,s),c(x,T),c(T,ye),f(_,ye,null),c(x,pt),c(x,de),a(e,be,s),a(e,B,s),a(e,Te,s),a(e,H,s),a(e,ke,s),f(k,e,s),a(e,Je,s),a(e,$,s),c($,J),c(J,Me),f(E,Me,null),c($,rt),c($,ue),a(e,Ze,s),a(e,V,s),a(e,Ce,s),a(e,q,s),a(e,Ge,s),f(z,e,s),a(e,Ie,s),a(e,Z,s),a(e,We,s),f(L,e,s),a(e,_e,s),a(e,R,s),a(e,Be,s),f(P,e,s),a(e,He,s),a(e,S,s),a(e,Ee,s),f(X,e,s),a(e,Ve,s),a(e,w,s),c(w,C),c(C,je),f(A,je,null),c(w,ct),c(w,me),a(e,qe,s),a(e,N,s),a(e,ze,s),f(Y,e,s),a(e,Le,s),a(e,F,s),a(e,Re,s),f(Q,e,s),a(e,Pe,s),a(e,D,s),a(e,Se,s),f(K,e,s),a(e,Xe,s),a(e,U,s),c(U,G),c(G,ve),f(O,ve,null),c(U,ht),c(U,fe),a(e,Ae,s),a(e,ee,s),a(e,Ne,s),a(e,te,s),a(e,Ye,s),f(se,e,s),a(e,Fe,s),a(e,ae,s),a(e,Qe,s),f(le,e,s),a(e,De,s),a(e,b,s),c(b,I),c(I,xe),f(ne,xe,null),c(b,dt),c(b,ge),a(e,Ke,s),a(e,ie,s),a(e,Oe,s),a(e,oe,s),a(e,et,s),a(e,pe,s),a(e,tt,s),f(re,e,s),a(e,st,s),a(e,$e,s),at=!0},p(e,[s]){const ce={};s&2&&(ce.$$scope={dirty:s,ctx:e}),k.$set(ce)},i(e){at||(g(_.$$.fragment,e),g(k.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),g(L.$$.fragment,e),g(P.$$.fragment,e),g(X.$$.fragment,e),g(A.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),at=!0)},o(e){y(_.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(X.$$.fragment,e),y(A.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),at=!1},d(e){e&&(t(W),t(j),t(he),t(x),t(be),t(B),t(Te),t(H),t(ke),t(Je),t($),t(Ze),t(V),t(Ce),t(q),t(Ge),t(Ie),t(Z),t(We),t(_e),t(R),t(Be),t(He),t(S),t(Ee),t(Ve),t(w),t(qe),t(N),t(ze),t(Le),t(F),t(Re),t(Pe),t(D),t(Se),t(Xe),t(U),t(Ae),t(ee),t(Ne),t(te),t(Ye),t(Fe),t(ae),t(Qe),t(De),t(b),t(Ke),t(ie),t(Oe),t(oe),t(et),t(pe),t(tt),t(st),t($e)),t(h),M(_),M(k,e),M(E),M(z,e),M(L,e),M(P,e),M(X,e),M(A),M(Y,e),M(Q,e),M(K,e),M(O),M(se,e),M(le,e),M(ne),M(re,e)}}}const Ot={local:"pipelines-para-inferencia",sections:[{local:"uso-del-pipeline",sections:[{local:"selecciona-un-modelo-y-un-tokenizador",title:"Selecciona un modelo y un tokenizador"}],title:"Uso del pipeline"},{local:"pipeline-de-audio",title:"Pipeline de audio"},{local:"pipeline-de-visin",title:"Pipeline de visión"}],title:"Pipelines para inferencia"};function es(Ue){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Nt{constructor(h){super(),Yt(this,h,es,Kt,St,{})}}export{is as component};
