import{s as cl,f as pl,o as ml,n as Y}from"../chunks/scheduler.9bc65507.js";import{S as ul,i as hl,g as n,s as a,u as g,A as fl,h as s,f as t,c as r,j as u,v as _,y as p,k as m,o,a as l,w as M,d as k,t as y,x as b}from"../chunks/index.78c82d43.js";import{T as Xs}from"../chunks/Tip.87d55b76.js";import{D as x}from"../chunks/Docstring.f3d04bd2.js";import{C as S}from"../chunks/CodeBlock.48618ec2.js";import{I as Z}from"../chunks/IconCopyLink.bedaa44d.js";import{E as gn}from"../chunks/ExampleCodeBlock.872b014d.js";function gl($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNTW9kZWwlMkMlMjBNYXJrdXBMTUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXJrdXBMTSUyMG1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFya3VwTE1Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMModel, MarkupLMConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MarkupLM microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MarkupLMConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/markuplm-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function _l($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUwQSUwQXBhZ2VfbmFtZV8xJTIwJTNEJTIwJTIycGFnZTEuaHRtbCUyMiUwQXBhZ2VfbmFtZV8yJTIwJTNEJTIwJTIycGFnZTIuaHRtbCUyMiUwQXBhZ2VfbmFtZV8zJTIwJTNEJTIwJTIycGFnZTMuaHRtbCUyMiUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8xKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHNpbmdsZV9odG1sX3N0cmluZyUyMCUzRCUyMGYucmVhZCgpJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQSUwQSUyMyUyMHNpbmdsZSUyMGV4YW1wbGUlMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKHNpbmdsZV9odG1sX3N0cmluZyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCklMEElMEElMjMlMjBiYXRjaGVkJTIwZXhhbXBsZSUwQSUwQW11bHRpX2h0bWxfc3RyaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQXdpdGglMjBvcGVuKHBhZ2VfbmFtZV8yKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMG11bHRpX2h0bWxfc3RyaW5ncy5hcHBlbmQoZi5yZWFkKCkpJTBBd2l0aCUyMG9wZW4ocGFnZV9uYW1lXzMpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwbXVsdGlfaHRtbF9zdHJpbmdzLmFwcGVuZChmLnJlYWQoKSklMEElMEFlbmNvZGluZyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKG11bHRpX2h0bWxfc3RyaW5ncyklMEFwcmludChlbmNvZGluZy5rZXlzKCkpJTBBJTIzJTIwZGljdF9rZXlzKCU1Qidub2RlcyclMkMlMjAneHBhdGhzJyU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_1 = <span class="hljs-string">&quot;page1.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_2 = <span class="hljs-string">&quot;page2.html&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>page_name_3 = <span class="hljs-string">&quot;page3.html&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_1) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    single_html_string = f.read()

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = MarkupLMFeatureExtractor()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># single example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(single_html_string)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batched example</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>multi_html_strings = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_2) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(page_name_3) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    multi_html_strings.append(f.read())

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = feature_extractor(multi_html_strings)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dict_keys([&#x27;nodes&#x27;, &#x27;xpaths&#x27;])</span>`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function Ml($){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(f){c=s(f,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(f,h){l(f,c,h)},p:Y,d(f){f&&t(c)}}}function kl($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTU1vZGVsJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hcmt1cExNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFUGFnZSUyMFRpdGxlJTNDJTJGdGl0bGUlM0UlMjAlM0MlMkZoZWFkJTNFJTIwJTNDJTJGaHRtbCUzRSUyMiUwQSUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMModel.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span>]`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function yl($){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(f){c=s(f,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(f,h){l(f,c,h)},p:Y,d(f){f&&t(c)}}}function bl($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0Q3KSUwQSUwQWh0bWxfc3RyaW5nJTIwJTNEJTIwJTIyJTNDaHRtbCUzRSUyMCUzQ2hlYWQlM0UlMjAlM0N0aXRsZSUzRVBhZ2UlMjBUaXRsZSUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;Page Title&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function vl($){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(f){c=s(f,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(f,h){l(f,c,h)},p:Y,d(f){f&&t(c)}}}function Tl($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlJTIyKSUwQXByb2Nlc3Nvci5wYXJzZV9odG1sJTIwJTNEJTIwRmFsc2UlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIlMkMlMjBudW1fbGFiZWxzJTNENyklMEElMEFub2RlcyUyMCUzRCUyMCU1QiUyMmhlbGxvJTIyJTJDJTIwJTIyd29ybGQlMjIlNUQlMEF4cGF0aHMlMjAlM0QlMjAlNUIlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlMkMlMjAlMjIlMkZodG1sJTJGYm9keSUyRmRpdiUyRmxpJTVCMSU1RCUyRmRpdiUyRnNwYW4lMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTVEJTBBZW5jb2RpbmclMjAlM0QlMjBwcm9jZXNzb3Iobm9kZXMlM0Rub2RlcyUyQyUyMHhwYXRocyUzRHhwYXRocyUyQyUyMG5vZGVfbGFiZWxzJTNEbm9kZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>, num_labels=<span class="hljs-number">7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function wl($){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(f){c=s(f,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(f,h){l(f,c,h)},p:Y,d(f){f&&t(c)}}}function xl($){let c,T="Examples:",f,h,v;return h=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXJrdXBMTUZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZtYXJrdXBsbS1iYXNlLWZpbmV0dW5lZC13ZWJzcmMlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlM0NodG1sJTNFJTIwJTNDaGVhZCUzRSUyMCUzQ3RpdGxlJTNFTXklMjBuYW1lJTIwaXMlMjBOaWVscyUzQyUyRnRpdGxlJTNFJTIwJTNDJTJGaGVhZCUzRSUyMCUzQyUyRmh0bWwlM0UlMjIlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEElMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHF1ZXN0aW9ucyUzRHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwZW5jb2RpbmcuaW5wdXRfaWRzJTVCMCUyQyUyMGFuc3dlcl9zdGFydF9pbmRleCUyMCUzQSUyMGFuc3dlcl9lbmRfaW5kZXglMjAlMkIlMjAxJTVEJTBBcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMpLnN0cmlwKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MarkupLMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MarkupLMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base-finetuned-websrc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&lt;html&gt; &lt;head&gt; &lt;title&gt;My name is Niels&lt;/title&gt; &lt;/head&gt; &lt;/html&gt;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = encoding.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(predict_answer_tokens).strip()
<span class="hljs-string">&#x27;Niels&#x27;</span>`}}),{c(){c=n("p"),c.textContent=T,f=a(),g(h.$$.fragment)},l(d){c=s(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=T),f=r(d),_(h.$$.fragment,d)},m(d,w){l(d,c,w),l(d,f,w),M(h,d,w),v=!0},p:Y,i(d){v||(k(h.$$.fragment,d),v=!0)},o(d){y(h.$$.fragment,d),v=!1},d(d){d&&(t(c),t(f)),b(h,d)}}}function Ll($){let c,T,f,h,v,d,w,Pe,Ds,co,kr="MarkupLM",In,O,ce,_n,Ae,Ys,po,yr="Overview",Zn,Qe,br=`The MarkupLM model was proposed in <a href="https://arxiv.org/abs/2110.08518" rel="nofollow">MarkupLM: Pre-training of Text and Markup Language for Visually-rich Document
Understanding</a> by Junlong Li, Yiheng Xu, Lei Cui, Furu Wei. MarkupLM is BERT, but
applied to HTML pages instead of raw text documents. The model incorporates additional embedding layers to improve
performance, similar to <a href="layoutlm">LayoutLM</a>.`,En,Xe,vr=`The model can be used for tasks like question answering on web pages or information extraction from web pages. It obtains
state-of-the-art results on 2 important benchmarks:`,Rn,De,Tr=`<li><a href="https://x-lance.github.io/WebSRC/" rel="nofollow">WebSRC</a>, a dataset for Web-Based Structural Reading Comprehension (a bit like SQuAD but for web pages)</li> <li><a href="https://www.researchgate.net/publication/221299838_From_one_tree_to_a_forest_a_unified_solution_for_structured_web_data_extraction" rel="nofollow">SWDE</a>, a dataset
for information extraction from web pages (basically named-entity recogntion on web pages)</li>`,Gn,Ye,wr="The abstract from the paper is the following:",Bn,Oe,xr=`<em>Multimodal pre-training with text, layout, and image has made significant progress for Visually-rich Document
Understanding (VrDU), especially the fixed-layout documents such as scanned document images. While, there are still a
large number of digital documents where the layout information is not fixed and needs to be interactively and
dynamically rendered for visualization, making existing layout-based pre-training approaches not easy to apply. In this
paper, we propose MarkupLM for document understanding tasks with markup languages as the backbone such as
HTML/XML-based documents, where text and markup information is jointly pre-trained. Experiment results show that the
pre-trained MarkupLM significantly outperforms the existing strong baseline models on several document understanding
tasks. The pre-trained model and code will be publicly available.</em>`,Hn,Ke,Lr="Tips:",Wn,et,$r=`<li>In addition to <code>input_ids</code>, <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMModel.forward">forward()</a> expects 2 additional inputs, namely <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.
These are the XPATH tags and subscripts respectively for each token in the input sequence.</li> <li>One can use <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> to prepare all data for the model. Refer to the <a href="#usage-markuplmprocessor">usage guide</a> for more info.</li> <li>Demo notebooks can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MarkupLM" rel="nofollow">here</a>.</li>`,Sn,pe,Jr,Vn,tt,Ur='MarkupLM architecture. Taken from the <a href="https://arxiv.org/abs/2110.08518">original paper.</a>',Pn,ot,qr='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/markuplm" rel="nofollow">here</a>.',An,K,me,Mn,nt,Os,mo,jr="Usage: MarkupLMProcessor",Qn,st,zr=`The easiest way to prepare data for the model is to use <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>, which internally combines a feature extractor
(<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>) and a tokenizer (<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>). The feature extractor is
used to extract all nodes and xpaths from the HTML strings, which are then provided to the tokenizer, which turns them into the
token-level inputs of the model (<code>input_ids</code> etc.). Note that you can still use the feature extractor and tokenizer separately,
if you only want to handle one of the two tasks.`,Xn,at,Dn,rt,Cr=`In short, one can provide HTML strings (and possibly additional data) to <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a>,
and it will create the inputs expected by the model. Internally, the processor first uses
<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to get a list of nodes and corresponding xpaths. The nodes and
xpaths are then provided to <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which converts them
to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_subs_seq</code>, <code>xpath_tags_seq</code>.
Optionally, one can provide node labels to the processor, which are turned into token-level <code>labels</code>.`,Yn,it,Fr=`<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> uses <a href="https://www.crummy.com/software/BeautifulSoup/bs4/doc/" rel="nofollow">Beautiful Soup</a>, a Python library for
pulling data out of HTML and XML files, under the hood. Note that you can still use your own parsing solution of
choice, and provide the nodes and xpaths yourself to <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>.`,On,lt,Nr=`In total, there are 5 use cases that are supported by the processor. Below, we list them all. Note that each of these
use cases work for both batched and non-batched inputs (we illustrate them for non-batched inputs).`,Kn,dt,Ir="<strong>Use case 1: web page classification (training, inference) + token classification (inference), parse_html = True</strong>",es,ct,Zr="This is the simplest case, in which the processor will use the feature extractor to get all nodes and xpaths from the HTML.",ts,pt,os,mt,Er="<strong>Use case 2: web page classification (training, inference) + token classification (inference), parse_html=False</strong>",ns,ut,Rr=`In case one already has obtained all nodes and xpaths, one doesn’t need the feature extractor. In that case, one should
provide the nodes and corresponding xpaths themselves to the processor, and make sure to set <code>parse_html</code> to <code>False</code>.`,ss,ht,as,ft,Gr="<strong>Use case 3: token classification (training), parse_html=False</strong>",rs,gt,Br=`For token classification tasks (such as <a href="https://paperswithcode.com/dataset/swde" rel="nofollow">SWDE</a>), one can also provide the
corresponding node labels in order to train a model. The processor will then convert these into token-level <code>labels</code>.
By default, it will only label the first wordpiece of a word, and label the remaining wordpieces with -100, which is the
<code>ignore_index</code> of PyTorch’s CrossEntropyLoss. In case you want all wordpieces of a word to be labeled, you can
initialize the tokenizer with <code>only_label_first_subword</code> set to <code>False</code>.`,is,_t,ls,Mt,Hr="<strong>Use case 4: web page question answering (inference), parse_html=True</strong>",ds,kt,Wr=`For question answering tasks on web pages, you can provide a question to the processor. By default, the
processor will use the feature extractor to get all nodes and xpaths, and create [CLS] question tokens [SEP] word tokens [SEP].`,cs,yt,ps,bt,Sr="<strong>Use case 5: web page question answering (inference), parse_html=False</strong>",ms,vt,Vr=`For question answering tasks (such as WebSRC), you can provide a question to the processor. If you have extracted
all nodes and xpaths yourself, you can provide them directly to the processor. Make sure to set <code>parse_html</code> to <code>False</code>.`,us,Tt,hs,ee,ue,kn,wt,Ks,uo,Pr="Documentation resources",fs,xt,Ar='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li>',gs,te,he,yn,Lt,ea,ho,Qr="MarkupLMConfig",_s,C,$t,ta,fo,Xr=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>. It is used to instantiate a
MarkupLM model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the MarkupLM
<a href="https://huggingface.co/microsoft/markuplm-base" rel="nofollow">microsoft/markuplm-base</a> architecture.`,oa,go,Dr=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertConfig">BertConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertConfig">BertConfig</a> for more information.`,na,fe,Ms,oe,ge,bn,Jt,sa,_o,Yr="MarkupLMFeatureExtractor",ks,F,Ut,aa,Mo,Or=`Constructs a MarkupLM feature extractor. This can be used to get a list of nodes and corresponding xpaths from HTML
strings.`,ra,ko,Kr=`This feature extractor inherits from <code>PreTrainedFeatureExtractor()</code> which contains most
of the main methods. Users should refer to this superclass for more information regarding those methods.`,ia,A,qt,la,yo,ei="Main method to prepare for the model one or several HTML strings.",da,_e,ys,ne,Me,vn,jt,ca,bo,ti="MarkupLMTokenizer",bs,q,zt,pa,vo,oi=`Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE). <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> can be used to
turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and
<code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods.
Users should refer to this superclass for more information regarding those methods.`,ma,Q,Ct,ua,To,ni=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,ha,wo,si="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",fa,xo,Ft,ga,ke,Nt,_a,Lo,ai=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,Ma,$o,It,vs,se,ye,Tn,Zt,ka,Jo,ri="MarkupLMTokenizerFast",Ts,L,Et,ya,Uo,ii="Construct a MarkupLM tokenizer. Based on byte-level Byte-Pair-Encoding (BPE).",ba,qo,li=`<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a> can be used to turn HTML strings into to token-level <code>input_ids</code>, <code>attention_mask</code>,
<code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_tags_seq</code>. This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which
contains most of the main methods.`,va,jo,di="Users should refer to this superclass for more information regarding those methods.",Ta,J,Rt,wa,zo,ci=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to encode the sequences with the special tokens relative to their model.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,xa,Co,pi=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters.</p></li>`,La,Fo,mi=`If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
is_split_into_words (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).
return_tensors (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:`,$a,No,ui="<li><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</li> <li><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li> <li><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</li>",Ja,Io,hi=`add_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to encode the sequences with the special tokens relative to their model.
padding (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls padding. Accepts the following values:`,Ua,Zo,fi=`<li><p><code>True</code> or <code>&#39;longest&#39;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</p></li> <li><p><code>&#39;max_length&#39;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_pad&#39;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).
truncation (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>):
Activates and controls truncation. Accepts the following values:</p></li> <li><p><code>True</code> or <code>&#39;longest_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_first&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>&#39;only_second&#39;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</p></li> <li><p><code>False</code> or <code>&#39;do_not_truncate&#39;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).
max_length (<code>int</code>, <em>optional</em>):
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.
stride (<code>int</code>, <em>optional</em>, defaults to 0):
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.
pad_to_multiple_of (<code>int</code>, <em>optional</em>):
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).
return_tensors (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>):
If set, will return tensors instead of list of python integers. Acceptable values are:</p></li> <li><p><code>&#39;tf&#39;</code>: Return TensorFlow <code>tf.constant</code> objects.</p></li> <li><p><code>&#39;pt&#39;</code>: Return PyTorch <code>torch.Tensor</code> objects.</p></li> <li><p><code>&#39;np&#39;</code>: Return Numpy <code>np.ndarray</code> objects.</p></li>`,qa,X,Gt,ja,Eo,gi=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A RoBERTa sequence has the following format:`,za,Ro,_i="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",Ca,be,Bt,Fa,Go,Mi=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. RoBERTa does not
make use of token type ids, therefore a list of zeros is returned.`,Na,ve,Ht,Ia,Bo,ki=`Tokenize and prepare for the model a sequence or a pair of sequences. .. warning:: This method is deprecated,
<code>__call__</code> should be used instead.`,Za,Te,Wt,Ea,Ho,yi=`Given the xpath expression of one particular node (like “/html/body/div/li[1]/div/span[2]”), return a list of
tag IDs and corresponding subscripts, taking into account max depth.`,ws,ae,we,wn,St,Ra,Wo,bi="MarkupLMProcessor",xs,j,Vt,Ga,So,vi=`Constructs a MarkupLM processor which combines a MarkupLM feature extractor and a MarkupLM tokenizer into a single
processor.`,Ba,Vo,Ti='<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> offers all the functionalities you need to prepare data for the model.',Ha,Po,wi=`It first uses <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a> to extract nodes and corresponding xpaths from one or more HTML strings.
Next, these are provided to <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>, which turns them into token-level
<code>input_ids</code>, <code>attention_mask</code>, <code>token_type_ids</code>, <code>xpath_tags_seq</code> and <code>xpath_subs_seq</code>.`,Wa,E,Pt,Sa,Ao,xi=`This method first forwards the <code>html_strings</code> argument to <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor.__call__"><strong>call</strong>()</a>. Next, it
passes the <code>nodes</code> and <code>xpaths</code> along with the additional arguments to <code>__call__()</code> and
returns the output.`,Va,Qo,Li="Optionally, one can also provide a <code>text</code> argument which is passed along as first sequence.",Pa,Xo,$i="Please refer to the docstring of the above two methods for more information.",Ls,re,xe,xn,At,Aa,Do,Ji="MarkupLMModel",$s,V,Qt,Qa,Yo,Ui=`The bare MarkupLM Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Xa,R,Xt,Da,Oo,qi='The <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> forward method, overrides the <code>__call__</code> special method.',Ya,Le,Oa,$e,Js,ie,Je,Ln,Dt,Ka,Ko,ji="MarkupLMForSequenceClassification",Us,N,Yt,er,en,zi=`MarkupLM Model transformer with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,tr,tn,Ci=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,or,G,Ot,nr,on,Fi='The <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',sr,Ue,ar,qe,qs,le,je,$n,Kt,rr,nn,Ni="MarkupLMForTokenClassification",js,P,eo,ir,sn,Ii=`MarkupLM Model with a <code>token_classification</code> head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,lr,B,to,dr,an,Zi='The <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',cr,ze,pr,Ce,zs,de,Fe,Jn,oo,mr,rn,Ei="MarkupLMForQuestionAnswering",Cs,I,no,ur,ln,Ri=`MarkupLM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,hr,dn,Gi=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,fr,H,so,gr,cn,Bi='The <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',_r,Ne,Mr,Ie,Fs,Un,Ns;return Pe=new Z({}),Ae=new Z({}),nt=new Z({}),at=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNRmVhdHVyZUV4dHJhY3RvciUyQyUyME1hcmt1cExNVG9rZW5pemVyRmFzdCUyQyUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBNYXJrdXBMTUZlYXR1cmVFeHRyYWN0b3IoKSUwQXRva2VuaXplciUyMCUzRCUyME1hcmt1cExNVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGbWFya3VwbG0tYmFzZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBNYXJrdXBMTVByb2Nlc3NvcihmZWF0dXJlX2V4dHJhY3RvciUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMFeatureExtractor, MarkupLMTokenizerFast, MarkupLMProcessor

feature_extractor = MarkupLMFeatureExtractor()
tokenizer = MarkupLMTokenizerFast.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
processor = MarkupLMProcessor(feature_extractor, tokenizer)`}}),pt=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VIZXJlJTIwaXMlMjBteSUyMHdlYnNpdGUuJTNDJTJGcCUzRSUwQSUyMCUzQyUyRmJvZHklM0UlMEElMjAlM0MlMkZodG1sJTNFJTIyJTIyJTIyJTBBJTBBJTIzJTIwbm90ZSUyMHRoYXQlMjB5b3UlMjBjYW4lMjBhbHNvJTIwYWRkJTIwcHJvdmlkZSUyMGFsbCUyMHRva2VuaXplciUyMHBhcmFtZXRlcnMlMjBoZXJlJTIwc3VjaCUyMGFzJTIwcGFkZGluZyUyQyUyMHRydW5jYXRpb24lMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3NvcihodG1sX3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;Here is my website.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note that you can also add provide all tokenizer parameters here such as padding, truncation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`}}),ht=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChlbmNvZGluZy5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`}}),_t=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFub2RlX2xhYmVscyUyMCUzRCUyMCU1QjElMkMlMjAyJTJDJTIwMiUyQyUyMDElNUQlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwbm9kZV9sYWJlbHMlM0Rub2RlX2xhYmVscyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBcHJpbnQoZW5jb2Rpbmcua2V5cygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>node_labels = [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, node_labels=node_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>])`}}),yt=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBJTBBaHRtbF9zdHJpbmclMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlM0MhRE9DVFlQRSUyMGh0bWwlM0UlMEElMjAlM0NodG1sJTNFJTBBJTIwJTNDaGVhZCUzRSUwQSUyMCUzQ3RpdGxlJTNFSGVsbG8lMjB3b3JsZCUzQyUyRnRpdGxlJTNFJTBBJTIwJTNDJTJGaGVhZCUzRSUwQSUyMCUzQ2JvZHklM0UlMEElMjAlM0NoMSUzRVdlbGNvbWUlM0MlMkZoMSUzRSUwQSUyMCUzQ3AlM0VNeSUyMG5hbWUlMjBpcyUyME5pZWxzLiUzQyUyRnAlM0UlMEElMjAlM0MlMkZib2R5JTNFJTBBJTIwJTNDJTJGaHRtbCUzRSUyMiUyMiUyMiUwQSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwaGlzJTIwbmFtZSUzRiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGh0bWxfc3RyaW5nJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>html_string = <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span> &lt;!DOCTYPE html&gt;
<span class="hljs-meta">... </span> &lt;html&gt;
<span class="hljs-meta">... </span> &lt;head&gt;
<span class="hljs-meta">... </span> &lt;title&gt;Hello world&lt;/title&gt;
<span class="hljs-meta">... </span> &lt;/head&gt;
<span class="hljs-meta">... </span> &lt;body&gt;
<span class="hljs-meta">... </span> &lt;h1&gt;Welcome&lt;/h1&gt;
<span class="hljs-meta">... </span> &lt;p&gt;My name is Niels.&lt;/p&gt;
<span class="hljs-meta">... </span> &lt;/body&gt;
<span class="hljs-meta">... </span> &lt;/html&gt;&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(html_string, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`}}),Tt=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hcmt1cExNUHJvY2Vzc29yJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwTWFya3VwTE1Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRm1hcmt1cGxtLWJhc2UlMjIpJTBBcHJvY2Vzc29yLnBhcnNlX2h0bWwlMjAlM0QlMjBGYWxzZSUwQSUwQW5vZGVzJTIwJTNEJTIwJTVCJTIyaGVsbG8lMjIlMkMlMjAlMjJ3b3JsZCUyMiUyQyUyMCUyMmhvdyUyMiUyQyUyMCUyMmFyZSUyMiU1RCUwQXhwYXRocyUyMCUzRCUyMCU1QiUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMiUyRmh0bWwlMkZib2R5JTJGZGl2JTJGbGklNUIxJTVEJTJGZGl2JTJGc3BhbiUyMiUyQyUyMCUyMmh0bWwlMkZib2R5JTIyJTJDJTIwJTIyaHRtbCUyRmJvZHklMkZkaXYlMjIlNUQlMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQncyUyMGhpcyUyMG5hbWUlM0YlMjIlMEFlbmNvZGluZyUyMCUzRCUyMHByb2Nlc3Nvcihub2RlcyUzRG5vZGVzJTJDJTIweHBhdGhzJTNEeHBhdGhzJTJDJTIwcXVlc3Rpb25zJTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KGVuY29kaW5nLmtleXMoKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MarkupLMProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MarkupLMProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/markuplm-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.parse_html = <span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>nodes = [<span class="hljs-string">&quot;hello&quot;</span>, <span class="hljs-string">&quot;world&quot;</span>, <span class="hljs-string">&quot;how&quot;</span>, <span class="hljs-string">&quot;are&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>xpaths = [<span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;/html/body/div/li[1]/div/span&quot;</span>, <span class="hljs-string">&quot;html/body&quot;</span>, <span class="hljs-string">&quot;html/body/div&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s his name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = processor(nodes=nodes, xpaths=xpaths, questions=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoding.keys())
dict_keys([<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;xpath_tags_seq&#x27;</span>, <span class="hljs-string">&#x27;xpath_subs_seq&#x27;</span>])`}}),wt=new Z({}),Lt=new Z({}),$t=new x({props:{name:"class transformers.MarkupLMConfig",anchor:"transformers.MarkupLMConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_xpath_tag_unit_embeddings",val:" = 256"},{name:"max_xpath_subs_unit_embeddings",val:" = 1024"},{name:"tag_pad_id",val:" = 216"},{name:"subs_pad_id",val:" = 1001"},{name:"xpath_unit_hidden_size",val:" = 32"},{name:"max_depth",val:" = 50"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"classifier_dropout",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the MarkupLM model. Defines the different tokens that can be represented by the
<em>inputs_ids</em> passed to the forward method of <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"vocab_size"},{anchor:"transformers.MarkupLMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MarkupLMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MarkupLMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.MarkupLMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.MarkupLMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.MarkupLMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.MarkupLMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.MarkupLMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MarkupLMConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed into <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.MarkupLMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MarkupLMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MarkupLMConfig.max_tree_id_unit_embeddings",description:`<strong>max_tree_id_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the tree id unit embedding might ever use. Typically set this to something large
just in case (e.g., 1024).`,name:"max_tree_id_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_tag_unit_embeddings",description:`<strong>max_xpath_tag_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum value that the xpath tag unit embedding might ever use. Typically set this to something large
just in case (e.g., 256).`,name:"max_xpath_tag_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.max_xpath_subs_unit_embeddings",description:`<strong>max_xpath_subs_unit_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the xpath subscript unit embedding might ever use. Typically set this to something
large just in case (e.g., 1024).`,name:"max_xpath_subs_unit_embeddings"},{anchor:"transformers.MarkupLMConfig.tag_pad_id",description:`<strong>tag_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 216) &#x2014;
The id of the padding token in the xpath tags.`,name:"tag_pad_id"},{anchor:"transformers.MarkupLMConfig.subs_pad_id",description:`<strong>subs_pad_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1001) &#x2014;
The id of the padding token in the xpath subscripts.`,name:"subs_pad_id"},{anchor:"transformers.MarkupLMConfig.xpath_tag_unit_hidden_size",description:`<strong>xpath_tag_unit_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The hidden size of each tree id unit. One complete tree index will have
(50*xpath_tag_unit_hidden_size)-dim.`,name:"xpath_tag_unit_hidden_size"},{anchor:"transformers.MarkupLMConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The maximum depth in xpath.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/configuration_markuplm.py#L29"}}),fe=new gn({props:{anchor:"transformers.MarkupLMConfig.example",$$slots:{default:[gl]},$$scope:{ctx:$}}}),Jt=new Z({}),Ut=new x({props:{name:"class transformers.MarkupLMFeatureExtractor",anchor:"transformers.MarkupLMFeatureExtractor",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/feature_extraction_markuplm.py#L33"}}),qt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMFeatureExtractor.__call__",parameters:[{name:"html_strings",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMFeatureExtractor.__call__.html_strings",description:`<strong>html_strings</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The HTML string or batch of HTML strings from which to extract nodes and corresponding xpaths.`,name:"html_strings"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/feature_extraction_markuplm.py#L99",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>nodes</strong> — Nodes.</li>
<li><strong>xpaths</strong> — Corresponding xpaths.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),_e=new gn({props:{anchor:"transformers.MarkupLMFeatureExtractor.__call__.example",$$slots:{default:[_l]},$$scope:{ctx:$}}}),jt=new Z({}),zt=new x({props:{name:"class transformers.MarkupLMTokenizer",anchor:"transformers.MarkupLMTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizer.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizer.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm.py#L145"}}),Ct=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm.py#L423",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Ft=new x({props:{name:"get_special_tokens_mask",anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.Retrieve",description:"<strong>Retrieve</strong> sequence ids from a token list that has no special tokens added. This method is called when adding &#x2014;",name:"Retrieve"},{anchor:"transformers.MarkupLMTokenizer.get_special_tokens_mask.special",description:`<strong>special</strong> tokens using the tokenizer <code>prepare_for_model</code> method. &#x2014;
token_ids_0 (<code>List[int]</code>):
List of IDs.
token_ids_1 (<code>List[int]</code>, <em>optional</em>):
Optional second list of IDs for sequence pairs.
already_has_special_tokens (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>):
Whether or not the token list is already formatted with special tokens for the model.`,name:"special"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm.py#L462",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Nt=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm.py#L487",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),It=new x({props:{name:"save_vocabulary",anchor:"transformers.MarkupLMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm.py#L386"}}),Zt=new Z({}),Et=new x({props:{name:"class transformers.MarkupLMTokenizerFast",anchor:"transformers.MarkupLMTokenizerFast",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"tags_dict",val:""},{name:"tokenizer_file",val:" = None"},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_depth",val:" = 50"},{name:"max_width",val:" = 1000"},{name:"pad_width",val:" = 1001"},{name:"pad_token_label",val:" = -100"},{name:"only_label_first_subword",val:" = True"},{name:"trim_offsets",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.MarkupLMTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.MarkupLMTokenizerFast.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.MarkupLMTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.MarkupLMTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.MarkupLMTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.MarkupLMTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.MarkupLMTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.MarkupLMTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.MarkupLMTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.MarkupLMTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (RoBERTa tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L99"}}),Rt=new x({props:{name:"batch_encode_plus",anchor:"transformers.MarkupLMTokenizerFast.batch_encode_plus",parameters:[{name:"batch_text_or_text_pairs",val:": typing.Union[typing.List[str], typing.List[typing.Tuple[str, str]], typing.List[typing.List[str]]]"},{name:"is_pair",val:": bool = None"},{name:"xpaths",val:": typing.Optional[typing.List[typing.List[typing.List[int]]]] = None"},{name:"node_labels",val:": typing.Union[typing.List[int], typing.List[typing.List[int]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L429"}}),Gt=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L879",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Bt=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.MarkupLMTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L902",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Ht=new x({props:{name:"encode_plus",anchor:"transformers.MarkupLMTokenizerFast.encode_plus",parameters:[{name:"text",val:": typing.Union[str, typing.List[str]]"},{name:"text_pair",val:": typing.Optional[typing.List[str]] = None"},{name:"xpaths",val:": typing.Optional[typing.List[typing.List[int]]] = None"},{name:"node_labels",val:": typing.Optional[typing.List[int]] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The first sequence to be encoded. This can be a string, a list of strings or a list of list of strings.`,name:"text"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.text_pair",description:`<strong>text_pair</strong> (<code>List[str]</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second sequence to be encoded. This can be a list of strings (words of a single example) or a
list of list of strings (words of a batch of examples).`,name:"text_pair"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.MarkupLMTokenizerFast.encode_plus.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L496"}}),Wt=new x({props:{name:"get_xpath_seq",anchor:"transformers.MarkupLMTokenizerFast.get_xpath_seq",parameters:[{name:"xpath",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/tokenization_markuplm_fast.py#L259"}}),St=new Z({}),Vt=new x({props:{name:"class transformers.MarkupLMProcessor",anchor:"transformers.MarkupLMProcessor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MarkupLMFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMFeatureExtractor">MarkupLMFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MarkupLMProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>MarkupLMTokenizer</code> or <code>MarkupLMTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizer">MarkupLMTokenizer</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMTokenizerFast">MarkupLMTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.MarkupLMProcessor.parse_html",description:`<strong>parse_html</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use <code>MarkupLMFeatureExtractor</code> to parse HTML strings into nodes and corresponding xpaths.`,name:"parse_html"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/processing_markuplm.py#L25"}}),Pt=new x({props:{name:"__call__",anchor:"transformers.MarkupLMProcessor.__call__",parameters:[{name:"html_strings",val:" = None"},{name:"nodes",val:" = None"},{name:"xpaths",val:" = None"},{name:"node_labels",val:" = None"},{name:"questions",val:" = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/processing_markuplm.py#L48"}}),At=new Z({}),Qt=new x({props:{name:"class transformers.MarkupLMModel",anchor:"transformers.MarkupLMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L807"}}),Xt=new x({props:{name:"forward",anchor:"transformers.MarkupLMModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"xpath_tags_seq",val:": typing.Optional[torch.LongTensor] = None"},{name:"xpath_subs_seq",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMModel.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMModel.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L835",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Le=new Xs({props:{$$slots:{default:[Ml]},$$scope:{ctx:$}}}),$e=new gn({props:{anchor:"transformers.MarkupLMModel.forward.example",$$slots:{default:[kl]},$$scope:{ctx:$}}}),Dt=new Z({}),Yt=new x({props:{name:"class transformers.MarkupLMForSequenceClassification",anchor:"transformers.MarkupLMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L1201"}}),Ot=new x({props:{name:"forward",anchor:"transformers.MarkupLMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_tags_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_subs_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L1218",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ue=new Xs({props:{$$slots:{default:[yl]},$$scope:{ctx:$}}}),qe=new gn({props:{anchor:"transformers.MarkupLMForSequenceClassification.forward.example",$$slots:{default:[bl]},$$scope:{ctx:$}}}),Kt=new Z({}),eo=new x({props:{name:"class transformers.MarkupLMForTokenClassification",anchor:"transformers.MarkupLMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L1095"}}),to=new x({props:{name:"forward",anchor:"transformers.MarkupLMForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_tags_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_subs_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L1111",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ze=new Xs({props:{$$slots:{default:[vl]},$$scope:{ctx:$}}}),Ce=new gn({props:{anchor:"transformers.MarkupLMForTokenClassification.forward.example",$$slots:{default:[Tl]},$$scope:{ctx:$}}}),oo=new Z({}),no=new x({props:{name:"class transformers.MarkupLMForQuestionAnswering",anchor:"transformers.MarkupLMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L975"}}),so=new x({props:{name:"forward",anchor:"transformers.MarkupLMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_tags_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"xpath_subs_seq",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MarkupLMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_tags_seq",description:`<strong>xpath_tags_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Tag IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_tags_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.xpath_subs_seq",description:`<strong>xpath_subs_seq</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, config.max_depth)</code>, <em>optional</em>) &#x2014;
Subscript IDs for each token in the input sequence, padded up to config.max_depth.`,name:"xpath_subs_seq"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>: <code>1</code> for
tokens that are NOT MASKED, <code>0</code> for MASKED tokens.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: <code>0</code> corresponds to a <em>sentence A</em> token, <code>1</code> corresponds to a <em>sentence B</em> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>: <code>1</code>
indicates the head is <strong>not masked</strong>, <code>0</code> indicates the head is <strong>masked</strong>.`,name:"head_mask"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the attentions tensors of all attention layers are returned. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the hidden states of all layers are returned. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the model will return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MarkupLMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/markuplm/modeling_markuplm.py#L987",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/markuplm#transformers.MarkupLMConfig"
>MarkupLMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ne=new Xs({props:{$$slots:{default:[wl]},$$scope:{ctx:$}}}),Ie=new gn({props:{anchor:"transformers.MarkupLMForQuestionAnswering.forward.example",$$slots:{default:[xl]},$$scope:{ctx:$}}}),{c(){c=n("meta"),T=a(),f=n("p"),h=a(),v=n("h1"),d=n("a"),w=n("span"),g(Pe.$$.fragment),Ds=a(),co=n("span"),co.textContent=kr,In=a(),O=n("h2"),ce=n("a"),_n=n("span"),g(Ae.$$.fragment),Ys=a(),po=n("span"),po.textContent=yr,Zn=a(),Qe=n("p"),Qe.innerHTML=br,En=a(),Xe=n("p"),Xe.textContent=vr,Rn=a(),De=n("ul"),De.innerHTML=Tr,Gn=a(),Ye=n("p"),Ye.textContent=wr,Bn=a(),Oe=n("p"),Oe.innerHTML=xr,Hn=a(),Ke=n("p"),Ke.textContent=Lr,Wn=a(),et=n("ul"),et.innerHTML=$r,Sn=a(),pe=n("img"),Vn=a(),tt=n("small"),tt.innerHTML=Ur,Pn=a(),ot=n("p"),ot.innerHTML=qr,An=a(),K=n("h2"),me=n("a"),Mn=n("span"),g(nt.$$.fragment),Os=a(),mo=n("span"),mo.textContent=jr,Qn=a(),st=n("p"),st.innerHTML=zr,Xn=a(),g(at.$$.fragment),Dn=a(),rt=n("p"),rt.innerHTML=Cr,Yn=a(),it=n("p"),it.innerHTML=Fr,On=a(),lt=n("p"),lt.textContent=Nr,Kn=a(),dt=n("p"),dt.innerHTML=Ir,es=a(),ct=n("p"),ct.textContent=Zr,ts=a(),g(pt.$$.fragment),os=a(),mt=n("p"),mt.innerHTML=Er,ns=a(),ut=n("p"),ut.innerHTML=Rr,ss=a(),g(ht.$$.fragment),as=a(),ft=n("p"),ft.innerHTML=Gr,rs=a(),gt=n("p"),gt.innerHTML=Br,is=a(),g(_t.$$.fragment),ls=a(),Mt=n("p"),Mt.innerHTML=Hr,ds=a(),kt=n("p"),kt.textContent=Wr,cs=a(),g(yt.$$.fragment),ps=a(),bt=n("p"),bt.innerHTML=Sr,ms=a(),vt=n("p"),vt.innerHTML=Vr,us=a(),g(Tt.$$.fragment),hs=a(),ee=n("h2"),ue=n("a"),kn=n("span"),g(wt.$$.fragment),Ks=a(),uo=n("span"),uo.textContent=Pr,fs=a(),xt=n("ul"),xt.innerHTML=Ar,gs=a(),te=n("h2"),he=n("a"),yn=n("span"),g(Lt.$$.fragment),ea=a(),ho=n("span"),ho.textContent=Qr,_s=a(),C=n("div"),g($t.$$.fragment),ta=a(),fo=n("p"),fo.innerHTML=Xr,oa=a(),go=n("p"),go.innerHTML=Dr,na=a(),g(fe.$$.fragment),Ms=a(),oe=n("h2"),ge=n("a"),bn=n("span"),g(Jt.$$.fragment),sa=a(),_o=n("span"),_o.textContent=Yr,ks=a(),F=n("div"),g(Ut.$$.fragment),aa=a(),Mo=n("p"),Mo.textContent=Or,ra=a(),ko=n("p"),ko.innerHTML=Kr,ia=a(),A=n("div"),g(qt.$$.fragment),la=a(),yo=n("p"),yo.textContent=ei,da=a(),g(_e.$$.fragment),ys=a(),ne=n("h2"),Me=n("a"),vn=n("span"),g(jt.$$.fragment),ca=a(),bo=n("span"),bo.textContent=ti,bs=a(),q=n("div"),g(zt.$$.fragment),pa=a(),vo=n("p"),vo.innerHTML=oi,ma=a(),Q=n("div"),g(Ct.$$.fragment),ua=a(),To=n("p"),To.textContent=ni,ha=a(),wo=n("ul"),wo.innerHTML=si,fa=a(),xo=n("div"),g(Ft.$$.fragment),ga=a(),ke=n("div"),g(Nt.$$.fragment),_a=a(),Lo=n("p"),Lo.textContent=ai,Ma=a(),$o=n("div"),g(It.$$.fragment),vs=a(),se=n("h2"),ye=n("a"),Tn=n("span"),g(Zt.$$.fragment),ka=a(),Jo=n("span"),Jo.textContent=ri,Ts=a(),L=n("div"),g(Et.$$.fragment),ya=a(),Uo=n("p"),Uo.textContent=ii,ba=a(),qo=n("p"),qo.innerHTML=li,va=a(),jo=n("p"),jo.textContent=di,Ta=a(),J=n("div"),g(Rt.$$.fragment),wa=a(),zo=n("p"),zo.innerHTML=ci,xa=a(),Co=n("ul"),Co.innerHTML=pi,La=a(),Fo=n("p"),Fo.innerHTML=mi,$a=a(),No=n("ul"),No.innerHTML=ui,Ja=a(),Io=n("p"),Io.innerHTML=hi,Ua=a(),Zo=n("ul"),Zo.innerHTML=fi,qa=a(),X=n("div"),g(Gt.$$.fragment),ja=a(),Eo=n("p"),Eo.textContent=gi,za=a(),Ro=n("ul"),Ro.innerHTML=_i,Ca=a(),be=n("div"),g(Bt.$$.fragment),Fa=a(),Go=n("p"),Go.textContent=Mi,Na=a(),ve=n("div"),g(Ht.$$.fragment),Ia=a(),Bo=n("p"),Bo.innerHTML=ki,Za=a(),Te=n("div"),g(Wt.$$.fragment),Ea=a(),Ho=n("p"),Ho.textContent=yi,ws=a(),ae=n("h2"),we=n("a"),wn=n("span"),g(St.$$.fragment),Ra=a(),Wo=n("span"),Wo.textContent=bi,xs=a(),j=n("div"),g(Vt.$$.fragment),Ga=a(),So=n("p"),So.textContent=vi,Ba=a(),Vo=n("p"),Vo.innerHTML=Ti,Ha=a(),Po=n("p"),Po.innerHTML=wi,Wa=a(),E=n("div"),g(Pt.$$.fragment),Sa=a(),Ao=n("p"),Ao.innerHTML=xi,Va=a(),Qo=n("p"),Qo.innerHTML=Li,Pa=a(),Xo=n("p"),Xo.textContent=$i,Ls=a(),re=n("h2"),xe=n("a"),xn=n("span"),g(At.$$.fragment),Aa=a(),Do=n("span"),Do.textContent=Ji,$s=a(),V=n("div"),g(Qt.$$.fragment),Qa=a(),Yo=n("p"),Yo.innerHTML=Ui,Xa=a(),R=n("div"),g(Xt.$$.fragment),Da=a(),Oo=n("p"),Oo.innerHTML=qi,Ya=a(),g(Le.$$.fragment),Oa=a(),g($e.$$.fragment),Js=a(),ie=n("h2"),Je=n("a"),Ln=n("span"),g(Dt.$$.fragment),Ka=a(),Ko=n("span"),Ko.textContent=ji,Us=a(),N=n("div"),g(Yt.$$.fragment),er=a(),en=n("p"),en.textContent=zi,tr=a(),tn=n("p"),tn.innerHTML=Ci,or=a(),G=n("div"),g(Ot.$$.fragment),nr=a(),on=n("p"),on.innerHTML=Fi,sr=a(),g(Ue.$$.fragment),ar=a(),g(qe.$$.fragment),qs=a(),le=n("h2"),je=n("a"),$n=n("span"),g(Kt.$$.fragment),rr=a(),nn=n("span"),nn.textContent=Ni,js=a(),P=n("div"),g(eo.$$.fragment),ir=a(),sn=n("p"),sn.innerHTML=Ii,lr=a(),B=n("div"),g(to.$$.fragment),dr=a(),an=n("p"),an.innerHTML=Zi,cr=a(),g(ze.$$.fragment),pr=a(),g(Ce.$$.fragment),zs=a(),de=n("h2"),Fe=n("a"),Jn=n("span"),g(oo.$$.fragment),mr=a(),rn=n("span"),rn.textContent=Ei,Cs=a(),I=n("div"),g(no.$$.fragment),ur=a(),ln=n("p"),ln.innerHTML=Ri,hr=a(),dn=n("p"),dn.innerHTML=Gi,fr=a(),H=n("div"),g(so.$$.fragment),gr=a(),cn=n("p"),cn.innerHTML=Bi,_r=a(),g(Ne.$$.fragment),Mr=a(),g(Ie.$$.fragment),Fs=a(),Un=n("p"),this.h()},l(e){const i=fl("svelte-1phssyn",document.head);c=s(i,"META",{name:!0,content:!0}),i.forEach(t),T=r(e),f=s(e,"P",{}),u(f).forEach(t),h=r(e),v=s(e,"H1",{class:!0});var ao=u(v);d=s(ao,"A",{id:!0,class:!0,href:!0});var qn=u(d);w=s(qn,"SPAN",{});var jn=u(w);_(Pe.$$.fragment,jn),jn.forEach(t),qn.forEach(t),Ds=r(ao),co=s(ao,"SPAN",{"data-svelte-h":!0}),p(co)!=="svelte-g1qy60"&&(co.textContent=kr),ao.forEach(t),In=r(e),O=s(e,"H2",{class:!0});var ro=u(O);ce=s(ro,"A",{id:!0,class:!0,href:!0});var zn=u(ce);_n=s(zn,"SPAN",{});var Cn=u(_n);_(Ae.$$.fragment,Cn),Cn.forEach(t),zn.forEach(t),Ys=r(ro),po=s(ro,"SPAN",{"data-svelte-h":!0}),p(po)!=="svelte-1jsw1pg"&&(po.textContent=yr),ro.forEach(t),Zn=r(e),Qe=s(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1t0sxmg"&&(Qe.innerHTML=br),En=r(e),Xe=s(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1ytlk74"&&(Xe.textContent=vr),Rn=r(e),De=s(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-1k58bth"&&(De.innerHTML=Tr),Gn=r(e),Ye=s(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-vfdo9a"&&(Ye.textContent=wr),Bn=r(e),Oe=s(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-hdnp88"&&(Oe.innerHTML=xr),Hn=r(e),Ke=s(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-axv494"&&(Ke.textContent=Lr),Wn=r(e),et=s(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-10heivd"&&(et.innerHTML=$r),Sn=r(e),pe=s(e,"IMG",{src:!0,alt:!0,width:!0}),Vn=r(e),tt=s(e,"SMALL",{"data-svelte-h":!0}),p(tt)!=="svelte-1ylkkn"&&(tt.innerHTML=Ur),Pn=r(e),ot=s(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-rdxa92"&&(ot.innerHTML=qr),An=r(e),K=s(e,"H2",{class:!0});var io=u(K);me=s(io,"A",{id:!0,class:!0,href:!0});var Fn=u(me);Mn=s(Fn,"SPAN",{});var Nn=u(Mn);_(nt.$$.fragment,Nn),Nn.forEach(t),Fn.forEach(t),Os=r(io),mo=s(io,"SPAN",{"data-svelte-h":!0}),p(mo)!=="svelte-1vua137"&&(mo.textContent=jr),io.forEach(t),Qn=r(e),st=s(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1exy7uy"&&(st.innerHTML=zr),Xn=r(e),_(at.$$.fragment,e),Dn=r(e),rt=s(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1fe0hi7"&&(rt.innerHTML=Cr),Yn=r(e),it=s(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-4fehrr"&&(it.innerHTML=Fr),On=r(e),lt=s(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-jv0had"&&(lt.textContent=Nr),Kn=r(e),dt=s(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-dkcsne"&&(dt.innerHTML=Ir),es=r(e),ct=s(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-6kpuj"&&(ct.textContent=Zr),ts=r(e),_(pt.$$.fragment,e),os=r(e),mt=s(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1i783jq"&&(mt.innerHTML=Er),ns=r(e),ut=s(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-glfvnv"&&(ut.innerHTML=Rr),ss=r(e),_(ht.$$.fragment,e),as=r(e),ft=s(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-owkrw8"&&(ft.innerHTML=Gr),rs=r(e),gt=s(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1x7hckg"&&(gt.innerHTML=Br),is=r(e),_(_t.$$.fragment,e),ls=r(e),Mt=s(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-34jdzj"&&(Mt.innerHTML=Hr),ds=r(e),kt=s(e,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-11r3tgp"&&(kt.textContent=Wr),cs=r(e),_(yt.$$.fragment,e),ps=r(e),bt=s(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-147vwql"&&(bt.innerHTML=Sr),ms=r(e),vt=s(e,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-1wesasz"&&(vt.innerHTML=Vr),us=r(e),_(Tt.$$.fragment,e),hs=r(e),ee=s(e,"H2",{class:!0});var lo=u(ee);ue=s(lo,"A",{id:!0,class:!0,href:!0});var Hi=u(ue);kn=s(Hi,"SPAN",{});var Wi=u(kn);_(wt.$$.fragment,Wi),Wi.forEach(t),Hi.forEach(t),Ks=r(lo),uo=s(lo,"SPAN",{"data-svelte-h":!0}),p(uo)!=="svelte-n3f0j0"&&(uo.textContent=Pr),lo.forEach(t),fs=r(e),xt=s(e,"UL",{"data-svelte-h":!0}),p(xt)!=="svelte-fiyac8"&&(xt.innerHTML=Ar),gs=r(e),te=s(e,"H2",{class:!0});var Is=u(te);he=s(Is,"A",{id:!0,class:!0,href:!0});var Si=u(he);yn=s(Si,"SPAN",{});var Vi=u(yn);_(Lt.$$.fragment,Vi),Vi.forEach(t),Si.forEach(t),ea=r(Is),ho=s(Is,"SPAN",{"data-svelte-h":!0}),p(ho)!=="svelte-x885ri"&&(ho.textContent=Qr),Is.forEach(t),_s=r(e),C=s(e,"DIV",{class:!0});var Ze=u(C);_($t.$$.fragment,Ze),ta=r(Ze),fo=s(Ze,"P",{"data-svelte-h":!0}),p(fo)!=="svelte-ljj9xq"&&(fo.innerHTML=Xr),oa=r(Ze),go=s(Ze,"P",{"data-svelte-h":!0}),p(go)!=="svelte-12i1qyr"&&(go.innerHTML=Dr),na=r(Ze),_(fe.$$.fragment,Ze),Ze.forEach(t),Ms=r(e),oe=s(e,"H2",{class:!0});var Zs=u(oe);ge=s(Zs,"A",{id:!0,class:!0,href:!0});var Pi=u(ge);bn=s(Pi,"SPAN",{});var Ai=u(bn);_(Jt.$$.fragment,Ai),Ai.forEach(t),Pi.forEach(t),sa=r(Zs),_o=s(Zs,"SPAN",{"data-svelte-h":!0}),p(_o)!=="svelte-mlvysa"&&(_o.textContent=Yr),Zs.forEach(t),ks=r(e),F=s(e,"DIV",{class:!0});var Ee=u(F);_(Ut.$$.fragment,Ee),aa=r(Ee),Mo=s(Ee,"P",{"data-svelte-h":!0}),p(Mo)!=="svelte-t29t5v"&&(Mo.textContent=Or),ra=r(Ee),ko=s(Ee,"P",{"data-svelte-h":!0}),p(ko)!=="svelte-1xyp3q9"&&(ko.innerHTML=Kr),ia=r(Ee),A=s(Ee,"DIV",{class:!0});var pn=u(A);_(qt.$$.fragment,pn),la=r(pn),yo=s(pn,"P",{"data-svelte-h":!0}),p(yo)!=="svelte-ep3db5"&&(yo.textContent=ei),da=r(pn),_(_e.$$.fragment,pn),pn.forEach(t),Ee.forEach(t),ys=r(e),ne=s(e,"H2",{class:!0});var Es=u(ne);Me=s(Es,"A",{id:!0,class:!0,href:!0});var Qi=u(Me);vn=s(Qi,"SPAN",{});var Xi=u(vn);_(jt.$$.fragment,Xi),Xi.forEach(t),Qi.forEach(t),ca=r(Es),bo=s(Es,"SPAN",{"data-svelte-h":!0}),p(bo)!=="svelte-n62vir"&&(bo.textContent=ti),Es.forEach(t),bs=r(e),q=s(e,"DIV",{class:!0});var W=u(q);_(zt.$$.fragment,W),pa=r(W),vo=s(W,"P",{"data-svelte-h":!0}),p(vo)!=="svelte-1r860al"&&(vo.innerHTML=oi),ma=r(W),Q=s(W,"DIV",{class:!0});var mn=u(Q);_(Ct.$$.fragment,mn),ua=r(mn),To=s(mn,"P",{"data-svelte-h":!0}),p(To)!=="svelte-og4clw"&&(To.textContent=ni),ha=r(mn),wo=s(mn,"UL",{"data-svelte-h":!0}),p(wo)!=="svelte-rq8uot"&&(wo.innerHTML=si),mn.forEach(t),fa=r(W),xo=s(W,"DIV",{class:!0});var Di=u(xo);_(Ft.$$.fragment,Di),Di.forEach(t),ga=r(W),ke=s(W,"DIV",{class:!0});var Rs=u(ke);_(Nt.$$.fragment,Rs),_a=r(Rs),Lo=s(Rs,"P",{"data-svelte-h":!0}),p(Lo)!=="svelte-wwxeoo"&&(Lo.textContent=ai),Rs.forEach(t),Ma=r(W),$o=s(W,"DIV",{class:!0});var Yi=u($o);_(It.$$.fragment,Yi),Yi.forEach(t),W.forEach(t),vs=r(e),se=s(e,"H2",{class:!0});var Gs=u(se);ye=s(Gs,"A",{id:!0,class:!0,href:!0});var Oi=u(ye);Tn=s(Oi,"SPAN",{});var Ki=u(Tn);_(Zt.$$.fragment,Ki),Ki.forEach(t),Oi.forEach(t),ka=r(Gs),Jo=s(Gs,"SPAN",{"data-svelte-h":!0}),p(Jo)!=="svelte-1mj9nxt"&&(Jo.textContent=ri),Gs.forEach(t),Ts=r(e),L=s(e,"DIV",{class:!0});var U=u(L);_(Et.$$.fragment,U),ya=r(U),Uo=s(U,"P",{"data-svelte-h":!0}),p(Uo)!=="svelte-w71jv6"&&(Uo.textContent=ii),ba=r(U),qo=s(U,"P",{"data-svelte-h":!0}),p(qo)!=="svelte-1s0o4zk"&&(qo.innerHTML=li),va=r(U),jo=s(U,"P",{"data-svelte-h":!0}),p(jo)!=="svelte-1x24yjd"&&(jo.textContent=di),Ta=r(U),J=s(U,"DIV",{class:!0});var z=u(J);_(Rt.$$.fragment,z),wa=r(z),zo=s(z,"P",{"data-svelte-h":!0}),p(zo)!=="svelte-m9yf02"&&(zo.innerHTML=ci),xa=r(z),Co=s(z,"UL",{"data-svelte-h":!0}),p(Co)!=="svelte-1rbr7il"&&(Co.innerHTML=pi),La=r(z),Fo=s(z,"P",{"data-svelte-h":!0}),p(Fo)!=="svelte-i1gpil"&&(Fo.innerHTML=mi),$a=r(z),No=s(z,"UL",{"data-svelte-h":!0}),p(No)!=="svelte-sxb3sg"&&(No.innerHTML=ui),Ja=r(z),Io=s(z,"P",{"data-svelte-h":!0}),p(Io)!=="svelte-m9yf02"&&(Io.innerHTML=hi),Ua=r(z),Zo=s(z,"UL",{"data-svelte-h":!0}),p(Zo)!=="svelte-227xdf"&&(Zo.innerHTML=fi),z.forEach(t),qa=r(U),X=s(U,"DIV",{class:!0});var un=u(X);_(Gt.$$.fragment,un),ja=r(un),Eo=s(un,"P",{"data-svelte-h":!0}),p(Eo)!=="svelte-og4clw"&&(Eo.textContent=gi),za=r(un),Ro=s(un,"UL",{"data-svelte-h":!0}),p(Ro)!=="svelte-rq8uot"&&(Ro.innerHTML=_i),un.forEach(t),Ca=r(U),be=s(U,"DIV",{class:!0});var Bs=u(be);_(Bt.$$.fragment,Bs),Fa=r(Bs),Go=s(Bs,"P",{"data-svelte-h":!0}),p(Go)!=="svelte-wwxeoo"&&(Go.textContent=Mi),Bs.forEach(t),Na=r(U),ve=s(U,"DIV",{class:!0});var Hs=u(ve);_(Ht.$$.fragment,Hs),Ia=r(Hs),Bo=s(Hs,"P",{"data-svelte-h":!0}),p(Bo)!=="svelte-1eppb6b"&&(Bo.innerHTML=ki),Hs.forEach(t),Za=r(U),Te=s(U,"DIV",{class:!0});var Ws=u(Te);_(Wt.$$.fragment,Ws),Ea=r(Ws),Ho=s(Ws,"P",{"data-svelte-h":!0}),p(Ho)!=="svelte-19qak01"&&(Ho.textContent=yi),Ws.forEach(t),U.forEach(t),ws=r(e),ae=s(e,"H2",{class:!0});var Ss=u(ae);we=s(Ss,"A",{id:!0,class:!0,href:!0});var el=u(we);wn=s(el,"SPAN",{});var tl=u(wn);_(St.$$.fragment,tl),tl.forEach(t),el.forEach(t),Ra=r(Ss),Wo=s(Ss,"SPAN",{"data-svelte-h":!0}),p(Wo)!=="svelte-18jsxlu"&&(Wo.textContent=bi),Ss.forEach(t),xs=r(e),j=s(e,"DIV",{class:!0});var D=u(j);_(Vt.$$.fragment,D),Ga=r(D),So=s(D,"P",{"data-svelte-h":!0}),p(So)!=="svelte-jukxuq"&&(So.textContent=vi),Ba=r(D),Vo=s(D,"P",{"data-svelte-h":!0}),p(Vo)!=="svelte-1on4ky0"&&(Vo.innerHTML=Ti),Ha=r(D),Po=s(D,"P",{"data-svelte-h":!0}),p(Po)!=="svelte-1fr2nk0"&&(Po.innerHTML=wi),Wa=r(D),E=s(D,"DIV",{class:!0});var Re=u(E);_(Pt.$$.fragment,Re),Sa=r(Re),Ao=s(Re,"P",{"data-svelte-h":!0}),p(Ao)!=="svelte-1dcvleu"&&(Ao.innerHTML=xi),Va=r(Re),Qo=s(Re,"P",{"data-svelte-h":!0}),p(Qo)!=="svelte-yz8mju"&&(Qo.innerHTML=Li),Pa=r(Re),Xo=s(Re,"P",{"data-svelte-h":!0}),p(Xo)!=="svelte-ws0hzs"&&(Xo.textContent=$i),Re.forEach(t),D.forEach(t),Ls=r(e),re=s(e,"H2",{class:!0});var Vs=u(re);xe=s(Vs,"A",{id:!0,class:!0,href:!0});var ol=u(xe);xn=s(ol,"SPAN",{});var nl=u(xn);_(At.$$.fragment,nl),nl.forEach(t),ol.forEach(t),Aa=r(Vs),Do=s(Vs,"SPAN",{"data-svelte-h":!0}),p(Do)!=="svelte-1m8h3ub"&&(Do.textContent=Ji),Vs.forEach(t),$s=r(e),V=s(e,"DIV",{class:!0});var hn=u(V);_(Qt.$$.fragment,hn),Qa=r(hn),Yo=s(hn,"P",{"data-svelte-h":!0}),p(Yo)!=="svelte-du7a53"&&(Yo.innerHTML=Ui),Xa=r(hn),R=s(hn,"DIV",{class:!0});var Ge=u(R);_(Xt.$$.fragment,Ge),Da=r(Ge),Oo=s(Ge,"P",{"data-svelte-h":!0}),p(Oo)!=="svelte-1ysoxhm"&&(Oo.innerHTML=qi),Ya=r(Ge),_(Le.$$.fragment,Ge),Oa=r(Ge),_($e.$$.fragment,Ge),Ge.forEach(t),hn.forEach(t),Js=r(e),ie=s(e,"H2",{class:!0});var Ps=u(ie);Je=s(Ps,"A",{id:!0,class:!0,href:!0});var sl=u(Je);Ln=s(sl,"SPAN",{});var al=u(Ln);_(Dt.$$.fragment,al),al.forEach(t),sl.forEach(t),Ka=r(Ps),Ko=s(Ps,"SPAN",{"data-svelte-h":!0}),p(Ko)!=="svelte-1t5l3ls"&&(Ko.textContent=ji),Ps.forEach(t),Us=r(e),N=s(e,"DIV",{class:!0});var Be=u(N);_(Yt.$$.fragment,Be),er=r(Be),en=s(Be,"P",{"data-svelte-h":!0}),p(en)!=="svelte-hwwz9z"&&(en.textContent=zi),tr=r(Be),tn=s(Be,"P",{"data-svelte-h":!0}),p(tn)!=="svelte-68lg8f"&&(tn.innerHTML=Ci),or=r(Be),G=s(Be,"DIV",{class:!0});var He=u(G);_(Ot.$$.fragment,He),nr=r(He),on=s(He,"P",{"data-svelte-h":!0}),p(on)!=="svelte-1vqx1vm"&&(on.innerHTML=Fi),sr=r(He),_(Ue.$$.fragment,He),ar=r(He),_(qe.$$.fragment,He),He.forEach(t),Be.forEach(t),qs=r(e),le=s(e,"H2",{class:!0});var As=u(le);je=s(As,"A",{id:!0,class:!0,href:!0});var rl=u(je);$n=s(rl,"SPAN",{});var il=u($n);_(Kt.$$.fragment,il),il.forEach(t),rl.forEach(t),rr=r(As),nn=s(As,"SPAN",{"data-svelte-h":!0}),p(nn)!=="svelte-w4odbk"&&(nn.textContent=Ni),As.forEach(t),js=r(e),P=s(e,"DIV",{class:!0});var fn=u(P);_(eo.$$.fragment,fn),ir=r(fn),sn=s(fn,"P",{"data-svelte-h":!0}),p(sn)!=="svelte-z4eix7"&&(sn.innerHTML=Ii),lr=r(fn),B=s(fn,"DIV",{class:!0});var We=u(B);_(to.$$.fragment,We),dr=r(We),an=s(We,"P",{"data-svelte-h":!0}),p(an)!=="svelte-1m6uofc"&&(an.innerHTML=Zi),cr=r(We),_(ze.$$.fragment,We),pr=r(We),_(Ce.$$.fragment,We),We.forEach(t),fn.forEach(t),zs=r(e),de=s(e,"H2",{class:!0});var Qs=u(de);Fe=s(Qs,"A",{id:!0,class:!0,href:!0});var ll=u(Fe);Jn=s(ll,"SPAN",{});var dl=u(Jn);_(oo.$$.fragment,dl),dl.forEach(t),ll.forEach(t),mr=r(Qs),rn=s(Qs,"SPAN",{"data-svelte-h":!0}),p(rn)!=="svelte-168uw4x"&&(rn.textContent=Ei),Qs.forEach(t),Cs=r(e),I=s(e,"DIV",{class:!0});var Se=u(I);_(no.$$.fragment,Se),ur=r(Se),ln=s(Se,"P",{"data-svelte-h":!0}),p(ln)!=="svelte-15cf5fq"&&(ln.innerHTML=Ri),hr=r(Se),dn=s(Se,"P",{"data-svelte-h":!0}),p(dn)!=="svelte-68lg8f"&&(dn.innerHTML=Gi),fr=r(Se),H=s(Se,"DIV",{class:!0});var Ve=u(H);_(so.$$.fragment,Ve),gr=r(Ve),cn=s(Ve,"P",{"data-svelte-h":!0}),p(cn)!=="svelte-4zcwda"&&(cn.innerHTML=Bi),_r=r(Ve),_(Ne.$$.fragment,Ve),Mr=r(Ve),_(Ie.$$.fragment,Ve),Ve.forEach(t),Se.forEach(t),Fs=r(e),Un=s(e,"P",{}),u(Un).forEach(t),this.h()},h(){m(c,"name","hf:doc:metadata"),m(c,"content",JSON.stringify($l)),m(d,"id","markuplm"),m(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(d,"href","#markuplm"),m(v,"class","relative group"),m(ce,"id","overview"),m(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ce,"href","#overview"),m(O,"class","relative group"),pl(pe.src,Jr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/markuplm_architecture.jpg")||m(pe,"src",Jr),m(pe,"alt","drawing"),m(pe,"width","600"),m(me,"id","usage-markuplmprocessor"),m(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(me,"href","#usage-markuplmprocessor"),m(K,"class","relative group"),m(ue,"id","documentation-resources"),m(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ue,"href","#documentation-resources"),m(ee,"class","relative group"),m(he,"id","transformers.MarkupLMConfig"),m(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(he,"href","#transformers.MarkupLMConfig"),m(te,"class","relative group"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ge,"id","transformers.MarkupLMFeatureExtractor"),m(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ge,"href","#transformers.MarkupLMFeatureExtractor"),m(oe,"class","relative group"),m(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Me,"id","transformers.MarkupLMTokenizer"),m(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Me,"href","#transformers.MarkupLMTokenizer"),m(ne,"class","relative group"),m(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ye,"id","transformers.MarkupLMTokenizerFast"),m(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ye,"href","#transformers.MarkupLMTokenizerFast"),m(se,"class","relative group"),m(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(we,"id","transformers.MarkupLMProcessor"),m(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(we,"href","#transformers.MarkupLMProcessor"),m(ae,"class","relative group"),m(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(xe,"id","transformers.MarkupLMModel"),m(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(xe,"href","#transformers.MarkupLMModel"),m(re,"class","relative group"),m(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Je,"id","transformers.MarkupLMForSequenceClassification"),m(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Je,"href","#transformers.MarkupLMForSequenceClassification"),m(ie,"class","relative group"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(je,"id","transformers.MarkupLMForTokenClassification"),m(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(je,"href","#transformers.MarkupLMForTokenClassification"),m(le,"class","relative group"),m(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Fe,"id","transformers.MarkupLMForQuestionAnswering"),m(Fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Fe,"href","#transformers.MarkupLMForQuestionAnswering"),m(de,"class","relative group"),m(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,c),l(e,T,i),l(e,f,i),l(e,h,i),l(e,v,i),o(v,d),o(d,w),M(Pe,w,null),o(v,Ds),o(v,co),l(e,In,i),l(e,O,i),o(O,ce),o(ce,_n),M(Ae,_n,null),o(O,Ys),o(O,po),l(e,Zn,i),l(e,Qe,i),l(e,En,i),l(e,Xe,i),l(e,Rn,i),l(e,De,i),l(e,Gn,i),l(e,Ye,i),l(e,Bn,i),l(e,Oe,i),l(e,Hn,i),l(e,Ke,i),l(e,Wn,i),l(e,et,i),l(e,Sn,i),l(e,pe,i),l(e,Vn,i),l(e,tt,i),l(e,Pn,i),l(e,ot,i),l(e,An,i),l(e,K,i),o(K,me),o(me,Mn),M(nt,Mn,null),o(K,Os),o(K,mo),l(e,Qn,i),l(e,st,i),l(e,Xn,i),M(at,e,i),l(e,Dn,i),l(e,rt,i),l(e,Yn,i),l(e,it,i),l(e,On,i),l(e,lt,i),l(e,Kn,i),l(e,dt,i),l(e,es,i),l(e,ct,i),l(e,ts,i),M(pt,e,i),l(e,os,i),l(e,mt,i),l(e,ns,i),l(e,ut,i),l(e,ss,i),M(ht,e,i),l(e,as,i),l(e,ft,i),l(e,rs,i),l(e,gt,i),l(e,is,i),M(_t,e,i),l(e,ls,i),l(e,Mt,i),l(e,ds,i),l(e,kt,i),l(e,cs,i),M(yt,e,i),l(e,ps,i),l(e,bt,i),l(e,ms,i),l(e,vt,i),l(e,us,i),M(Tt,e,i),l(e,hs,i),l(e,ee,i),o(ee,ue),o(ue,kn),M(wt,kn,null),o(ee,Ks),o(ee,uo),l(e,fs,i),l(e,xt,i),l(e,gs,i),l(e,te,i),o(te,he),o(he,yn),M(Lt,yn,null),o(te,ea),o(te,ho),l(e,_s,i),l(e,C,i),M($t,C,null),o(C,ta),o(C,fo),o(C,oa),o(C,go),o(C,na),M(fe,C,null),l(e,Ms,i),l(e,oe,i),o(oe,ge),o(ge,bn),M(Jt,bn,null),o(oe,sa),o(oe,_o),l(e,ks,i),l(e,F,i),M(Ut,F,null),o(F,aa),o(F,Mo),o(F,ra),o(F,ko),o(F,ia),o(F,A),M(qt,A,null),o(A,la),o(A,yo),o(A,da),M(_e,A,null),l(e,ys,i),l(e,ne,i),o(ne,Me),o(Me,vn),M(jt,vn,null),o(ne,ca),o(ne,bo),l(e,bs,i),l(e,q,i),M(zt,q,null),o(q,pa),o(q,vo),o(q,ma),o(q,Q),M(Ct,Q,null),o(Q,ua),o(Q,To),o(Q,ha),o(Q,wo),o(q,fa),o(q,xo),M(Ft,xo,null),o(q,ga),o(q,ke),M(Nt,ke,null),o(ke,_a),o(ke,Lo),o(q,Ma),o(q,$o),M(It,$o,null),l(e,vs,i),l(e,se,i),o(se,ye),o(ye,Tn),M(Zt,Tn,null),o(se,ka),o(se,Jo),l(e,Ts,i),l(e,L,i),M(Et,L,null),o(L,ya),o(L,Uo),o(L,ba),o(L,qo),o(L,va),o(L,jo),o(L,Ta),o(L,J),M(Rt,J,null),o(J,wa),o(J,zo),o(J,xa),o(J,Co),o(J,La),o(J,Fo),o(J,$a),o(J,No),o(J,Ja),o(J,Io),o(J,Ua),o(J,Zo),o(L,qa),o(L,X),M(Gt,X,null),o(X,ja),o(X,Eo),o(X,za),o(X,Ro),o(L,Ca),o(L,be),M(Bt,be,null),o(be,Fa),o(be,Go),o(L,Na),o(L,ve),M(Ht,ve,null),o(ve,Ia),o(ve,Bo),o(L,Za),o(L,Te),M(Wt,Te,null),o(Te,Ea),o(Te,Ho),l(e,ws,i),l(e,ae,i),o(ae,we),o(we,wn),M(St,wn,null),o(ae,Ra),o(ae,Wo),l(e,xs,i),l(e,j,i),M(Vt,j,null),o(j,Ga),o(j,So),o(j,Ba),o(j,Vo),o(j,Ha),o(j,Po),o(j,Wa),o(j,E),M(Pt,E,null),o(E,Sa),o(E,Ao),o(E,Va),o(E,Qo),o(E,Pa),o(E,Xo),l(e,Ls,i),l(e,re,i),o(re,xe),o(xe,xn),M(At,xn,null),o(re,Aa),o(re,Do),l(e,$s,i),l(e,V,i),M(Qt,V,null),o(V,Qa),o(V,Yo),o(V,Xa),o(V,R),M(Xt,R,null),o(R,Da),o(R,Oo),o(R,Ya),M(Le,R,null),o(R,Oa),M($e,R,null),l(e,Js,i),l(e,ie,i),o(ie,Je),o(Je,Ln),M(Dt,Ln,null),o(ie,Ka),o(ie,Ko),l(e,Us,i),l(e,N,i),M(Yt,N,null),o(N,er),o(N,en),o(N,tr),o(N,tn),o(N,or),o(N,G),M(Ot,G,null),o(G,nr),o(G,on),o(G,sr),M(Ue,G,null),o(G,ar),M(qe,G,null),l(e,qs,i),l(e,le,i),o(le,je),o(je,$n),M(Kt,$n,null),o(le,rr),o(le,nn),l(e,js,i),l(e,P,i),M(eo,P,null),o(P,ir),o(P,sn),o(P,lr),o(P,B),M(to,B,null),o(B,dr),o(B,an),o(B,cr),M(ze,B,null),o(B,pr),M(Ce,B,null),l(e,zs,i),l(e,de,i),o(de,Fe),o(Fe,Jn),M(oo,Jn,null),o(de,mr),o(de,rn),l(e,Cs,i),l(e,I,i),M(no,I,null),o(I,ur),o(I,ln),o(I,hr),o(I,dn),o(I,fr),o(I,H),M(so,H,null),o(H,gr),o(H,cn),o(H,_r),M(Ne,H,null),o(H,Mr),M(Ie,H,null),l(e,Fs,i),l(e,Un,i),Ns=!0},p(e,[i]){const ao={};i&2&&(ao.$$scope={dirty:i,ctx:e}),fe.$set(ao);const qn={};i&2&&(qn.$$scope={dirty:i,ctx:e}),_e.$set(qn);const jn={};i&2&&(jn.$$scope={dirty:i,ctx:e}),Le.$set(jn);const ro={};i&2&&(ro.$$scope={dirty:i,ctx:e}),$e.$set(ro);const zn={};i&2&&(zn.$$scope={dirty:i,ctx:e}),Ue.$set(zn);const Cn={};i&2&&(Cn.$$scope={dirty:i,ctx:e}),qe.$set(Cn);const io={};i&2&&(io.$$scope={dirty:i,ctx:e}),ze.$set(io);const Fn={};i&2&&(Fn.$$scope={dirty:i,ctx:e}),Ce.$set(Fn);const Nn={};i&2&&(Nn.$$scope={dirty:i,ctx:e}),Ne.$set(Nn);const lo={};i&2&&(lo.$$scope={dirty:i,ctx:e}),Ie.$set(lo)},i(e){Ns||(k(Pe.$$.fragment,e),k(Ae.$$.fragment,e),k(nt.$$.fragment,e),k(at.$$.fragment,e),k(pt.$$.fragment,e),k(ht.$$.fragment,e),k(_t.$$.fragment,e),k(yt.$$.fragment,e),k(Tt.$$.fragment,e),k(wt.$$.fragment,e),k(Lt.$$.fragment,e),k($t.$$.fragment,e),k(fe.$$.fragment,e),k(Jt.$$.fragment,e),k(Ut.$$.fragment,e),k(qt.$$.fragment,e),k(_e.$$.fragment,e),k(jt.$$.fragment,e),k(zt.$$.fragment,e),k(Ct.$$.fragment,e),k(Ft.$$.fragment,e),k(Nt.$$.fragment,e),k(It.$$.fragment,e),k(Zt.$$.fragment,e),k(Et.$$.fragment,e),k(Rt.$$.fragment,e),k(Gt.$$.fragment,e),k(Bt.$$.fragment,e),k(Ht.$$.fragment,e),k(Wt.$$.fragment,e),k(St.$$.fragment,e),k(Vt.$$.fragment,e),k(Pt.$$.fragment,e),k(At.$$.fragment,e),k(Qt.$$.fragment,e),k(Xt.$$.fragment,e),k(Le.$$.fragment,e),k($e.$$.fragment,e),k(Dt.$$.fragment,e),k(Yt.$$.fragment,e),k(Ot.$$.fragment,e),k(Ue.$$.fragment,e),k(qe.$$.fragment,e),k(Kt.$$.fragment,e),k(eo.$$.fragment,e),k(to.$$.fragment,e),k(ze.$$.fragment,e),k(Ce.$$.fragment,e),k(oo.$$.fragment,e),k(no.$$.fragment,e),k(so.$$.fragment,e),k(Ne.$$.fragment,e),k(Ie.$$.fragment,e),Ns=!0)},o(e){y(Pe.$$.fragment,e),y(Ae.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(pt.$$.fragment,e),y(ht.$$.fragment,e),y(_t.$$.fragment,e),y(yt.$$.fragment,e),y(Tt.$$.fragment,e),y(wt.$$.fragment,e),y(Lt.$$.fragment,e),y($t.$$.fragment,e),y(fe.$$.fragment,e),y(Jt.$$.fragment,e),y(Ut.$$.fragment,e),y(qt.$$.fragment,e),y(_e.$$.fragment,e),y(jt.$$.fragment,e),y(zt.$$.fragment,e),y(Ct.$$.fragment,e),y(Ft.$$.fragment,e),y(Nt.$$.fragment,e),y(It.$$.fragment,e),y(Zt.$$.fragment,e),y(Et.$$.fragment,e),y(Rt.$$.fragment,e),y(Gt.$$.fragment,e),y(Bt.$$.fragment,e),y(Ht.$$.fragment,e),y(Wt.$$.fragment,e),y(St.$$.fragment,e),y(Vt.$$.fragment,e),y(Pt.$$.fragment,e),y(At.$$.fragment,e),y(Qt.$$.fragment,e),y(Xt.$$.fragment,e),y(Le.$$.fragment,e),y($e.$$.fragment,e),y(Dt.$$.fragment,e),y(Yt.$$.fragment,e),y(Ot.$$.fragment,e),y(Ue.$$.fragment,e),y(qe.$$.fragment,e),y(Kt.$$.fragment,e),y(eo.$$.fragment,e),y(to.$$.fragment,e),y(ze.$$.fragment,e),y(Ce.$$.fragment,e),y(oo.$$.fragment,e),y(no.$$.fragment,e),y(so.$$.fragment,e),y(Ne.$$.fragment,e),y(Ie.$$.fragment,e),Ns=!1},d(e){e&&(t(T),t(f),t(h),t(v),t(In),t(O),t(Zn),t(Qe),t(En),t(Xe),t(Rn),t(De),t(Gn),t(Ye),t(Bn),t(Oe),t(Hn),t(Ke),t(Wn),t(et),t(Sn),t(pe),t(Vn),t(tt),t(Pn),t(ot),t(An),t(K),t(Qn),t(st),t(Xn),t(Dn),t(rt),t(Yn),t(it),t(On),t(lt),t(Kn),t(dt),t(es),t(ct),t(ts),t(os),t(mt),t(ns),t(ut),t(ss),t(as),t(ft),t(rs),t(gt),t(is),t(ls),t(Mt),t(ds),t(kt),t(cs),t(ps),t(bt),t(ms),t(vt),t(us),t(hs),t(ee),t(fs),t(xt),t(gs),t(te),t(_s),t(C),t(Ms),t(oe),t(ks),t(F),t(ys),t(ne),t(bs),t(q),t(vs),t(se),t(Ts),t(L),t(ws),t(ae),t(xs),t(j),t(Ls),t(re),t($s),t(V),t(Js),t(ie),t(Us),t(N),t(qs),t(le),t(js),t(P),t(zs),t(de),t(Cs),t(I),t(Fs),t(Un)),t(c),b(Pe),b(Ae),b(nt),b(at,e),b(pt,e),b(ht,e),b(_t,e),b(yt,e),b(Tt,e),b(wt),b(Lt),b($t),b(fe),b(Jt),b(Ut),b(qt),b(_e),b(jt),b(zt),b(Ct),b(Ft),b(Nt),b(It),b(Zt),b(Et),b(Rt),b(Gt),b(Bt),b(Ht),b(Wt),b(St),b(Vt),b(Pt),b(At),b(Qt),b(Xt),b(Le),b($e),b(Dt),b(Yt),b(Ot),b(Ue),b(qe),b(Kt),b(eo),b(to),b(ze),b(Ce),b(oo),b(no),b(so),b(Ne),b(Ie)}}}const $l={local:"markuplm",sections:[{local:"overview",title:"Overview"},{local:"usage-markuplmprocessor",title:"Usage: MarkupLMProcessor"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.MarkupLMConfig",title:"MarkupLMConfig"},{local:"transformers.MarkupLMFeatureExtractor",title:"MarkupLMFeatureExtractor"},{local:"transformers.MarkupLMTokenizer",title:"MarkupLMTokenizer"},{local:"transformers.MarkupLMTokenizerFast",title:"MarkupLMTokenizerFast"},{local:"transformers.MarkupLMProcessor",title:"MarkupLMProcessor"},{local:"transformers.MarkupLMModel",title:"MarkupLMModel"},{local:"transformers.MarkupLMForSequenceClassification",title:"MarkupLMForSequenceClassification"},{local:"transformers.MarkupLMForTokenClassification",title:"MarkupLMForTokenClassification"},{local:"transformers.MarkupLMForQuestionAnswering",title:"MarkupLMForQuestionAnswering"}],title:"MarkupLM"};function Jl($){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends ul{constructor(c){super(),hl(this,c,Jl,Ll,cl,{})}}export{Il as component};
