import{s as Vt,o as xt,n as Mt}from"../chunks/scheduler.8c3d61f6.js";import{S as kt,i as Ht,g as s,s as i,r as f,A as $t,h as l,f as n,c as a,j as J,u as g,x as c,k,y as r,a as o,v as h,d as _,t as y,w as b}from"../chunks/index.da70eac4.js";import{T as Jt}from"../chunks/Tip.1d9b8c37.js";import{D as ae}from"../chunks/Docstring.6b390b9a.js";import{C as Tt}from"../chunks/CodeBlock.00a903b3.js";import{E as jt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as he,E as Ct}from"../chunks/EditOnGithub.1e64e623.js";function Pt(se){let d,V='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=s("p"),d.innerHTML=V},l(v){d=l(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1qn15hi"&&(d.innerHTML=V)},m(v,w){o(v,d,w)},p:Mt,d(v){v&&n(d)}}}function It(se){let d,V="Examples:",v,w,M;return w=new Tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSHVueXVhblZpZGVvUGlwZWxpbmUlMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBIdW55dWFuVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudmFlLmVuYWJsZV90aWxpbmcoKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QzMjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0Q2MSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer = HunyuanVideoTransformer3DModel.from_pretrained(
<span class="hljs-meta">... </span>    model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = HunyuanVideoPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">320</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">61</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){d=s("p"),d.textContent=V,v=i(),f(w.$$.fragment)},l(u){d=l(u,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=V),v=a(u),g(w.$$.fragment,u)},m(u,T){o(u,d,T),o(u,v,T),h(w,u,T),M=!0},p:Mt,i(u){M||(_(w.$$.fragment,u),M=!0)},o(u){y(w.$$.fragment,u),M=!1},d(u){u&&(n(d),n(v)),b(w,u)}}}function Zt(se){let d,V,v,w,M,u,T,ot='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',_e,U,it='<a href="https://www.arxiv.org/abs/2412.03603" rel="nofollow">HunyuanVideo</a> by Tencent.',ye,L,at='<em>Recent advancements in video generation have significantly impacted daily life for both individuals and industries. However, the leading video generation models remain closed-source, resulting in a notable performance gap between industry capabilities and those available to the public. In this report, we introduce HunyuanVideo, an innovative open-source video foundation model that demonstrates performance in video generation comparable to, or even surpassing, that of leading closed-source models. HunyuanVideo encompasses a comprehensive framework that integrates several key elements, including data curation, advanced architectural design, progressive model scaling and training, and an efficient infrastructure tailored for large-scale model training and inference. As a result, we successfully trained a video generative model with over 13 billion parameters, making it the largest among all open-source models. We conducted extensive experiments and implemented a series of targeted designs to ensure high visual quality, motion dynamics, text-video alignment, and advanced filming techniques. According to evaluations by professionals, HunyuanVideo outperforms previous state-of-the-art models, including Runway Gen-3, Luma 1.6, and three top-performing Chinese video generative models. By releasing the code for the foundation model and its applications, we aim to bridge the gap between closed-source and open-source communities. This initiative will empower individuals within the community to experiment with their ideas, fostering a more dynamic and vibrant video generation ecosystem. The code is publicly available at <a href="https://github.com/tencent/HunyuanVideo" rel="nofollow">this https URL</a>.</em>',be,j,ve,E,st="Recommendations for inference:",we,B,lt='<li>Both text encoders should be in <code>torch.float16</code>.</li> <li>Transformer should be in <code>torch.bfloat16</code>.</li> <li>VAE should be in <code>torch.float16</code>.</li> <li><code>num_frames</code> should be of the form <code>4 * k + 1</code>, for example <code>49</code> or <code>129</code>.</li> <li>For smaller resolution videos, try lower values of <code>shift</code> (between <code>2.0</code> to <code>5.0</code>) in the <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler.shift" rel="nofollow">Scheduler</a>. For larger resolution images, try higher values (between <code>7.0</code> and <code>12.0</code>). The default value is <code>7.0</code> for HunyuanVideo.</li> <li>For more information about supported resolutions and other details, please refer to the original repository <a href="https://github.com/Tencent/HunyuanVideo/" rel="nofollow">here</a>.</li>',Me,G,Te,z,rt='The following models are available for the <a href="text-to-video"><code>HunyuanVideoPipeline</code></a> pipeline:',Ve,A,dt='<thead><tr><th align="left">Model name</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><a href="https://huggingface.co/hunyuanvideo-community/HunyuanVideo" rel="nofollow"><code>hunyuanvideo-community/HunyuanVideo</code></a></td> <td align="left">Official HunyuanVideo (guidance-distilled). Performs best at multiple resolutions and frames. Performs best with <code>guidance_scale=6.0</code>, <code>true_cfg_scale=1.0</code> and without a negative prompt.</td></tr> <tr><td align="left"><a href="https://huggingface.co/Skywork/SkyReels-V1-Hunyuan-T2V" rel="nofollow"><code>https://huggingface.co/Skywork/SkyReels-V1-Hunyuan-T2V</code></a></td> <td align="left">Skywork’s custom finetune of HunyuanVideo (de-distilled). Performs best with <code>97x544x960</code> resolution, <code>guidance_scale=1.0</code>, <code>true_cfg_scale=6.0</code> and a negative prompt.</td></tr></tbody>',xe,X,pt="The following models are available for the image-to-video pipeline:",ke,D,ct='<thead><tr><th align="left">Model name</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><a href="https://huggingface.co/Skywork/SkyReels-V1-Hunyuan-I2V" rel="nofollow"><code>Skywork/SkyReels-V1-Hunyuan-I2V</code></a></td> <td align="left">Skywork’s custom finetune of HunyuanVideo (de-distilled). Performs best with <code>97x544x960</code> resolution. Performs best at <code>97x544x960</code> resolution, <code>guidance_scale=1.0</code>, <code>true_cfg_scale=6.0</code> and a negative prompt.</td></tr> <tr><td align="left"><a href="https://huggingface.co/hunyuanvideo-community/HunyuanVideo-I2V" rel="nofollow"><code>hunyuanvideo-community/HunyuanVideo-I2V</code></a></td> <td align="left">Tecent’s official HunyuanVideo I2V model. Performs best at resolutions of 480, 720, 960, 1280. A higher <code>shift</code> value when initializing the scheduler is recommended (good values are between 7 and 20)</td></tr></tbody>',He,Q,$e,R,ut="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Je,q,mt='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/hunyuan_video#diffusers.HunyuanVideoPipeline">HunyuanVideoPipeline</a> for inference with bitsandbytes.',je,F,Ce,N,Pe,p,S,Xe,le,ft="Pipeline for text-to-video generation using HunyuanVideo.",De,re,gt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Qe,x,Y,Re,de,ht="The call function to the pipeline for generation.",qe,C,Fe,P,O,Ne,pe,_t=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Se,I,K,Ye,ce,yt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Oe,Z,ee,Ke,ue,bt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,et,W,te,tt,me,vt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ie,ne,Ze,H,oe,nt,fe,wt="Output class for HunyuanVideo pipelines.",We,ie,Ue,ge,Le;return M=new he({props:{title:"HunyuanVideo",local:"hunyuanvideo",headingTag:"h1"}}),j=new Jt({props:{$$slots:{default:[Pt]},$$scope:{ctx:se}}}),G=new he({props:{title:"Available models",local:"available-models",headingTag:"h2"}}),Q=new he({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),F=new Tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMkMlMjBIdW55dWFuVmlkZW9QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjBzdHlsZS4lMjIlMEF2aWRlbyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9mcmFtZXMlM0Q2MSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMmNhdC5tcDQlMjIlMkMlMjBmcHMlM0QxNSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, HunyuanVideoTransformer3DModel, HunyuanVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = HunyuanVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
)

pipeline = HunyuanVideoPipeline.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A cat walks on the grass, realistic style.&quot;</span>
video = pipeline(prompt=prompt, num_frames=<span class="hljs-number">61</span>, num_inference_steps=<span class="hljs-number">30</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;cat.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),N=new he({props:{title:"HunyuanVideoPipeline",local:"diffusers.HunyuanVideoPipeline",headingTag:"h2"}}),S=new ae({props:{name:"class diffusers.HunyuanVideoPipeline",anchor:"diffusers.HunyuanVideoPipeline",parameters:[{name:"text_encoder",val:": LlamaModel"},{name:"tokenizer",val:": LlamaTokenizerFast"},{name:"transformer",val:": HunyuanVideoTransformer3DModel"},{name:"vae",val:": AutoencoderKLHunyuanVideo"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"text_encoder_2",val:": CLIPTextModel"},{name:"tokenizer_2",val:": CLIPTokenizer"}],parametersDescription:[{anchor:"diffusers.HunyuanVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>LlamaModel</code>) &#x2014;
<a href="https://huggingface.co/xtuner/llava-llama-3-8b-v1_1-transformers" rel="nofollow">Llava Llama3-8B</a>.`,name:"text_encoder"},{anchor:"diffusers.HunyuanVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/xtuner/llava-llama-3-8b-v1_1-transformers" rel="nofollow">Llava Llama3-8B</a>.`,name:"tokenizer"},{anchor:"diffusers.HunyuanVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/hunyuan_video_transformer_3d#diffusers.HunyuanVideoTransformer3DModel">HunyuanVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.HunyuanVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.HunyuanVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_hunyuan_video#diffusers.AutoencoderKLHunyuanVideo">AutoencoderKLHunyuanVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.HunyuanVideoPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.HunyuanVideoPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L144"}}),Y=new ae({props:{name:"__call__",anchor:"diffusers.HunyuanVideoPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 720"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 129"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.List[float] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"prompt_template",val:": typing.Dict[str, typing.Any] = {'template': '<|start_header_id|>system<|end_header_id|>\\n\\nDescribe the video by detailing the following aspects: 1. The main content and theme of the video.2. The color, shape, size, texture, quantity, text, and spatial relationships of the objects.3. Actions, events, behaviors temporal relationships, physical movement changes of the objects.4. background environment, light, style and atmosphere.5. camera angles, movements, and transitions used in the video:<|eot_id|><|start_header_id|>user<|end_header_id|>\\n\\n{}<|eot_id|>', 'crop_start': 95}"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>129</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. Note that the only available HunyuanVideo model is
CFG-distilled, which means that traditional guidance between unconditional and conditional latent is
not applied.`,name:"guidance_scale"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>HunyuanVideoPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L467",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>HunyuanVideoPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~HunyuanVideoPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new jt({props:{anchor:"diffusers.HunyuanVideoPipeline.__call__.example",$$slots:{default:[It]},$$scope:{ctx:se}}}),O=new ae({props:{name:"disable_vae_slicing",anchor:"diffusers.HunyuanVideoPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L425"}}),K=new ae({props:{name:"disable_vae_tiling",anchor:"diffusers.HunyuanVideoPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L440"}}),ee=new ae({props:{name:"enable_vae_slicing",anchor:"diffusers.HunyuanVideoPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L418"}}),te=new ae({props:{name:"enable_vae_tiling",anchor:"diffusers.HunyuanVideoPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L432"}}),ne=new he({props:{title:"HunyuanVideoPipelineOutput",local:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",headingTag:"h2"}}),oe=new ae({props:{name:"class diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",anchor:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_output.py#L8"}}),ie=new Ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/hunyuan_video.md"}}),{c(){d=s("meta"),V=i(),v=s("p"),w=i(),f(M.$$.fragment),u=i(),T=s("div"),T.innerHTML=ot,_e=i(),U=s("p"),U.innerHTML=it,ye=i(),L=s("p"),L.innerHTML=at,be=i(),f(j.$$.fragment),ve=i(),E=s("p"),E.textContent=st,we=i(),B=s("ul"),B.innerHTML=lt,Me=i(),f(G.$$.fragment),Te=i(),z=s("p"),z.innerHTML=rt,Ve=i(),A=s("table"),A.innerHTML=dt,xe=i(),X=s("p"),X.textContent=pt,ke=i(),D=s("table"),D.innerHTML=ct,He=i(),f(Q.$$.fragment),$e=i(),R=s("p"),R.textContent=ut,Je=i(),q=s("p"),q.innerHTML=mt,je=i(),f(F.$$.fragment),Ce=i(),f(N.$$.fragment),Pe=i(),p=s("div"),f(S.$$.fragment),Xe=i(),le=s("p"),le.textContent=ft,De=i(),re=s("p"),re.innerHTML=gt,Qe=i(),x=s("div"),f(Y.$$.fragment),Re=i(),de=s("p"),de.textContent=ht,qe=i(),f(C.$$.fragment),Fe=i(),P=s("div"),f(O.$$.fragment),Ne=i(),pe=s("p"),pe.innerHTML=_t,Se=i(),I=s("div"),f(K.$$.fragment),Ye=i(),ce=s("p"),ce.innerHTML=yt,Oe=i(),Z=s("div"),f(ee.$$.fragment),Ke=i(),ue=s("p"),ue.textContent=bt,et=i(),W=s("div"),f(te.$$.fragment),tt=i(),me=s("p"),me.textContent=vt,Ie=i(),f(ne.$$.fragment),Ze=i(),H=s("div"),f(oe.$$.fragment),nt=i(),fe=s("p"),fe.textContent=wt,We=i(),f(ie.$$.fragment),Ue=i(),ge=s("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(n),V=a(e),v=l(e,"P",{}),J(v).forEach(n),w=a(e),g(M.$$.fragment,e),u=a(e),T=l(e,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-si9ct8"&&(T.innerHTML=ot),_e=a(e),U=l(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-r39nnx"&&(U.innerHTML=it),ye=a(e),L=l(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-nu132f"&&(L.innerHTML=at),be=a(e),g(j.$$.fragment,e),ve=a(e),E=l(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1bbhycm"&&(E.textContent=st),we=a(e),B=l(e,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-jc657q"&&(B.innerHTML=lt),Me=a(e),g(G.$$.fragment,e),Te=a(e),z=l(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-iw5psn"&&(z.innerHTML=rt),Ve=a(e),A=l(e,"TABLE",{"data-svelte-h":!0}),c(A)!=="svelte-1vwel2v"&&(A.innerHTML=dt),xe=a(e),X=l(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-j275yy"&&(X.textContent=pt),ke=a(e),D=l(e,"TABLE",{"data-svelte-h":!0}),c(D)!=="svelte-qodcku"&&(D.innerHTML=ct),He=a(e),g(Q.$$.fragment,e),$e=a(e),R=l(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ou2pxc"&&(R.textContent=ut),Je=a(e),q=l(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-4th7qw"&&(q.innerHTML=mt),je=a(e),g(F.$$.fragment,e),Ce=a(e),g(N.$$.fragment,e),Pe=a(e),p=l(e,"DIV",{class:!0});var m=J(p);g(S.$$.fragment,m),Xe=a(m),le=l(m,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1a4x0ff"&&(le.textContent=ft),De=a(m),re=l(m,"P",{"data-svelte-h":!0}),c(re)!=="svelte-496sm0"&&(re.innerHTML=gt),Qe=a(m),x=l(m,"DIV",{class:!0});var $=J(x);g(Y.$$.fragment,$),Re=a($),de=l($,"P",{"data-svelte-h":!0}),c(de)!=="svelte-50j04k"&&(de.textContent=ht),qe=a($),g(C.$$.fragment,$),$.forEach(n),Fe=a(m),P=l(m,"DIV",{class:!0});var Ee=J(P);g(O.$$.fragment,Ee),Ne=a(Ee),pe=l(Ee,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1s3c06i"&&(pe.innerHTML=_t),Ee.forEach(n),Se=a(m),I=l(m,"DIV",{class:!0});var Be=J(I);g(K.$$.fragment,Be),Ye=a(Be),ce=l(Be,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-pkn4ui"&&(ce.innerHTML=yt),Be.forEach(n),Oe=a(m),Z=l(m,"DIV",{class:!0});var Ge=J(Z);g(ee.$$.fragment,Ge),Ke=a(Ge),ue=l(Ge,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-14bnrb6"&&(ue.textContent=bt),Ge.forEach(n),et=a(m),W=l(m,"DIV",{class:!0});var ze=J(W);g(te.$$.fragment,ze),tt=a(ze),me=l(ze,"P",{"data-svelte-h":!0}),c(me)!=="svelte-1xwrf7t"&&(me.textContent=vt),ze.forEach(n),m.forEach(n),Ie=a(e),g(ne.$$.fragment,e),Ze=a(e),H=l(e,"DIV",{class:!0});var Ae=J(H);g(oe.$$.fragment,Ae),nt=a(Ae),fe=l(Ae,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-i6xdzu"&&(fe.textContent=wt),Ae.forEach(n),We=a(e),g(ie.$$.fragment,e),Ue=a(e),ge=l(e,"P",{}),J(ge).forEach(n),this.h()},h(){k(d,"name","hf:doc:metadata"),k(d,"content",Wt),k(T,"class","flex flex-wrap space-x-1"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,d),o(e,V,t),o(e,v,t),o(e,w,t),h(M,e,t),o(e,u,t),o(e,T,t),o(e,_e,t),o(e,U,t),o(e,ye,t),o(e,L,t),o(e,be,t),h(j,e,t),o(e,ve,t),o(e,E,t),o(e,we,t),o(e,B,t),o(e,Me,t),h(G,e,t),o(e,Te,t),o(e,z,t),o(e,Ve,t),o(e,A,t),o(e,xe,t),o(e,X,t),o(e,ke,t),o(e,D,t),o(e,He,t),h(Q,e,t),o(e,$e,t),o(e,R,t),o(e,Je,t),o(e,q,t),o(e,je,t),h(F,e,t),o(e,Ce,t),h(N,e,t),o(e,Pe,t),o(e,p,t),h(S,p,null),r(p,Xe),r(p,le),r(p,De),r(p,re),r(p,Qe),r(p,x),h(Y,x,null),r(x,Re),r(x,de),r(x,qe),h(C,x,null),r(p,Fe),r(p,P),h(O,P,null),r(P,Ne),r(P,pe),r(p,Se),r(p,I),h(K,I,null),r(I,Ye),r(I,ce),r(p,Oe),r(p,Z),h(ee,Z,null),r(Z,Ke),r(Z,ue),r(p,et),r(p,W),h(te,W,null),r(W,tt),r(W,me),o(e,Ie,t),h(ne,e,t),o(e,Ze,t),o(e,H,t),h(oe,H,null),r(H,nt),r(H,fe),o(e,We,t),h(ie,e,t),o(e,Ue,t),o(e,ge,t),Le=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),j.$set(m);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),C.$set($)},i(e){Le||(_(M.$$.fragment,e),_(j.$$.fragment,e),_(G.$$.fragment,e),_(Q.$$.fragment,e),_(F.$$.fragment,e),_(N.$$.fragment,e),_(S.$$.fragment,e),_(Y.$$.fragment,e),_(C.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(ie.$$.fragment,e),Le=!0)},o(e){y(M.$$.fragment,e),y(j.$$.fragment,e),y(G.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(C.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),Le=!1},d(e){e&&(n(V),n(v),n(w),n(u),n(T),n(_e),n(U),n(ye),n(L),n(be),n(ve),n(E),n(we),n(B),n(Me),n(Te),n(z),n(Ve),n(A),n(xe),n(X),n(ke),n(D),n(He),n($e),n(R),n(Je),n(q),n(je),n(Ce),n(Pe),n(p),n(Ie),n(Ze),n(H),n(We),n(Ue),n(ge)),n(d),b(M,e),b(j,e),b(G,e),b(Q,e),b(F,e),b(N,e),b(S),b(Y),b(C),b(O),b(K),b(ee),b(te),b(ne,e),b(oe),b(ie,e)}}}const Wt='{"title":"HunyuanVideo","local":"hunyuanvideo","sections":[{"title":"Available models","local":"available-models","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"HunyuanVideoPipeline","local":"diffusers.HunyuanVideoPipeline","sections":[],"depth":2},{"title":"HunyuanVideoPipelineOutput","local":"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ut(se){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends kt{constructor(d){super(),Ht(this,d,Ut,Zt,Vt,{})}}export{Dt as component};
