import{s as Hr,o as Ar,n as V}from"../chunks/scheduler.8c3d61f6.js";import{S as Sr,i as qr,g as i,s as o,r as c,A as Dr,h as p,f as n,c as s,j as J,u as m,x as b,k as T,y as a,a as r,v as g,d as u,t as f,w as h,m as Or,n as Kr}from"../chunks/index.da70eac4.js";import{T as Fl}from"../chunks/Tip.1d9b8c37.js";import{D as I}from"../chunks/Docstring.6b390b9a.js";import{C as k}from"../chunks/CodeBlock.00a903b3.js";import{E as le}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Z,E as ei}from"../chunks/EditOnGithub.1e64e623.js";function ti(j){let d,x='Flux can be quite expensive to run on consumer hardware devices. However, you can perform a suite of optimizations to run it faster and in a more memory-friendly manner. Check out <a href="https://huggingface.co/blog/sd3#memory-optimizations-for-sd3" rel="nofollow">this section</a> for more details. Additionally, Flux can benefit from quantization for memory efficiency with a trade-off in inference latency. Refer to <a href="https://huggingface.co/blog/quanto-diffusers" rel="nofollow">this blog post</a> to learn more.  For an exhaustive list of resources, check out <a href="https://gist.github.com/sayakpaul/b664605caf0aa3bf8585ab109dd5ac9c" rel="nofollow">this gist</a>.';return{c(){d=i("p"),d.innerHTML=x},l(y){d=p(y,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1nl2vrj"&&(d.innerHTML=x)},m(y,_){r(y,d,_)},p:V,d(y){y&&n(d)}}}function ni(j){let d,x='Check out <a href="../../../using-diffusers/ip_adapter">IP-Adapter</a> to learn more about how IP-Adapters work.';return{c(){d=i("p"),d.innerHTML=x},l(y){d=p(y,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1xq17cf"&&(d.innerHTML=x)},m(y,_){r(y,d,_)},p:V,d(y){y&&n(d)}}}function oi(j){let d;return{c(){d=Or("`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},l(x){d=Kr(x,"`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},m(x,y){r(x,d,y)},d(x){x&&n(d)}}}function si(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function ai(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXBpcGUlMjAlM0QlMjBGbHV4SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2UpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwc3RyZW5ndGglM0QwLjk1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=init_image, num_inference_steps=<span class="hljs-number">4</span>, strength=<span class="hljs-number">0.95</span>, guidance_scale=<span class="hljs-number">0.0</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function li(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eElucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFzb3VyY2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEc291cmNlJTJDJTIwbWFza19pbWFnZSUzRG1hc2spLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZsdXhfaW5wYWludGluZy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=source, mask_image=mask).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function ri(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> FluxControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = FluxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-controlnet-canny&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/InstantX/FLUX.1-dev-Controlnet-Canny-alpha/resolve/main/canny.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A girl holding a sign that says InstantX&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    control_guidance_start=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    control_guidance_end=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">28</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.5</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_controlnet_inpaint.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function ii(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetImg2ImgPipeline, FluxControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = FluxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-Controlnet-Canny-alpha&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.controlnet.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/InstantX/SD3-Controlnet-Canny/resolve/main/canny.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A girl in city, 25 years old, cool, futuristic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    control_guidance_start=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    control_guidance_end=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.5</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_controlnet_img2img.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function pi(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1DYW5ueS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDYW5ueURldGVjdG9yKCklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlMkMlMjBsb3dfdGhyZXNob2xkJTNENTAlMkMlMjBoaWdoX3RocmVzaG9sZCUzRDIwMCUyQyUyMGRldGVjdF9yZXNvbHV0aW9uJTNEMTAyNCUyQyUyMGltYWdlX3Jlc29sdXRpb24lM0QxMDI0JTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = CannyDetector()
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = processor(
<span class="hljs-meta">... </span>    control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function di(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwRmx1eENvbnRyb2xJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUNhbm55LWRldiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMEFic3RyYWN0JTIwYmFja2dyb3VuZCUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZ3YXRlcmNvbG9yLXBhaW50aW5nLmpwZyUyMiUwQSklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZyb2JvdC5wbmclMjIlMEEpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ2FubnlEZXRlY3RvcigpJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUzRDUwJTJDJTIwaGlnaF90aHJlc2hvbGQlM0QyMDAlMkMlMjBkZXRlY3RfcmVzb2x1dGlvbiUzRDEwMjQlMkMlMjBpbWFnZV9yZXNvbHV0aW9uJTNEMTAyNCUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzMC4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. Abstract background&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/watercolor-painting.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = CannyDetector()
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = processor(
<span class="hljs-meta">... </span>    control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function ci(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFByaW9yUmVkdXhQaXBlbGluZSUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEFyZXBvX3JlZHV4JTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtUmVkdXgtZGV2JTIyJTBBcmVwb19iYXNlJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcGlwZV9wcmlvcl9yZWR1eCUyMCUzRCUyMEZsdXhQcmlvclJlZHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9fcmVkdXglMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKS50byhkZXZpY2UpJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcmVwb19iYXNlJTJDJTIwdGV4dF9lbmNvZGVyJTNETm9uZSUyQyUyMHRleHRfZW5jb2Rlcl8yJTNETm9uZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKGRldmljZSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0eWxlX3ppZ2d5JTJGaW1nNS5wbmclMjIlMEEpJTBBcGlwZV9wcmlvcl9vdXRwdXQlMjAlM0QlMjBwaXBlX3ByaW9yX3JlZHV4KGltYWdlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyLjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9wcmlvcl9vdXRwdXQlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJmbHV4LXJlZHV4LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPriorReduxPipeline, FluxPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dtype = torch.bfloat16

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_redux = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Redux-dev&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_base = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior_redux = FluxPriorReduxPipeline.from_pretrained(repo_redux, torch_dtype=dtype).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(
<span class="hljs-meta">... </span>    repo_base, text_encoder=<span class="hljs-literal">None</span>, text_encoder_2=<span class="hljs-literal">None</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy/img5.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior_output = pipe_prior_redux(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">2.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>    **pipe_prior_output,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;flux-redux.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function mi(j){let d,x="Examples:",y,_,M;return _=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEZpbGxQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXAucG5nJTIyKSUwQW1hc2slMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXBfbWFzay5wbmclMjIpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhGaWxsUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUZpbGwtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTIwJTIwJTIzJTIwc2F2ZSUyMHNvbWUlMjBWUkFNJTIwYnklMjBvZmZsb2FkaW5nJTIwdGhlJTIwbW9kZWwlMjB0byUyMENQVSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwd2hpdGUlMjBwYXBlciUyMGN1cCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDE2MzIlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyMzIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvciglMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmbHV4X2ZpbGwucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxFillPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup_mask.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxFillPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Fill-dev&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()  <span class="hljs-comment"># save some VRAM by offloading the model to CPU</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;a white paper cup&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    mask_image=mask,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1632</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1232</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    max_sequence_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_fill.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(l){d=p(l,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(l),m(_.$$.fragment,l)},m(l,w){r(l,d,w),r(l,y,w),g(_,l,w),M=!0},p:V,i(l){M||(u(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(n(d),n(y)),h(_,l)}}}function gi(j){let d,x,y,_,M,l,w,kl='Flux is a series of text-to-image generation models based on diffusion transformers. To know more about Flux, check out the original <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">blog post</a> by the creators of Flux, Black Forest Labs.',Zo,Ce,Zl='Original model checkpoints for Flux can be found <a href="https://huggingface.co/black-forest-labs" rel="nofollow">here</a>. Original inference code can be found <a href="https://github.com/black-forest-labs/flux" rel="nofollow">here</a>.',Co,re,Wo,We,Cl="Flux comes in the following variants:",Go,Ge,Wl='<thead><tr><th align="center">model type</th> <th align="center">model id</th></tr></thead> <tbody><tr><td align="center">Timestep-distilled</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-schnell" rel="nofollow"><code>black-forest-labs/FLUX.1-schnell</code></a></td></tr> <tr><td align="center">Guidance-distilled</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-dev</code></a></td></tr> <tr><td align="center">Fill Inpainting/Outpainting (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Fill-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Fill-dev</code></a></td></tr> <tr><td align="center">Canny Control (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Canny-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Canny-dev</code></a></td></tr> <tr><td align="center">Depth Control (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Depth-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Depth-dev</code></a></td></tr> <tr><td align="center">Canny Control (LoRA)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Canny-dev-lora" rel="nofollow"><code>black-forest-labs/FLUX.1-Canny-dev-lora</code></a></td></tr> <tr><td align="center">Depth Control (LoRA)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Depth-dev-lora" rel="nofollow"><code>black-forest-labs/FLUX.1-Depth-dev-lora</code></a></td></tr> <tr><td align="center">Redux (Adapter)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Redux-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Redux-dev</code></a></td></tr></tbody>',Bo,Be,Gl="All checkpoints have different usage which we detail below.",Po,Pe,No,Ne,Bl="<li><code>max_sequence_length</code> cannot be more than 256.</li> <li><code>guidance_scale</code> needs to be 0.</li> <li>As this is a timestep-distilled model, it benefits from fewer sampling steps.</li>",$o,$e,Lo,Le,Ro,Re,Pl="<li>The guidance-distilled variant takes about 50 sampling steps for good-quality generation.</li> <li>It doesn’t have any limitations around the <code>max_sequence_length</code>.</li>",Xo,Xe,Eo,Ee,Vo,Ve,Nl="<li>Flux Fill pipeline does not require <code>strength</code> as an input like regular inpainting pipelines.</li> <li>It supports both inpainting and outpainting.</li>",Yo,Ye,zo,ze,Qo,Qe,$l='<strong>Note:</strong> <code>black-forest-labs/Flux.1-Canny-dev</code> is <em>not</em> a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> model. ControlNet models are a separate component from the UNet/Transformer whose residuals are added to the actual underlying model. Canny Control is an alternate architecture that achieves effectively the same results as a ControlNet model would, by using channel-wise concatenation with input control condition and ensuring the transformer learns structure control by following the condition as closely as possible.',Ho,He,Ao,Ae,Ll="Canny Control is also possible with a LoRA variant of this condition. The usage is as follows:",So,Se,qo,qe,Do,De,Rl='<strong>Note:</strong> <code>black-forest-labs/Flux.1-Depth-dev</code> is <em>not</em> a ControlNet model. <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> models are a separate component from the UNet/Transformer whose residuals are added to the actual underlying model. Depth Control is an alternate architecture that achieves effectively the same results as a ControlNet model would, by using channel-wise concatenation with input control condition and ensuring the transformer learns structure control by following the condition as closely as possible.',Oo,Oe,Ko,Ke,Xl="Depth Control is also possible with a LoRA variant of this condition. The usage is as follows:",es,et,ts,tt,ns,nt,El="<li>Flux Redux pipeline is an adapter for FLUX.1 base models. It can be used with both flux-dev and flux-schnell, for image-to-image generation.</li> <li>You can first use the <code>FluxPriorReduxPipeline</code> to get the <code>prompt_embeds</code> and <code>pooled_prompt_embeds</code>, and then feed them into the <code>FluxPipeline</code> for image-to-image generation.</li> <li>When use <code>FluxPriorReduxPipeline</code> with a base pipeline, you can set <code>text_encoder=None</code> and <code>text_encoder_2=None</code> in the base pipeline, in order to save VRAM.</li>",os,ot,ss,st,as,at,Vl='We can combine Flux Turbo LoRAs with Flux Control and other pipelines like Fill and Redux to enable few-steps’ inference. The example below shows how to do that for Flux Control LoRA for depth and turbo LoRA from <a href="https://hf.co/ByteDance/Hyper-SD" rel="nofollow"><code>ByteDance/Hyper-SD</code></a>.',ls,lt,rs,rt,is,it,Yl='When unloading the Control LoRA weights, call <code>pipe.unload_lora_weights(reset_to_overwritten_params=True)</code> to reset the <code>pipe.transformer</code> completely back to its original form. The resultant pipeline can then be used with methods like <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a>. More details about this argument are available in <a href="https://github.com/huggingface/diffusers/pull/10397" rel="nofollow">this PR</a>.',ps,pt,ds,ie,cs,dt,zl="An IP-Adapter lets you prompt Flux with images, in addition to the text prompt. This is especially useful when describing complex concepts that are difficult to articulate through text alone and you have reference images.",ms,ct,gs,pe,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flux_ip_adapter_output.jpg"/> <figcaption class="mt-2 text-sm text-center text-gray-500">IP-Adapter examples with prompt &quot;wearing sunglasses&quot;</figcaption>',us,mt,fs,gt,Hl='Flux can generate high-quality images with FP16 (i.e. to accelerate inference on Turing/Volta GPUs) but produces different outputs compared to FP32/BF16. The issue is that some activations in the text encoders have to be clipped when running in FP16, which affects the overall image. Forcing text encoders to run with FP32 inference thus removes this output difference. See <a href="https://github.com/huggingface/diffusers/pull/9097#issuecomment-2272292516" rel="nofollow">here</a> for details.',hs,ut,Al="FP16 inference code:",_s,ft,bs,ht,ys,_t,Sl="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Ms,bt,ql='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> for inference with bitsandbytes.',xs,yt,ws,Mt,Ts,xt,Dl="The <code>FluxTransformer2DModel</code> supports loading checkpoints in the original format shipped by Black Forest Labs. This is also useful when trying to load finetunes or quantized versions of the models that have been published by the community.",Js,de,Is,wt,Ol="The following example demonstrates how to run Flux with less than 16GB of VRAM.",js,Tt,Kl="First install <code>optimum-quanto</code>",vs,Jt,Us,It,er="Then run the following example",Fs,jt,ks,vt,Zs,v,Ut,aa,vn,tr="The Flux pipeline for text-to-image generation.",la,Un,nr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',ra,Y,Ft,ia,Fn,or="Function invoked when calling the pipeline for generation.",pa,ce,da,me,kt,ca,kn,sr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ma,ge,Zt,ga,Zn,ar=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ua,ue,Ct,fa,Cn,lr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ha,fe,Wt,_a,Wn,rr=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ba,Gn,Gt,Cs,Bt,Ws,B,Pt,ya,Bn,ir="The Flux pipeline for image inpainting.",Ma,Pn,pr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',xa,z,Nt,wa,Nn,dr="Function invoked when calling the pipeline for generation.",Ta,he,Ja,$n,$t,Gs,Lt,Bs,P,Rt,Ia,Ln,cr="The Flux pipeline for image inpainting.",ja,Rn,mr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',va,Q,Xt,Ua,Xn,gr="Function invoked when calling the pipeline for generation.",Fa,_e,ka,En,Et,Ps,Vt,Ns,N,Yt,Za,Vn,ur="The Flux controlnet pipeline for inpainting.",Ca,Yn,fr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Wa,H,zt,Ga,zn,hr="Function invoked when calling the pipeline for generation.",Ba,be,Pa,Qn,Qt,$s,Ht,Ls,$,At,Na,Hn,_r="The Flux controlnet pipeline for image-to-image generation.",$a,An,br='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',La,A,St,Ra,Sn,yr="Function invoked when calling the pipeline for generation.",Xa,ye,Ea,qn,qt,Rs,Dt,Xs,U,Ot,Va,Dn,Mr="The Flux pipeline for controllable text-to-image generation.",Ya,On,xr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',za,S,Kt,Qa,Kn,wr="Function invoked when calling the pipeline for generation.",Ha,Me,Aa,xe,en,Sa,eo,Tr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,qa,we,tn,Da,to,Jr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Oa,Te,nn,Ka,no,Ir=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,el,Je,on,tl,oo,jr=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,nl,so,sn,Es,an,Vs,L,ln,ol,ao,vr="The Flux pipeline for image inpainting.",sl,lo,Ur='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',al,q,rn,ll,ro,Fr="Function invoked when calling the pipeline for generation.",rl,Ie,il,io,pn,Ys,dn,zs,R,cn,pl,po,kr="The Flux Redux pipeline for image-to-image generation.",dl,co,Zr='Reference: <a href="https://blackforestlabs.ai/flux-1-tools/" rel="nofollow">https://blackforestlabs.ai/flux-1-tools/</a>',cl,D,mn,ml,mo,Cr="Function invoked when calling the pipeline for generation.",gl,je,ul,go,gn,Qs,un,Hs,F,fn,fl,uo,Wr="The Flux Fill pipeline for image inpainting/outpainting.",hl,fo,Gr='Reference: <a href="https://blackforestlabs.ai/flux-1-tools/" rel="nofollow">https://blackforestlabs.ai/flux-1-tools/</a>',_l,O,hn,bl,ho,Br="Function invoked when calling the pipeline for generation.",yl,ve,Ml,Ue,_n,xl,_o,Pr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,wl,Fe,bn,Tl,bo,Nr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Jl,ke,yn,Il,yo,$r=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,jl,Ze,Mn,vl,Mo,Lr=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ul,xo,xn,As,wn,Ss,Uo,qs;return M=new Z({props:{title:"Flux",local:"flux",headingTag:"h1"}}),re=new Fl({props:{$$slots:{default:[ti]},$$scope:{ctx:j}}}),Pe=new Z({props:{title:"Timestep-distilled",local:"timestep-distilled",headingTag:"h3"}}),$e=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFvdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMC4lMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXF1ZW5jZV9sZW5ndGglM0QyNTYlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),Le=new Z({props:{title:"Guidance-distilled",local:"guidance-distilled",headingTag:"h3"}}),Xe=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHRpbnklMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyMG9uJTIwdGhlJTIwbW9vbiUyMiUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),Ee=new Z({props:{title:"Fill Inpainting/Outpainting",local:"fill-inpaintingoutpainting",headingTag:"h3"}}),Ye=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEZpbGxQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXAucG5nJTIyKSUwQW1hc2slMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXBfbWFzay5wbmclMjIpJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUZpbGwtZGV2JTIyJTBBcGlwZSUyMCUzRCUyMEZsdXhGaWxsUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwd2hpdGUlMjBwYXBlciUyMGN1cCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDE2MzIlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyMzIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKGYlMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxFillPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup.png&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup_mask.png&quot;</span>)

repo_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Fill-dev&quot;</span>
pipe = FluxFillPipeline.from_pretrained(repo_id, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a white paper cup&quot;</span>,
    image=image,
    mask_image=mask,
    height=<span class="hljs-number">1632</span>,
    width=<span class="hljs-number">1232</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">f&quot;output.png&quot;</span>)`,wrap:!1}}),ze=new Z({props:{title:"Canny Control",local:"canny-control",headingTag:"h3"}}),He=new k({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjAtVSUyMGNvbnRyb2xuZXQtYXV4JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1DYW5ueS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDYW5ueURldGVjdG9yKCklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKGNvbnRyb2xfaW1hZ2UlMkMlMjBsb3dfdGhyZXNob2xkJTNENTAlMkMlMjBoaWdoX3RocmVzaG9sZCUzRDIwMCUyQyUyMGRldGVjdF9yZXNvbHV0aW9uJTNEMTAyNCUyQyUyMGltYWdlX3Jlc29sdXRpb24lM0QxMDI0KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># !pip install -U controlnet-aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = CannyDetector()
control_image = processor(control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">30.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Se=new k({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjAtVSUyMGNvbnRyb2xuZXQtYXV4JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtQ2FubnktZGV2LWxvcmElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGZpbGxlZCUyMHdpdGglMjBjb25mZXR0aSUyMGFuZCUyMGNlbGVicmF0b3J5JTIwZ2lmdHMuJTIyJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcm9ib3QucG5nJTIyKSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMENhbm55RGV0ZWN0b3IoKSUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBwcm9jZXNzb3IoY29udHJvbF9pbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlM0Q1MCUyQyUyMGhpZ2hfdGhyZXNob2xkJTNEMjAwJTJDJTIwZGV0ZWN0X3Jlc29sdXRpb24lM0QxMDI0JTJDJTIwaW1hZ2VfcmVzb2x1dGlvbiUzRDEwMjQpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMzAuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-comment"># !pip install -U controlnet-aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev-lora&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = CannyDetector()
control_image = processor(control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">30.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),qe=new Z({props:{title:"Depth Control",local:"depth-control",headingTag:"h3"}}),Oe=new k({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmltYWdlX2dlbl9hdXglMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMGltYWdlX2dlbl9hdXglMjBpbXBvcnQlMjBEZXB0aFByZXByb2Nlc3NvciUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1EZXB0aC1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBEZXB0aFByZXByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctbGFyZ2UtaGYlMjIpJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMHByb2Nlc3Nvcihjb250cm9sX2ltYWdlKSU1QjAlNUQuY29udmVydCglMjJSR0IlMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMTAuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcigpLm1hbnVhbF9zZWVkKDQyKSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-comment"># !pip install git+https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline, FluxTransformer2DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),et=new k({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmltYWdlX2dlbl9hdXglMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMGltYWdlX2dlbl9hdXglMjBpbXBvcnQlMjBEZXB0aFByZXByb2Nlc3NvciUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtRGVwdGgtZGV2LWxvcmElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGZpbGxlZCUyMHdpdGglMjBjb25mZXR0aSUyMGFuZCUyMGNlbGVicmF0b3J5JTIwZ2lmdHMuJTIyJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcm9ib3QucG5nJTIyKSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMERlcHRoUHJlcHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1sYXJnZS1oZiUyMiklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKGNvbnRyb2xfaW1hZ2UpJTVCMCU1RC5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC4wJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCkubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># !pip install git+https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline, FluxTransformer2DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev-lora&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),tt=new Z({props:{title:"Redux",local:"redux",headingTag:"h3"}}),ot=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFByaW9yUmVkdXhQaXBlbGluZSUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEElMEFyZXBvX3JlZHV4JTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtUmVkdXgtZGV2JTIyJTBBcmVwb19iYXNlJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTIwJTBBcGlwZV9wcmlvcl9yZWR1eCUyMCUzRCUyMEZsdXhQcmlvclJlZHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9fcmVkdXglMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKS50byhkZXZpY2UpJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcmVwb19iYXNlJTJDJTIwJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKGRldmljZSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0eWxlX3ppZ2d5JTJGaW1nNS5wbmclMjIpJTBBcGlwZV9wcmlvcl9vdXRwdXQlMjAlM0QlMjBwaXBlX3ByaW9yX3JlZHV4KGltYWdlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyLjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9wcmlvcl9vdXRwdXQlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJmbHV4LXJlZHV4LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPriorReduxPipeline, FluxPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
device = <span class="hljs-string">&quot;cuda&quot;</span>
dtype = torch.bfloat16


repo_redux = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Redux-dev&quot;</span>
repo_base = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span> 
pipe_prior_redux = FluxPriorReduxPipeline.from_pretrained(repo_redux, torch_dtype=dtype).to(device)
pipe = FluxPipeline.from_pretrained(
    repo_base, 
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    torch_dtype=torch.bfloat16
).to(device)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy/img5.png&quot;</span>)
pipe_prior_output = pipe_prior_redux(image)
images = pipe(
    guidance_scale=<span class="hljs-number">2.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
    **pipe_prior_output,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;flux-redux.png&quot;</span>)`,wrap:!1}}),st=new Z({props:{title:"Combining Flux Turbo LoRAs with Flux Control, Fill, and Redux",local:"combining-flux-turbo-loras-with-flux-control-fill-and-redux",headingTag:"h2"}}),lt=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch

control_pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)
control_pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;depth&quot;</span>)
control_pipe.load_lora_weights(
    hf_hub_download(<span class="hljs-string">&quot;ByteDance/Hyper-SD&quot;</span>, <span class="hljs-string">&quot;Hyper-FLUX.1-dev-8steps-lora.safetensors&quot;</span>), adapter_name=<span class="hljs-string">&quot;hyper-sd&quot;</span>
)
control_pipe.set_adapters([<span class="hljs-string">&quot;depth&quot;</span>, <span class="hljs-string">&quot;hyper-sd&quot;</span>], adapter_weights=[<span class="hljs-number">0.85</span>, <span class="hljs-number">0.125</span>])
control_pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = control_pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),rt=new Z({props:{title:"Note about unload_lora_weights() when using Flux LoRAs",local:"note-about-unloadloraweights-when-using-flux-loras",headingTag:"h2"}}),pt=new Z({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h2"}}),ie=new Fl({props:{$$slots:{default:[ni]},$$scope:{ctx:j}}}),ct=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZmbHV4X2lwX2FkYXB0ZXJfaW5wdXQuanBnJTIyKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEElMEFwaXBlLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjAlMjAlMjJYTGFicy1BSSUyRmZsdXgtaXAtYWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXBfYWRhcHRlci5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXJfcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjJvcGVuYWklMkZjbGlwLXZpdC1sYXJnZS1wYXRjaDE0JTIyJTBBKSUwQXBpcGUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMS4wKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyd2VhcmluZyUyMHN1bmdsYXNzZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVlX2NmZyUzRDQuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcigpLm1hbnVhbF9zZWVkKDQ0NDQpJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSgnZmx1eF9pcF9hZGFwdGVyX291dHB1dC5qcGcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flux_ip_adapter_input.jpg&quot;</span>).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

pipe.load_ip_adapter(
    <span class="hljs-string">&quot;XLabs-AI/flux-ip-adapter&quot;</span>,
    weight_name=<span class="hljs-string">&quot;ip_adapter.safetensors&quot;</span>,
    image_encoder_pretrained_model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
)
pipe.set_ip_adapter_scale(<span class="hljs-number">1.0</span>)

image = pipe(
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    prompt=<span class="hljs-string">&quot;wearing sunglasses&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    true_cfg=<span class="hljs-number">4.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">4444</span>),
    ip_adapter_image=image,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&#x27;flux_ip_adapter_output.jpg&#x27;</span>)`,wrap:!1}}),mt=new Z({props:{title:"Running FP16 inference",local:"running-fp16-inference",headingTag:"h2"}}),ft=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTIwJTIzJTIwY2FuJTIwcmVwbGFjZSUyMHNjaG5lbGwlMjB3aXRoJTIwZGV2JTBBJTIzJTIwdG8lMjBydW4lMjBvbiUyMGxvdyUyMHZyYW0lMjBHUFVzJTIwKGkuZS4lMjBiZXR3ZWVuJTIwNCUyMGFuZCUyMDMyJTIwR0IlMjBWUkFNKSUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQXBpcGUudmFlLmVuYWJsZV9zbGljaW5nKCklMEFwaXBlLnZhZS5lbmFibGVfdGlsaW5nKCklMEElMEFwaXBlLnRvKHRvcmNoLmZsb2F0MTYpJTIwJTIzJTIwY2FzdGluZyUyMGhlcmUlMjBpbnN0ZWFkJTIwb2YlMjBpbiUyMHRoZSUyMHBpcGVsaW5lJTIwY29uc3RydWN0b3IlMjBiZWNhdXNlJTIwZG9pbmclMjBzbyUyMGluJTIwdGhlJTIwY29uc3RydWN0b3IlMjBsb2FkcyUyMGFsbCUyMG1vZGVscyUyMGludG8lMjBDUFUlMjBtZW1vcnklMjBhdCUyMG9uY2UlMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBb3V0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBb3V0LnNhdmUoJTIyaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16) <span class="hljs-comment"># can replace schnell with dev</span>
<span class="hljs-comment"># to run on low vram GPUs (i.e. between 4 and 32 GB VRAM)</span>
pipe.enable_sequential_cpu_offload()
pipe.vae.enable_slicing()
pipe.vae.enable_tiling()

pipe.to(torch.float16) <span class="hljs-comment"># casting here instead of in the pipeline constructor because doing so in the constructor loads all models into CPU memory at once</span>

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),ht=new Z({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),yt=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwRmx1eFBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0ZXh0X2VuY29kZXJfOGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwdGlueSUyMGFzdHJvbmF1dCUyMGhhdGNoaW5nJTIwZnJvbSUyMGFuJTIwZWdnJTIwb24lMjB0aGUlMjBtb29uJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUyMGhlaWdodCUzRDc2OCUyQyUyMHdpZHRoJTNEMTM2MCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, FluxTransformer2DModel, FluxPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder_2=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt, guidance_scale=<span class="hljs-number">3.5</span>, height=<span class="hljs-number">768</span>, width=<span class="hljs-number">1360</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),Mt=new Z({props:{title:"Single File Loading for the FluxTransformer2DModel",local:"single-file-loading-for-the-fluxtransformer2dmodel",headingTag:"h2"}}),de=new Fl({props:{$$slots:{default:[oi]},$$scope:{ctx:j}}}),Jt=new k({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tcXVhbnRv",highlighted:"pip install optimum-quanto",wrap:!1}}),jt=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUyQyUyMENMSVBUZXh0TW9kZWwlMEFmcm9tJTIwb3B0aW11bS5xdWFudG8lMjBpbXBvcnQlMjBmcmVlemUlMkMlMjBxZmxvYXQ4JTJDJTIwcXVhbnRpemUlMEElMEFiZmxfcmVwbyUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGS2lqYWklMkZmbHV4LWZwOCUyRmJsb2IlMkZtYWluJTJGZmx1eDEtZGV2LWZwOC5zYWZldGVuc29ycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodHJhbnNmb3JtZXIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodHJhbnNmb3JtZXIpJTBBJTBBdGV4dF9lbmNvZGVyXzIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodGV4dF9lbmNvZGVyXzIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodGV4dF9lbmNvZGVyXzIpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjB0cmFuc2Zvcm1lciUzRE5vbmUlMkMlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjB0cmFuc2Zvcm1lciUwQXBpcGUudGV4dF9lbmNvZGVyXzIlMjAlM0QlMjB0ZXh0X2VuY29kZXJfMiUwQSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMy41JTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyZmx1eC1mcDgtZGV2LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, FluxPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, CLIPTextModel
<span class="hljs-keyword">from</span> optimum.quanto <span class="hljs-keyword">import</span> freeze, qfloat8, quantize

bfl_repo = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

transformer = FluxTransformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/Kijai/flux-fp8/blob/main/flux1-dev-fp8.safetensors&quot;</span>, torch_dtype=dtype)
quantize(transformer, weights=qfloat8)
freeze(transformer)

text_encoder_2 = T5EncoderModel.from_pretrained(bfl_repo, subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>, torch_dtype=dtype)
quantize(text_encoder_2, weights=qfloat8)
freeze(text_encoder_2)

pipe = FluxPipeline.from_pretrained(bfl_repo, transformer=<span class="hljs-literal">None</span>, text_encoder_2=<span class="hljs-literal">None</span>, torch_dtype=dtype)
pipe.transformer = transformer
pipe.text_encoder_2 = text_encoder_2

pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;flux-fp8-dev.png&quot;</span>)`,wrap:!1}}),vt=new Z({props:{title:"FluxPipeline",local:"diffusers.FluxPipeline",headingTag:"h2"}}),Ut=new I({props:{name:"class diffusers.FluxPipeline",anchor:"diffusers.FluxPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L146"}}),Ft=new I({props:{name:"__call__",anchor:"diffusers.FluxPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.FluxPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.FluxPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.FluxPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"diffusers.FluxPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L630",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),ce=new le({props:{anchor:"diffusers.FluxPipeline.__call__.example",$$slots:{default:[si]},$$scope:{ctx:j}}}),kt=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L553"}}),Zt=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L568"}}),Ct=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L546"}}),Wt=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L560"}}),Gt=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L310"}}),Bt=new Z({props:{title:"FluxImg2ImgPipeline",local:"diffusers.FluxImg2ImgPipeline",headingTag:"h2"}}),Pt=new I({props:{name:"class diffusers.FluxImg2ImgPipeline",anchor:"diffusers.FluxImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L162"}}),Nt=new I({props:{name:"__call__",anchor:"diffusers.FluxImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L583",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),he=new le({props:{anchor:"diffusers.FluxImg2ImgPipeline.__call__.example",$$slots:{default:[ai]},$$scope:{ctx:j}}}),$t=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L319"}}),Lt=new Z({props:{title:"FluxInpaintPipeline",local:"diffusers.FluxInpaintPipeline",headingTag:"h2"}}),Rt=new I({props:{name:"class diffusers.FluxInpaintPipeline",anchor:"diffusers.FluxInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L159"}}),Xt=new I({props:{name:"__call__",anchor:"diffusers.FluxInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.FluxInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.FluxInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxInpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new le({props:{anchor:"diffusers.FluxInpaintPipeline.__call__.example",$$slots:{default:[li]},$$scope:{ctx:j}}}),Et=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L324"}}),Vt=new Z({props:{title:"FluxControlNetInpaintPipeline",local:"diffusers.FluxControlNetInpaintPipeline",headingTag:"h2"}}),Yt=new I({props:{name:"class diffusers.FluxControlNetInpaintPipeline",anchor:"diffusers.FluxControlNetInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel, typing.List[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], diffusers.models.controlnets.controlnet_flux.FluxMultiControlNetModel]"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlNetInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlNetInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L174"}}),zt=new I({props:{name:"__call__",anchor:"diffusers.FluxControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_mode",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The image(s) to inpaint.`,name:"image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The mask image(s) to use for inpainting. White pixels in the mask will be repainted, while black pixels
will be preserved.`,name:"mask_image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.masked_image_latents",description:`<strong>masked_image_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated masked image latents.`,name:"masked_image_latents"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The ControlNet input condition. Image to control the generation.`,name:"control_image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.6) &#x2014;
Conceptually, indicates how much to inpaint the masked area. Must be between 0 and 1.`,name:"strength"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The size of the padding to use when cropping the mask.`,name:"padding_mask_crop"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_mode",description:`<strong>control_mode</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The mode for the ControlNet. If multiple ControlNets are used, this should be a list.`,name:"control_mode"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original transformer.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or more <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a> to
make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts.`,name:"latents"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to be passed to the joint attention mechanism.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising step during the inference.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L740",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),be=new le({props:{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.example",$$slots:{default:[ri]},$$scope:{ctx:j}}}),Qt=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L346"}}),Ht=new Z({props:{title:"FluxControlNetImg2ImgPipeline",local:"diffusers.FluxControlNetImg2ImgPipeline",headingTag:"h2"}}),At=new I({props:{name:"class diffusers.FluxControlNetImg2ImgPipeline",anchor:"diffusers.FluxControlNetImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel, typing.List[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], diffusers.models.controlnets.controlnet_flux.FluxMultiControlNetModel]"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L172"}}),St=new I({props:{name:"__call__",anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_mode",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The ControlNet input condition. Image to control the generation.`,name:"control_image"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.6) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1.`,name:"strength"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.control_mode",description:`<strong>control_mode</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The mode for the ControlNet. If multiple ControlNets are used, this should be a list.`,name:"control_mode"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original transformer.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or more <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a> to
make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts.`,name:"latents"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to be passed to the joint attention mechanism.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising step during the inference.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),ye=new le({props:{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[ii]},$$scope:{ctx:j}}}),qt=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L335"}}),Dt=new Z({props:{title:"FluxControlPipeline",local:"diffusers.FluxControlPipeline",headingTag:"h2"}}),Ot=new I({props:{name:"class diffusers.FluxControlPipeline",anchor:"diffusers.FluxControlPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L159"}}),Kt=new I({props:{name:"__call__",anchor:"diffusers.FluxControlPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxControlPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxControlPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.FluxControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L610",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Me=new le({props:{anchor:"diffusers.FluxControlPipeline.__call__.example",$$slots:{default:[pi]},$$scope:{ctx:j}}}),en=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxControlPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L501"}}),tn=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxControlPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L516"}}),nn=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxControlPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L494"}}),on=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxControlPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L508"}}),sn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L324"}}),an=new Z({props:{title:"FluxControlImg2ImgPipeline",local:"diffusers.FluxControlImg2ImgPipeline",headingTag:"h2"}}),ln=new I({props:{name:"class diffusers.FluxControlImg2ImgPipeline",anchor:"diffusers.FluxControlImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L178"}}),rn=new I({props:{name:"__call__",anchor:"diffusers.FluxControlImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Ie=new le({props:{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.example",$$slots:{default:[di]},$$scope:{ctx:j}}}),pn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L335"}}),dn=new Z({props:{title:"FluxPriorReduxPipeline",local:"diffusers.FluxPriorReduxPipeline",headingTag:"h2"}}),cn=new I({props:{name:"class diffusers.FluxPriorReduxPipeline",anchor:"diffusers.FluxPriorReduxPipeline",parameters:[{name:"image_encoder",val:": SiglipVisionModel"},{name:"feature_extractor",val:": SiglipImageProcessor"},{name:"image_embedder",val:": ReduxImageEncoder"},{name:"text_encoder",val:": CLIPTextModel = None"},{name:"tokenizer",val:": CLIPTokenizer = None"},{name:"text_encoder_2",val:": T5EncoderModel = None"},{name:"tokenizer_2",val:": T5TokenizerFast = None"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>SiglipVisionModel</code>) &#x2014;
SIGLIP vision model to encode the input image.`,name:"image_encoder"},{anchor:"diffusers.FluxPriorReduxPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>SiglipImageProcessor</code>) &#x2014;
Image processor for preprocessing images for the SIGLIP model.`,name:"feature_extractor"},{anchor:"diffusers.FluxPriorReduxPipeline.image_embedder",description:`<strong>image_embedder</strong> (<code>ReduxImageEncoder</code>) &#x2014;
Redux image encoder to process the SIGLIP embeddings.`,name:"image_embedder"},{anchor:"diffusers.FluxPriorReduxPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>, <em>optional</em>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxPriorReduxPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>, <em>optional</em>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxPriorReduxPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>, <em>optional</em>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxPriorReduxPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>, <em>optional</em>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L84"}}),mn=new I({props:{name:"__call__",anchor:"diffusers.FluxPriorReduxPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds_scale",val:": typing.Union[float, typing.List[float], NoneType] = 1.0"},{name:"pooled_prompt_embeds_scale",val:": typing.Union[float, typing.List[float], NoneType] = 1.0"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>`,name:"image"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. <strong>experimental feature</strong>: to use this feature,
make sure to explicitly load text encoders to the pipeline. Prompts will be ignored if text encoders
are not loaded.`,name:"prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> or <code>tuple</code></p>
`}}),je=new le({props:{anchor:"diffusers.FluxPriorReduxPipeline.__call__.example",$$slots:{default:[ci]},$$scope:{ctx:j}}}),gn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L292"}}),un=new Z({props:{title:"FluxFillPipeline",local:"diffusers.FluxFillPipeline",headingTag:"h2"}}),fn=new I({props:{name:"class diffusers.FluxFillPipeline",anchor:"diffusers.FluxFillPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxFillPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxFillPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxFillPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxFillPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxFillPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxFillPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L167"}}),hn=new I({props:{name:"__call__",anchor:"diffusers.FluxFillPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Optional[torch.FloatTensor] = None"},{name:"mask_image",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masked_image_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 30.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxFillPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxFillPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>.`,name:"image"},{anchor:"diffusers.FluxFillPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.FluxFillPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.FluxFillPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxFillPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxFillPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxFillPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxFillPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxFillPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxFillPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxFillPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxFillPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxFillPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxFillPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxFillPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxFillPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxFillPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L679",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),ve=new le({props:{anchor:"diffusers.FluxFillPipeline.__call__.example",$$slots:{default:[mi]},$$scope:{ctx:j}}}),_n=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxFillPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L605"}}),bn=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxFillPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L620"}}),yn=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxFillPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L598"}}),Mn=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxFillPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L612"}}),xn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxFillPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L417"}}),wn=new ei({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/flux.md"}}),{c(){d=i("meta"),x=o(),y=i("p"),_=o(),c(M.$$.fragment),l=o(),w=i("p"),w.innerHTML=kl,Zo=o(),Ce=i("p"),Ce.innerHTML=Zl,Co=o(),c(re.$$.fragment),Wo=o(),We=i("p"),We.textContent=Cl,Go=o(),Ge=i("table"),Ge.innerHTML=Wl,Bo=o(),Be=i("p"),Be.textContent=Gl,Po=o(),c(Pe.$$.fragment),No=o(),Ne=i("ul"),Ne.innerHTML=Bl,$o=o(),c($e.$$.fragment),Lo=o(),c(Le.$$.fragment),Ro=o(),Re=i("ul"),Re.innerHTML=Pl,Xo=o(),c(Xe.$$.fragment),Eo=o(),c(Ee.$$.fragment),Vo=o(),Ve=i("ul"),Ve.innerHTML=Nl,Yo=o(),c(Ye.$$.fragment),zo=o(),c(ze.$$.fragment),Qo=o(),Qe=i("p"),Qe.innerHTML=$l,Ho=o(),c(He.$$.fragment),Ao=o(),Ae=i("p"),Ae.textContent=Ll,So=o(),c(Se.$$.fragment),qo=o(),c(qe.$$.fragment),Do=o(),De=i("p"),De.innerHTML=Rl,Oo=o(),c(Oe.$$.fragment),Ko=o(),Ke=i("p"),Ke.textContent=Xl,es=o(),c(et.$$.fragment),ts=o(),c(tt.$$.fragment),ns=o(),nt=i("ul"),nt.innerHTML=El,os=o(),c(ot.$$.fragment),ss=o(),c(st.$$.fragment),as=o(),at=i("p"),at.innerHTML=Vl,ls=o(),c(lt.$$.fragment),rs=o(),c(rt.$$.fragment),is=o(),it=i("p"),it.innerHTML=Yl,ps=o(),c(pt.$$.fragment),ds=o(),c(ie.$$.fragment),cs=o(),dt=i("p"),dt.textContent=zl,ms=o(),c(ct.$$.fragment),gs=o(),pe=i("div"),pe.innerHTML=Ql,us=o(),c(mt.$$.fragment),fs=o(),gt=i("p"),gt.innerHTML=Hl,hs=o(),ut=i("p"),ut.textContent=Al,_s=o(),c(ft.$$.fragment),bs=o(),c(ht.$$.fragment),ys=o(),_t=i("p"),_t.textContent=Sl,Ms=o(),bt=i("p"),bt.innerHTML=ql,xs=o(),c(yt.$$.fragment),ws=o(),c(Mt.$$.fragment),Ts=o(),xt=i("p"),xt.innerHTML=Dl,Js=o(),c(de.$$.fragment),Is=o(),wt=i("p"),wt.textContent=Ol,js=o(),Tt=i("p"),Tt.innerHTML=Kl,vs=o(),c(Jt.$$.fragment),Us=o(),It=i("p"),It.textContent=er,Fs=o(),c(jt.$$.fragment),ks=o(),c(vt.$$.fragment),Zs=o(),v=i("div"),c(Ut.$$.fragment),aa=o(),vn=i("p"),vn.textContent=tr,la=o(),Un=i("p"),Un.innerHTML=nr,ra=o(),Y=i("div"),c(Ft.$$.fragment),ia=o(),Fn=i("p"),Fn.textContent=or,pa=o(),c(ce.$$.fragment),da=o(),me=i("div"),c(kt.$$.fragment),ca=o(),kn=i("p"),kn.innerHTML=sr,ma=o(),ge=i("div"),c(Zt.$$.fragment),ga=o(),Zn=i("p"),Zn.innerHTML=ar,ua=o(),ue=i("div"),c(Ct.$$.fragment),fa=o(),Cn=i("p"),Cn.textContent=lr,ha=o(),fe=i("div"),c(Wt.$$.fragment),_a=o(),Wn=i("p"),Wn.textContent=rr,ba=o(),Gn=i("div"),c(Gt.$$.fragment),Cs=o(),c(Bt.$$.fragment),Ws=o(),B=i("div"),c(Pt.$$.fragment),ya=o(),Bn=i("p"),Bn.textContent=ir,Ma=o(),Pn=i("p"),Pn.innerHTML=pr,xa=o(),z=i("div"),c(Nt.$$.fragment),wa=o(),Nn=i("p"),Nn.textContent=dr,Ta=o(),c(he.$$.fragment),Ja=o(),$n=i("div"),c($t.$$.fragment),Gs=o(),c(Lt.$$.fragment),Bs=o(),P=i("div"),c(Rt.$$.fragment),Ia=o(),Ln=i("p"),Ln.textContent=cr,ja=o(),Rn=i("p"),Rn.innerHTML=mr,va=o(),Q=i("div"),c(Xt.$$.fragment),Ua=o(),Xn=i("p"),Xn.textContent=gr,Fa=o(),c(_e.$$.fragment),ka=o(),En=i("div"),c(Et.$$.fragment),Ps=o(),c(Vt.$$.fragment),Ns=o(),N=i("div"),c(Yt.$$.fragment),Za=o(),Vn=i("p"),Vn.textContent=ur,Ca=o(),Yn=i("p"),Yn.innerHTML=fr,Wa=o(),H=i("div"),c(zt.$$.fragment),Ga=o(),zn=i("p"),zn.textContent=hr,Ba=o(),c(be.$$.fragment),Pa=o(),Qn=i("div"),c(Qt.$$.fragment),$s=o(),c(Ht.$$.fragment),Ls=o(),$=i("div"),c(At.$$.fragment),Na=o(),Hn=i("p"),Hn.textContent=_r,$a=o(),An=i("p"),An.innerHTML=br,La=o(),A=i("div"),c(St.$$.fragment),Ra=o(),Sn=i("p"),Sn.textContent=yr,Xa=o(),c(ye.$$.fragment),Ea=o(),qn=i("div"),c(qt.$$.fragment),Rs=o(),c(Dt.$$.fragment),Xs=o(),U=i("div"),c(Ot.$$.fragment),Va=o(),Dn=i("p"),Dn.textContent=Mr,Ya=o(),On=i("p"),On.innerHTML=xr,za=o(),S=i("div"),c(Kt.$$.fragment),Qa=o(),Kn=i("p"),Kn.textContent=wr,Ha=o(),c(Me.$$.fragment),Aa=o(),xe=i("div"),c(en.$$.fragment),Sa=o(),eo=i("p"),eo.innerHTML=Tr,qa=o(),we=i("div"),c(tn.$$.fragment),Da=o(),to=i("p"),to.innerHTML=Jr,Oa=o(),Te=i("div"),c(nn.$$.fragment),Ka=o(),no=i("p"),no.textContent=Ir,el=o(),Je=i("div"),c(on.$$.fragment),tl=o(),oo=i("p"),oo.textContent=jr,nl=o(),so=i("div"),c(sn.$$.fragment),Es=o(),c(an.$$.fragment),Vs=o(),L=i("div"),c(ln.$$.fragment),ol=o(),ao=i("p"),ao.textContent=vr,sl=o(),lo=i("p"),lo.innerHTML=Ur,al=o(),q=i("div"),c(rn.$$.fragment),ll=o(),ro=i("p"),ro.textContent=Fr,rl=o(),c(Ie.$$.fragment),il=o(),io=i("div"),c(pn.$$.fragment),Ys=o(),c(dn.$$.fragment),zs=o(),R=i("div"),c(cn.$$.fragment),pl=o(),po=i("p"),po.textContent=kr,dl=o(),co=i("p"),co.innerHTML=Zr,cl=o(),D=i("div"),c(mn.$$.fragment),ml=o(),mo=i("p"),mo.textContent=Cr,gl=o(),c(je.$$.fragment),ul=o(),go=i("div"),c(gn.$$.fragment),Qs=o(),c(un.$$.fragment),Hs=o(),F=i("div"),c(fn.$$.fragment),fl=o(),uo=i("p"),uo.textContent=Wr,hl=o(),fo=i("p"),fo.innerHTML=Gr,_l=o(),O=i("div"),c(hn.$$.fragment),bl=o(),ho=i("p"),ho.textContent=Br,yl=o(),c(ve.$$.fragment),Ml=o(),Ue=i("div"),c(_n.$$.fragment),xl=o(),_o=i("p"),_o.innerHTML=Pr,wl=o(),Fe=i("div"),c(bn.$$.fragment),Tl=o(),bo=i("p"),bo.innerHTML=Nr,Jl=o(),ke=i("div"),c(yn.$$.fragment),Il=o(),yo=i("p"),yo.textContent=$r,jl=o(),Ze=i("div"),c(Mn.$$.fragment),vl=o(),Mo=i("p"),Mo.textContent=Lr,Ul=o(),xo=i("div"),c(xn.$$.fragment),As=o(),c(wn.$$.fragment),Ss=o(),Uo=i("p"),this.h()},l(e){const t=Dr("svelte-u9bgzb",document.head);d=p(t,"META",{name:!0,content:!0}),t.forEach(n),x=s(e),y=p(e,"P",{}),J(y).forEach(n),_=s(e),m(M.$$.fragment,e),l=s(e),w=p(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-mlg237"&&(w.innerHTML=kl),Zo=s(e),Ce=p(e,"P",{"data-svelte-h":!0}),b(Ce)!=="svelte-pdc76o"&&(Ce.innerHTML=Zl),Co=s(e),m(re.$$.fragment,e),Wo=s(e),We=p(e,"P",{"data-svelte-h":!0}),b(We)!=="svelte-193hkal"&&(We.textContent=Cl),Go=s(e),Ge=p(e,"TABLE",{"data-svelte-h":!0}),b(Ge)!=="svelte-1od5eh6"&&(Ge.innerHTML=Wl),Bo=s(e),Be=p(e,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-1gsjsi1"&&(Be.textContent=Gl),Po=s(e),m(Pe.$$.fragment,e),No=s(e),Ne=p(e,"UL",{"data-svelte-h":!0}),b(Ne)!=="svelte-459kcz"&&(Ne.innerHTML=Bl),$o=s(e),m($e.$$.fragment,e),Lo=s(e),m(Le.$$.fragment,e),Ro=s(e),Re=p(e,"UL",{"data-svelte-h":!0}),b(Re)!=="svelte-k8komj"&&(Re.innerHTML=Pl),Xo=s(e),m(Xe.$$.fragment,e),Eo=s(e),m(Ee.$$.fragment,e),Vo=s(e),Ve=p(e,"UL",{"data-svelte-h":!0}),b(Ve)!=="svelte-gprzfd"&&(Ve.innerHTML=Nl),Yo=s(e),m(Ye.$$.fragment,e),zo=s(e),m(ze.$$.fragment,e),Qo=s(e),Qe=p(e,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-1yhkuyk"&&(Qe.innerHTML=$l),Ho=s(e),m(He.$$.fragment,e),Ao=s(e),Ae=p(e,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-vqyb98"&&(Ae.textContent=Ll),So=s(e),m(Se.$$.fragment,e),qo=s(e),m(qe.$$.fragment,e),Do=s(e),De=p(e,"P",{"data-svelte-h":!0}),b(De)!=="svelte-1rzvjcc"&&(De.innerHTML=Rl),Oo=s(e),m(Oe.$$.fragment,e),Ko=s(e),Ke=p(e,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-1833u4m"&&(Ke.textContent=Xl),es=s(e),m(et.$$.fragment,e),ts=s(e),m(tt.$$.fragment,e),ns=s(e),nt=p(e,"UL",{"data-svelte-h":!0}),b(nt)!=="svelte-44b2lm"&&(nt.innerHTML=El),os=s(e),m(ot.$$.fragment,e),ss=s(e),m(st.$$.fragment,e),as=s(e),at=p(e,"P",{"data-svelte-h":!0}),b(at)!=="svelte-d7sbsl"&&(at.innerHTML=Vl),ls=s(e),m(lt.$$.fragment,e),rs=s(e),m(rt.$$.fragment,e),is=s(e),it=p(e,"P",{"data-svelte-h":!0}),b(it)!=="svelte-107xhla"&&(it.innerHTML=Yl),ps=s(e),m(pt.$$.fragment,e),ds=s(e),m(ie.$$.fragment,e),cs=s(e),dt=p(e,"P",{"data-svelte-h":!0}),b(dt)!=="svelte-rmmcs6"&&(dt.textContent=zl),ms=s(e),m(ct.$$.fragment,e),gs=s(e),pe=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(pe)!=="svelte-1utwd2g"&&(pe.innerHTML=Ql),us=s(e),m(mt.$$.fragment,e),fs=s(e),gt=p(e,"P",{"data-svelte-h":!0}),b(gt)!=="svelte-17mig8z"&&(gt.innerHTML=Hl),hs=s(e),ut=p(e,"P",{"data-svelte-h":!0}),b(ut)!=="svelte-1gjlc3h"&&(ut.textContent=Al),_s=s(e),m(ft.$$.fragment,e),bs=s(e),m(ht.$$.fragment,e),ys=s(e),_t=p(e,"P",{"data-svelte-h":!0}),b(_t)!=="svelte-1ou2pxc"&&(_t.textContent=Sl),Ms=s(e),bt=p(e,"P",{"data-svelte-h":!0}),b(bt)!=="svelte-nyi6ih"&&(bt.innerHTML=ql),xs=s(e),m(yt.$$.fragment,e),ws=s(e),m(Mt.$$.fragment,e),Ts=s(e),xt=p(e,"P",{"data-svelte-h":!0}),b(xt)!=="svelte-hittsd"&&(xt.innerHTML=Dl),Js=s(e),m(de.$$.fragment,e),Is=s(e),wt=p(e,"P",{"data-svelte-h":!0}),b(wt)!=="svelte-1pyamwr"&&(wt.textContent=Ol),js=s(e),Tt=p(e,"P",{"data-svelte-h":!0}),b(Tt)!=="svelte-1ljbc3s"&&(Tt.innerHTML=Kl),vs=s(e),m(Jt.$$.fragment,e),Us=s(e),It=p(e,"P",{"data-svelte-h":!0}),b(It)!=="svelte-15rpvn4"&&(It.textContent=er),Fs=s(e),m(jt.$$.fragment,e),ks=s(e),m(vt.$$.fragment,e),Zs=s(e),v=p(e,"DIV",{class:!0});var C=J(v);m(Ut.$$.fragment,C),aa=s(C),vn=p(C,"P",{"data-svelte-h":!0}),b(vn)!=="svelte-77uxl4"&&(vn.textContent=tr),la=s(C),Un=p(C,"P",{"data-svelte-h":!0}),b(Un)!=="svelte-mxgguy"&&(Un.innerHTML=nr),ra=s(C),Y=p(C,"DIV",{class:!0});var oe=J(Y);m(Ft.$$.fragment,oe),ia=s(oe),Fn=p(oe,"P",{"data-svelte-h":!0}),b(Fn)!=="svelte-v78lg8"&&(Fn.textContent=or),pa=s(oe),m(ce.$$.fragment,oe),oe.forEach(n),da=s(C),me=p(C,"DIV",{class:!0});var Tn=J(me);m(kt.$$.fragment,Tn),ca=s(Tn),kn=p(Tn,"P",{"data-svelte-h":!0}),b(kn)!=="svelte-1s3c06i"&&(kn.innerHTML=sr),Tn.forEach(n),ma=s(C),ge=p(C,"DIV",{class:!0});var Jn=J(ge);m(Zt.$$.fragment,Jn),ga=s(Jn),Zn=p(Jn,"P",{"data-svelte-h":!0}),b(Zn)!=="svelte-pkn4ui"&&(Zn.innerHTML=ar),Jn.forEach(n),ua=s(C),ue=p(C,"DIV",{class:!0});var In=J(ue);m(Ct.$$.fragment,In),fa=s(In),Cn=p(In,"P",{"data-svelte-h":!0}),b(Cn)!=="svelte-14bnrb6"&&(Cn.textContent=lr),In.forEach(n),ha=s(C),fe=p(C,"DIV",{class:!0});var jn=J(fe);m(Wt.$$.fragment,jn),_a=s(jn),Wn=p(jn,"P",{"data-svelte-h":!0}),b(Wn)!=="svelte-1xwrf7t"&&(Wn.textContent=rr),jn.forEach(n),ba=s(C),Gn=p(C,"DIV",{class:!0});var Fo=J(Gn);m(Gt.$$.fragment,Fo),Fo.forEach(n),C.forEach(n),Cs=s(e),m(Bt.$$.fragment,e),Ws=s(e),B=p(e,"DIV",{class:!0});var X=J(B);m(Pt.$$.fragment,X),ya=s(X),Bn=p(X,"P",{"data-svelte-h":!0}),b(Bn)!=="svelte-9yovg9"&&(Bn.textContent=ir),Ma=s(X),Pn=p(X,"P",{"data-svelte-h":!0}),b(Pn)!=="svelte-mxgguy"&&(Pn.innerHTML=pr),xa=s(X),z=p(X,"DIV",{class:!0});var se=J(z);m(Nt.$$.fragment,se),wa=s(se),Nn=p(se,"P",{"data-svelte-h":!0}),b(Nn)!=="svelte-v78lg8"&&(Nn.textContent=dr),Ta=s(se),m(he.$$.fragment,se),se.forEach(n),Ja=s(X),$n=p(X,"DIV",{class:!0});var ko=J($n);m($t.$$.fragment,ko),ko.forEach(n),X.forEach(n),Gs=s(e),m(Lt.$$.fragment,e),Bs=s(e),P=p(e,"DIV",{class:!0});var E=J(P);m(Rt.$$.fragment,E),Ia=s(E),Ln=p(E,"P",{"data-svelte-h":!0}),b(Ln)!=="svelte-9yovg9"&&(Ln.textContent=cr),ja=s(E),Rn=p(E,"P",{"data-svelte-h":!0}),b(Rn)!=="svelte-mxgguy"&&(Rn.innerHTML=mr),va=s(E),Q=p(E,"DIV",{class:!0});var ae=J(Q);m(Xt.$$.fragment,ae),Ua=s(ae),Xn=p(ae,"P",{"data-svelte-h":!0}),b(Xn)!=="svelte-v78lg8"&&(Xn.textContent=gr),Fa=s(ae),m(_e.$$.fragment,ae),ae.forEach(n),ka=s(E),En=p(E,"DIV",{class:!0});var Rr=J(En);m(Et.$$.fragment,Rr),Rr.forEach(n),E.forEach(n),Ps=s(e),m(Vt.$$.fragment,e),Ns=s(e),N=p(e,"DIV",{class:!0});var K=J(N);m(Yt.$$.fragment,K),Za=s(K),Vn=p(K,"P",{"data-svelte-h":!0}),b(Vn)!=="svelte-1q2iwpg"&&(Vn.textContent=ur),Ca=s(K),Yn=p(K,"P",{"data-svelte-h":!0}),b(Yn)!=="svelte-mxgguy"&&(Yn.innerHTML=fr),Wa=s(K),H=p(K,"DIV",{class:!0});var wo=J(H);m(zt.$$.fragment,wo),Ga=s(wo),zn=p(wo,"P",{"data-svelte-h":!0}),b(zn)!=="svelte-v78lg8"&&(zn.textContent=hr),Ba=s(wo),m(be.$$.fragment,wo),wo.forEach(n),Pa=s(K),Qn=p(K,"DIV",{class:!0});var Xr=J(Qn);m(Qt.$$.fragment,Xr),Xr.forEach(n),K.forEach(n),$s=s(e),m(Ht.$$.fragment,e),Ls=s(e),$=p(e,"DIV",{class:!0});var ee=J($);m(At.$$.fragment,ee),Na=s(ee),Hn=p(ee,"P",{"data-svelte-h":!0}),b(Hn)!=="svelte-1luolc8"&&(Hn.textContent=_r),$a=s(ee),An=p(ee,"P",{"data-svelte-h":!0}),b(An)!=="svelte-mxgguy"&&(An.innerHTML=br),La=s(ee),A=p(ee,"DIV",{class:!0});var To=J(A);m(St.$$.fragment,To),Ra=s(To),Sn=p(To,"P",{"data-svelte-h":!0}),b(Sn)!=="svelte-v78lg8"&&(Sn.textContent=yr),Xa=s(To),m(ye.$$.fragment,To),To.forEach(n),Ea=s(ee),qn=p(ee,"DIV",{class:!0});var Er=J(qn);m(qt.$$.fragment,Er),Er.forEach(n),ee.forEach(n),Rs=s(e),m(Dt.$$.fragment,e),Xs=s(e),U=p(e,"DIV",{class:!0});var W=J(U);m(Ot.$$.fragment,W),Va=s(W),Dn=p(W,"P",{"data-svelte-h":!0}),b(Dn)!=="svelte-zx53af"&&(Dn.textContent=Mr),Ya=s(W),On=p(W,"P",{"data-svelte-h":!0}),b(On)!=="svelte-mxgguy"&&(On.innerHTML=xr),za=s(W),S=p(W,"DIV",{class:!0});var Jo=J(S);m(Kt.$$.fragment,Jo),Qa=s(Jo),Kn=p(Jo,"P",{"data-svelte-h":!0}),b(Kn)!=="svelte-v78lg8"&&(Kn.textContent=wr),Ha=s(Jo),m(Me.$$.fragment,Jo),Jo.forEach(n),Aa=s(W),xe=p(W,"DIV",{class:!0});var Ds=J(xe);m(en.$$.fragment,Ds),Sa=s(Ds),eo=p(Ds,"P",{"data-svelte-h":!0}),b(eo)!=="svelte-1s3c06i"&&(eo.innerHTML=Tr),Ds.forEach(n),qa=s(W),we=p(W,"DIV",{class:!0});var Os=J(we);m(tn.$$.fragment,Os),Da=s(Os),to=p(Os,"P",{"data-svelte-h":!0}),b(to)!=="svelte-pkn4ui"&&(to.innerHTML=Jr),Os.forEach(n),Oa=s(W),Te=p(W,"DIV",{class:!0});var Ks=J(Te);m(nn.$$.fragment,Ks),Ka=s(Ks),no=p(Ks,"P",{"data-svelte-h":!0}),b(no)!=="svelte-14bnrb6"&&(no.textContent=Ir),Ks.forEach(n),el=s(W),Je=p(W,"DIV",{class:!0});var ea=J(Je);m(on.$$.fragment,ea),tl=s(ea),oo=p(ea,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-1xwrf7t"&&(oo.textContent=jr),ea.forEach(n),nl=s(W),so=p(W,"DIV",{class:!0});var Vr=J(so);m(sn.$$.fragment,Vr),Vr.forEach(n),W.forEach(n),Es=s(e),m(an.$$.fragment,e),Vs=s(e),L=p(e,"DIV",{class:!0});var te=J(L);m(ln.$$.fragment,te),ol=s(te),ao=p(te,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-9yovg9"&&(ao.textContent=vr),sl=s(te),lo=p(te,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-mxgguy"&&(lo.innerHTML=Ur),al=s(te),q=p(te,"DIV",{class:!0});var Io=J(q);m(rn.$$.fragment,Io),ll=s(Io),ro=p(Io,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-v78lg8"&&(ro.textContent=Fr),rl=s(Io),m(Ie.$$.fragment,Io),Io.forEach(n),il=s(te),io=p(te,"DIV",{class:!0});var Yr=J(io);m(pn.$$.fragment,Yr),Yr.forEach(n),te.forEach(n),Ys=s(e),m(dn.$$.fragment,e),zs=s(e),R=p(e,"DIV",{class:!0});var ne=J(R);m(cn.$$.fragment,ne),pl=s(ne),po=p(ne,"P",{"data-svelte-h":!0}),b(po)!=="svelte-p02kn2"&&(po.textContent=kr),dl=s(ne),co=p(ne,"P",{"data-svelte-h":!0}),b(co)!=="svelte-12zhw7u"&&(co.innerHTML=Zr),cl=s(ne),D=p(ne,"DIV",{class:!0});var jo=J(D);m(mn.$$.fragment,jo),ml=s(jo),mo=p(jo,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-v78lg8"&&(mo.textContent=Cr),gl=s(jo),m(je.$$.fragment,jo),jo.forEach(n),ul=s(ne),go=p(ne,"DIV",{class:!0});var zr=J(go);m(gn.$$.fragment,zr),zr.forEach(n),ne.forEach(n),Qs=s(e),m(un.$$.fragment,e),Hs=s(e),F=p(e,"DIV",{class:!0});var G=J(F);m(fn.$$.fragment,G),fl=s(G),uo=p(G,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-1d13as9"&&(uo.textContent=Wr),hl=s(G),fo=p(G,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-12zhw7u"&&(fo.innerHTML=Gr),_l=s(G),O=p(G,"DIV",{class:!0});var vo=J(O);m(hn.$$.fragment,vo),bl=s(vo),ho=p(vo,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-v78lg8"&&(ho.textContent=Br),yl=s(vo),m(ve.$$.fragment,vo),vo.forEach(n),Ml=s(G),Ue=p(G,"DIV",{class:!0});var ta=J(Ue);m(_n.$$.fragment,ta),xl=s(ta),_o=p(ta,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-1s3c06i"&&(_o.innerHTML=Pr),ta.forEach(n),wl=s(G),Fe=p(G,"DIV",{class:!0});var na=J(Fe);m(bn.$$.fragment,na),Tl=s(na),bo=p(na,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-pkn4ui"&&(bo.innerHTML=Nr),na.forEach(n),Jl=s(G),ke=p(G,"DIV",{class:!0});var oa=J(ke);m(yn.$$.fragment,oa),Il=s(oa),yo=p(oa,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-14bnrb6"&&(yo.textContent=$r),oa.forEach(n),jl=s(G),Ze=p(G,"DIV",{class:!0});var sa=J(Ze);m(Mn.$$.fragment,sa),vl=s(sa),Mo=p(sa,"P",{"data-svelte-h":!0}),b(Mo)!=="svelte-1xwrf7t"&&(Mo.textContent=Lr),sa.forEach(n),Ul=s(G),xo=p(G,"DIV",{class:!0});var Qr=J(xo);m(xn.$$.fragment,Qr),Qr.forEach(n),G.forEach(n),As=s(e),m(wn.$$.fragment,e),Ss=s(e),Uo=p(e,"P",{}),J(Uo).forEach(n),this.h()},h(){T(d,"name","hf:doc:metadata"),T(d,"content",ui),T(pe,"class","justify-center"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(so,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,d),r(e,x,t),r(e,y,t),r(e,_,t),g(M,e,t),r(e,l,t),r(e,w,t),r(e,Zo,t),r(e,Ce,t),r(e,Co,t),g(re,e,t),r(e,Wo,t),r(e,We,t),r(e,Go,t),r(e,Ge,t),r(e,Bo,t),r(e,Be,t),r(e,Po,t),g(Pe,e,t),r(e,No,t),r(e,Ne,t),r(e,$o,t),g($e,e,t),r(e,Lo,t),g(Le,e,t),r(e,Ro,t),r(e,Re,t),r(e,Xo,t),g(Xe,e,t),r(e,Eo,t),g(Ee,e,t),r(e,Vo,t),r(e,Ve,t),r(e,Yo,t),g(Ye,e,t),r(e,zo,t),g(ze,e,t),r(e,Qo,t),r(e,Qe,t),r(e,Ho,t),g(He,e,t),r(e,Ao,t),r(e,Ae,t),r(e,So,t),g(Se,e,t),r(e,qo,t),g(qe,e,t),r(e,Do,t),r(e,De,t),r(e,Oo,t),g(Oe,e,t),r(e,Ko,t),r(e,Ke,t),r(e,es,t),g(et,e,t),r(e,ts,t),g(tt,e,t),r(e,ns,t),r(e,nt,t),r(e,os,t),g(ot,e,t),r(e,ss,t),g(st,e,t),r(e,as,t),r(e,at,t),r(e,ls,t),g(lt,e,t),r(e,rs,t),g(rt,e,t),r(e,is,t),r(e,it,t),r(e,ps,t),g(pt,e,t),r(e,ds,t),g(ie,e,t),r(e,cs,t),r(e,dt,t),r(e,ms,t),g(ct,e,t),r(e,gs,t),r(e,pe,t),r(e,us,t),g(mt,e,t),r(e,fs,t),r(e,gt,t),r(e,hs,t),r(e,ut,t),r(e,_s,t),g(ft,e,t),r(e,bs,t),g(ht,e,t),r(e,ys,t),r(e,_t,t),r(e,Ms,t),r(e,bt,t),r(e,xs,t),g(yt,e,t),r(e,ws,t),g(Mt,e,t),r(e,Ts,t),r(e,xt,t),r(e,Js,t),g(de,e,t),r(e,Is,t),r(e,wt,t),r(e,js,t),r(e,Tt,t),r(e,vs,t),g(Jt,e,t),r(e,Us,t),r(e,It,t),r(e,Fs,t),g(jt,e,t),r(e,ks,t),g(vt,e,t),r(e,Zs,t),r(e,v,t),g(Ut,v,null),a(v,aa),a(v,vn),a(v,la),a(v,Un),a(v,ra),a(v,Y),g(Ft,Y,null),a(Y,ia),a(Y,Fn),a(Y,pa),g(ce,Y,null),a(v,da),a(v,me),g(kt,me,null),a(me,ca),a(me,kn),a(v,ma),a(v,ge),g(Zt,ge,null),a(ge,ga),a(ge,Zn),a(v,ua),a(v,ue),g(Ct,ue,null),a(ue,fa),a(ue,Cn),a(v,ha),a(v,fe),g(Wt,fe,null),a(fe,_a),a(fe,Wn),a(v,ba),a(v,Gn),g(Gt,Gn,null),r(e,Cs,t),g(Bt,e,t),r(e,Ws,t),r(e,B,t),g(Pt,B,null),a(B,ya),a(B,Bn),a(B,Ma),a(B,Pn),a(B,xa),a(B,z),g(Nt,z,null),a(z,wa),a(z,Nn),a(z,Ta),g(he,z,null),a(B,Ja),a(B,$n),g($t,$n,null),r(e,Gs,t),g(Lt,e,t),r(e,Bs,t),r(e,P,t),g(Rt,P,null),a(P,Ia),a(P,Ln),a(P,ja),a(P,Rn),a(P,va),a(P,Q),g(Xt,Q,null),a(Q,Ua),a(Q,Xn),a(Q,Fa),g(_e,Q,null),a(P,ka),a(P,En),g(Et,En,null),r(e,Ps,t),g(Vt,e,t),r(e,Ns,t),r(e,N,t),g(Yt,N,null),a(N,Za),a(N,Vn),a(N,Ca),a(N,Yn),a(N,Wa),a(N,H),g(zt,H,null),a(H,Ga),a(H,zn),a(H,Ba),g(be,H,null),a(N,Pa),a(N,Qn),g(Qt,Qn,null),r(e,$s,t),g(Ht,e,t),r(e,Ls,t),r(e,$,t),g(At,$,null),a($,Na),a($,Hn),a($,$a),a($,An),a($,La),a($,A),g(St,A,null),a(A,Ra),a(A,Sn),a(A,Xa),g(ye,A,null),a($,Ea),a($,qn),g(qt,qn,null),r(e,Rs,t),g(Dt,e,t),r(e,Xs,t),r(e,U,t),g(Ot,U,null),a(U,Va),a(U,Dn),a(U,Ya),a(U,On),a(U,za),a(U,S),g(Kt,S,null),a(S,Qa),a(S,Kn),a(S,Ha),g(Me,S,null),a(U,Aa),a(U,xe),g(en,xe,null),a(xe,Sa),a(xe,eo),a(U,qa),a(U,we),g(tn,we,null),a(we,Da),a(we,to),a(U,Oa),a(U,Te),g(nn,Te,null),a(Te,Ka),a(Te,no),a(U,el),a(U,Je),g(on,Je,null),a(Je,tl),a(Je,oo),a(U,nl),a(U,so),g(sn,so,null),r(e,Es,t),g(an,e,t),r(e,Vs,t),r(e,L,t),g(ln,L,null),a(L,ol),a(L,ao),a(L,sl),a(L,lo),a(L,al),a(L,q),g(rn,q,null),a(q,ll),a(q,ro),a(q,rl),g(Ie,q,null),a(L,il),a(L,io),g(pn,io,null),r(e,Ys,t),g(dn,e,t),r(e,zs,t),r(e,R,t),g(cn,R,null),a(R,pl),a(R,po),a(R,dl),a(R,co),a(R,cl),a(R,D),g(mn,D,null),a(D,ml),a(D,mo),a(D,gl),g(je,D,null),a(R,ul),a(R,go),g(gn,go,null),r(e,Qs,t),g(un,e,t),r(e,Hs,t),r(e,F,t),g(fn,F,null),a(F,fl),a(F,uo),a(F,hl),a(F,fo),a(F,_l),a(F,O),g(hn,O,null),a(O,bl),a(O,ho),a(O,yl),g(ve,O,null),a(F,Ml),a(F,Ue),g(_n,Ue,null),a(Ue,xl),a(Ue,_o),a(F,wl),a(F,Fe),g(bn,Fe,null),a(Fe,Tl),a(Fe,bo),a(F,Jl),a(F,ke),g(yn,ke,null),a(ke,Il),a(ke,yo),a(F,jl),a(F,Ze),g(Mn,Ze,null),a(Ze,vl),a(Ze,Mo),a(F,Ul),a(F,xo),g(xn,xo,null),r(e,As,t),g(wn,e,t),r(e,Ss,t),r(e,Uo,t),qs=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),re.$set(C);const oe={};t&2&&(oe.$$scope={dirty:t,ctx:e}),ie.$set(oe);const Tn={};t&2&&(Tn.$$scope={dirty:t,ctx:e}),de.$set(Tn);const Jn={};t&2&&(Jn.$$scope={dirty:t,ctx:e}),ce.$set(Jn);const In={};t&2&&(In.$$scope={dirty:t,ctx:e}),he.$set(In);const jn={};t&2&&(jn.$$scope={dirty:t,ctx:e}),_e.$set(jn);const Fo={};t&2&&(Fo.$$scope={dirty:t,ctx:e}),be.$set(Fo);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),ye.$set(X);const se={};t&2&&(se.$$scope={dirty:t,ctx:e}),Me.$set(se);const ko={};t&2&&(ko.$$scope={dirty:t,ctx:e}),Ie.$set(ko);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),je.$set(E);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:e}),ve.$set(ae)},i(e){qs||(u(M.$$.fragment,e),u(re.$$.fragment,e),u(Pe.$$.fragment,e),u($e.$$.fragment,e),u(Le.$$.fragment,e),u(Xe.$$.fragment,e),u(Ee.$$.fragment,e),u(Ye.$$.fragment,e),u(ze.$$.fragment,e),u(He.$$.fragment,e),u(Se.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(pt.$$.fragment,e),u(ie.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(yt.$$.fragment,e),u(Mt.$$.fragment,e),u(de.$$.fragment,e),u(Jt.$$.fragment,e),u(jt.$$.fragment,e),u(vt.$$.fragment,e),u(Ut.$$.fragment,e),u(Ft.$$.fragment,e),u(ce.$$.fragment,e),u(kt.$$.fragment,e),u(Zt.$$.fragment,e),u(Ct.$$.fragment,e),u(Wt.$$.fragment,e),u(Gt.$$.fragment,e),u(Bt.$$.fragment,e),u(Pt.$$.fragment,e),u(Nt.$$.fragment,e),u(he.$$.fragment,e),u($t.$$.fragment,e),u(Lt.$$.fragment,e),u(Rt.$$.fragment,e),u(Xt.$$.fragment,e),u(_e.$$.fragment,e),u(Et.$$.fragment,e),u(Vt.$$.fragment,e),u(Yt.$$.fragment,e),u(zt.$$.fragment,e),u(be.$$.fragment,e),u(Qt.$$.fragment,e),u(Ht.$$.fragment,e),u(At.$$.fragment,e),u(St.$$.fragment,e),u(ye.$$.fragment,e),u(qt.$$.fragment,e),u(Dt.$$.fragment,e),u(Ot.$$.fragment,e),u(Kt.$$.fragment,e),u(Me.$$.fragment,e),u(en.$$.fragment,e),u(tn.$$.fragment,e),u(nn.$$.fragment,e),u(on.$$.fragment,e),u(sn.$$.fragment,e),u(an.$$.fragment,e),u(ln.$$.fragment,e),u(rn.$$.fragment,e),u(Ie.$$.fragment,e),u(pn.$$.fragment,e),u(dn.$$.fragment,e),u(cn.$$.fragment,e),u(mn.$$.fragment,e),u(je.$$.fragment,e),u(gn.$$.fragment,e),u(un.$$.fragment,e),u(fn.$$.fragment,e),u(hn.$$.fragment,e),u(ve.$$.fragment,e),u(_n.$$.fragment,e),u(bn.$$.fragment,e),u(yn.$$.fragment,e),u(Mn.$$.fragment,e),u(xn.$$.fragment,e),u(wn.$$.fragment,e),qs=!0)},o(e){f(M.$$.fragment,e),f(re.$$.fragment,e),f(Pe.$$.fragment,e),f($e.$$.fragment,e),f(Le.$$.fragment,e),f(Xe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(ze.$$.fragment,e),f(He.$$.fragment,e),f(Se.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(st.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),f(pt.$$.fragment,e),f(ie.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(de.$$.fragment,e),f(Jt.$$.fragment,e),f(jt.$$.fragment,e),f(vt.$$.fragment,e),f(Ut.$$.fragment,e),f(Ft.$$.fragment,e),f(ce.$$.fragment,e),f(kt.$$.fragment,e),f(Zt.$$.fragment,e),f(Ct.$$.fragment,e),f(Wt.$$.fragment,e),f(Gt.$$.fragment,e),f(Bt.$$.fragment,e),f(Pt.$$.fragment,e),f(Nt.$$.fragment,e),f(he.$$.fragment,e),f($t.$$.fragment,e),f(Lt.$$.fragment,e),f(Rt.$$.fragment,e),f(Xt.$$.fragment,e),f(_e.$$.fragment,e),f(Et.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(zt.$$.fragment,e),f(be.$$.fragment,e),f(Qt.$$.fragment,e),f(Ht.$$.fragment,e),f(At.$$.fragment,e),f(St.$$.fragment,e),f(ye.$$.fragment,e),f(qt.$$.fragment,e),f(Dt.$$.fragment,e),f(Ot.$$.fragment,e),f(Kt.$$.fragment,e),f(Me.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),f(sn.$$.fragment,e),f(an.$$.fragment,e),f(ln.$$.fragment,e),f(rn.$$.fragment,e),f(Ie.$$.fragment,e),f(pn.$$.fragment,e),f(dn.$$.fragment,e),f(cn.$$.fragment,e),f(mn.$$.fragment,e),f(je.$$.fragment,e),f(gn.$$.fragment,e),f(un.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(ve.$$.fragment,e),f(_n.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(Mn.$$.fragment,e),f(xn.$$.fragment,e),f(wn.$$.fragment,e),qs=!1},d(e){e&&(n(x),n(y),n(_),n(l),n(w),n(Zo),n(Ce),n(Co),n(Wo),n(We),n(Go),n(Ge),n(Bo),n(Be),n(Po),n(No),n(Ne),n($o),n(Lo),n(Ro),n(Re),n(Xo),n(Eo),n(Vo),n(Ve),n(Yo),n(zo),n(Qo),n(Qe),n(Ho),n(Ao),n(Ae),n(So),n(qo),n(Do),n(De),n(Oo),n(Ko),n(Ke),n(es),n(ts),n(ns),n(nt),n(os),n(ss),n(as),n(at),n(ls),n(rs),n(is),n(it),n(ps),n(ds),n(cs),n(dt),n(ms),n(gs),n(pe),n(us),n(fs),n(gt),n(hs),n(ut),n(_s),n(bs),n(ys),n(_t),n(Ms),n(bt),n(xs),n(ws),n(Ts),n(xt),n(Js),n(Is),n(wt),n(js),n(Tt),n(vs),n(Us),n(It),n(Fs),n(ks),n(Zs),n(v),n(Cs),n(Ws),n(B),n(Gs),n(Bs),n(P),n(Ps),n(Ns),n(N),n($s),n(Ls),n($),n(Rs),n(Xs),n(U),n(Es),n(Vs),n(L),n(Ys),n(zs),n(R),n(Qs),n(Hs),n(F),n(As),n(Ss),n(Uo)),n(d),h(M,e),h(re,e),h(Pe,e),h($e,e),h(Le,e),h(Xe,e),h(Ee,e),h(Ye,e),h(ze,e),h(He,e),h(Se,e),h(qe,e),h(Oe,e),h(et,e),h(tt,e),h(ot,e),h(st,e),h(lt,e),h(rt,e),h(pt,e),h(ie,e),h(ct,e),h(mt,e),h(ft,e),h(ht,e),h(yt,e),h(Mt,e),h(de,e),h(Jt,e),h(jt,e),h(vt,e),h(Ut),h(Ft),h(ce),h(kt),h(Zt),h(Ct),h(Wt),h(Gt),h(Bt,e),h(Pt),h(Nt),h(he),h($t),h(Lt,e),h(Rt),h(Xt),h(_e),h(Et),h(Vt,e),h(Yt),h(zt),h(be),h(Qt),h(Ht,e),h(At),h(St),h(ye),h(qt),h(Dt,e),h(Ot),h(Kt),h(Me),h(en),h(tn),h(nn),h(on),h(sn),h(an,e),h(ln),h(rn),h(Ie),h(pn),h(dn,e),h(cn),h(mn),h(je),h(gn),h(un,e),h(fn),h(hn),h(ve),h(_n),h(bn),h(yn),h(Mn),h(xn),h(wn,e)}}}const ui='{"title":"Flux","local":"flux","sections":[{"title":"Timestep-distilled","local":"timestep-distilled","sections":[],"depth":3},{"title":"Guidance-distilled","local":"guidance-distilled","sections":[],"depth":3},{"title":"Fill Inpainting/Outpainting","local":"fill-inpaintingoutpainting","sections":[],"depth":3},{"title":"Canny Control","local":"canny-control","sections":[],"depth":3},{"title":"Depth Control","local":"depth-control","sections":[],"depth":3},{"title":"Redux","local":"redux","sections":[],"depth":3},{"title":"Combining Flux Turbo LoRAs with Flux Control, Fill, and Redux","local":"combining-flux-turbo-loras-with-flux-control-fill-and-redux","sections":[],"depth":2},{"title":"Note about unload_lora_weights() when using Flux LoRAs","local":"note-about-unloadloraweights-when-using-flux-loras","sections":[],"depth":2},{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":2},{"title":"Running FP16 inference","local":"running-fp16-inference","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"Single File Loading for the FluxTransformer2DModel","local":"single-file-loading-for-the-fluxtransformer2dmodel","sections":[],"depth":2},{"title":"FluxPipeline","local":"diffusers.FluxPipeline","sections":[],"depth":2},{"title":"FluxImg2ImgPipeline","local":"diffusers.FluxImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxInpaintPipeline","local":"diffusers.FluxInpaintPipeline","sections":[],"depth":2},{"title":"FluxControlNetInpaintPipeline","local":"diffusers.FluxControlNetInpaintPipeline","sections":[],"depth":2},{"title":"FluxControlNetImg2ImgPipeline","local":"diffusers.FluxControlNetImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxControlPipeline","local":"diffusers.FluxControlPipeline","sections":[],"depth":2},{"title":"FluxControlImg2ImgPipeline","local":"diffusers.FluxControlImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxPriorReduxPipeline","local":"diffusers.FluxPriorReduxPipeline","sections":[],"depth":2},{"title":"FluxFillPipeline","local":"diffusers.FluxFillPipeline","sections":[],"depth":2}],"depth":1}';function fi(j){return Ar(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ti extends Sr{constructor(d){super(),qr(this,d,fi,gi,Hr,{})}}export{Ti as component};
