import{s as ol,o as pl,n as rl}from"../chunks/scheduler.8c3d61f6.js";import{S as cl,i as dl,g as n,s,r as c,A as ml,h as r,f as l,c as i,j as sl,u as d,x as o,k as il,y as Ml,a,v as m,d as M,t as f,w as u}from"../chunks/index.da70eac4.js";import{T as nl}from"../chunks/Tip.1d9b8c37.js";import{C as h}from"../chunks/CodeBlock.00a903b3.js";import{H as ge,E as fl}from"../chunks/EditOnGithub.1e64e623.js";function ul(_e){let p,b='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){p=n("p"),p.innerHTML=b},l(y){p=r(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1qbiqsn"&&(p.innerHTML=b)},m(y,w){a(y,p,w)},p:rl,d(y){y&&l(p)}}}function yl(_e){let p,b='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){p=n("p"),p.innerHTML=b},l(y){p=r(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-zx7n4c"&&(p.innerHTML=b)},m(y,w){a(y,p,w)},p:rl,d(y){y&&l(p)}}}function hl(_e){let p,b,y,w,_,Te,J,Ct='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',je,T,$t='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',Ce,j,Zt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',$e,C,Rt="Before running the script, make sure you install the library from source:",Ze,$,Re,Z,xt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",xe,R,Xe,U,We,x,Xt="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",Ie,X,ve,W,Wt="To setup a default 🤗 Accelerate environment without choosing any configurations:",Ge,I,Ve,v,It="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Le,G,ke,V,vt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',He,L,Ne,g,Ae,k,Gt='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Ye,H,Vt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Be,N,Qe,A,Lt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Fe,Y,kt='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',Ee,B,ze,Q,Ht='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',Se,F,qe,E,Nt='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',De,z,Pe,S,At='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',Ke,q,Oe,D,Yt='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',et,P,tt,K,Bt='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',lt,O,at,ee,Qt='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',st,te,it,le,Ft='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',nt,ae,rt,se,Et='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',ot,ie,pt,ne,zt="Now you’re ready to launch the training script and start distilling!",ct,re,St='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',dt,oe,mt,pe,qt="Once training is complete, you can use your new LCM for inference.",Mt,ce,ft,de,ut,me,Dt='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',yt,Me,Pt='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',ht,fe,bt,ue,Kt='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',wt,ye,Ot='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',Ut,he,gt,be,el="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",_t,we,tl='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',Jt,Ue,Tt,Je,jt;return _=new ge({props:{title:"Latent Consistency Distillation",local:"latent-consistency-distillation",headingTag:"h1"}}),$=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),R=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`,wrap:!1}}),U=new nl({props:{$$slots:{default:[ul]},$$scope:{ctx:_e}}}),X=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),I=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),L=new ge({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),g=new nl({props:{$$slots:{default:[yl]},$$scope:{ctx:_e}}}),N=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),B=new ge({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),F=new h({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`,wrap:!1}}),z=new h({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`,wrap:!1}}),q=new h({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`,wrap:!1}}),P=new h({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),O=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`,wrap:!1}}),te=new h({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`,wrap:!1}}),ae=new h({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`,wrap:!1}}),ie=new ge({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),oe=new h({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyRnRvJTJGc2F2ZWQlMkZtb2RlbCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl9sY21fZGlzdGlsbF9zZF93ZHMucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfdGVhY2hlcl9tb2RlbCUzRCUyNE1PREVMX0RJUiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRGZwMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS02JTIwLS1sb3NzX3R5cGUlM0QlMjJodWJlciUyMiUyMC0tZW1hX2RlY2F5JTNEMC45NSUyMC0tYWRhbV93ZWlnaHRfZGVjYXklM0QwLjAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDEwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zYW1wbGVzJTNENDAwMDAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YWxvYWRlcl9udW1fd29ya2VycyUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRCUyMnBpcGUlM0FjdXJsJTIwLUwlMjAtcyUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmxhaW9uJTJGY29uY2VwdHVhbC1jYXB0aW9ucy0xMm0td2ViZGF0YXNldCUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRiU3QjAwMDAwLi4wMTA5OSU3RC50YXIlM0Zkb3dubG9hZCUzRHRydWUlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZhbGlkYXRpb25fc3RlcHMlM0QyMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNoZWNrcG9pbnRpbmdfc3RlcHMlM0QyMDAlMjAtLWNoZWNrcG9pbnRzX3RvdGFsX2xpbWl0JTNEMTAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11c2VfOGJpdF9hZGFtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXN1bWVfZnJvbV9jaGVja3BvaW50JTNEbGF0ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvcnRfdG8lM0R3YW5kYiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQ1MzY0NTYzNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`,wrap:!1}}),ce=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVuZXQlM0R1bmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnN1c2hpJTIwcm9sbHMlMjBpbiUyMHRoZSUyMGZvcm0lMjBvZiUyMHBhbmRhJTIwaGVhZHMlMkMlMjBzdXNoaSUyMHBsYXR0ZXIlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new ge({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),fe=new ge({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),he=new ge({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ue=new fl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/lcm_distill.md"}}),{c(){p=n("meta"),b=s(),y=n("p"),w=s(),c(_.$$.fragment),Te=s(),J=n("p"),J.innerHTML=Ct,je=s(),T=n("p"),T.innerHTML=$t,Ce=s(),j=n("p"),j.innerHTML=Zt,$e=s(),C=n("p"),C.textContent=Rt,Ze=s(),c($.$$.fragment),Re=s(),Z=n("p"),Z.textContent=xt,xe=s(),c(R.$$.fragment),Xe=s(),c(U.$$.fragment),We=s(),x=n("p"),x.innerHTML=Xt,Ie=s(),c(X.$$.fragment),ve=s(),W=n("p"),W.textContent=Wt,Ge=s(),c(I.$$.fragment),Ve=s(),v=n("p"),v.textContent=It,Le=s(),c(G.$$.fragment),ke=s(),V=n("p"),V.innerHTML=vt,He=s(),c(L.$$.fragment),Ne=s(),c(g.$$.fragment),Ae=s(),k=n("p"),k.innerHTML=Gt,Ye=s(),H=n("p"),H.innerHTML=Vt,Be=s(),c(N.$$.fragment),Qe=s(),A=n("p"),A.innerHTML=Lt,Fe=s(),Y=n("ul"),Y.innerHTML=kt,Ee=s(),c(B.$$.fragment),ze=s(),Q=n("p"),Q.innerHTML=Ht,Se=s(),c(F.$$.fragment),qe=s(),E=n("p"),E.innerHTML=Nt,De=s(),c(z.$$.fragment),Pe=s(),S=n("p"),S.innerHTML=At,Ke=s(),c(q.$$.fragment),Oe=s(),D=n("p"),D.innerHTML=Yt,et=s(),c(P.$$.fragment),tt=s(),K=n("p"),K.innerHTML=Bt,lt=s(),c(O.$$.fragment),at=s(),ee=n("p"),ee.innerHTML=Qt,st=s(),c(te.$$.fragment),it=s(),le=n("p"),le.innerHTML=Ft,nt=s(),c(ae.$$.fragment),rt=s(),se=n("p"),se.innerHTML=Et,ot=s(),c(ie.$$.fragment),pt=s(),ne=n("p"),ne.textContent=zt,ct=s(),re=n("p"),re.innerHTML=St,dt=s(),c(oe.$$.fragment),mt=s(),pe=n("p"),pe.textContent=qt,Mt=s(),c(ce.$$.fragment),ft=s(),c(de.$$.fragment),ut=s(),me=n("p"),me.innerHTML=Dt,yt=s(),Me=n("p"),Me.innerHTML=Pt,ht=s(),c(fe.$$.fragment),bt=s(),ue=n("p"),ue.innerHTML=Kt,wt=s(),ye=n("p"),ye.innerHTML=Ot,Ut=s(),c(he.$$.fragment),gt=s(),be=n("p"),be.textContent=el,_t=s(),we=n("ul"),we.innerHTML=tl,Jt=s(),c(Ue.$$.fragment),Tt=s(),Je=n("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=i(e),y=r(e,"P",{}),sl(y).forEach(l),w=i(e),d(_.$$.fragment,e),Te=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1oefohu"&&(J.innerHTML=Ct),je=i(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-w1dbtu"&&(T.innerHTML=$t),Ce=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1izwzxl"&&(j.innerHTML=Zt),$e=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-l7dm2q"&&(C.textContent=Rt),Ze=i(e),d($.$$.fragment,e),Re=i(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-z4z0b9"&&(Z.textContent=xt),xe=i(e),d(R.$$.fragment,e),Xe=i(e),d(U.$$.fragment,e),We=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-h7f7kz"&&(x.innerHTML=Xt),Ie=i(e),d(X.$$.fragment,e),ve=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-di6juu"&&(W.textContent=Wt),Ge=i(e),d(I.$$.fragment,e),Ve=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-tsz4qp"&&(v.textContent=It),Le=i(e),d(G.$$.fragment,e),ke=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1fkfdql"&&(V.innerHTML=vt),He=i(e),d(L.$$.fragment,e),Ne=i(e),d(g.$$.fragment,e),Ae=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-z8r4ny"&&(k.innerHTML=Gt),Ye=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1r0bv1x"&&(H.innerHTML=Vt),Be=i(e),d(N.$$.fragment,e),Qe=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-opb00x"&&(A.innerHTML=Lt),Fe=i(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-q5d022"&&(Y.innerHTML=kt),Ee=i(e),d(B.$$.fragment,e),ze=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-xygc62"&&(Q.innerHTML=Ht),Se=i(e),d(F.$$.fragment,e),qe=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1fe8qlp"&&(E.innerHTML=Nt),De=i(e),d(z.$$.fragment,e),Pe=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-184frii"&&(S.innerHTML=At),Ke=i(e),d(q.$$.fragment,e),Oe=i(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-he12t1"&&(D.innerHTML=Yt),et=i(e),d(P.$$.fragment,e),tt=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1c3frfx"&&(K.innerHTML=Bt),lt=i(e),d(O.$$.fragment,e),at=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4kbgth"&&(ee.innerHTML=Qt),st=i(e),d(te.$$.fragment,e),it=i(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1g18b9r"&&(le.innerHTML=Ft),nt=i(e),d(ae.$$.fragment,e),rt=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1pefyrm"&&(se.innerHTML=Et),ot=i(e),d(ie.$$.fragment,e),pt=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-5c8ldp"&&(ne.textContent=zt),ct=i(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-14rdptq"&&(re.innerHTML=St),dt=i(e),d(oe.$$.fragment,e),mt=i(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-2n690z"&&(pe.textContent=qt),Mt=i(e),d(ce.$$.fragment,e),ft=i(e),d(de.$$.fragment,e),ut=i(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-21u499"&&(me.innerHTML=Dt),yt=i(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1sxi0tl"&&(Me.innerHTML=Pt),ht=i(e),d(fe.$$.fragment,e),bt=i(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-swritx"&&(ue.innerHTML=Kt),wt=i(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-6dxtva"&&(ye.innerHTML=Ot),Ut=i(e),d(he.$$.fragment,e),gt=i(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1bflftn"&&(be.textContent=el),_t=i(e),we=r(e,"UL",{"data-svelte-h":!0}),o(we)!=="svelte-e624yw"&&(we.innerHTML=tl),Jt=i(e),d(Ue.$$.fragment,e),Tt=i(e),Je=r(e,"P",{}),sl(Je).forEach(l),this.h()},h(){il(p,"name","hf:doc:metadata"),il(p,"content",bl)},m(e,t){Ml(document.head,p),a(e,b,t),a(e,y,t),a(e,w,t),m(_,e,t),a(e,Te,t),a(e,J,t),a(e,je,t),a(e,T,t),a(e,Ce,t),a(e,j,t),a(e,$e,t),a(e,C,t),a(e,Ze,t),m($,e,t),a(e,Re,t),a(e,Z,t),a(e,xe,t),m(R,e,t),a(e,Xe,t),m(U,e,t),a(e,We,t),a(e,x,t),a(e,Ie,t),m(X,e,t),a(e,ve,t),a(e,W,t),a(e,Ge,t),m(I,e,t),a(e,Ve,t),a(e,v,t),a(e,Le,t),m(G,e,t),a(e,ke,t),a(e,V,t),a(e,He,t),m(L,e,t),a(e,Ne,t),m(g,e,t),a(e,Ae,t),a(e,k,t),a(e,Ye,t),a(e,H,t),a(e,Be,t),m(N,e,t),a(e,Qe,t),a(e,A,t),a(e,Fe,t),a(e,Y,t),a(e,Ee,t),m(B,e,t),a(e,ze,t),a(e,Q,t),a(e,Se,t),m(F,e,t),a(e,qe,t),a(e,E,t),a(e,De,t),m(z,e,t),a(e,Pe,t),a(e,S,t),a(e,Ke,t),m(q,e,t),a(e,Oe,t),a(e,D,t),a(e,et,t),m(P,e,t),a(e,tt,t),a(e,K,t),a(e,lt,t),m(O,e,t),a(e,at,t),a(e,ee,t),a(e,st,t),m(te,e,t),a(e,it,t),a(e,le,t),a(e,nt,t),m(ae,e,t),a(e,rt,t),a(e,se,t),a(e,ot,t),m(ie,e,t),a(e,pt,t),a(e,ne,t),a(e,ct,t),a(e,re,t),a(e,dt,t),m(oe,e,t),a(e,mt,t),a(e,pe,t),a(e,Mt,t),m(ce,e,t),a(e,ft,t),m(de,e,t),a(e,ut,t),a(e,me,t),a(e,yt,t),a(e,Me,t),a(e,ht,t),m(fe,e,t),a(e,bt,t),a(e,ue,t),a(e,wt,t),a(e,ye,t),a(e,Ut,t),m(he,e,t),a(e,gt,t),a(e,be,t),a(e,_t,t),a(e,we,t),a(e,Jt,t),m(Ue,e,t),a(e,Tt,t),a(e,Je,t),jt=!0},p(e,[t]){const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),U.$set(ll);const al={};t&2&&(al.$$scope={dirty:t,ctx:e}),g.$set(al)},i(e){jt||(M(_.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(U.$$.fragment,e),M(X.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(L.$$.fragment,e),M(g.$$.fragment,e),M(N.$$.fragment,e),M(B.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(fe.$$.fragment,e),M(he.$$.fragment,e),M(Ue.$$.fragment,e),jt=!0)},o(e){f(_.$$.fragment,e),f($.$$.fragment,e),f(R.$$.fragment,e),f(U.$$.fragment,e),f(X.$$.fragment,e),f(I.$$.fragment,e),f(G.$$.fragment,e),f(L.$$.fragment,e),f(g.$$.fragment,e),f(N.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(z.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(Ue.$$.fragment,e),jt=!1},d(e){e&&(l(b),l(y),l(w),l(Te),l(J),l(je),l(T),l(Ce),l(j),l($e),l(C),l(Ze),l(Re),l(Z),l(xe),l(Xe),l(We),l(x),l(Ie),l(ve),l(W),l(Ge),l(Ve),l(v),l(Le),l(ke),l(V),l(He),l(Ne),l(Ae),l(k),l(Ye),l(H),l(Be),l(Qe),l(A),l(Fe),l(Y),l(Ee),l(ze),l(Q),l(Se),l(qe),l(E),l(De),l(Pe),l(S),l(Ke),l(Oe),l(D),l(et),l(tt),l(K),l(lt),l(at),l(ee),l(st),l(it),l(le),l(nt),l(rt),l(se),l(ot),l(pt),l(ne),l(ct),l(re),l(dt),l(mt),l(pe),l(Mt),l(ft),l(ut),l(me),l(yt),l(Me),l(ht),l(bt),l(ue),l(wt),l(ye),l(Ut),l(gt),l(be),l(_t),l(we),l(Jt),l(Tt),l(Je)),l(p),u(_,e),u($,e),u(R,e),u(U,e),u(X,e),u(I,e),u(G,e),u(L,e),u(g,e),u(N,e),u(B,e),u(F,e),u(z,e),u(q,e),u(P,e),u(O,e),u(te,e),u(ae,e),u(ie,e),u(oe,e),u(ce,e),u(de,e),u(fe,e),u(he,e),u(Ue,e)}}}const bl='{"title":"Latent Consistency Distillation","local":"latent-consistency-distillation","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function wl(_e){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends cl{constructor(p){super(),dl(this,p,wl,hl,ol,{})}}export{jl as component};
