import{s as Ji,o as ki,n as ji}from"../chunks/scheduler.182ea377.js";import{S as Ci,i as Ui,g as n,s as a,p as m,x as Hs,A as Vi,h as s,f as o,c as i,j as d,q as h,m as c,y as qs,k as p,v as t,a as l,r as f,d as u,t as _,u as g}from"../chunks/index.008d68e4.js";import{T as Ii}from"../chunks/Tip.4f096367.js";import{D as M}from"../chunks/Docstring.7aec8b85.js";import{C as Z}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as J}from"../chunks/IconCopyLink.96bbb92b.js";function Xi(Uo){let x,fe='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){x=n("p"),x.innerHTML=fe},l(y){x=s(y,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1wmc0l4"&&(x.innerHTML=fe)},m(y,k){l(y,x,k)},p:ji,d(y){y&&o(x)}}}function Pi(Uo){let x,fe,y,k,go,ue,Yn,Mt,Os="Text2Video-Zero",Vo,_e,Ks='<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">Text2Video-Zero: Text-to-Image Diffusion Models are Zero-Shot Video Generators</a> is by Levon Khachatryan, Andranik Movsisyan, Vahram Tadevosyan, Roberto Henschel, <a href="https://www.ece.utexas.edu/people/faculty/atlas-wang" rel="nofollow">Zhangyang Wang</a>, Shant Navasardyan, <a href="https://www.humphreyshi.com" rel="nofollow">Humphrey Shi</a>.',Io,ge,ea="Text2Video-Zero enables zero-shot video generation using either:",Xo,ve,ta="<li>A textual prompt</li> <li>A prompt combined with guidance from poses or edges</li> <li>Video Instruct-Pix2Pix (instruction-guided video editing)</li>",Po,be,oa="Results are temporally consistent and closely follow the guidance and textual prompts.",So,Te,na='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2v_zero_teaser.png" alt="teaser-img"/>',Wo,xe,sa="The abstract from the paper is:",No,ye,aa=`<em>Recent text-to-video generation approaches rely on computationally heavy training and require large-scale video datasets. In this paper, we introduce a new task of zero-shot text-to-video generation and propose a low-cost approach (without any training or optimization) by leveraging the power of existing text-to-image synthesis methods (e.g., Stable Diffusion), making them suitable for the video domain.
Our key modifications include (i) enriching the latent codes of the generated frames with motion dynamics to keep the global scene and the background time consistent; and (ii) reprogramming frame-level self-attention using a new cross-frame attention of each frame on the first frame, to preserve the context, appearance, and identity of the foreground object.
Experiments show that this leads to low overhead, yet high-quality and remarkably consistent video generation. Moreover, our approach is not limited to text-to-video synthesis but is also applicable to other tasks such as conditional and content-specialized video generation, and Video Instruct-Pix2Pix, i.e., instruction-guided video editing.
As experiments show, our method performs comparably or sometimes better than recent approaches, despite not being trained on additional video data.</em>`,$o,we,ia='You can find additional information about Text2Video-Zero on the <a href="https://text2video-zero.github.io/" rel="nofollow">project page</a>, <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, and <a href="https://github.com/Picsart-AI-Research/Text2Video-Zero" rel="nofollow">original codebase</a>.',Go,U,L,vo,Me,An,Zt,ra="Usage example",zo,V,D,bo,Ze,Hn,Jt,la="Text-To-Video",Bo,Je,da="To generate a video from prompt, run the following Python code:",Ro,ke,Lo,je,pa="You can change these parameters in the pipeline call:",Do,Ce,ca='<li>Motion field strength (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1):<ul><li><code>motion_field_strength_x</code> and <code>motion_field_strength_y</code>. Default: <code>motion_field_strength_x=12</code>, <code>motion_field_strength_y=12</code></li></ul></li> <li><code>T</code> and <code>T&#39;</code> (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1)<ul><li><code>t0</code> and <code>t1</code> in the range <code>{0, ..., num_inference_steps}</code>. Default: <code>t0=45</code>, <code>t1=48</code></li></ul></li> <li>Video length:<ul><li><code>video_length</code>, the number of frames video_length to be generated. Default: <code>video_length=8</code></li></ul></li>',Eo,Ue,ma="We can also generate longer videos by doing the processing in a chunk-by-chunk manner:",Qo,Ve,Fo,kt,E,Q,F,To,Ie,qn,jt,ha="SDXL Support",On,Ct,fa="TextToVideoZeroSDXLPipeline",Kn,Yo,Xe,Ao,I,Y,xo,Pe,es,Ut,ua="Text-To-Video with Pose Control",Ho,Vt,Se,It,_a="Download a demo video",ts,We,qo,X,P,Xt,ga="Read video containing extracted pose images",os,Ne,ns,Pt,va='To extract pose from actual video, read <a href="controlnet">ControlNet documentation</a>.',ss,$e,St,ba="Run <code>StableDiffusionControlNetPipeline</code> with our custom attention processor",as,Ge,Oo,Wt,S,A,H,yo,ze,is,Nt,Ta="SDXL Support",rs,$t,xa="Since our attention processor also works with SDXL, it can be utilized to generate a video from prompt using ControlNet models powered by SDXL:",ls,Be,Ko,W,q,wo,Re,ds,Gt,ya="Text-To-Video with Edge Control",en,Le,wa='To generate a video from prompt with additional Canny edge control, follow the same steps described above for pose-guided generation using <a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a>.',tn,N,O,Mo,De,ps,zt,Ma="Video Instruct-Pix2Pix",on,Ee,Za='To perform text-guided video editing (with <a href="pix2pix">InstructPix2Pix</a>):',nn,j,Qe,Bt,Ja="Download a demo video",cs,Fe,ms,Ye,Rt,ka="Read video from path",hs,Ae,fs,He,Lt,ja="Run <code>StableDiffusionInstructPix2PixPipeline</code> with our custom attention processor",us,qe,sn,$,K,Zo,Oe,_s,Dt,Ca="DreamBooth specialization",an,Ke,Ua=`Methods <strong>Text-To-Video</strong>, <strong>Text-To-Video with Pose Control</strong> and <strong>Text-To-Video with Edge Control</strong>
can run with custom <a href="../../training/dreambooth">DreamBooth</a> models, as shown below for
<a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a> and
<a href="https://huggingface.co/PAIR/text2video-zero-controlnet-canny-avatar" rel="nofollow">Avatar style DreamBooth</a> model:`,rn,C,et,Et,Va="Download a demo video",gs,tt,vs,ot,Qt,Ia="Read video from path",bs,nt,Ts,st,Ft,Xa="Run <code>StableDiffusionControlNetPipeline</code> with custom trained DreamBooth model",xs,at,ln,it,Pa='You can filter out some available DreamBooth-trained models with <a href="https://huggingface.co/models?search=dreambooth" rel="nofollow">this link</a>.',dn,ee,pn,G,te,Jo,rt,ys,Yt,Sa="TextToVideoZeroPipeline",cn,b,lt,ws,At,Wa="Pipeline for zero-shot text-to-video generation using Stable Diffusion.",Ms,Ht,Na=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Zs,oe,dt,Js,qt,$a="The call function to the pipeline for generation.",ks,ne,pt,js,Ot,Ga="Perform backward process given list of time steps.",Cs,se,ct,Us,Kt,za="Encodes the prompt into text encoder hidden states.",Vs,ae,mt,Is,eo,Ba="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",mn,z,ie,ko,ht,Xs,to,Ra="TextToVideoZeroSDXLPipeline",hn,v,ft,Ps,oo,La="Pipeline for zero-shot text-to-video generation using Stable Diffusion XL.",Ss,no,Da=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ws,re,ut,Ns,so,Ea="Function invoked when calling the pipeline for generation.",$s,le,_t,Gs,ao,Qa="Perform backward process given list of time steps",zs,de,gt,Bs,io,Fa=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Rs,pe,vt,Ls,ro,Ya=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ds,ce,bt,Es,lo,Aa="Encodes the prompt into text encoder hidden states.",Qs,me,Tt,Fs,po,Ha="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",fn,B,he,jo,xt,Ys,co,qa="TextToVideoPipelineOutput",un,R,yt,As,mo,Oa="Output class for zero-shot text-to-video pipeline.",_n;return ue=new J({}),Me=new J({}),Ze=new J({}),ke=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFRleHRUb1ZpZGVvWmVyb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcGFuZGElMjBpcyUyMHBsYXlpbmclMjBndWl0YXIlMjBvbiUyMHRpbWVzJTIwc3F1YXJlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQpLmltYWdlcyUwQXJlc3VsdCUyMCUzRCUyMCU1QihyJTIwKiUyMDI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyMGZvciUyMHIlMjBpbiUyMHJlc3VsdCU1RCUwQWltYWdlaW8ubWltc2F2ZSglMjJ2aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>
result = pipe(prompt=prompt).images
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),Ve=new Z({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
seed = <span class="hljs-number">0</span>
video_length = <span class="hljs-number">24</span>  <span class="hljs-comment">#24 ÷ 4fps = 6 seconds</span>
chunk_size = <span class="hljs-number">8</span>
prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>

<span class="hljs-comment"># Generate the video chunk-by-chunk</span>
result = []
chunk_ids = np.arange(<span class="hljs-number">0</span>, video_length, chunk_size - <span class="hljs-number">1</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(chunk_ids)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Processing chunk <span class="hljs-subst">{i + <span class="hljs-number">1</span>}</span> / <span class="hljs-subst">{<span class="hljs-built_in">len</span>(chunk_ids)}</span>&quot;</span>)
    ch_start = chunk_ids[i]
    ch_end = video_length <span class="hljs-keyword">if</span> i == <span class="hljs-built_in">len</span>(chunk_ids) - <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> chunk_ids[i + <span class="hljs-number">1</span>]
    <span class="hljs-comment"># Attach the first frame for Cross Frame Attention</span>
    frame_ids = [<span class="hljs-number">0</span>] + <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(ch_start, ch_end))
    <span class="hljs-comment"># Fix the seed for the temporal consistency</span>
    generator.manual_seed(seed)
    output = pipe(prompt=prompt, video_length=<span class="hljs-built_in">len</span>(frame_ids), generator=generator, frame_ids=frame_ids)
    result.append(output.images[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Concatenate chunks and save</span>
result = np.concatenate(result)
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),Ie=new J({}),Xe=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvU0RYTFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMEFwaXBlJTIwJTNEJTIwVGV4dFRvVmlkZW9aZXJvU0RYTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroSDXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
pipe = TextToVideoZeroSDXLPipeline.from_pretrained(
    model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),Pe=new J({}),We=new Z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBvc2VzX3NrZWxldG9uX2dpZnMlMkZkYW5jZTFfY29yci5tcDQlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyUEFJUiUyRlRleHQyVmlkZW8tWmVybyUyMiUwQXZpZGVvX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`}}),Ne=new Z({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`}}),Ge=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtb3BlbnBvc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBTZXQlMjB0aGUlMjBhdHRlbnRpb24lMjBwcm9jZXNzb3IlMEFwaXBlLnVuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEFwaXBlLmNvbnRyb2xuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEElMEElMjMlMjBmaXglMjBsYXRlbnRzJTIwZm9yJTIwYWxsJTIwZnJhbWVzJTBBbGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNikucmVwZWF0KGxlbihwb3NlX2ltYWdlcyklMkMlMjAxJTJDJTIwMSUyQyUyMDEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMGRhbmNpbmclMjBpbiUyMGElMjBkZXNlcnQlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4ocG9zZV9pbWFnZXMpJTJDJTIwaW1hZ2UlM0Rwb3NlX2ltYWdlcyUyQyUyMGxhdGVudHMlM0RsYXRlbnRzKS5pbWFnZXMlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),ze=new J({}),Be=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQWNvbnRyb2xuZXRfbW9kZWxfaWQlMjAlM0QlMjAndGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAnJTBBbW9kZWxfaWQlMjAlM0QlMjAnc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJyUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5bW9kZWxfaWQlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJ2N1ZGEnKSUwQSUwQSUyMyUyMFNldCUyMHRoZSUyMGF0dGVudGlvbiUyMHByb2Nlc3NvciUwQXBpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IoYmF0Y2hfc2l6ZSUzRDIpKSUwQXBpcGUuY29udHJvbG5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IoYmF0Y2hfc2l6ZSUzRDIpKSUwQSUwQSUyMyUyMGZpeCUyMGxhdGVudHMlMjBmb3IlMjBhbGwlMjBmcmFtZXMlMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjA0JTJDJTIwMTI4JTJDJTIwMTI4KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4ocG9zZV9pbWFnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkRhcnRoJTIwVmFkZXIlMjBkYW5jaW5nJTIwaW4lMjBhJTIwZGVzZXJ0JTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHBvc2VfaW1hZ2VzKSUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

controlnet_model_id = <span class="hljs-string">&#x27;thibaud/controlnet-openpose-sdxl-1.0&#x27;</span>
model_id = <span class="hljs-string">&#x27;stabilityai/stable-diffusion-xl-base-1.0&#x27;</span>

controlnet = ControlNetModel.from_pretrained(controlnet_model_id, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
	model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),Re=new J({}),De=new J({}),Fe=new Z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBpeDJwaXglMjB2aWRlbyUyRmNhbWVsLm1wNCUyMiUwQXJlcG9faWQlMjAlM0QlMjAlMjJQQUlSJTJGVGV4dDJWaWRlby1aZXJvJTIyJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZmlsZW5hbWUlM0RmaWxlbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/pix2pix video/camel.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`}}),Ae=new Z({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXZpZGVvJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
video = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`}}),qe=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMykpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIybWFrZSUyMGl0JTIwVmFuJTIwR29naCUyMFN0YXJyeSUyME5pZ2h0JTIwc3R5bGUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4odmlkZW8pJTJDJTIwaW1hZ2UlM0R2aWRlbykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMmVkaXRlZF92aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">3</span>))

prompt = <span class="hljs-string">&quot;make it Van Gogh Starry Night style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(video), image=video).images
imageio.mimsave(<span class="hljs-string">&quot;edited_video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),Oe=new J({}),tt=new Z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRmNhbm55X3ZpZGVvc19tcDQlMkZnaXJsX3R1cm5pbmcubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/canny_videos_mp4/girl_turning.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`}}),nt=new Z({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQWNhbm55X2VkZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
canny_edges = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`}}),at=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEElMjMlMjBzZXQlMjBtb2RlbCUyMGlkJTIwdG8lMjBjdXN0b20lMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyUEFJUiUyRnRleHQydmlkZW8temVyby1jb250cm9sbmV0LWNhbm55LWF2YXRhciUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwYXR0ZW50aW9uJTIwcHJvY2Vzc29yJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBcGlwZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBJTBBJTIzJTIwZml4JTIwbGF0ZW50cyUyMGZvciUyMGFsbCUyMGZyYW1lcyUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbigoMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4oY2FubnlfZWRnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwYmVhdXRpZnVsJTIwZ2lybCUyMGF2YXRhciUyMHN0eWxlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKGNhbm55X2VkZ2VzKSUyQyUyMGltYWdlJTNEY2FubnlfZWRnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

<span class="hljs-comment"># set model id to custom model</span>
model_id = <span class="hljs-string">&quot;PAIR/text2video-zero-controlnet-canny-avatar&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(canny_edges), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;oil painting of a beautiful girl avatar style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(canny_edges), image=canny_edges, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`}}),ee=new Ii({props:{$$slots:{default:[Xi]},$$scope:{ctx:Uo}}}),rt=new J({}),lt=new M({props:{name:"class diffusers.TextToVideoZeroPipeline",anchor:"diffusers.TextToVideoZeroPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoZeroPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoZeroPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoZeroPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.25.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoZeroPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.TextToVideoZeroPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.TextToVideoZeroPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L284"}}),dt=new M({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"video_length",val:": Optional = 8"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": Optional = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"},{name:"frame_ids",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;numpy&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>&quot;latent&quot;</code> and <code>&quot;numpy&quot;</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a
<a href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput">TextToVideoPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L521",returnDescription:`
<p>The output contains a <code>ndarray</code> of the generated video, when <code>output_type</code> != <code>"latent"</code>, otherwise a
latent code of generated videos and a list of <code>bool</code>s indicating whether the corresponding generated
video contains “not-safe-for-work” (nsfw) content..</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"
>TextToVideoPipelineOutput</a></p>
`}}),pt=new M({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"cross_attention_kwargs",val:" = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.
extra_step_kwargs &#x2014;
Extra_step_kwargs.
cross_attention_kwargs &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.
num_warmup_steps &#x2014;
number of warmup steps.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L375",returnDescription:`
<p>Latents of backward process output at time timesteps[-1].</p>
`,returnType:`
<p>latents</p>
`}}),ct=new M({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L782"}}),mt=new M({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L351",returnDescription:`
<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`
<p>x_t1</p>
`}}),ht=new J({}),ft=new M({props:{name:"class diffusers.TextToVideoZeroSDXLPipeline",anchor:"diffusers.TextToVideoZeroSDXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L328"}}),ut=new M({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union = None"},{name:"video_length",val:": Optional = 8"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"frame_ids",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"latents",val:": Optional = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": Optional = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Optional = None"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/cross_attention.py" rel="nofollow">diffusers.cross_attention</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L938",returnDescription:`
<p><code>~pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoSDXLPipelineOutput</code> or
<code>tuple</code>: <code>~pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoSDXLPipelineOutput</code>
if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated images.</p>
`}}),_t=new M({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"add_text_embeds",val:""},{name:"add_time_ids",val:""},{name:"cross_attention_kwargs",val:" = None"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.
extra_step_kwargs &#x2014;
Extra_step_kwargs.
cross_attention_kwargs &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.
num_warmup_steps &#x2014;
number of warmup steps.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L853",returnDescription:`
<p>latents of backward process output at time timesteps[-1]</p>
`,returnType:`
<p>latents</p>
`}}),gt=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.TextToVideoZeroSDXLPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L448"}}),vt=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.TextToVideoZeroSDXLPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L440"}}),bt=new M({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L594"}}),Tt=new M({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L829",returnDescription:`
<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`
<p>x_t1</p>
`}}),xt=new J({}),yt=new M({props:{name:"class diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.images",description:`<strong>images</strong> (<code>[List[PIL.Image.Image]</code>, <code>np.ndarray</code>]) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>[List[bool]]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L182"}}),{c(){x=n("meta"),fe=a(),y=n("h1"),k=n("a"),go=n("span"),m(ue.$$.fragment),Yn=a(),Mt=n("span"),Mt.textContent=Os,Vo=a(),_e=n("p"),_e.innerHTML=Ks,Io=a(),ge=n("p"),ge.textContent=ea,Xo=a(),ve=n("ol"),ve.innerHTML=ta,Po=a(),be=n("p"),be.textContent=oa,So=a(),Te=n("p"),Te.innerHTML=na,Wo=a(),xe=n("p"),xe.textContent=sa,No=a(),ye=n("p"),ye.innerHTML=aa,$o=a(),we=n("p"),we.innerHTML=ia,Go=a(),U=n("h2"),L=n("a"),vo=n("span"),m(Me.$$.fragment),An=a(),Zt=n("span"),Zt.textContent=ra,zo=a(),V=n("h3"),D=n("a"),bo=n("span"),m(Ze.$$.fragment),Hn=a(),Jt=n("span"),Jt.textContent=la,Bo=a(),Je=n("p"),Je.textContent=da,Ro=a(),m(ke.$$.fragment),Lo=a(),je=n("p"),je.textContent=pa,Do=a(),Ce=n("ul"),Ce.innerHTML=ca,Eo=a(),Ue=n("p"),Ue.textContent=ma,Qo=a(),m(Ve.$$.fragment),Fo=a(),kt=n("ul"),E=n("li"),Q=n("h4"),F=n("a"),To=n("span"),m(Ie.$$.fragment),qn=a(),jt=n("span"),jt.textContent=ha,On=Hs(`
In order to use the SDXL model when generating a video from prompt, use the `),Ct=n("code"),Ct.textContent=fa,Kn=Hs(" pipeline:"),Yo=a(),m(Xe.$$.fragment),Ao=a(),I=n("h3"),Y=n("a"),xo=n("span"),m(Pe.$$.fragment),es=a(),Ut=n("span"),Ut.textContent=ua,Ho=Hs(`

To generate a video from prompt with additional pose control
`),Vt=n("ol"),Se=n("li"),It=n("p"),It.textContent=_a,ts=a(),m(We.$$.fragment),qo=a(),X=n("ol"),P=n("li"),Xt=n("p"),Xt.textContent=ga,os=a(),m(Ne.$$.fragment),ns=a(),Pt=n("p"),Pt.innerHTML=va,ss=a(),$e=n("li"),St=n("p"),St.innerHTML=ba,as=a(),m(Ge.$$.fragment),Oo=a(),Wt=n("ul"),S=n("li"),A=n("h4"),H=n("a"),yo=n("span"),m(ze.$$.fragment),is=a(),Nt=n("span"),Nt.textContent=Ta,rs=a(),$t=n("p"),$t.textContent=xa,ls=a(),m(Be.$$.fragment),Ko=a(),W=n("h3"),q=n("a"),wo=n("span"),m(Re.$$.fragment),ds=a(),Gt=n("span"),Gt.textContent=ya,en=a(),Le=n("p"),Le.innerHTML=wa,tn=a(),N=n("h3"),O=n("a"),Mo=n("span"),m(De.$$.fragment),ps=a(),zt=n("span"),zt.textContent=Ma,on=a(),Ee=n("p"),Ee.innerHTML=Za,nn=a(),j=n("ol"),Qe=n("li"),Bt=n("p"),Bt.textContent=Ja,cs=a(),m(Fe.$$.fragment),ms=a(),Ye=n("li"),Rt=n("p"),Rt.textContent=ka,hs=a(),m(Ae.$$.fragment),fs=a(),He=n("li"),Lt=n("p"),Lt.innerHTML=ja,us=a(),m(qe.$$.fragment),sn=a(),$=n("h3"),K=n("a"),Zo=n("span"),m(Oe.$$.fragment),_s=a(),Dt=n("span"),Dt.textContent=Ca,an=a(),Ke=n("p"),Ke.innerHTML=Ua,rn=a(),C=n("ol"),et=n("li"),Et=n("p"),Et.textContent=Va,gs=a(),m(tt.$$.fragment),vs=a(),ot=n("li"),Qt=n("p"),Qt.textContent=Ia,bs=a(),m(nt.$$.fragment),Ts=a(),st=n("li"),Ft=n("p"),Ft.innerHTML=Xa,xs=a(),m(at.$$.fragment),ln=a(),it=n("p"),it.innerHTML=Pa,dn=a(),m(ee.$$.fragment),pn=a(),G=n("h2"),te=n("a"),Jo=n("span"),m(rt.$$.fragment),ys=a(),Yt=n("span"),Yt.textContent=Sa,cn=a(),b=n("div"),m(lt.$$.fragment),ws=a(),At=n("p"),At.textContent=Wa,Ms=a(),Ht=n("p"),Ht.innerHTML=Na,Zs=a(),oe=n("div"),m(dt.$$.fragment),Js=a(),qt=n("p"),qt.textContent=$a,ks=a(),ne=n("div"),m(pt.$$.fragment),js=a(),Ot=n("p"),Ot.textContent=Ga,Cs=a(),se=n("div"),m(ct.$$.fragment),Us=a(),Kt=n("p"),Kt.textContent=za,Vs=a(),ae=n("div"),m(mt.$$.fragment),Is=a(),eo=n("p"),eo.textContent=Ba,mn=a(),z=n("h2"),ie=n("a"),ko=n("span"),m(ht.$$.fragment),Xs=a(),to=n("span"),to.textContent=Ra,hn=a(),v=n("div"),m(ft.$$.fragment),Ps=a(),oo=n("p"),oo.textContent=La,Ss=a(),no=n("p"),no.innerHTML=Da,Ws=a(),re=n("div"),m(ut.$$.fragment),Ns=a(),so=n("p"),so.textContent=Ea,$s=a(),le=n("div"),m(_t.$$.fragment),Gs=a(),ao=n("p"),ao.textContent=Qa,zs=a(),de=n("div"),m(gt.$$.fragment),Bs=a(),io=n("p"),io.innerHTML=Fa,Rs=a(),pe=n("div"),m(vt.$$.fragment),Ls=a(),ro=n("p"),ro.textContent=Ya,Ds=a(),ce=n("div"),m(bt.$$.fragment),Es=a(),lo=n("p"),lo.textContent=Aa,Qs=a(),me=n("div"),m(Tt.$$.fragment),Fs=a(),po=n("p"),po.textContent=Ha,fn=a(),B=n("h2"),he=n("a"),jo=n("span"),m(xt.$$.fragment),Ys=a(),co=n("span"),co.textContent=qa,un=a(),R=n("div"),m(yt.$$.fragment),As=a(),mo=n("p"),mo.textContent=Oa,this.h()},l(e){const r=Vi("svelte-1phssyn",document.head);x=s(r,"META",{name:!0,content:!0}),r.forEach(o),fe=i(e),y=s(e,"H1",{class:!0});var wt=d(y);k=s(wt,"A",{id:!0,class:!0,href:!0});var Ka=d(k);go=s(Ka,"SPAN",{});var ei=d(go);h(ue.$$.fragment,ei),ei.forEach(o),Ka.forEach(o),Yn=i(wt),Mt=s(wt,"SPAN",{"data-svelte-h":!0}),c(Mt)!=="svelte-1s0pta8"&&(Mt.textContent=Os),wt.forEach(o),Vo=i(e),_e=s(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-16xpzkf"&&(_e.innerHTML=Ks),Io=i(e),ge=s(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1jaz0ks"&&(ge.textContent=ea),Xo=i(e),ve=s(e,"OL",{"data-svelte-h":!0}),c(ve)!=="svelte-19ca1wn"&&(ve.innerHTML=ta),Po=i(e),be=s(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-yhxhyq"&&(be.textContent=oa),So=i(e),Te=s(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-uupw0l"&&(Te.innerHTML=na),Wo=i(e),xe=s(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1cwsb16"&&(xe.textContent=sa),No=i(e),ye=s(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1rtg145"&&(ye.innerHTML=aa),$o=i(e),we=s(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-u78olw"&&(we.innerHTML=ia),Go=i(e),U=s(e,"H2",{class:!0});var gn=d(U);L=s(gn,"A",{id:!0,class:!0,href:!0});var ti=d(L);vo=s(ti,"SPAN",{});var oi=d(vo);h(Me.$$.fragment,oi),oi.forEach(o),ti.forEach(o),An=i(gn),Zt=s(gn,"SPAN",{"data-svelte-h":!0}),c(Zt)!=="svelte-11riiwe"&&(Zt.textContent=ra),gn.forEach(o),zo=i(e),V=s(e,"H3",{class:!0});var vn=d(V);D=s(vn,"A",{id:!0,class:!0,href:!0});var ni=d(D);bo=s(ni,"SPAN",{});var si=d(bo);h(Ze.$$.fragment,si),si.forEach(o),ni.forEach(o),Hn=i(vn),Jt=s(vn,"SPAN",{"data-svelte-h":!0}),c(Jt)!=="svelte-1r90w1e"&&(Jt.textContent=la),vn.forEach(o),Bo=i(e),Je=s(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1dpixty"&&(Je.textContent=da),Ro=i(e),h(ke.$$.fragment,e),Lo=i(e),je=s(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-rs2kss"&&(je.textContent=pa),Do=i(e),Ce=s(e,"UL",{"data-svelte-h":!0}),c(Ce)!=="svelte-1na1mhs"&&(Ce.innerHTML=ca),Eo=i(e),Ue=s(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1xdujjh"&&(Ue.textContent=ma),Qo=i(e),h(Ve.$$.fragment,e),Fo=i(e),kt=s(e,"UL",{});var ai=d(kt);E=s(ai,"LI",{});var Co=d(E);Q=s(Co,"H4",{class:!0});var bn=d(Q);F=s(bn,"A",{id:!0,class:!0,href:!0});var ii=d(F);To=s(ii,"SPAN",{});var ri=d(To);h(Ie.$$.fragment,ri),ri.forEach(o),ii.forEach(o),qn=i(bn),jt=s(bn,"SPAN",{"data-svelte-h":!0}),c(jt)!=="svelte-7rjvxh"&&(jt.textContent=ha),bn.forEach(o),On=qs(Co,`
In order to use the SDXL model when generating a video from prompt, use the `),Ct=s(Co,"CODE",{"data-svelte-h":!0}),c(Ct)!=="svelte-7o0i0w"&&(Ct.textContent=fa),Kn=qs(Co," pipeline:"),Co.forEach(o),ai.forEach(o),Yo=i(e),h(Xe.$$.fragment,e),Ao=i(e),I=s(e,"H3",{class:!0});var Tn=d(I);Y=s(Tn,"A",{id:!0,class:!0,href:!0});var li=d(Y);xo=s(li,"SPAN",{});var di=d(xo);h(Pe.$$.fragment,di),di.forEach(o),li.forEach(o),es=i(Tn),Ut=s(Tn,"SPAN",{"data-svelte-h":!0}),c(Ut)!=="svelte-1eyoz7y"&&(Ut.textContent=ua),Tn.forEach(o),Ho=qs(e,`

To generate a video from prompt with additional pose control
`),Vt=s(e,"OL",{});var pi=d(Vt);Se=s(pi,"LI",{});var xn=d(Se);It=s(xn,"P",{"data-svelte-h":!0}),c(It)!=="svelte-1xo2nq1"&&(It.textContent=_a),ts=i(xn),h(We.$$.fragment,xn),xn.forEach(o),pi.forEach(o),qo=i(e),X=s(e,"OL",{start:!0});var yn=d(X);P=s(yn,"LI",{});var ho=d(P);Xt=s(ho,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-7pm43o"&&(Xt.textContent=ga),os=i(ho),h(Ne.$$.fragment,ho),ns=i(ho),Pt=s(ho,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-mij11h"&&(Pt.innerHTML=va),ho.forEach(o),ss=i(yn),$e=s(yn,"LI",{});var wn=d($e);St=s(wn,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1wsv5bt"&&(St.innerHTML=ba),as=i(wn),h(Ge.$$.fragment,wn),wn.forEach(o),yn.forEach(o),Oo=i(e),Wt=s(e,"UL",{});var ci=d(Wt);S=s(ci,"LI",{});var fo=d(S);A=s(fo,"H4",{class:!0});var Mn=d(A);H=s(Mn,"A",{id:!0,class:!0,href:!0});var mi=d(H);yo=s(mi,"SPAN",{});var hi=d(yo);h(ze.$$.fragment,hi),hi.forEach(o),mi.forEach(o),is=i(Mn),Nt=s(Mn,"SPAN",{"data-svelte-h":!0}),c(Nt)!=="svelte-7rjvxh"&&(Nt.textContent=Ta),Mn.forEach(o),rs=i(fo),$t=s(fo,"P",{"data-svelte-h":!0}),c($t)!=="svelte-bcy3mo"&&($t.textContent=xa),ls=i(fo),h(Be.$$.fragment,fo),fo.forEach(o),ci.forEach(o),Ko=i(e),W=s(e,"H3",{class:!0});var Zn=d(W);q=s(Zn,"A",{id:!0,class:!0,href:!0});var fi=d(q);wo=s(fi,"SPAN",{});var ui=d(wo);h(Re.$$.fragment,ui),ui.forEach(o),fi.forEach(o),ds=i(Zn),Gt=s(Zn,"SPAN",{"data-svelte-h":!0}),c(Gt)!=="svelte-12hvvyi"&&(Gt.textContent=ya),Zn.forEach(o),en=i(e),Le=s(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1fgx3w6"&&(Le.innerHTML=wa),tn=i(e),N=s(e,"H3",{class:!0});var Jn=d(N);O=s(Jn,"A",{id:!0,class:!0,href:!0});var _i=d(O);Mo=s(_i,"SPAN",{});var gi=d(Mo);h(De.$$.fragment,gi),gi.forEach(o),_i.forEach(o),ps=i(Jn),zt=s(Jn,"SPAN",{"data-svelte-h":!0}),c(zt)!=="svelte-1n8ysyd"&&(zt.textContent=Ma),Jn.forEach(o),on=i(e),Ee=s(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-o0vmiz"&&(Ee.innerHTML=Za),nn=i(e),j=s(e,"OL",{});var uo=d(j);Qe=s(uo,"LI",{});var kn=d(Qe);Bt=s(kn,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-1xo2nq1"&&(Bt.textContent=Ja),cs=i(kn),h(Fe.$$.fragment,kn),kn.forEach(o),ms=i(uo),Ye=s(uo,"LI",{});var jn=d(Ye);Rt=s(jn,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-1wln6n0"&&(Rt.textContent=ka),hs=i(jn),h(Ae.$$.fragment,jn),jn.forEach(o),fs=i(uo),He=s(uo,"LI",{});var Cn=d(He);Lt=s(Cn,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-14jy04z"&&(Lt.innerHTML=ja),us=i(Cn),h(qe.$$.fragment,Cn),Cn.forEach(o),uo.forEach(o),sn=i(e),$=s(e,"H3",{class:!0});var Un=d($);K=s(Un,"A",{id:!0,class:!0,href:!0});var vi=d(K);Zo=s(vi,"SPAN",{});var bi=d(Zo);h(Oe.$$.fragment,bi),bi.forEach(o),vi.forEach(o),_s=i(Un),Dt=s(Un,"SPAN",{"data-svelte-h":!0}),c(Dt)!=="svelte-1rhjl1"&&(Dt.textContent=Ca),Un.forEach(o),an=i(e),Ke=s(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-x1pkth"&&(Ke.innerHTML=Ua),rn=i(e),C=s(e,"OL",{});var _o=d(C);et=s(_o,"LI",{});var Vn=d(et);Et=s(Vn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-1xo2nq1"&&(Et.textContent=Va),gs=i(Vn),h(tt.$$.fragment,Vn),Vn.forEach(o),vs=i(_o),ot=s(_o,"LI",{});var In=d(ot);Qt=s(In,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-1wln6n0"&&(Qt.textContent=Ia),bs=i(In),h(nt.$$.fragment,In),In.forEach(o),Ts=i(_o),st=s(_o,"LI",{});var Xn=d(st);Ft=s(Xn,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-okpmrc"&&(Ft.innerHTML=Xa),xs=i(Xn),h(at.$$.fragment,Xn),Xn.forEach(o),_o.forEach(o),ln=i(e),it=s(e,"P",{"data-svelte-h":!0}),c(it)!=="svelte-18tnclt"&&(it.innerHTML=Pa),dn=i(e),h(ee.$$.fragment,e),pn=i(e),G=s(e,"H2",{class:!0});var Pn=d(G);te=s(Pn,"A",{id:!0,class:!0,href:!0});var Ti=d(te);Jo=s(Ti,"SPAN",{});var xi=d(Jo);h(rt.$$.fragment,xi),xi.forEach(o),Ti.forEach(o),ys=i(Pn),Yt=s(Pn,"SPAN",{"data-svelte-h":!0}),c(Yt)!=="svelte-t9fw4i"&&(Yt.textContent=Sa),Pn.forEach(o),cn=i(e),b=s(e,"DIV",{class:!0});var w=d(b);h(lt.$$.fragment,w),ws=i(w),At=s(w,"P",{"data-svelte-h":!0}),c(At)!=="svelte-1q57293"&&(At.textContent=Wa),Ms=i(w),Ht=s(w,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-s6xyvg"&&(Ht.innerHTML=Na),Zs=i(w),oe=s(w,"DIV",{class:!0});var Sn=d(oe);h(dt.$$.fragment,Sn),Js=i(Sn),qt=s(Sn,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-50j04k"&&(qt.textContent=$a),Sn.forEach(o),ks=i(w),ne=s(w,"DIV",{class:!0});var Wn=d(ne);h(pt.$$.fragment,Wn),js=i(Wn),Ot=s(Wn,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-1cxzr1t"&&(Ot.textContent=Ga),Wn.forEach(o),Cs=i(w),se=s(w,"DIV",{class:!0});var Nn=d(se);h(ct.$$.fragment,Nn),Us=i(Nn),Kt=s(Nn,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-16q0ax1"&&(Kt.textContent=za),Nn.forEach(o),Vs=i(w),ae=s(w,"DIV",{class:!0});var $n=d(ae);h(mt.$$.fragment,$n),Is=i($n),eo=s($n,"P",{"data-svelte-h":!0}),c(eo)!=="svelte-1d8vbe1"&&(eo.textContent=Ba),$n.forEach(o),w.forEach(o),mn=i(e),z=s(e,"H2",{class:!0});var Gn=d(z);ie=s(Gn,"A",{id:!0,class:!0,href:!0});var yi=d(ie);ko=s(yi,"SPAN",{});var wi=d(ko);h(ht.$$.fragment,wi),wi.forEach(o),yi.forEach(o),Xs=i(Gn),to=s(Gn,"SPAN",{"data-svelte-h":!0}),c(to)!=="svelte-xhzgml"&&(to.textContent=Ra),Gn.forEach(o),hn=i(e),v=s(e,"DIV",{class:!0});var T=d(v);h(ft.$$.fragment,T),Ps=i(T),oo=s(T,"P",{"data-svelte-h":!0}),c(oo)!=="svelte-pyonrv"&&(oo.textContent=La),Ss=i(T),no=s(T,"P",{"data-svelte-h":!0}),c(no)!=="svelte-s6xyvg"&&(no.innerHTML=Da),Ws=i(T),re=s(T,"DIV",{class:!0});var zn=d(re);h(ut.$$.fragment,zn),Ns=i(zn),so=s(zn,"P",{"data-svelte-h":!0}),c(so)!=="svelte-v78lg8"&&(so.textContent=Ea),zn.forEach(o),$s=i(T),le=s(T,"DIV",{class:!0});var Bn=d(le);h(_t.$$.fragment,Bn),Gs=i(Bn),ao=s(Bn,"P",{"data-svelte-h":!0}),c(ao)!=="svelte-jp6j47"&&(ao.textContent=Qa),Bn.forEach(o),zs=i(T),de=s(T,"DIV",{class:!0});var Rn=d(de);h(gt.$$.fragment,Rn),Bs=i(Rn),io=s(Rn,"P",{"data-svelte-h":!0}),c(io)!=="svelte-1s3c06i"&&(io.innerHTML=Fa),Rn.forEach(o),Rs=i(T),pe=s(T,"DIV",{class:!0});var Ln=d(pe);h(vt.$$.fragment,Ln),Ls=i(Ln),ro=s(Ln,"P",{"data-svelte-h":!0}),c(ro)!=="svelte-14bnrb6"&&(ro.textContent=Ya),Ln.forEach(o),Ds=i(T),ce=s(T,"DIV",{class:!0});var Dn=d(ce);h(bt.$$.fragment,Dn),Es=i(Dn),lo=s(Dn,"P",{"data-svelte-h":!0}),c(lo)!=="svelte-16q0ax1"&&(lo.textContent=Aa),Dn.forEach(o),Qs=i(T),me=s(T,"DIV",{class:!0});var En=d(me);h(Tt.$$.fragment,En),Fs=i(En),po=s(En,"P",{"data-svelte-h":!0}),c(po)!=="svelte-1d8vbe1"&&(po.textContent=Ha),En.forEach(o),T.forEach(o),fn=i(e),B=s(e,"H2",{class:!0});var Qn=d(B);he=s(Qn,"A",{id:!0,class:!0,href:!0});var Mi=d(he);jo=s(Mi,"SPAN",{});var Zi=d(jo);h(xt.$$.fragment,Zi),Zi.forEach(o),Mi.forEach(o),Ys=i(Qn),co=s(Qn,"SPAN",{"data-svelte-h":!0}),c(co)!=="svelte-s99n5h"&&(co.textContent=qa),Qn.forEach(o),un=i(e),R=s(e,"DIV",{class:!0});var Fn=d(R);h(yt.$$.fragment,Fn),As=i(Fn),mo=s(Fn,"P",{"data-svelte-h":!0}),c(mo)!=="svelte-1dgz4ei"&&(mo.textContent=Oa),Fn.forEach(o),this.h()},h(){p(x,"name","hf:doc:metadata"),p(x,"content",JSON.stringify(Si)),p(k,"id","text2videozero"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#text2videozero"),p(y,"class","relative group"),p(L,"id","usage-example"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#usage-example"),p(U,"class","relative group"),p(D,"id","texttovideo"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#texttovideo"),p(V,"class","relative group"),p(F,"id","sdxl-support"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#sdxl-support"),p(Q,"class","relative group"),p(Y,"id","texttovideo-with-pose-control"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#texttovideo-with-pose-control"),p(I,"class","relative group"),p(X,"start","2"),p(H,"id","sdxl-support"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#sdxl-support"),p(A,"class","relative group"),p(q,"id","texttovideo-with-edge-control"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#texttovideo-with-edge-control"),p(W,"class","relative group"),p(O,"id","video-instructpix2pix"),p(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(O,"href","#video-instructpix2pix"),p(N,"class","relative group"),p(K,"id","dreambooth-specialization"),p(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(K,"href","#dreambooth-specialization"),p($,"class","relative group"),p(te,"id","diffusers.TextToVideoZeroPipeline"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#diffusers.TextToVideoZeroPipeline"),p(G,"class","relative group"),p(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ie,"id","diffusers.TextToVideoZeroSDXLPipeline"),p(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ie,"href","#diffusers.TextToVideoZeroSDXLPipeline"),p(z,"class","relative group"),p(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(he,"id","diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"),p(B,"class","relative group"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,x),l(e,fe,r),l(e,y,r),t(y,k),t(k,go),f(ue,go,null),t(y,Yn),t(y,Mt),l(e,Vo,r),l(e,_e,r),l(e,Io,r),l(e,ge,r),l(e,Xo,r),l(e,ve,r),l(e,Po,r),l(e,be,r),l(e,So,r),l(e,Te,r),l(e,Wo,r),l(e,xe,r),l(e,No,r),l(e,ye,r),l(e,$o,r),l(e,we,r),l(e,Go,r),l(e,U,r),t(U,L),t(L,vo),f(Me,vo,null),t(U,An),t(U,Zt),l(e,zo,r),l(e,V,r),t(V,D),t(D,bo),f(Ze,bo,null),t(V,Hn),t(V,Jt),l(e,Bo,r),l(e,Je,r),l(e,Ro,r),f(ke,e,r),l(e,Lo,r),l(e,je,r),l(e,Do,r),l(e,Ce,r),l(e,Eo,r),l(e,Ue,r),l(e,Qo,r),f(Ve,e,r),l(e,Fo,r),l(e,kt,r),t(kt,E),t(E,Q),t(Q,F),t(F,To),f(Ie,To,null),t(Q,qn),t(Q,jt),t(E,On),t(E,Ct),t(E,Kn),l(e,Yo,r),f(Xe,e,r),l(e,Ao,r),l(e,I,r),t(I,Y),t(Y,xo),f(Pe,xo,null),t(I,es),t(I,Ut),l(e,Ho,r),l(e,Vt,r),t(Vt,Se),t(Se,It),t(Se,ts),f(We,Se,null),l(e,qo,r),l(e,X,r),t(X,P),t(P,Xt),t(P,os),f(Ne,P,null),t(P,ns),t(P,Pt),t(X,ss),t(X,$e),t($e,St),t($e,as),f(Ge,$e,null),l(e,Oo,r),l(e,Wt,r),t(Wt,S),t(S,A),t(A,H),t(H,yo),f(ze,yo,null),t(A,is),t(A,Nt),t(S,rs),t(S,$t),t(S,ls),f(Be,S,null),l(e,Ko,r),l(e,W,r),t(W,q),t(q,wo),f(Re,wo,null),t(W,ds),t(W,Gt),l(e,en,r),l(e,Le,r),l(e,tn,r),l(e,N,r),t(N,O),t(O,Mo),f(De,Mo,null),t(N,ps),t(N,zt),l(e,on,r),l(e,Ee,r),l(e,nn,r),l(e,j,r),t(j,Qe),t(Qe,Bt),t(Qe,cs),f(Fe,Qe,null),t(j,ms),t(j,Ye),t(Ye,Rt),t(Ye,hs),f(Ae,Ye,null),t(j,fs),t(j,He),t(He,Lt),t(He,us),f(qe,He,null),l(e,sn,r),l(e,$,r),t($,K),t(K,Zo),f(Oe,Zo,null),t($,_s),t($,Dt),l(e,an,r),l(e,Ke,r),l(e,rn,r),l(e,C,r),t(C,et),t(et,Et),t(et,gs),f(tt,et,null),t(C,vs),t(C,ot),t(ot,Qt),t(ot,bs),f(nt,ot,null),t(C,Ts),t(C,st),t(st,Ft),t(st,xs),f(at,st,null),l(e,ln,r),l(e,it,r),l(e,dn,r),f(ee,e,r),l(e,pn,r),l(e,G,r),t(G,te),t(te,Jo),f(rt,Jo,null),t(G,ys),t(G,Yt),l(e,cn,r),l(e,b,r),f(lt,b,null),t(b,ws),t(b,At),t(b,Ms),t(b,Ht),t(b,Zs),t(b,oe),f(dt,oe,null),t(oe,Js),t(oe,qt),t(b,ks),t(b,ne),f(pt,ne,null),t(ne,js),t(ne,Ot),t(b,Cs),t(b,se),f(ct,se,null),t(se,Us),t(se,Kt),t(b,Vs),t(b,ae),f(mt,ae,null),t(ae,Is),t(ae,eo),l(e,mn,r),l(e,z,r),t(z,ie),t(ie,ko),f(ht,ko,null),t(z,Xs),t(z,to),l(e,hn,r),l(e,v,r),f(ft,v,null),t(v,Ps),t(v,oo),t(v,Ss),t(v,no),t(v,Ws),t(v,re),f(ut,re,null),t(re,Ns),t(re,so),t(v,$s),t(v,le),f(_t,le,null),t(le,Gs),t(le,ao),t(v,zs),t(v,de),f(gt,de,null),t(de,Bs),t(de,io),t(v,Rs),t(v,pe),f(vt,pe,null),t(pe,Ls),t(pe,ro),t(v,Ds),t(v,ce),f(bt,ce,null),t(ce,Es),t(ce,lo),t(v,Qs),t(v,me),f(Tt,me,null),t(me,Fs),t(me,po),l(e,fn,r),l(e,B,r),t(B,he),t(he,jo),f(xt,jo,null),t(B,Ys),t(B,co),l(e,un,r),l(e,R,r),f(yt,R,null),t(R,As),t(R,mo),_n=!0},p(e,[r]){const wt={};r&2&&(wt.$$scope={dirty:r,ctx:e}),ee.$set(wt)},i(e){_n||(u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(Ze.$$.fragment,e),u(ke.$$.fragment,e),u(Ve.$$.fragment,e),u(Ie.$$.fragment,e),u(Xe.$$.fragment,e),u(Pe.$$.fragment,e),u(We.$$.fragment,e),u(Ne.$$.fragment,e),u(Ge.$$.fragment,e),u(ze.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(De.$$.fragment,e),u(Fe.$$.fragment,e),u(Ae.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(ee.$$.fragment,e),u(rt.$$.fragment,e),u(lt.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),u(ut.$$.fragment,e),u(_t.$$.fragment,e),u(gt.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(Tt.$$.fragment,e),u(xt.$$.fragment,e),u(yt.$$.fragment,e),_n=!0)},o(e){_(ue.$$.fragment,e),_(Me.$$.fragment,e),_(Ze.$$.fragment,e),_(ke.$$.fragment,e),_(Ve.$$.fragment,e),_(Ie.$$.fragment,e),_(Xe.$$.fragment,e),_(Pe.$$.fragment,e),_(We.$$.fragment,e),_(Ne.$$.fragment,e),_(Ge.$$.fragment,e),_(ze.$$.fragment,e),_(Be.$$.fragment,e),_(Re.$$.fragment,e),_(De.$$.fragment,e),_(Fe.$$.fragment,e),_(Ae.$$.fragment,e),_(qe.$$.fragment,e),_(Oe.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(ee.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(pt.$$.fragment,e),_(ct.$$.fragment,e),_(mt.$$.fragment,e),_(ht.$$.fragment,e),_(ft.$$.fragment,e),_(ut.$$.fragment,e),_(_t.$$.fragment,e),_(gt.$$.fragment,e),_(vt.$$.fragment,e),_(bt.$$.fragment,e),_(Tt.$$.fragment,e),_(xt.$$.fragment,e),_(yt.$$.fragment,e),_n=!1},d(e){e&&(o(fe),o(y),o(Vo),o(_e),o(Io),o(ge),o(Xo),o(ve),o(Po),o(be),o(So),o(Te),o(Wo),o(xe),o(No),o(ye),o($o),o(we),o(Go),o(U),o(zo),o(V),o(Bo),o(Je),o(Ro),o(Lo),o(je),o(Do),o(Ce),o(Eo),o(Ue),o(Qo),o(Fo),o(kt),o(Yo),o(Ao),o(I),o(Ho),o(Vt),o(qo),o(X),o(Oo),o(Wt),o(Ko),o(W),o(en),o(Le),o(tn),o(N),o(on),o(Ee),o(nn),o(j),o(sn),o($),o(an),o(Ke),o(rn),o(C),o(ln),o(it),o(dn),o(pn),o(G),o(cn),o(b),o(mn),o(z),o(hn),o(v),o(fn),o(B),o(un),o(R)),o(x),g(ue),g(Me),g(Ze),g(ke,e),g(Ve,e),g(Ie),g(Xe,e),g(Pe),g(We),g(Ne),g(Ge),g(ze),g(Be),g(Re),g(De),g(Fe),g(Ae),g(qe),g(Oe),g(tt),g(nt),g(at),g(ee,e),g(rt),g(lt),g(dt),g(pt),g(ct),g(mt),g(ht),g(ft),g(ut),g(_t),g(gt),g(vt),g(bt),g(Tt),g(xt),g(yt)}}}const Si={local:"text2videozero",sections:[{local:"usage-example",sections:[{local:"texttovideo",title:"Text-To-Video"},{local:"texttovideo-with-pose-control",title:"Text-To-Video with Pose Control"},{local:"texttovideo-with-edge-control",title:"Text-To-Video with Edge Control"},{local:"video-instructpix2pix",title:"Video Instruct-Pix2Pix"},{local:"dreambooth-specialization",title:"DreamBooth specialization"}],title:"Usage example"},{local:"diffusers.TextToVideoZeroPipeline",title:"TextToVideoZeroPipeline"},{local:"diffusers.TextToVideoZeroSDXLPipeline",title:"TextToVideoZeroSDXLPipeline"},{local:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",title:"TextToVideoPipelineOutput"}],title:"Text2Video-Zero"};function Wi(Uo){return ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Li extends Ci{constructor(x){super(),Ui(this,x,Wi,Pi,Ji,{})}}export{Li as component};
