import{s as qo,o as Ao,n as R}from"../chunks/scheduler.182ea377.js";import{S as Ko,i as Oo,g as m,s as a,r as u,m as Eo,H as es,A as ts,h as c,f as i,c as r,j,u as h,n as So,B as os,x,k,y as s,a as v,v as g,d as M,t as b,w as y}from"../chunks/index.abf12888.js";import{T as Lo}from"../chunks/Tip.230e2334.js";import{D as G}from"../chunks/Docstring.93f6f462.js";import{C as Q}from"../chunks/CodeBlock.57fe6e13.js";import{E as D}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as wt}from"../chunks/Heading.16916d63.js";function ss($){let o,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=m("p"),o.textContent=_},l(l){o=c(l,"P",{"data-svelte-h":!0}),x(o)!=="svelte-17p1lpg"&&(o.textContent=_)},m(l,n){v(l,o,n)},p:R,d(l){l&&i(o)}}}function ns($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQW1vZGVsJTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTElMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oYXR0ZW50aW9uX29wJTNETWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function as($){let o,_=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>. You can also activate the special
<a href="https://huggingface.co/diffusers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to use this method in a
firewalled environment.`;return{c(){o=m("p"),o.innerHTML=_},l(l){o=c(l,"P",{"data-svelte-h":!0}),x(o)!=="svelte-19a77yg"&&(o.innerHTML=_)},m(l,n){v(l,o,n)},p:R,d(l){l&&i(o)}}}function rs($){let o,_="Example:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-11lpom8"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function ls($){let o,_="If you get the error message below, you need to finetune the weights for your downstream task:",l,n,d;return n=new Q({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-xueb0m"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function is($){let o,_="Example:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKSUwQXVuZXQubnVtX3BhcmFtZXRlcnMob25seV90cmFpbmFibGUlM0RUcnVlKSUwQTg1OTUyMDk2NA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
unet = UNet2DConditionModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)
unet.num_parameters(only_trainable=<span class="hljs-literal">True</span>)
<span class="hljs-number">859520964</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-11lpom8"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function ds($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyME1vZGVsJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSolMjAoZm9yJTIwZXhhbXBsZSUyMHB1cnBvc2VzJTJDJTIwbm90JTIwcnVubmFibGUpLiUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)* (for example purposes, not runnable).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function ms($){let o,_="If you get the error message below, you need to finetune the weights for your downstream task:",l,n,d;return n=new Q({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-xueb0m"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function cs($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtZXRlcnMlMjB3aWxsJTIwYmUlMjBpbiUyMGZwMzIlMjBwcmVjaXNpb24lMkMlMjB0byUyMGNhc3QlMjB0aGVzZSUyMHRvJTIwYmZsb2F0MTYlMjBwcmVjaXNpb24lMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19iZjE2KHBhcmFtcyklMEElMjMlMjBJZiUyMHlvdSUyMGRvbid0JTIwd2FudCUyMHRvJTIwY2FzdCUyMGNlcnRhaW4lMjBwYXJhbWV0ZXJzJTIwKGZvciUyMGV4YW1wbGUlMjBsYXllciUyMG5vcm0lMjBiaWFzJTIwYW5kJTIwc2NhbGUpJTBBJTIzJTIwdGhlbiUyMHBhc3MlMjB0aGUlMjBtYXNrJTIwYXMlMjBmb2xsb3dzJTBBZnJvbSUyMGZsYXglMjBpbXBvcnQlMjB0cmF2ZXJzZV91dGlsJTBBJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQWZsYXRfcGFyYW1zJTIwJTNEJTIwdHJhdmVyc2VfdXRpbC5mbGF0dGVuX2RpY3QocGFyYW1zKSUwQW1hc2slMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwKHBhdGglNUItMiU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyYmlhcyUyMiklMjBhbmQlMjBwYXRoJTVCLTIlM0ElNUQlMjAhJTNEJTIwKCUyMkxheWVyTm9ybSUyMiUyQyUyMCUyMnNjYWxlJTIyKSklMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmbGF0X3BhcmFtcyUwQSU3RCUwQW1hc2slMjAlM0QlMjB0cmF2ZXJzZV91dGlsLnVuZmxhdHRlbl9kaWN0KG1hc2spJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fYmYxNihwYXJhbXMlMkMlMjBtYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model parameters will be in fp32 precision, to cast these to bfloat16 precision</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params, mask)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function ps($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtcyUyMHdpbGwlMjBiZSUyMGluJTIwZnAzMiUyQyUyMHRvJTIwY2FzdCUyMHRoZXNlJTIwdG8lMjBmbG9hdDE2JTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZnAxNihwYXJhbXMpJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwZG9uJ3QlMjB3YW50JTIwdG8lMjBjYXN0JTIwY2VydGFpbiUyMHBhcmFtZXRlcnMlMjAoZm9yJTIwZXhhbXBsZSUyMGxheWVyJTIwbm9ybSUyMGJpYXMlMjBhbmQlMjBzY2FsZSklMEElMjMlMjB0aGVuJTIwcGFzcyUyMHRoZSUyMG1hc2slMjBhcyUyMGZvbGxvd3MlMEFmcm9tJTIwZmxheCUyMGltcG9ydCUyMHRyYXZlcnNlX3V0aWwlMEElMEFtb2RlbCUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBZmxhdF9wYXJhbXMlMjAlM0QlMjB0cmF2ZXJzZV91dGlsLmZsYXR0ZW5fZGljdChwYXJhbXMpJTBBbWFzayUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAocGF0aCU1Qi0yJTVEJTIwISUzRCUyMCglMjJMYXllck5vcm0lMjIlMkMlMjAlMjJiaWFzJTIyKSUyMGFuZCUyMHBhdGglNUItMiUzQSU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyc2NhbGUlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhdGglMjBpbiUyMGZsYXRfcGFyYW1zJTBBJTdEJTBBbWFzayUyMCUzRCUyMHRyYXZlcnNlX3V0aWwudW5mbGF0dGVuX2RpY3QobWFzayklMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19mcDE2KHBhcmFtcyUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to cast these to float16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params, mask)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function fs($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMG1vZGVsJTIwcGFyYW1zJTIwd2lsbCUyMGJlJTIwaW4lMjBmcDMyJTJDJTIwdG8lMjBpbGx1c3RyYXRlJTIwdGhlJTIwdXNlJTIwb2YlMjB0aGlzJTIwbWV0aG9kJTJDJTBBJTIzJTIwd2UnbGwlMjBmaXJzdCUyMGNhc3QlMjB0byUyMGZwMTYlMjBhbmQlMjBiYWNrJTIwdG8lMjBmcDMyJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZjE2KHBhcmFtcyklMEElMjMlMjBub3clMjBjYXN0JTIwYmFjayUyMHRvJTIwZnAzMiUwQXBhcmFtcyUyMCUzRCUyMG1vZGVsLnRvX2ZwMzIocGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to illustrate the use of this method,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we&#x27;ll first cast to fp16 and back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_f16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now cast back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp32(params)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function us($){let o,_="Examples:",l,n,d;return n=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=_,l=a(),u(n.$$.fragment)},l(e){o=c(e,"P",{"data-svelte-h":!0}),x(o)!=="svelte-kvfsh7"&&(o.textContent=_),l=r(e),h(n.$$.fragment,e)},m(e,f){v(e,o,f),v(e,l,f),g(n,e,f),d=!0},p:R,i(e){d||(M(n.$$.fragment,e),d=!0)},o(e){b(n.$$.fragment,e),d=!1},d(e){e&&(i(o),i(l)),y(n,e)}}}function hs($){let o,_,l,n,d,e,f,$t,pt,Po='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_{\\theta}(x_{t-1}|x_{t})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ft,ut,pe,vo='All models are built from the base <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> class which is a <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow"><code>torch.nn.Module</code></a> providing basic functionality for saving and loading models, locally and from the Hugging Face Hub.',ht,fe,gt,w,ue,Tt,Re,xo="Base class for all models.",Ut,Xe,wo=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,Jt,He,$o='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>',jt,S,he,kt,Ne,To=`Deactivates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,Zt,L,ge,Gt,ze,Uo='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ct,P,Me,Ft,Ye,Jo=`Activates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,It,F,be,Wt,De,jo='Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Bt,Qe,ko=`When this option is enabled, you should observe lower GPU memory usage and a potential speed up during
inference. Speed up during training is not guaranteed.`,Vt,q,Rt,A,Xt,Z,ye,Ht,Ee,Zo="Instantiate a pretrained PyTorch model from a pretrained model configuration.",Nt,Se,Go=`The model is set in evaluation mode - <code>model.eval()</code> - by default, and dropout modules are deactivated. To
train the model, set it back in training mode with <code>model.train()</code>.`,zt,K,Yt,O,Dt,ee,Qt,N,_e,Et,Le,Co="Get number of (trainable or non-embedding) parameters in the module.",St,te,Lt,oe,ve,Pt,Pe,Fo=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> class method.`,Mt,xe,bt,U,we,qt,qe,Io="Base class for all Flax models.",At,Ae,Wo=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin">FlaxModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,Kt,Ke,Bo='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>',Ot,W,$e,eo,Oe,Vo="Instantiate a pretrained Flax model from a pretrained model configuration.",to,se,oo,ne,so,ae,Te,no,et,Ro=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.from_pretrained">from_pretrained()</a> class method.`,ao,B,Ue,ro,tt,Xo=`Cast the floating-point <code>params</code> to <code>jax.numpy.bfloat16</code>. This returns a new <code>params</code> tree and does not cast
the <code>params</code> in place.`,lo,ot,Ho=`This method can be used on a TPU to explicitly convert the model parameters to bfloat16 precision to do full
half-precision training or to save weights in bfloat16 for inference in order to save memory and improve speed.`,io,re,mo,V,Je,co,st,No=`Cast the floating-point <code>params</code> to <code>jax.numpy.float16</code>. This returns a new <code>params</code> tree and does not cast the
<code>params</code> in place.`,po,nt,zo=`This method can be used on a GPU to explicitly convert the model parameters to float16 precision to do full
half-precision training or to save weights in float16 for inference in order to save memory and improve speed.`,fo,le,uo,z,je,ho,at,Yo=`Cast the floating-point <code>params</code> to <code>jax.numpy.float32</code>. This method can be used to explicitly convert the
model parameters to fp32 precision. This returns a new <code>params</code> tree and does not cast the <code>params</code> in place.`,go,ie,yt,ke,_t,X,Ze,Mo,rt,Do="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",bo,Y,Ge,yo,lt,Qo="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",_o,de,vt,ct,xt;return d=new wt({props:{title:"Models",local:"models",headingTag:"h1"}}),fe=new wt({props:{title:"ModelMixin",local:"diffusers.ModelMixin",headingTag:"h2"}}),ue=new G({props:{name:"class diffusers.ModelMixin",anchor:"diffusers.ModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L184"}}),he=new G({props:{name:"disable_gradient_checkpointing",anchor:"diffusers.ModelMixin.disable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L236"}}),ge=new G({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L297"}}),Me=new G({props:{name:"enable_gradient_checkpointing",anchor:"diffusers.ModelMixin.enable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L227"}}),be=new G({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L261"}}),q=new Lo({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:$}}}),A=new D({props:{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ns]},$$scope:{ctx:$}}}),ye=new G({props:{name:"from_pretrained",anchor:"diffusers.ModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.ModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.ModelMixin.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.ModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.ModelMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.ModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.ModelMixin.from_pretrained.output_loading_info",description:`<strong>output_loading_info</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info"},{anchor:"diffusers.ModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.ModelMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.ModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.ModelMixin.from_pretrained.from_flax",description:`<strong>from_flax</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a Flax checkpoint save file.`,name:"from_flax"},{anchor:"diffusers.ModelMixin.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.ModelMixin.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.ModelMixin.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.ModelMixin.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if <code>device_map</code> contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.ModelMixin.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.ModelMixin.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified <code>variant</code> filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the <code>safetensors</code> weights are downloaded if they&#x2019;re available <strong>and</strong> if the
<code>safetensors</code> library is installed. If set to <code>True</code>, the model is forcibly loaded from <code>safetensors</code>
weights. If set to <code>False</code>, <code>safetensors</code> weights are not loaded.`,name:"use_safetensors"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L386"}}),K=new Lo({props:{$$slots:{default:[as]},$$scope:{ctx:$}}}),O=new D({props:{anchor:"diffusers.ModelMixin.from_pretrained.example",$$slots:{default:[rs]},$$scope:{ctx:$}}}),ee=new D({props:{anchor:"diffusers.ModelMixin.from_pretrained.example-2",$$slots:{default:[ls]},$$scope:{ctx:$}}}),_e=new G({props:{name:"num_parameters",anchor:"diffusers.ModelMixin.num_parameters",parameters:[{name:"only_trainable",val:": bool = False"},{name:"exclude_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.ModelMixin.num_parameters.only_trainable",description:`<strong>only_trainable</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of trainable parameters.`,name:"only_trainable"},{anchor:"diffusers.ModelMixin.num_parameters.exclude_embeddings",description:`<strong>exclude_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of non-embedding parameters.`,name:"exclude_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The number of parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),te=new D({props:{anchor:"diffusers.ModelMixin.num_parameters.example",$$slots:{default:[is]},$$scope:{ctx:$}}}),ve=new G({props:{name:"save_pretrained",anchor:"diffusers.ModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"save_function",val:": typing.Optional[typing.Callable] = None"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.ModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.ModelMixin.save_pretrained.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.ModelMixin.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.ModelMixin.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face Hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.ModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L303"}}),xe=new wt({props:{title:"FlaxModelMixin",local:"diffusers.FlaxModelMixin",headingTag:"h2"}}),we=new G({props:{name:"class diffusers.FlaxModelMixin",anchor:"diffusers.FlaxModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L50"}}),$e=new G({props:{name:"from_pretrained",anchor:"diffusers.FlaxModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained model
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified, all the computation will be performed with the given <code>dtype</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>This only specifies the dtype of the <em>computation</em> and does not influence the dtype of model
parameters.</p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_fp16">to_fp16()</a> and
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_bf16">to_bf16()</a>.</p>

					</div>`,name:"dtype"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.model_args",description:`<strong>model_args</strong> (sequence of positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments are passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file.`,name:"from_pt"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it is loaded) and initiate the model (for
example, <code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>kwargs</code> are directly passed to the underlying
model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have already been
done).</li>
<li>If a configuration is not provided, <code>kwargs</code> are first passed to the configuration class
initialization function <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a>. Each key of the <code>kwargs</code> that corresponds
to a configuration attribute is used to override said attribute with the supplied <code>kwargs</code> value.
Remaining keys that do not correspond to any configuration attribute are passed to the underlying
model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L203"}}),se=new D({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example",$$slots:{default:[ds]},$$scope:{ctx:$}}}),ne=new D({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example-2",$$slots:{default:[ms]},$$scope:{ctx:$}}}),Te=new G({props:{name:"save_pretrained",anchor:"diffusers.FlaxModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"is_main_process",val:": bool = True"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L502"}}),Ue=new G({props:{name:"to_bf16",anchor:"diffusers.FlaxModelMixin.to_bf16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_bf16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_bf16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L95"}}),re=new D({props:{anchor:"diffusers.FlaxModelMixin.to_bf16.example",$$slots:{default:[cs]},$$scope:{ctx:$}}}),Je=new G({props:{name:"to_fp16",anchor:"diffusers.FlaxModelMixin.to_fp16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L161"}}),le=new D({props:{anchor:"diffusers.FlaxModelMixin.to_fp16.example",$$slots:{default:[ps]},$$scope:{ctx:$}}}),je=new G({props:{name:"to_fp32",anchor:"diffusers.FlaxModelMixin.to_fp32",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp32.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp32.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L134"}}),ie=new D({props:{anchor:"diffusers.FlaxModelMixin.to_fp32.example",$$slots:{default:[fs]},$$scope:{ctx:$}}}),ke=new wt({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ze=new G({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L361"}}),Ge=new G({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L390"}}),de=new D({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[us]},$$scope:{ctx:$}}}),{c(){o=m("meta"),_=a(),l=m("p"),n=a(),u(d.$$.fragment),e=a(),f=m("p"),$t=Eo("🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),pt=new es(!1),ft=Eo("."),ut=a(),pe=m("p"),pe.innerHTML=vo,ht=a(),u(fe.$$.fragment),gt=a(),w=m("div"),u(ue.$$.fragment),Tt=a(),Re=m("p"),Re.textContent=xo,Ut=a(),Xe=m("p"),Xe.innerHTML=wo,Jt=a(),He=m("ul"),He.innerHTML=$o,jt=a(),S=m("div"),u(he.$$.fragment),kt=a(),Ne=m("p"),Ne.innerHTML=To,Zt=a(),L=m("div"),u(ge.$$.fragment),Gt=a(),ze=m("p"),ze.innerHTML=Uo,Ct=a(),P=m("div"),u(Me.$$.fragment),Ft=a(),Ye=m("p"),Ye.innerHTML=Jo,It=a(),F=m("div"),u(be.$$.fragment),Wt=a(),De=m("p"),De.innerHTML=jo,Bt=a(),Qe=m("p"),Qe.textContent=ko,Vt=a(),u(q.$$.fragment),Rt=a(),u(A.$$.fragment),Xt=a(),Z=m("div"),u(ye.$$.fragment),Ht=a(),Ee=m("p"),Ee.textContent=Zo,Nt=a(),Se=m("p"),Se.innerHTML=Go,zt=a(),u(K.$$.fragment),Yt=a(),u(O.$$.fragment),Dt=a(),u(ee.$$.fragment),Qt=a(),N=m("div"),u(_e.$$.fragment),Et=a(),Le=m("p"),Le.textContent=Co,St=a(),u(te.$$.fragment),Lt=a(),oe=m("div"),u(ve.$$.fragment),Pt=a(),Pe=m("p"),Pe.innerHTML=Fo,Mt=a(),u(xe.$$.fragment),bt=a(),U=m("div"),u(we.$$.fragment),qt=a(),qe=m("p"),qe.textContent=Io,At=a(),Ae=m("p"),Ae.innerHTML=Wo,Kt=a(),Ke=m("ul"),Ke.innerHTML=Bo,Ot=a(),W=m("div"),u($e.$$.fragment),eo=a(),Oe=m("p"),Oe.textContent=Vo,to=a(),u(se.$$.fragment),oo=a(),u(ne.$$.fragment),so=a(),ae=m("div"),u(Te.$$.fragment),no=a(),et=m("p"),et.innerHTML=Ro,ao=a(),B=m("div"),u(Ue.$$.fragment),ro=a(),tt=m("p"),tt.innerHTML=Xo,lo=a(),ot=m("p"),ot.textContent=Ho,io=a(),u(re.$$.fragment),mo=a(),V=m("div"),u(Je.$$.fragment),co=a(),st=m("p"),st.innerHTML=No,po=a(),nt=m("p"),nt.textContent=zo,fo=a(),u(le.$$.fragment),uo=a(),z=m("div"),u(je.$$.fragment),ho=a(),at=m("p"),at.innerHTML=Yo,go=a(),u(ie.$$.fragment),yt=a(),u(ke.$$.fragment),_t=a(),X=m("div"),u(Ze.$$.fragment),Mo=a(),rt=m("p"),rt.textContent=Do,bo=a(),Y=m("div"),u(Ge.$$.fragment),yo=a(),lt=m("p"),lt.textContent=Qo,_o=a(),u(de.$$.fragment),vt=a(),ct=m("p"),this.h()},l(t){const p=ts("svelte-u9bgzb",document.head);o=c(p,"META",{name:!0,content:!0}),p.forEach(i),_=r(t),l=c(t,"P",{}),j(l).forEach(i),n=r(t),h(d.$$.fragment,t),e=r(t),f=c(t,"P",{});var Ce=j(f);$t=So(Ce,"🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),pt=os(Ce,!1),ft=So(Ce,"."),Ce.forEach(i),ut=r(t),pe=c(t,"P",{"data-svelte-h":!0}),x(pe)!=="svelte-1elbdrk"&&(pe.innerHTML=vo),ht=r(t),h(fe.$$.fragment,t),gt=r(t),w=c(t,"DIV",{class:!0});var T=j(w);h(ue.$$.fragment,T),Tt=r(T),Re=c(T,"P",{"data-svelte-h":!0}),x(Re)!=="svelte-12nk4t7"&&(Re.textContent=xo),Ut=r(T),Xe=c(T,"P",{"data-svelte-h":!0}),x(Xe)!=="svelte-ku6myw"&&(Xe.innerHTML=wo),Jt=r(T),He=c(T,"UL",{"data-svelte-h":!0}),x(He)!=="svelte-kvpw1l"&&(He.innerHTML=$o),jt=r(T),S=c(T,"DIV",{class:!0});var Fe=j(S);h(he.$$.fragment,Fe),kt=r(Fe),Ne=c(Fe,"P",{"data-svelte-h":!0}),x(Ne)!=="svelte-jedy0o"&&(Ne.innerHTML=To),Fe.forEach(i),Zt=r(T),L=c(T,"DIV",{class:!0});var Ie=j(L);h(ge.$$.fragment,Ie),Gt=r(Ie),ze=c(Ie,"P",{"data-svelte-h":!0}),x(ze)!=="svelte-1vfte1e"&&(ze.innerHTML=Uo),Ie.forEach(i),Ct=r(T),P=c(T,"DIV",{class:!0});var We=j(P);h(Me.$$.fragment,We),Ft=r(We),Ye=c(We,"P",{"data-svelte-h":!0}),x(Ye)!=="svelte-1rv66k9"&&(Ye.innerHTML=Jo),We.forEach(i),It=r(T),F=c(T,"DIV",{class:!0});var I=j(F);h(be.$$.fragment,I),Wt=r(I),De=c(I,"P",{"data-svelte-h":!0}),x(De)!=="svelte-yfpdyb"&&(De.innerHTML=jo),Bt=r(I),Qe=c(I,"P",{"data-svelte-h":!0}),x(Qe)!=="svelte-z1uct7"&&(Qe.textContent=ko),Vt=r(I),h(q.$$.fragment,I),Rt=r(I),h(A.$$.fragment,I),I.forEach(i),Xt=r(T),Z=c(T,"DIV",{class:!0});var C=j(Z);h(ye.$$.fragment,C),Ht=r(C),Ee=c(C,"P",{"data-svelte-h":!0}),x(Ee)!=="svelte-1lisopl"&&(Ee.textContent=Zo),Nt=r(C),Se=c(C,"P",{"data-svelte-h":!0}),x(Se)!=="svelte-1fnd9e6"&&(Se.innerHTML=Go),zt=r(C),h(K.$$.fragment,C),Yt=r(C),h(O.$$.fragment,C),Dt=r(C),h(ee.$$.fragment,C),C.forEach(i),Qt=r(T),N=c(T,"DIV",{class:!0});var E=j(N);h(_e.$$.fragment,E),Et=r(E),Le=c(E,"P",{"data-svelte-h":!0}),x(Le)!=="svelte-1jxmzhx"&&(Le.textContent=Co),St=r(E),h(te.$$.fragment,E),E.forEach(i),Lt=r(T),oe=c(T,"DIV",{class:!0});var Be=j(oe);h(ve.$$.fragment,Be),Pt=r(Be),Pe=c(Be,"P",{"data-svelte-h":!0}),x(Pe)!=="svelte-1y16a8m"&&(Pe.innerHTML=Fo),Be.forEach(i),T.forEach(i),Mt=r(t),h(xe.$$.fragment,t),bt=r(t),U=c(t,"DIV",{class:!0});var J=j(U);h(we.$$.fragment,J),qt=r(J),qe=c(J,"P",{"data-svelte-h":!0}),x(qe)!=="svelte-1kw8rks"&&(qe.textContent=Io),At=r(J),Ae=c(J,"P",{"data-svelte-h":!0}),x(Ae)!=="svelte-ltxz86"&&(Ae.innerHTML=Wo),Kt=r(J),Ke=c(J,"UL",{"data-svelte-h":!0}),x(Ke)!=="svelte-5tww1s"&&(Ke.innerHTML=Bo),Ot=r(J),W=c(J,"DIV",{class:!0});var H=j(W);h($e.$$.fragment,H),eo=r(H),Oe=c(H,"P",{"data-svelte-h":!0}),x(Oe)!=="svelte-72pb05"&&(Oe.textContent=Vo),to=r(H),h(se.$$.fragment,H),oo=r(H),h(ne.$$.fragment,H),H.forEach(i),so=r(J),ae=c(J,"DIV",{class:!0});var Ve=j(ae);h(Te.$$.fragment,Ve),no=r(Ve),et=c(Ve,"P",{"data-svelte-h":!0}),x(et)!=="svelte-9z80ed"&&(et.innerHTML=Ro),Ve.forEach(i),ao=r(J),B=c(J,"DIV",{class:!0});var me=j(B);h(Ue.$$.fragment,me),ro=r(me),tt=c(me,"P",{"data-svelte-h":!0}),x(tt)!=="svelte-16uni9u"&&(tt.innerHTML=Xo),lo=r(me),ot=c(me,"P",{"data-svelte-h":!0}),x(ot)!=="svelte-1y9zqww"&&(ot.textContent=Ho),io=r(me),h(re.$$.fragment,me),me.forEach(i),mo=r(J),V=c(J,"DIV",{class:!0});var ce=j(V);h(Je.$$.fragment,ce),co=r(ce),st=c(ce,"P",{"data-svelte-h":!0}),x(st)!=="svelte-ifz6ak"&&(st.innerHTML=No),po=r(ce),nt=c(ce,"P",{"data-svelte-h":!0}),x(nt)!=="svelte-yfkr09"&&(nt.textContent=zo),fo=r(ce),h(le.$$.fragment,ce),ce.forEach(i),uo=r(J),z=c(J,"DIV",{class:!0});var it=j(z);h(je.$$.fragment,it),ho=r(it),at=c(it,"P",{"data-svelte-h":!0}),x(at)!=="svelte-j66hh4"&&(at.innerHTML=Yo),go=r(it),h(ie.$$.fragment,it),it.forEach(i),J.forEach(i),yt=r(t),h(ke.$$.fragment,t),_t=r(t),X=c(t,"DIV",{class:!0});var dt=j(X);h(Ze.$$.fragment,dt),Mo=r(dt),rt=c(dt,"P",{"data-svelte-h":!0}),x(rt)!=="svelte-7y8zei"&&(rt.textContent=Do),bo=r(dt),Y=c(dt,"DIV",{class:!0});var mt=j(Y);h(Ge.$$.fragment,mt),yo=r(mt),lt=c(mt,"P",{"data-svelte-h":!0}),x(lt)!=="svelte-5nfhmh"&&(lt.textContent=Qo),_o=r(mt),h(de.$$.fragment,mt),mt.forEach(i),dt.forEach(i),vt=r(t),ct=c(t,"P",{}),j(ct).forEach(i),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",gs),pt.a=ft,k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,p){s(document.head,o),v(t,_,p),v(t,l,p),v(t,n,p),g(d,t,p),v(t,e,p),v(t,f,p),s(f,$t),pt.m(Po,f),s(f,ft),v(t,ut,p),v(t,pe,p),v(t,ht,p),g(fe,t,p),v(t,gt,p),v(t,w,p),g(ue,w,null),s(w,Tt),s(w,Re),s(w,Ut),s(w,Xe),s(w,Jt),s(w,He),s(w,jt),s(w,S),g(he,S,null),s(S,kt),s(S,Ne),s(w,Zt),s(w,L),g(ge,L,null),s(L,Gt),s(L,ze),s(w,Ct),s(w,P),g(Me,P,null),s(P,Ft),s(P,Ye),s(w,It),s(w,F),g(be,F,null),s(F,Wt),s(F,De),s(F,Bt),s(F,Qe),s(F,Vt),g(q,F,null),s(F,Rt),g(A,F,null),s(w,Xt),s(w,Z),g(ye,Z,null),s(Z,Ht),s(Z,Ee),s(Z,Nt),s(Z,Se),s(Z,zt),g(K,Z,null),s(Z,Yt),g(O,Z,null),s(Z,Dt),g(ee,Z,null),s(w,Qt),s(w,N),g(_e,N,null),s(N,Et),s(N,Le),s(N,St),g(te,N,null),s(w,Lt),s(w,oe),g(ve,oe,null),s(oe,Pt),s(oe,Pe),v(t,Mt,p),g(xe,t,p),v(t,bt,p),v(t,U,p),g(we,U,null),s(U,qt),s(U,qe),s(U,At),s(U,Ae),s(U,Kt),s(U,Ke),s(U,Ot),s(U,W),g($e,W,null),s(W,eo),s(W,Oe),s(W,to),g(se,W,null),s(W,oo),g(ne,W,null),s(U,so),s(U,ae),g(Te,ae,null),s(ae,no),s(ae,et),s(U,ao),s(U,B),g(Ue,B,null),s(B,ro),s(B,tt),s(B,lo),s(B,ot),s(B,io),g(re,B,null),s(U,mo),s(U,V),g(Je,V,null),s(V,co),s(V,st),s(V,po),s(V,nt),s(V,fo),g(le,V,null),s(U,uo),s(U,z),g(je,z,null),s(z,ho),s(z,at),s(z,go),g(ie,z,null),v(t,yt,p),g(ke,t,p),v(t,_t,p),v(t,X,p),g(Ze,X,null),s(X,Mo),s(X,rt),s(X,bo),s(X,Y),g(Ge,Y,null),s(Y,yo),s(Y,lt),s(Y,_o),g(de,Y,null),v(t,vt,p),v(t,ct,p),xt=!0},p(t,[p]){const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:t}),q.$set(Ce);const T={};p&2&&(T.$$scope={dirty:p,ctx:t}),A.$set(T);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:t}),K.$set(Fe);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:t}),O.$set(Ie);const We={};p&2&&(We.$$scope={dirty:p,ctx:t}),ee.$set(We);const I={};p&2&&(I.$$scope={dirty:p,ctx:t}),te.$set(I);const C={};p&2&&(C.$$scope={dirty:p,ctx:t}),se.$set(C);const E={};p&2&&(E.$$scope={dirty:p,ctx:t}),ne.$set(E);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:t}),re.$set(Be);const J={};p&2&&(J.$$scope={dirty:p,ctx:t}),le.$set(J);const H={};p&2&&(H.$$scope={dirty:p,ctx:t}),ie.$set(H);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:t}),de.$set(Ve)},i(t){xt||(M(d.$$.fragment,t),M(fe.$$.fragment,t),M(ue.$$.fragment,t),M(he.$$.fragment,t),M(ge.$$.fragment,t),M(Me.$$.fragment,t),M(be.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(ye.$$.fragment,t),M(K.$$.fragment,t),M(O.$$.fragment,t),M(ee.$$.fragment,t),M(_e.$$.fragment,t),M(te.$$.fragment,t),M(ve.$$.fragment,t),M(xe.$$.fragment,t),M(we.$$.fragment,t),M($e.$$.fragment,t),M(se.$$.fragment,t),M(ne.$$.fragment,t),M(Te.$$.fragment,t),M(Ue.$$.fragment,t),M(re.$$.fragment,t),M(Je.$$.fragment,t),M(le.$$.fragment,t),M(je.$$.fragment,t),M(ie.$$.fragment,t),M(ke.$$.fragment,t),M(Ze.$$.fragment,t),M(Ge.$$.fragment,t),M(de.$$.fragment,t),xt=!0)},o(t){b(d.$$.fragment,t),b(fe.$$.fragment,t),b(ue.$$.fragment,t),b(he.$$.fragment,t),b(ge.$$.fragment,t),b(Me.$$.fragment,t),b(be.$$.fragment,t),b(q.$$.fragment,t),b(A.$$.fragment,t),b(ye.$$.fragment,t),b(K.$$.fragment,t),b(O.$$.fragment,t),b(ee.$$.fragment,t),b(_e.$$.fragment,t),b(te.$$.fragment,t),b(ve.$$.fragment,t),b(xe.$$.fragment,t),b(we.$$.fragment,t),b($e.$$.fragment,t),b(se.$$.fragment,t),b(ne.$$.fragment,t),b(Te.$$.fragment,t),b(Ue.$$.fragment,t),b(re.$$.fragment,t),b(Je.$$.fragment,t),b(le.$$.fragment,t),b(je.$$.fragment,t),b(ie.$$.fragment,t),b(ke.$$.fragment,t),b(Ze.$$.fragment,t),b(Ge.$$.fragment,t),b(de.$$.fragment,t),xt=!1},d(t){t&&(i(_),i(l),i(n),i(e),i(f),i(ut),i(pe),i(ht),i(gt),i(w),i(Mt),i(bt),i(U),i(yt),i(_t),i(X),i(vt),i(ct)),i(o),y(d,t),y(fe,t),y(ue),y(he),y(ge),y(Me),y(be),y(q),y(A),y(ye),y(K),y(O),y(ee),y(_e),y(te),y(ve),y(xe,t),y(we),y($e),y(se),y(ne),y(Te),y(Ue),y(re),y(Je),y(le),y(je),y(ie),y(ke,t),y(Ze),y(Ge),y(de)}}}const gs='{"title":"Models","local":"models","sections":[{"title":"ModelMixin","local":"diffusers.ModelMixin","sections":[],"depth":2},{"title":"FlaxModelMixin","local":"diffusers.FlaxModelMixin","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function Ms($){return Ao(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends Ko{constructor(o){super(),Oo(this,o,Ms,hs,qo,{})}}export{Ts as component};
