import{s as ps,o as is,n as os}from"../chunks/scheduler.9991993c.js";import{S as rs,i as ms,g as p,s as a,r,A as Ms,h as i,f as s,c as n,j as ns,u as m,x as o,k as ke,y as cs,a as l,v as M,d as c,t as u,w as g}from"../chunks/index.7fc9a5e7.js";import{T as us}from"../chunks/Tip.9de92fc6.js";import{C as T}from"../chunks/CodeBlock.e11cba92.js";import{D as gs}from"../chunks/DocNotebookDropdown.145e5ada.js";import{H as h}from"../chunks/Heading.e3de321f.js";function ds(Ut){let d,b='如果您对基本的LLM使用感兴趣，我们高级的<a href="pipeline_tutorial"><code>Pipeline</code></a>接口是一个很好的起点。然而，LLMs通常需要像<code>quantization</code>和<code>token选择步骤的精细控制</code>等高级功能，这最好通过<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>来完成。使用LLM进行自回归生成也是资源密集型的操作，应该在GPU上执行以获得足够的吞吐量。';return{c(){d=p("p"),d.innerHTML=b},l(y){d=i(y,"P",{"data-svelte-h":!0}),o(d)!=="svelte-szanly"&&(d.innerHTML=b)},m(y,ft){l(y,d,ft)},p:os,d(y){y&&s(d)}}}function hs(Ut){let d,b,y,ft,U,wt,w,Zt,Z,Ie="LLMs，即大语言模型，是文本生成背后的关键组成部分。简单来说，它们包含经过大规模预训练的transformer模型，用于根据给定的输入文本预测下一个词（或更准确地说，下一个<code>token</code>）。由于它们一次只预测一个<code>token</code>，因此除了调用模型之外，您需要执行更复杂的操作来生成新的句子——您需要进行自回归生成。",kt,k,Ge='自回归生成是在给定一些初始输入，通过迭代调用模型及其自身的生成输出来生成文本的推理过程，。在🤗 Transformers中，这由<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>方法处理，所有具有生成能力的模型都可以使用该方法。',It,I,_e="本教程将向您展示如何：",Gt,G,Be="<li>使用LLM生成文本</li> <li>避免常见的陷阱</li> <li>帮助您充分利用LLM下一步指导</li>",_t,_,$e="在开始之前，请确保已安装所有必要的库：",Bt,B,$t,$,Xt,X,Xe='一个用于<a href="tasks/language_modeling">因果语言建模</a>训练的语言模型，将文本<code>tokens</code>序列作为输入，并返回下一个<code>token</code>的概率分布。',Vt,j,Ve='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;LLM的前向传递&quot;</figcaption>',Wt,V,We="使用LLM进行自回归生成的一个关键方面是如何从这个概率分布中选择下一个<code>token</code>。这个步骤可以随意进行，只要最终得到下一个迭代的<code>token</code>。这意味着可以简单的从概率分布中选择最可能的<code>token</code>，也可以复杂的在对结果分布进行采样之前应用多种变换，这取决于你的需求。",Rt,J,Re='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;自回归生成迭代地从概率分布中选择下一个token以生成文本&quot;</figcaption>',vt,W,ve="上述过程是迭代重复的，直到达到某个停止条件。理想情况下，停止条件由模型决定，该模型应学会在何时输出一个结束序列（<code>EOS</code>）标记。如果不是这种情况，生成将在达到某个预定义的最大长度时停止。",Ct,R,Ce="正确设置<code>token</code>选择步骤和停止条件对于让你的模型按照预期的方式执行任务至关重要。这就是为什么我们为每个模型都有一个[~generation.GenerationConfig]文件，它包含一个效果不错的默认生成参数配置，并与您模型一起加载。",zt,v,ze="让我们谈谈代码！",Ht,f,xt,C,He="首先，您需要加载模型。",Lt,z,Ft,H,xe="您将会注意到在<code>from_pretrained</code>调用中的两个标志：",qt,x,Le='<li><code>device_map</code>确保模型被移动到您的GPU(s)上</li> <li><code>load_in_4bit</code>应用<a href="main_classes/quantization">4位动态量化</a>来极大地减少资源需求</li>',Qt,L,Fe="还有其他方式来初始化一个模型，但这是一个开始使用LLM很好的起点。",Nt,F,qe='接下来，你需要使用一个<a href="tokenizer_summary">tokenizer</a>来预处理你的文本输入。',Et,q,St,Q,Qe='<code>model_inputs</code>变量保存着分词后的文本输入以及注意力掩码。尽管<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>在未传递注意力掩码时会尽其所能推断出注意力掩码，但建议尽可能传递它以获得最佳结果。',Yt,N,Ne='在对输入进行分词后，可以调用<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>方法来返回生成的<code>tokens</code>。生成的<code>tokens</code>应该在打印之前转换为文本。',At,E,Kt,S,Ee="最后，您不需要一次处理一个序列！您可以批量输入，这将在小延迟和低内存成本下显著提高吞吐量。您只需要确保正确地填充您的输入（详见下文）。",Dt,Y,Pt,A,Se="就是这样！在几行代码中，您就可以利用LLM的强大功能。",Ot,K,te,D,Ye='有许多<a href="generation_strategies">生成策略</a>，有时默认值可能不适合您的用例。如果您的输出与您期望的结果不匹配，我们已经创建了一个最常见的陷阱列表以及如何避免它们。',ee,P,se,O,le,tt,Ae='如果在<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>文件中没有指定，<code>generate</code>默认返回20个tokens。我们强烈建议在您的<code>generate</code>调用中手动设置<code>max_new_tokens</code>以控制它可以返回的最大新tokens数量。请注意，LLMs（更准确地说，仅<a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">解码器模型</a>）也将输入提示作为输出的一部分返回。',ae,et,ne,st,pe,lt,Ke='默认情况下，除非在<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>文件中指定，否则<code>generate</code>会在每个迭代中选择最可能的token（贪婪解码）。对于您的任务，这可能是不理想的；像聊天机器人或写作文章这样的创造性任务受益于采样。另一方面，像音频转录或翻译这样的基于输入的任务受益于贪婪解码。通过将<code>do_sample=True</code>启用采样，您可以在这篇<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">博客文章</a>中了解更多关于这个话题的信息。',ie,at,oe,nt,re,pt,De='LLMs是<a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">仅解码器</a>架构，意味着它们会持续迭代您的输入提示。如果您的输入长度不相同，则需要对它们进行填充。由于LLMs没有接受过从<code>pad tokens</code>继续训练，因此您的输入需要左填充。确保在生成时不要忘记传递注意力掩码！',me,it,Me,ot,ce,rt,Pe='一些模型和任务期望某种输入提示格式才能正常工作。当未应用此格式时，您将获得悄然的性能下降：模型能工作，但不如预期提示那样好。有关提示的更多信息，包括哪些模型和任务需要小心，可在<a href="tasks/prompting">指南</a>中找到。让我们看一个使用<a href="chat_templating">聊天模板</a>的聊天LLM示例：',ue,mt,ge,Mt,de,ct,Oe="虽然自回归生成过程相对简单，但要充分利用LLM可能是一个具有挑战性的任务，因为很多组件复杂且密切关联。以下是帮助您深入了解LLM使用和理解的下一步：",he,ut,ye,gt,ts='<li><a href="generation_strategies">指南</a>，介绍如何控制不同的生成方法、如何设置生成配置文件以及如何进行输出流式传输；</li> <li><a href="chat_templating">指南</a>，介绍聊天LLMs的提示模板；</li> <li><a href="tasks/prompting">指南</a>，介绍如何充分利用提示设计；</li> <li>API参考文档，包括<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>、<a href="/docs/transformers/v4.37.1/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>和<a href="internal/generation_utils">与生成相关的类</a>。</li>',Te,dt,je,ht,es='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, 侧重于开源模型的质量;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, 侧重于LLM的吞吐量.</li>',Je,yt,fe,Tt,ss='<li><a href="llm_tutorial_optimization">指南</a>,如何优化LLMs以提高速度和内存利用；</li> <li><a href="main_classes/quantization">指南</a>, 关于<code>quantization</code>，如bitsandbytes和autogptq的指南，教您如何大幅降低内存需求。</li>',be,jt,Ue,Jt,ls='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, 一个面向生产的LLM服务器；</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, 一个🤗 Transformers的扩展，优化特定硬件设备的性能</li>',we,bt,Ze;return U=new h({props:{title:"使用LLMs进行生成",local:"使用llms进行生成",headingTag:"h2"}}),w=new gs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/llm_tutorial.ipynb"}]}}),B=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),$=new h({props:{title:"生成文本",local:"生成文本",headingTag:"h2"}}),f=new us({props:{$$slots:{default:[ds]},$$scope:{ctx:Ut}}}),z=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),Y=new T({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),K=new h({props:{title:"常见陷阱",local:"常见陷阱",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new h({props:{title:"生成的输出太短/太长",local:"生成的输出太短太长",headingTag:"h3"}}),et=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),st=new h({props:{title:"错误的生成模式",local:"错误的生成模式",headingTag:"h3"}}),at=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCg0MiklMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSUyMGFtJTIwYSUyMGNhdC4lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMExMTSUyMCUyQiUyMGdyZWVkeSUyMGRlY29kaW5nJTIwJTNEJTIwcmVwZXRpdGl2ZSUyQyUyMGJvcmluZyUyMG91dHB1dCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwYmVjb21lcyUyMG1vcmUlMjBjcmVhdGl2ZSElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),nt=new h({props:{title:"错误的填充位置",local:"错误的填充位置",headingTag:"h3"}}),it=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBsZWZ0LXBhZGRpbmclMkMlMjBpdCUyMHdvcmtzJTIwYXMlMjBleHBlY3RlZCElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTW9zdCUyMExMTXMlMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),ot=new h({props:{title:"错误的提示",local:"错误的提示",headingTag:"h3"}}),mt=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),Mt=new h({props:{title:"更多资源",local:"更多资源",headingTag:"h2"}}),ut=new h({props:{title:"高级生成用法",local:"高级生成用法",headingTag:"h3"}}),dt=new h({props:{title:"LLM排行榜",local:"llm排行榜",headingTag:"h3"}}),yt=new h({props:{title:"延迟、吞吐量和内存利用率",local:"延迟吞吐量和内存利用率",headingTag:"h3"}}),jt=new h({props:{title:"相关库",local:"相关库",headingTag:"h3"}}),{c(){d=p("meta"),b=a(),y=p("p"),ft=a(),r(U.$$.fragment),wt=a(),r(w.$$.fragment),Zt=a(),Z=p("p"),Z.innerHTML=Ie,kt=a(),k=p("p"),k.innerHTML=Ge,It=a(),I=p("p"),I.textContent=_e,Gt=a(),G=p("ul"),G.innerHTML=Be,_t=a(),_=p("p"),_.textContent=$e,Bt=a(),r(B.$$.fragment),$t=a(),r($.$$.fragment),Xt=a(),X=p("p"),X.innerHTML=Xe,Vt=a(),j=p("figure"),j.innerHTML=Ve,Wt=a(),V=p("p"),V.innerHTML=We,Rt=a(),J=p("figure"),J.innerHTML=Re,vt=a(),W=p("p"),W.innerHTML=ve,Ct=a(),R=p("p"),R.innerHTML=Ce,zt=a(),v=p("p"),v.textContent=ze,Ht=a(),r(f.$$.fragment),xt=a(),C=p("p"),C.textContent=He,Lt=a(),r(z.$$.fragment),Ft=a(),H=p("p"),H.innerHTML=xe,qt=a(),x=p("ul"),x.innerHTML=Le,Qt=a(),L=p("p"),L.textContent=Fe,Nt=a(),F=p("p"),F.innerHTML=qe,Et=a(),r(q.$$.fragment),St=a(),Q=p("p"),Q.innerHTML=Qe,Yt=a(),N=p("p"),N.innerHTML=Ne,At=a(),r(E.$$.fragment),Kt=a(),S=p("p"),S.textContent=Ee,Dt=a(),r(Y.$$.fragment),Pt=a(),A=p("p"),A.textContent=Se,Ot=a(),r(K.$$.fragment),te=a(),D=p("p"),D.innerHTML=Ye,ee=a(),r(P.$$.fragment),se=a(),r(O.$$.fragment),le=a(),tt=p("p"),tt.innerHTML=Ae,ae=a(),r(et.$$.fragment),ne=a(),r(st.$$.fragment),pe=a(),lt=p("p"),lt.innerHTML=Ke,ie=a(),r(at.$$.fragment),oe=a(),r(nt.$$.fragment),re=a(),pt=p("p"),pt.innerHTML=De,me=a(),r(it.$$.fragment),Me=a(),r(ot.$$.fragment),ce=a(),rt=p("p"),rt.innerHTML=Pe,ue=a(),r(mt.$$.fragment),ge=a(),r(Mt.$$.fragment),de=a(),ct=p("p"),ct.textContent=Oe,he=a(),r(ut.$$.fragment),ye=a(),gt=p("ol"),gt.innerHTML=ts,Te=a(),r(dt.$$.fragment),je=a(),ht=p("ol"),ht.innerHTML=es,Je=a(),r(yt.$$.fragment),fe=a(),Tt=p("ol"),Tt.innerHTML=ss,be=a(),r(jt.$$.fragment),Ue=a(),Jt=p("ol"),Jt.innerHTML=ls,we=a(),bt=p("p"),this.h()},l(t){const e=Ms("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(s),b=n(t),y=i(t,"P",{}),ns(y).forEach(s),ft=n(t),m(U.$$.fragment,t),wt=n(t),m(w.$$.fragment,t),Zt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-8lgfa7"&&(Z.innerHTML=Ie),kt=n(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-sehth9"&&(k.innerHTML=Ge),It=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-lx14wd"&&(I.textContent=_e),Gt=n(t),G=i(t,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-13m7zir"&&(G.innerHTML=Be),_t=n(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-noc1o7"&&(_.textContent=$e),Bt=n(t),m(B.$$.fragment,t),$t=n(t),m($.$$.fragment,t),Xt=n(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1wbwdf2"&&(X.innerHTML=Xe),Vt=n(t),j=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-4ssllr"&&(j.innerHTML=Ve),Wt=n(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1ikd8ml"&&(V.innerHTML=We),Rt=n(t),J=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-bzy8d0"&&(J.innerHTML=Re),vt=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-yw7aac"&&(W.innerHTML=ve),Ct=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-scvmxm"&&(R.innerHTML=Ce),zt=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-23apfz"&&(v.textContent=ze),Ht=n(t),m(f.$$.fragment,t),xt=n(t),C=i(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-11xv34o"&&(C.textContent=He),Lt=n(t),m(z.$$.fragment,t),Ft=n(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-6j494d"&&(H.innerHTML=xe),qt=n(t),x=i(t,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-4d7bnv"&&(x.innerHTML=Le),Qt=n(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-seh5kq"&&(L.textContent=Fe),Nt=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-57ytyl"&&(F.innerHTML=qe),Et=n(t),m(q.$$.fragment,t),St=n(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-uahzq3"&&(Q.innerHTML=Qe),Yt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1i3k460"&&(N.innerHTML=Ne),At=n(t),m(E.$$.fragment,t),Kt=n(t),S=i(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-dnai18"&&(S.textContent=Ee),Dt=n(t),m(Y.$$.fragment,t),Pt=n(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1eqj8jy"&&(A.textContent=Se),Ot=n(t),m(K.$$.fragment,t),te=n(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1awc9fu"&&(D.innerHTML=Ye),ee=n(t),m(P.$$.fragment,t),se=n(t),m(O.$$.fragment,t),le=n(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1eidv36"&&(tt.innerHTML=Ae),ae=n(t),m(et.$$.fragment,t),ne=n(t),m(st.$$.fragment,t),pe=n(t),lt=i(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1w11ixk"&&(lt.innerHTML=Ke),ie=n(t),m(at.$$.fragment,t),oe=n(t),m(nt.$$.fragment,t),re=n(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-pao9hp"&&(pt.innerHTML=De),me=n(t),m(it.$$.fragment,t),Me=n(t),m(ot.$$.fragment,t),ce=n(t),rt=i(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-15btsci"&&(rt.innerHTML=Pe),ue=n(t),m(mt.$$.fragment,t),ge=n(t),m(Mt.$$.fragment,t),de=n(t),ct=i(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-d2e6yq"&&(ct.textContent=Oe),he=n(t),m(ut.$$.fragment,t),ye=n(t),gt=i(t,"OL",{"data-svelte-h":!0}),o(gt)!=="svelte-ugztqr"&&(gt.innerHTML=ts),Te=n(t),m(dt.$$.fragment,t),je=n(t),ht=i(t,"OL",{"data-svelte-h":!0}),o(ht)!=="svelte-e1h2fe"&&(ht.innerHTML=es),Je=n(t),m(yt.$$.fragment,t),fe=n(t),Tt=i(t,"OL",{"data-svelte-h":!0}),o(Tt)!=="svelte-1aq8t2a"&&(Tt.innerHTML=ss),be=n(t),m(jt.$$.fragment,t),Ue=n(t),Jt=i(t,"OL",{"data-svelte-h":!0}),o(Jt)!=="svelte-1ubnemc"&&(Jt.innerHTML=ls),we=n(t),bt=i(t,"P",{}),ns(bt).forEach(s),this.h()},h(){ke(d,"name","hf:doc:metadata"),ke(d,"content",ys),ke(j,"class","image table text-center m-0 w-full"),ke(J,"class","image table text-center m-0 w-full")},m(t,e){cs(document.head,d),l(t,b,e),l(t,y,e),l(t,ft,e),M(U,t,e),l(t,wt,e),M(w,t,e),l(t,Zt,e),l(t,Z,e),l(t,kt,e),l(t,k,e),l(t,It,e),l(t,I,e),l(t,Gt,e),l(t,G,e),l(t,_t,e),l(t,_,e),l(t,Bt,e),M(B,t,e),l(t,$t,e),M($,t,e),l(t,Xt,e),l(t,X,e),l(t,Vt,e),l(t,j,e),l(t,Wt,e),l(t,V,e),l(t,Rt,e),l(t,J,e),l(t,vt,e),l(t,W,e),l(t,Ct,e),l(t,R,e),l(t,zt,e),l(t,v,e),l(t,Ht,e),M(f,t,e),l(t,xt,e),l(t,C,e),l(t,Lt,e),M(z,t,e),l(t,Ft,e),l(t,H,e),l(t,qt,e),l(t,x,e),l(t,Qt,e),l(t,L,e),l(t,Nt,e),l(t,F,e),l(t,Et,e),M(q,t,e),l(t,St,e),l(t,Q,e),l(t,Yt,e),l(t,N,e),l(t,At,e),M(E,t,e),l(t,Kt,e),l(t,S,e),l(t,Dt,e),M(Y,t,e),l(t,Pt,e),l(t,A,e),l(t,Ot,e),M(K,t,e),l(t,te,e),l(t,D,e),l(t,ee,e),M(P,t,e),l(t,se,e),M(O,t,e),l(t,le,e),l(t,tt,e),l(t,ae,e),M(et,t,e),l(t,ne,e),M(st,t,e),l(t,pe,e),l(t,lt,e),l(t,ie,e),M(at,t,e),l(t,oe,e),M(nt,t,e),l(t,re,e),l(t,pt,e),l(t,me,e),M(it,t,e),l(t,Me,e),M(ot,t,e),l(t,ce,e),l(t,rt,e),l(t,ue,e),M(mt,t,e),l(t,ge,e),M(Mt,t,e),l(t,de,e),l(t,ct,e),l(t,he,e),M(ut,t,e),l(t,ye,e),l(t,gt,e),l(t,Te,e),M(dt,t,e),l(t,je,e),l(t,ht,e),l(t,Je,e),M(yt,t,e),l(t,fe,e),l(t,Tt,e),l(t,be,e),M(jt,t,e),l(t,Ue,e),l(t,Jt,e),l(t,we,e),l(t,bt,e),Ze=!0},p(t,[e]){const as={};e&2&&(as.$$scope={dirty:e,ctx:t}),f.$set(as)},i(t){Ze||(c(U.$$.fragment,t),c(w.$$.fragment,t),c(B.$$.fragment,t),c($.$$.fragment,t),c(f.$$.fragment,t),c(z.$$.fragment,t),c(q.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(K.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(ot.$$.fragment,t),c(mt.$$.fragment,t),c(Mt.$$.fragment,t),c(ut.$$.fragment,t),c(dt.$$.fragment,t),c(yt.$$.fragment,t),c(jt.$$.fragment,t),Ze=!0)},o(t){u(U.$$.fragment,t),u(w.$$.fragment,t),u(B.$$.fragment,t),u($.$$.fragment,t),u(f.$$.fragment,t),u(z.$$.fragment,t),u(q.$$.fragment,t),u(E.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(ot.$$.fragment,t),u(mt.$$.fragment,t),u(Mt.$$.fragment,t),u(ut.$$.fragment,t),u(dt.$$.fragment,t),u(yt.$$.fragment,t),u(jt.$$.fragment,t),Ze=!1},d(t){t&&(s(b),s(y),s(ft),s(wt),s(Zt),s(Z),s(kt),s(k),s(It),s(I),s(Gt),s(G),s(_t),s(_),s(Bt),s($t),s(Xt),s(X),s(Vt),s(j),s(Wt),s(V),s(Rt),s(J),s(vt),s(W),s(Ct),s(R),s(zt),s(v),s(Ht),s(xt),s(C),s(Lt),s(Ft),s(H),s(qt),s(x),s(Qt),s(L),s(Nt),s(F),s(Et),s(St),s(Q),s(Yt),s(N),s(At),s(Kt),s(S),s(Dt),s(Pt),s(A),s(Ot),s(te),s(D),s(ee),s(se),s(le),s(tt),s(ae),s(ne),s(pe),s(lt),s(ie),s(oe),s(re),s(pt),s(me),s(Me),s(ce),s(rt),s(ue),s(ge),s(de),s(ct),s(he),s(ye),s(gt),s(Te),s(je),s(ht),s(Je),s(fe),s(Tt),s(be),s(Ue),s(Jt),s(we),s(bt)),s(d),g(U,t),g(w,t),g(B,t),g($,t),g(f,t),g(z,t),g(q,t),g(E,t),g(Y,t),g(K,t),g(P,t),g(O,t),g(et,t),g(st,t),g(at,t),g(nt,t),g(it,t),g(ot,t),g(mt,t),g(Mt,t),g(ut,t),g(dt,t),g(yt,t),g(jt,t)}}}const ys='{"title":"使用LLMs进行生成","local":"使用llms进行生成","sections":[],"depth":2}';function Ts(Ut){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends rs{constructor(d){super(),ms(this,d,Ts,hs,ps,{})}}export{Zs as component};
