import{s as Vt,o as Et,n as be}from"../chunks/scheduler.c57aa7ef.js";import{S as xt,i as Nt,g as U,s as o,r as d,A as Ht,h as b,f as l,c as r,j as zt,u as c,x as T,k as ut,y as Lt,a,v as f,d as y,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Jt}from"../chunks/Tip.9268b0ca.js";import{C as j}from"../chunks/CodeBlock.34f0a53d.js";import{H as Ue,E as qt}from"../chunks/EditOnGithub.958a8a49.js";import{H as St,a as ht}from"../chunks/HfOption.189bbdfa.js";function Dt($){let s,w='Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){s=U("p"),s.innerHTML=w},l(i){s=b(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-122rdqq"&&(s.innerHTML=w)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function Pt($){let s,w='Call the <a href="/docs/peft/v0.11.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/v0.11.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){s=U("p"),s.innerHTML=w},l(i){s=b(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1mj1w6z"&&(s.innerHTML=w)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function Kt($){let s,w='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.11.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=w,i=o(),d(p.$$.fragment)},l(n){s=b(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-qv2tlm"&&(s.innerHTML=w),i=r(n),c(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),f(p,n,J),M=!0},p:be,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function Ot($){let s,w='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.11.0/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=w,i=o(),d(p.$$.fragment)},l(n){s=b(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-9g03s3"&&(s.innerHTML=w),i=r(n),c(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),f(p,n,J),M=!0},p:be,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function el($){let s,w='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.11.0/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=w,i=o(),d(p.$$.fragment)},l(n){s=b(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-176ke5s"&&(s.innerHTML=w),i=r(n),c(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),f(p,n,J),M=!0},p:be,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function tl($){let s,w='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.11.0/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=w,i=o(),d(p.$$.fragment)},l(n){s=b(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-utrd4q"&&(s.innerHTML=w),i=r(n),c(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),f(p,n,J),M=!0},p:be,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function ll($){let s,w,i,p,M,n,J,B;return s=new ht({props:{id:"loras",option:"LoRA",$$slots:{default:[Kt]},$$scope:{ctx:$}}}),i=new ht({props:{id:"loras",option:"LoHa",$$slots:{default:[Ot]},$$scope:{ctx:$}}}),M=new ht({props:{id:"loras",option:"LoKr",$$slots:{default:[el]},$$scope:{ctx:$}}}),J=new ht({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[tl]},$$scope:{ctx:$}}}),{c(){d(s.$$.fragment),w=o(),d(i.$$.fragment),p=o(),d(M.$$.fragment),n=o(),d(J.$$.fragment)},l(m){c(s.$$.fragment,m),w=r(m),c(i.$$.fragment,m),p=r(m),c(M.$$.fragment,m),n=r(m),c(J.$$.fragment,m)},m(m,g){f(s,m,g),a(m,w,g),f(i,m,g),a(m,p,g),f(M,m,g),a(m,n,g),f(J,m,g),B=!0},p(m,g){const we={};g&2&&(we.$$scope={dirty:g,ctx:m}),s.$set(we);const v={};g&2&&(v.$$scope={dirty:g,ctx:m}),i.$set(v);const C={};g&2&&(C.$$scope={dirty:g,ctx:m}),M.$set(C);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:m}),J.$set(Te)},i(m){B||(y(s.$$.fragment,m),y(i.$$.fragment,m),y(M.$$.fragment,m),y(J.$$.fragment,m),B=!0)},o(m){h(s.$$.fragment,m),h(i.$$.fragment,m),h(M.$$.fragment,m),h(J.$$.fragment,m),B=!1},d(m){m&&(l(w),l(p),l(n)),u(s,m),u(i,m),u(M,m),u(J,m)}}}function al($){let s,w='AdaLoRA has an <a href="/docs/peft/v0.11.0/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.';return{c(){s=U("p"),s.innerHTML=w},l(i){s=b(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1gnwip9"&&(s.innerHTML=w)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function sl($){let s,w,i,p,M,n,J,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",m,g,we='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,C,Te="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",je,_,$e,R,Ut="Before you begin, make sure you have all the necessary libraries installed.",Ce,Q,_e,G,Ze,F,bt='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',Ie,X,wt="Load the dataset with the <code>load_dataset</code> function.",ke,Y,We,A,Tt="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Be,z,ve,V,gt="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Re,E,Qe,x,jt="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Ge,N,Fe,H,$t="Define the training and validation datasets, and use the <code>set_transform</code> function to apply the transformations on-the-fly.",Xe,L,Ye,q,Ct="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ae,S,ze,D,Ve,P,_t='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ee,K,xe,O,Ne,ee,Zt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/v0.11.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.11.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',He,Z,Le,I,qe,te,Se,le,It='For training, let’s use the <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',De,k,Pe,ae,Ke,se,kt='Begin training with <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',Oe,ne,et,oe,tt,re,Wt='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',lt,ie,at,pe,Bt='Call <a href="https://huggingface.co/docs/transformers/v4.40.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',st,me,nt,Me,ot,de,vt="Let’s load the model from the Hub and test it out on a food image.",rt,ce,it,W,Rt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',pt,fe,Qt="Convert the image to RGB and return the underlying PyTorch tensors.",mt,ye,Mt,he,Gt="Now run the model and return the predicted class!",dt,ue,ct,Je,ft,ge,yt;return M=new Ue({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),_=new Jt({props:{$$slots:{default:[Dt]},$$scope:{ctx:$}}}),Q=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),G=new Ue({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),Y=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),N=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),L=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),D=new Ue({props:{title:"Model",local:"model",headingTag:"h2"}}),K=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),O=new Ue({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),Z=new Jt({props:{$$slots:{default:[Pt]},$$scope:{ctx:$}}}),I=new St({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[ll]},$$scope:{ctx:$}}}),te=new Ue({props:{title:"Training",local:"training",headingTag:"h3"}}),k=new Jt({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:$}}}),ae=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),ne=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    tokenizer=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),oe=new Ue({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),ie=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),me=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),Me=new Ue({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ce=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9tZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFjb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjAlMjJzdGV2aGxpdSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGc2FtcGxlLWRhdGFzZXRzJTJGcmVzb2x2ZSUyRm1haW4lMkZiZWlnbmV0cy5qcGVnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transfomers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),ye=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ue=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),Je=new qt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){s=U("meta"),w=o(),i=U("p"),p=o(),d(M.$$.fragment),n=o(),J=U("p"),J.textContent=B,m=o(),g=U("p"),g.innerHTML=we,v=o(),C=U("p"),C.textContent=Te,je=o(),d(_.$$.fragment),$e=o(),R=U("p"),R.textContent=Ut,Ce=o(),d(Q.$$.fragment),_e=o(),d(G.$$.fragment),Ze=o(),F=U("p"),F.innerHTML=bt,Ie=o(),X=U("p"),X.innerHTML=wt,ke=o(),d(Y.$$.fragment),We=o(),A=U("p"),A.innerHTML=Tt,Be=o(),d(z.$$.fragment),ve=o(),V=U("p"),V.textContent=gt,Re=o(),d(E.$$.fragment),Qe=o(),x=U("p"),x.textContent=jt,Ge=o(),d(N.$$.fragment),Fe=o(),H=U("p"),H.innerHTML=$t,Xe=o(),d(L.$$.fragment),Ye=o(),q=U("p"),q.innerHTML=Ct,Ae=o(),d(S.$$.fragment),ze=o(),d(D.$$.fragment),Ve=o(),P=U("p"),P.innerHTML=_t,Ee=o(),d(K.$$.fragment),xe=o(),d(O.$$.fragment),Ne=o(),ee=U("p"),ee.innerHTML=Zt,He=o(),d(Z.$$.fragment),Le=o(),d(I.$$.fragment),qe=o(),d(te.$$.fragment),Se=o(),le=U("p"),le.innerHTML=It,De=o(),d(k.$$.fragment),Pe=o(),d(ae.$$.fragment),Ke=o(),se=U("p"),se.innerHTML=kt,Oe=o(),d(ne.$$.fragment),et=o(),d(oe.$$.fragment),tt=o(),re=U("p"),re.innerHTML=Wt,lt=o(),d(ie.$$.fragment),at=o(),pe=U("p"),pe.innerHTML=Bt,st=o(),d(me.$$.fragment),nt=o(),d(Me.$$.fragment),ot=o(),de=U("p"),de.textContent=vt,rt=o(),d(ce.$$.fragment),it=o(),W=U("div"),W.innerHTML=Rt,pt=o(),fe=U("p"),fe.textContent=Qt,mt=o(),d(ye.$$.fragment),Mt=o(),he=U("p"),he.textContent=Gt,dt=o(),d(ue.$$.fragment),ct=o(),d(Je.$$.fragment),ft=o(),ge=U("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);s=b(t,"META",{name:!0,content:!0}),t.forEach(l),w=r(e),i=b(e,"P",{}),zt(i).forEach(l),p=r(e),c(M.$$.fragment,e),n=r(e),J=b(e,"P",{"data-svelte-h":!0}),T(J)!=="svelte-3c4mx2"&&(J.textContent=B),m=r(e),g=b(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1mec8a1"&&(g.innerHTML=we),v=r(e),C=b(e,"P",{"data-svelte-h":!0}),T(C)!=="svelte-3yvnz9"&&(C.textContent=Te),je=r(e),c(_.$$.fragment,e),$e=r(e),R=b(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1rdzhb1"&&(R.textContent=Ut),Ce=r(e),c(Q.$$.fragment,e),_e=r(e),c(G.$$.fragment,e),Ze=r(e),F=b(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-l33v6t"&&(F.innerHTML=bt),Ie=r(e),X=b(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1ym8xm4"&&(X.innerHTML=wt),ke=r(e),c(Y.$$.fragment,e),We=r(e),A=b(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1a5q7dy"&&(A.innerHTML=Tt),Be=r(e),c(z.$$.fragment,e),ve=r(e),V=b(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-13cytaa"&&(V.textContent=gt),Re=r(e),c(E.$$.fragment,e),Qe=r(e),x=b(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1p1x6w4"&&(x.textContent=jt),Ge=r(e),c(N.$$.fragment,e),Fe=r(e),H=b(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1xjp5d1"&&(H.innerHTML=$t),Xe=r(e),c(L.$$.fragment,e),Ye=r(e),q=b(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-mznco7"&&(q.innerHTML=Ct),Ae=r(e),c(S.$$.fragment,e),ze=r(e),c(D.$$.fragment,e),Ve=r(e),P=b(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-akpunr"&&(P.innerHTML=_t),Ee=r(e),c(K.$$.fragment,e),xe=r(e),c(O.$$.fragment,e),Ne=r(e),ee=b(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-qbgc5k"&&(ee.innerHTML=Zt),He=r(e),c(Z.$$.fragment,e),Le=r(e),c(I.$$.fragment,e),qe=r(e),c(te.$$.fragment,e),Se=r(e),le=b(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1jn1r8l"&&(le.innerHTML=It),De=r(e),c(k.$$.fragment,e),Pe=r(e),c(ae.$$.fragment,e),Ke=r(e),se=b(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-17496x4"&&(se.innerHTML=kt),Oe=r(e),c(ne.$$.fragment,e),et=r(e),c(oe.$$.fragment,e),tt=r(e),re=b(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-1i2vfhp"&&(re.innerHTML=Wt),lt=r(e),c(ie.$$.fragment,e),at=r(e),pe=b(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-f5thb1"&&(pe.innerHTML=Bt),st=r(e),c(me.$$.fragment,e),nt=r(e),c(Me.$$.fragment,e),ot=r(e),de=b(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1whrqzq"&&(de.textContent=vt),rt=r(e),c(ce.$$.fragment,e),it=r(e),W=b(e,"DIV",{class:!0,"data-svelte-h":!0}),T(W)!=="svelte-sucph9"&&(W.innerHTML=Rt),pt=r(e),fe=b(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1nlb27h"&&(fe.textContent=Qt),mt=r(e),c(ye.$$.fragment,e),Mt=r(e),he=b(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-1mvhoi"&&(he.textContent=Gt),dt=r(e),c(ue.$$.fragment,e),ct=r(e),c(Je.$$.fragment,e),ft=r(e),ge=b(e,"P",{}),zt(ge).forEach(l),this.h()},h(){ut(s,"name","hf:doc:metadata"),ut(s,"content",nl),ut(W,"class","flex justify-center")},m(e,t){Lt(document.head,s),a(e,w,t),a(e,i,t),a(e,p,t),f(M,e,t),a(e,n,t),a(e,J,t),a(e,m,t),a(e,g,t),a(e,v,t),a(e,C,t),a(e,je,t),f(_,e,t),a(e,$e,t),a(e,R,t),a(e,Ce,t),f(Q,e,t),a(e,_e,t),f(G,e,t),a(e,Ze,t),a(e,F,t),a(e,Ie,t),a(e,X,t),a(e,ke,t),f(Y,e,t),a(e,We,t),a(e,A,t),a(e,Be,t),f(z,e,t),a(e,ve,t),a(e,V,t),a(e,Re,t),f(E,e,t),a(e,Qe,t),a(e,x,t),a(e,Ge,t),f(N,e,t),a(e,Fe,t),a(e,H,t),a(e,Xe,t),f(L,e,t),a(e,Ye,t),a(e,q,t),a(e,Ae,t),f(S,e,t),a(e,ze,t),f(D,e,t),a(e,Ve,t),a(e,P,t),a(e,Ee,t),f(K,e,t),a(e,xe,t),f(O,e,t),a(e,Ne,t),a(e,ee,t),a(e,He,t),f(Z,e,t),a(e,Le,t),f(I,e,t),a(e,qe,t),f(te,e,t),a(e,Se,t),a(e,le,t),a(e,De,t),f(k,e,t),a(e,Pe,t),f(ae,e,t),a(e,Ke,t),a(e,se,t),a(e,Oe,t),f(ne,e,t),a(e,et,t),f(oe,e,t),a(e,tt,t),a(e,re,t),a(e,lt,t),f(ie,e,t),a(e,at,t),a(e,pe,t),a(e,st,t),f(me,e,t),a(e,nt,t),f(Me,e,t),a(e,ot,t),a(e,de,t),a(e,rt,t),f(ce,e,t),a(e,it,t),a(e,W,t),a(e,pt,t),a(e,fe,t),a(e,mt,t),f(ye,e,t),a(e,Mt,t),a(e,he,t),a(e,dt,t),f(ue,e,t),a(e,ct,t),f(Je,e,t),a(e,ft,t),a(e,ge,t),yt=!0},p(e,[t]){const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),_.$set(Ft);const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),Z.$set(Xt);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),I.$set(Yt);const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),k.$set(At)},i(e){yt||(y(M.$$.fragment,e),y(_.$$.fragment,e),y(Q.$$.fragment,e),y(G.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(E.$$.fragment,e),y(N.$$.fragment,e),y(L.$$.fragment,e),y(S.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(te.$$.fragment,e),y(k.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(me.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(Je.$$.fragment,e),yt=!0)},o(e){h(M.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(te.$$.fragment,e),h(k.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(Me.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(Je.$$.fragment,e),yt=!1},d(e){e&&(l(w),l(i),l(p),l(n),l(J),l(m),l(g),l(v),l(C),l(je),l($e),l(R),l(Ce),l(_e),l(Ze),l(F),l(Ie),l(X),l(ke),l(We),l(A),l(Be),l(ve),l(V),l(Re),l(Qe),l(x),l(Ge),l(Fe),l(H),l(Xe),l(Ye),l(q),l(Ae),l(ze),l(Ve),l(P),l(Ee),l(xe),l(Ne),l(ee),l(He),l(Le),l(qe),l(Se),l(le),l(De),l(Pe),l(Ke),l(se),l(Oe),l(et),l(tt),l(re),l(lt),l(at),l(pe),l(st),l(nt),l(ot),l(de),l(rt),l(it),l(W),l(pt),l(fe),l(mt),l(Mt),l(he),l(dt),l(ct),l(ft),l(ge)),l(s),u(M,e),u(_,e),u(Q,e),u(G,e),u(Y,e),u(z,e),u(E,e),u(N,e),u(L,e),u(S,e),u(D,e),u(K,e),u(O,e),u(Z,e),u(I,e),u(te,e),u(k,e),u(ae,e),u(ne,e),u(oe,e),u(ie,e),u(me,e),u(Me,e),u(ce,e),u(ye,e),u(ue,e),u(Je,e)}}}const nl='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ol($){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends xt{constructor(s){super(),Nt(this,s,ol,sl,Vt,{})}}export{cl as component};
