import{s as Xt,o as $t,n as it}from"../chunks/scheduler.8c3d61f6.js";import{S as Rt,i as Yt,g as p,s as a,r as M,A as Ft,h as c,f as l,c as n,j as At,u,x as r,k as Me,y as Et,a as s,v as m,d,t as f,w as y}from"../chunks/index.da70eac4.js";import{T as nt}from"../chunks/Tip.1d9b8c37.js";import{C as w}from"../chunks/CodeBlock.a9c4becf.js";import{H as ue,E as Nt}from"../chunks/getInferenceSnippets.07305897.js";function Vt(J){let i,h='🤗 Diffusers currently only supports <code>callback_on_step_end</code>, but feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you have a cool use-case and require a callback function with a different execution point!';return{c(){i=p("p"),i.innerHTML=h},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1g9pkv"&&(i.innerHTML=h)},m(o,b){s(o,i,b)},p:it,d(o){o&&l(i)}}}function St(J){let i,h='If you want to add a new official callback, feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> or <a href="https://huggingface.co/docs/diffusers/main/en/conceptual/contribution#how-to-open-a-pr" rel="nofollow">submit a PR</a>.';return{c(){i=p("p"),i.innerHTML=h},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1q7jmra"&&(i.innerHTML=h)},m(o,b){s(o,i,b)},p:it,d(o){o&&l(i)}}}function Ht(J){let i,h='The interruption callback is supported for text-to-image, image-to-image, and inpainting for the <a href="../api/pipelines/stable_diffusion/overview">StableDiffusionPipeline</a> and <a href="../api/pipelines/stable_diffusion/stable_diffusion_xl">StableDiffusionXLPipeline</a>.';return{c(){i=p("p"),i.innerHTML=h},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-q9hytq"&&(i.innerHTML=h)},m(o,b){s(o,i,b)},p:it,d(o){o&&l(i)}}}function Qt(J){let i,h='This tip was contributed by <a href="https://github.com/asomoza" rel="nofollow">asomoza</a>.';return{c(){i=p("p"),i.innerHTML=h},l(o){i=c(o,"P",{"data-svelte-h":!0}),r(i)!=="svelte-13sfhtz"&&(i.innerHTML=h)},m(o,b){s(o,i,b)},p:it,d(o){o&&l(i)}}}function zt(J){let i,h,o,b,G,de,B,pt="The denoising loop of a pipeline can be modified with custom defined functions using the <code>callback_on_step_end</code> parameter. The callback function is executed at the end of each step, and modifies the pipeline attributes and variables for the next step. This is really useful for <em>dynamically</em> adjusting certain pipeline attributes or modifying tensor variables. This versatility allows for interesting use cases such as changing the prompt embeddings at each timestep, assigning different weights to the prompt embeddings, and editing the guidance scale. With callbacks, you can implement new features without modifying the underlying code!",fe,j,ye,W,ct="This guide will demonstrate how callbacks work by a few features you can implement with them.",he,x,be,v,ot="We provide a list of callbacks you can plug into an existing pipeline and modify the denoising loop. This is the current list of official callbacks:",Je,A,rt="<li><code>SDCFGCutoffCallback</code>: Disables the CFG after a certain number of steps for all SD 1.5 pipelines, including text-to-image, image-to-image, inpaint, and controlnet.</li> <li><code>SDXLCFGCutoffCallback</code>: Disables the CFG after a certain number of steps for all SDXL pipelines, including text-to-image, image-to-image, inpaint, and controlnet.</li> <li><code>IPAdapterScaleCutoffCallback</code>: Disables the IP Adapter after a certain number of steps for all pipelines supporting IP-Adapter.</li>",we,g,je,X,Mt="To set up a callback, you need to specify the number of denoising steps after which the callback comes into effect. You can do so by using either one of these two arguments",ge,$,ut="<li><code>cutoff_step_ratio</code>: Float number with the ratio of the steps.</li> <li><code>cutoff_step_index</code>: Integer number with the exact number of the step.</li>",Te,R,Ue,T,mt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/without_cfg_callback.png" alt="generated image of a sports car at the road"/> <figcaption class="mt-2 text-center text-sm text-gray-500">without SDXLCFGCutoffCallback</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/with_cfg_callback.png" alt="generated image of a sports car at the road with cfg callback"/> <figcaption class="mt-2 text-center text-sm text-gray-500">with SDXLCFGCutoffCallback</figcaption></div>',Ze,Y,Ce,F,dt="Dynamic classifier-free guidance (CFG) is a feature that allows you to disable CFG after a certain number of inference steps which can help you save compute with minimal cost to performance. The callback function for this should have the following arguments:",_e,E,ft="<li><code>pipeline</code> (or the pipeline instance) provides access to important properties such as <code>num_timesteps</code> and <code>guidance_scale</code>. You can modify these properties by updating the underlying attributes. For this example, you’ll disable CFG by setting <code>pipeline._guidance_scale=0.0</code>.</li> <li><code>step_index</code> and <code>timestep</code> tell you where you are in the denoising loop. Use <code>step_index</code> to turn off CFG after reaching 40% of <code>num_timesteps</code>.</li> <li><code>callback_kwargs</code> is a dict that contains tensor variables you can modify during the denoising loop. It only includes variables specified in the <code>callback_on_step_end_tensor_inputs</code> argument, which is passed to the pipeline’s <code>__call__</code> method. Different pipelines may use different sets of variables, so please check a pipeline’s <code>_callback_tensor_inputs</code> attribute for the list of variables you can modify. Some common variables include <code>latents</code> and <code>prompt_embeds</code>. For this function, change the batch size of <code>prompt_embeds</code> after setting <code>guidance_scale=0.0</code> in order for it to work properly.</li>",Ie,N,yt="Your callback function should look something like this:",ke,V,Ge,S,ht="Now, you can pass the callback function to the <code>callback_on_step_end</code> parameter and the <code>prompt_embeds</code> to <code>callback_on_step_end_tensor_inputs</code>.",Be,H,We,Q,xe,U,ve,z,bt="Stopping the diffusion process early is useful when building UIs that work with Diffusers because it allows users to stop the generation process if they’re unhappy with the intermediate results. You can incorporate this into your pipeline with a callback.",Ae,L,Jt="This callback function should take the following arguments: <code>pipeline</code>, <code>i</code>, <code>t</code>, and <code>callback_kwargs</code> (this must be returned). Set the pipeline’s <code>_interrupt</code> attribute to <code>True</code> to stop the diffusion process after a certain number of steps. You are also free to implement your own custom stopping logic inside the callback.",Xe,q,wt="In this example, the diffusion process is stopped after 10 steps even though <code>num_inference_steps</code> is set to 50.",$e,D,Re,P,Ye,K,jt="IP Adapter is an image prompt adapter that can be used for diffusion models without any changes to the underlying model. We can use the IP Adapter Cutoff Callback to disable the IP Adapter after a certain number of steps. To set up the callback, you need to specify the number of denoising steps after which the callback comes into effect. You can do so by using either one of these two arguments:",Fe,O,gt="<li><code>cutoff_step_ratio</code>: Float number with the ratio of the steps.</li> <li><code>cutoff_step_index</code>: Integer number with the exact number of the step.</li>",Ee,ee,Tt="We need to download the diffusion model and load the ip_adapter for it as follows:",Ne,te,Ve,le,Ut="The setup for the callback should look something like this:",Se,se,He,Z,Zt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/without_callback.png" alt="generated image of a tiger sitting in a chair drinking orange juice"/> <figcaption class="mt-2 text-center text-sm text-gray-500">without IPAdapterScaleCutoffCallback</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/with_callback2.png" alt="generated image of a tiger sitting in a chair drinking orange juice with ip adapter callback"/> <figcaption class="mt-2 text-center text-sm text-gray-500">with IPAdapterScaleCutoffCallback</figcaption></div>',Qe,ae,ze,C,Le,ne,Ct="Display an image after each generation step by accessing and converting the latents after each step into an image. The latent space is compressed to 128x128, so the images are also 128x128 which is useful for a quick preview.",qe,ie,_t='<li>Use the function below to convert the SDXL latents (4 channels) to RGB tensors (3 channels) as explained in the <a href="https://huggingface.co/blog/TimothyAlexisVass/explaining-the-sdxl-latent-space" rel="nofollow">Explaining the SDXL latent space</a> blog post.</li>',De,pe,Pe,_,It="<li>Create a function to decode and save the latents into an image.</li>",Ke,ce,Oe,I,kt="<li>Pass the <code>decode_tensors</code> function to the <code>callback_on_step_end</code> parameter to decode the tensors after each step. You also need to specify what you want to modify in the <code>callback_on_step_end_tensor_inputs</code> parameter, which in this case are the latents.</li>",et,oe,tt,k,Gt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 0</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_19.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 19</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_29.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 29</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_39.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 39</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_49.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 49</figcaption></div>',lt,re,st,me,at;return G=new ue({props:{title:"Pipeline callbacks",local:"pipeline-callbacks",headingTag:"h1"}}),j=new nt({props:{warning:!1,$$slots:{default:[Vt]},$$scope:{ctx:J}}}),x=new ue({props:{title:"Official callbacks",local:"official-callbacks",headingTag:"h2"}}),g=new nt({props:{warning:!1,$$slots:{default:[St]},$$scope:{ctx:J}}}),R=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMuY2FsbGJhY2tzJTIwaW1wb3J0JTIwU0RYTENGR0N1dG9mZkNhbGxiYWNrJTBBJTBBJTBBY2FsbGJhY2slMjAlM0QlMjBTRFhMQ0ZHQ3V0b2ZmQ2FsbGJhY2soY3V0b2ZmX3N0ZXBfcmF0aW8lM0QwLjQpJTBBJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwdXNlZCUyMHdpdGglMjBjdXRvZmZfc3RlcF9pbmRleCUwQSUyMyUyMGNhbGxiYWNrJTIwJTNEJTIwU0RYTENGR0N1dG9mZkNhbGxiYWNrKGN1dG9mZl9zdGVwX3JhdGlvJTNETm9uZSUyQyUyMGN1dG9mZl9zdGVwX2luZGV4JTNEMTApJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMHVzZV9rYXJyYXNfc2lnbWFzJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwc3BvcnRzJTIwY2FyJTIwYXQlMjB0aGUlMjByb2FkJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBkZXRhaWwlMkMlMjA4ayUyMHJlc29sdXRpb24lMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNjI4NjcwNjQxKSUwQSUwQW91dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RjYWxsYmFjayUyQyUwQSklMEElMEFvdXQuaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMm9mZmljaWFsX2NhbGxiYWNrLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler, StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> diffusers.callbacks <span class="hljs-keyword">import</span> SDXLCFGCutoffCallback


callback = SDXLCFGCutoffCallback(cutoff_step_ratio=<span class="hljs-number">0.4</span>)
<span class="hljs-comment"># can also be used with cutoff_step_index</span>
<span class="hljs-comment"># callback = SDXLCFGCutoffCallback(cutoff_step_ratio=None, cutoff_step_index=10)</span>

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config, use_karras_sigmas=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;a sports car at the road, best quality, high quality, high detail, 8k resolution&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">2628670641</span>)

out = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    guidance_scale=<span class="hljs-number">6.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    callback_on_step_end=callback,
)

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;official_callback.png&quot;</span>)`,wrap:!1}}),Y=new ue({props:{title:"Dynamic classifier-free guidance",local:"dynamic-classifier-free-guidance",headingTag:"h2"}}),V=new w({props:{code:"ZGVmJTIwY2FsbGJhY2tfZHluYW1pY19jZmcocGlwZSUyQyUyMHN0ZXBfaW5kZXglMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBhZGp1c3QlMjB0aGUlMjBiYXRjaF9zaXplJTIwb2YlMjBwcm9tcHRfZW1iZWRzJTIwYWNjb3JkaW5nJTIwdG8lMjBndWlkYW5jZV9zY2FsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RlcF9pbmRleCUyMCUzRCUzRCUyMGludChwaXBlbGluZS5udW1fdGltZXN0ZXBzJTIwKiUyMDAuNCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIycHJvbXB0X2VtYmVkcyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlMjAlM0QlMjBwcm9tcHRfZW1iZWRzLmNodW5rKDIpJTVCLTElNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB1cGRhdGUlMjBndWlkYW5jZV9zY2FsZSUyMGFuZCUyMHByb21wdF9lbWJlZHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5fZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxsYmFja19rd2FyZ3MlNUIlMjJwcm9tcHRfZW1iZWRzJTIyJTVEJTIwJTNEJTIwcHJvbXB0X2VtYmVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">callback_dynamic_cfg</span>(<span class="hljs-params">pipe, step_index, timestep, callback_kwargs</span>):
        <span class="hljs-comment"># adjust the batch_size of prompt_embeds according to guidance_scale</span>
        <span class="hljs-keyword">if</span> step_index == <span class="hljs-built_in">int</span>(pipeline.num_timesteps * <span class="hljs-number">0.4</span>):
                prompt_embeds = callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>]
                prompt_embeds = prompt_embeds.chunk(<span class="hljs-number">2</span>)[-<span class="hljs-number">1</span>]

                <span class="hljs-comment"># update guidance_scale and prompt_embeds</span>
                pipeline._guidance_scale = <span class="hljs-number">0.0</span>
                callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>] = prompt_embeds
        <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),H=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMSklMEFvdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZCUzRGNhbGxiYWNrX2R5bmFtaWNfY2ZnJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmRfdGVuc29yX2lucHV0cyUzRCU1Qidwcm9tcHRfZW1iZWRzJyU1RCUwQSklMEElMEFvdXQuaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMm91dF9jdXN0b21fY2ZnLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
out = pipeline(
    prompt,
    generator=generator,
    callback_on_step_end=callback_dynamic_cfg,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&#x27;prompt_embeds&#x27;</span>]
)

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;out_custom_cfg.png&quot;</span>)`,wrap:!1}}),Q=new ue({props:{title:"Interrupt the diffusion process",local:"interrupt-the-diffusion-process",headingTag:"h2"}}),U=new nt({props:{warning:!1,$$slots:{default:[Ht]},$$scope:{ctx:J}}}),D=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBbnVtX2luZmVyZW5jZV9zdGVwcyUyMCUzRCUyMDUwJTBBJTBBZGVmJTIwaW50ZXJydXB0X2NhbGxiYWNrKHBpcGVsaW5lJTJDJTIwaSUyQyUyMHQlMkMlMjBjYWxsYmFja19rd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwc3RvcF9pZHglMjAlM0QlMjAxMCUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRCUzRCUyMHN0b3BfaWR4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUuX2ludGVycnVwdCUyMCUzRCUyMFRydWUlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjYWxsYmFja19rd2FyZ3MlMEElMEFwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEaW50ZXJydXB0X2NhbGxiYWNrJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
pipeline.enable_model_cpu_offload()
num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">interrupt_callback</span>(<span class="hljs-params">pipeline, i, t, callback_kwargs</span>):
    stop_idx = <span class="hljs-number">10</span>
    <span class="hljs-keyword">if</span> i == stop_idx:
        pipeline._interrupt = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">return</span> callback_kwargs

pipeline(
    <span class="hljs-string">&quot;A photo of a cat&quot;</span>,
    num_inference_steps=num_inference_steps,
    callback_on_step_end=interrupt_callback,
)`,wrap:!1}}),P=new ue({props:{title:"IP Adapter Cutoff",local:"ip-adapter-cutoff",headingTag:"h2"}}),te=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),se=new w({props:{code:"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",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.callbacks <span class="hljs-keyword">import</span> IPAdapterScaleCutoffCallback
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
 

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, 
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)


pipeline.load_ip_adapter(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)


callback = IPAdapterScaleCutoffCallback(
    cutoff_step_ratio=<span class="hljs-literal">None</span>, 
    cutoff_step_index=<span class="hljs-number">5</span>
)

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>
)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">2628670641</span>)

images = pipeline(
    prompt=<span class="hljs-string">&quot;a tiger sitting in a chair drinking orange juice&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    generator=generator,
    num_inference_steps=<span class="hljs-number">50</span>,
    callback_on_step_end=callback,
).images

images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;custom_callback_img.png&quot;</span>)`,wrap:!1}}),ae=new ue({props:{title:"Display image after each generation step",local:"display-image-after-each-generation-step",headingTag:"h2"}}),C=new nt({props:{warning:!1,$$slots:{default:[Qt]},$$scope:{ctx:J}}}),pe=new w({props:{code:"ZGVmJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklM0ElMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMC02MCUyQyUyMDI1JTJDJTIwLTcwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMCUyMC01JTJDJTIwMTUlMkMlMjAtNTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKDYwJTJDJTIwJTIwMTAlMkMlMjAtNSUyQyUyMC0zNSklMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwd2VpZ2h0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC50KHRvcmNoLnRlbnNvcih3ZWlnaHRzJTJDJTIwZHR5cGUlM0RsYXRlbnRzLmR0eXBlKS50byhsYXRlbnRzLmRldmljZSkpJTBBJTIwJTIwJTIwJTIwYmlhc2VzX3RlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvcigoMTUwJTJDJTIwMTQwJTJDJTIwMTMwKSUyQyUyMGR0eXBlJTNEbGF0ZW50cy5kdHlwZSkudG8obGF0ZW50cy5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwcmdiX3RlbnNvciUyMCUzRCUyMHRvcmNoLmVpbnN1bSglMjIuLi5seHklMkNsciUyMC0lM0UlMjAuLi5yeHklMjIlMkMlMjBsYXRlbnRzJTJDJTIwd2VpZ2h0c190ZW5zb3IpJTIwJTJCJTIwYmlhc2VzX3RlbnNvci51bnNxdWVlemUoLTEpLnVuc3F1ZWV6ZSgtMSklMEElMjAlMjAlMjAlMjBpbWFnZV9hcnJheSUyMCUzRCUyMHJnYl90ZW5zb3IuY2xhbXAoMCUyQyUyMDI1NSkuYnl0ZSgpLmNwdSgpLm51bXB5KCkudHJhbnNwb3NlKDElMkMlMjAyJTJDJTIwMCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2VfYXJyYXkp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">latents_to_rgb</span>(<span class="hljs-params">latents</span>):
    weights = (
        (<span class="hljs-number">60</span>, -<span class="hljs-number">60</span>, <span class="hljs-number">25</span>, -<span class="hljs-number">70</span>),
        (<span class="hljs-number">60</span>,  -<span class="hljs-number">5</span>, <span class="hljs-number">15</span>, -<span class="hljs-number">50</span>),
        (<span class="hljs-number">60</span>,  <span class="hljs-number">10</span>, -<span class="hljs-number">5</span>, -<span class="hljs-number">35</span>),
    )

    weights_tensor = torch.t(torch.tensor(weights, dtype=latents.dtype).to(latents.device))
    biases_tensor = torch.tensor((<span class="hljs-number">150</span>, <span class="hljs-number">140</span>, <span class="hljs-number">130</span>), dtype=latents.dtype).to(latents.device)
    rgb_tensor = torch.einsum(<span class="hljs-string">&quot;...lxy,lr -&gt; ...rxy&quot;</span>, latents, weights_tensor) + biases_tensor.unsqueeze(-<span class="hljs-number">1</span>).unsqueeze(-<span class="hljs-number">1</span>)
    image_array = rgb_tensor.clamp(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).byte().cpu().numpy().transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)

    <span class="hljs-keyword">return</span> Image.fromarray(image_array)`,wrap:!1}}),ce=new w({props:{code:"ZGVmJTIwZGVjb2RlX3RlbnNvcnMocGlwZSUyQyUyMHN0ZXAlMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIybGF0ZW50cyUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyJTdCc3RlcCU3RC5wbmclMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FsbGJhY2tfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_tensors</span>(<span class="hljs-params">pipe, step, timestep, callback_kwargs</span>):
    latents = callback_kwargs[<span class="hljs-string">&quot;latents&quot;</span>]

    image = latents_to_rgb(latents[<span class="hljs-number">0</span>])
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{step}</span>.png&quot;</span>)

    <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),oe=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMGNyb2lzc2FudCUyMHNoYXBlZCUyMGxpa2UlMjBhJTIwY3V0ZSUyMGJlYXIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyRGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwYmFkJTIwYW5hdG9teSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEZGVjb2RlX3RlbnNvcnMlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZF90ZW5zb3JfaW5wdXRzJTNEJTVCJTIybGF0ZW50cyUyMiU1RCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A croissant shaped like a cute bear.&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;Deformed, ugly, bad anatomy&quot;</span>,
    callback_on_step_end=decode_tensors,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&quot;latents&quot;</span>],
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),re=new Nt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/callback.md"}}),{c(){i=p("meta"),h=a(),o=p("p"),b=a(),M(G.$$.fragment),de=a(),B=p("p"),B.innerHTML=pt,fe=a(),M(j.$$.fragment),ye=a(),W=p("p"),W.textContent=ct,he=a(),M(x.$$.fragment),be=a(),v=p("p"),v.textContent=ot,Je=a(),A=p("ul"),A.innerHTML=rt,we=a(),M(g.$$.fragment),je=a(),X=p("p"),X.textContent=Mt,ge=a(),$=p("ul"),$.innerHTML=ut,Te=a(),M(R.$$.fragment),Ue=a(),T=p("div"),T.innerHTML=mt,Ze=a(),M(Y.$$.fragment),Ce=a(),F=p("p"),F.textContent=dt,_e=a(),E=p("ul"),E.innerHTML=ft,Ie=a(),N=p("p"),N.textContent=yt,ke=a(),M(V.$$.fragment),Ge=a(),S=p("p"),S.innerHTML=ht,Be=a(),M(H.$$.fragment),We=a(),M(Q.$$.fragment),xe=a(),M(U.$$.fragment),ve=a(),z=p("p"),z.textContent=bt,Ae=a(),L=p("p"),L.innerHTML=Jt,Xe=a(),q=p("p"),q.innerHTML=wt,$e=a(),M(D.$$.fragment),Re=a(),M(P.$$.fragment),Ye=a(),K=p("p"),K.textContent=jt,Fe=a(),O=p("ul"),O.innerHTML=gt,Ee=a(),ee=p("p"),ee.textContent=Tt,Ne=a(),M(te.$$.fragment),Ve=a(),le=p("p"),le.textContent=Ut,Se=a(),M(se.$$.fragment),He=a(),Z=p("div"),Z.innerHTML=Zt,Qe=a(),M(ae.$$.fragment),ze=a(),M(C.$$.fragment),Le=a(),ne=p("p"),ne.textContent=Ct,qe=a(),ie=p("ol"),ie.innerHTML=_t,De=a(),M(pe.$$.fragment),Pe=a(),_=p("ol"),_.innerHTML=It,Ke=a(),M(ce.$$.fragment),Oe=a(),I=p("ol"),I.innerHTML=kt,et=a(),M(oe.$$.fragment),tt=a(),k=p("div"),k.innerHTML=Gt,lt=a(),M(re.$$.fragment),st=a(),me=p("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(l),h=n(e),o=c(e,"P",{}),At(o).forEach(l),b=n(e),u(G.$$.fragment,e),de=n(e),B=c(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ex9ief"&&(B.innerHTML=pt),fe=n(e),u(j.$$.fragment,e),ye=n(e),W=c(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ct42i6"&&(W.textContent=ct),he=n(e),u(x.$$.fragment,e),be=n(e),v=c(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1b451ym"&&(v.textContent=ot),Je=n(e),A=c(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-vd4zqd"&&(A.innerHTML=rt),we=n(e),u(g.$$.fragment,e),je=n(e),X=c(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1y502l4"&&(X.textContent=Mt),ge=n(e),$=c(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-3im7a1"&&($.innerHTML=ut),Te=n(e),u(R.$$.fragment,e),Ue=n(e),T=c(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-17tud58"&&(T.innerHTML=mt),Ze=n(e),u(Y.$$.fragment,e),Ce=n(e),F=c(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1f6wgfp"&&(F.textContent=dt),_e=n(e),E=c(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-dtd0ri"&&(E.innerHTML=ft),Ie=n(e),N=c(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s2b9st"&&(N.textContent=yt),ke=n(e),u(V.$$.fragment,e),Ge=n(e),S=c(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-y3yxaw"&&(S.innerHTML=ht),Be=n(e),u(H.$$.fragment,e),We=n(e),u(Q.$$.fragment,e),xe=n(e),u(U.$$.fragment,e),ve=n(e),z=c(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1nej5ag"&&(z.textContent=bt),Ae=n(e),L=c(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-zdg2uc"&&(L.innerHTML=Jt),Xe=n(e),q=c(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-s21qgj"&&(q.innerHTML=wt),$e=n(e),u(D.$$.fragment,e),Re=n(e),u(P.$$.fragment,e),Ye=n(e),K=c(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1xau8un"&&(K.textContent=jt),Fe=n(e),O=c(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-3im7a1"&&(O.innerHTML=gt),Ee=n(e),ee=c(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1f2qpl3"&&(ee.textContent=Tt),Ne=n(e),u(te.$$.fragment,e),Ve=n(e),le=c(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-bjmgr4"&&(le.textContent=Ut),Se=n(e),u(se.$$.fragment,e),He=n(e),Z=c(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1qb4eti"&&(Z.innerHTML=Zt),Qe=n(e),u(ae.$$.fragment,e),ze=n(e),u(C.$$.fragment,e),Le=n(e),ne=c(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ofpl9u"&&(ne.textContent=Ct),qe=n(e),ie=c(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-19fyqau"&&(ie.innerHTML=_t),De=n(e),u(pe.$$.fragment,e),Pe=n(e),_=c(e,"OL",{start:!0,"data-svelte-h":!0}),r(_)!=="svelte-ebwxn0"&&(_.innerHTML=It),Ke=n(e),u(ce.$$.fragment,e),Oe=n(e),I=c(e,"OL",{start:!0,"data-svelte-h":!0}),r(I)!=="svelte-1r24q0u"&&(I.innerHTML=kt),et=n(e),u(oe.$$.fragment,e),tt=n(e),k=c(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-o2x0os"&&(k.innerHTML=Gt),lt=n(e),u(re.$$.fragment,e),st=n(e),me=c(e,"P",{}),At(me).forEach(l),this.h()},h(){Me(i,"name","hf:doc:metadata"),Me(i,"content",Lt),Me(T,"class","flex gap-4"),Me(Z,"class","flex gap-4"),Me(_,"start","2"),Me(I,"start","3"),Me(k,"class","flex gap-4 justify-center")},m(e,t){Et(document.head,i),s(e,h,t),s(e,o,t),s(e,b,t),m(G,e,t),s(e,de,t),s(e,B,t),s(e,fe,t),m(j,e,t),s(e,ye,t),s(e,W,t),s(e,he,t),m(x,e,t),s(e,be,t),s(e,v,t),s(e,Je,t),s(e,A,t),s(e,we,t),m(g,e,t),s(e,je,t),s(e,X,t),s(e,ge,t),s(e,$,t),s(e,Te,t),m(R,e,t),s(e,Ue,t),s(e,T,t),s(e,Ze,t),m(Y,e,t),s(e,Ce,t),s(e,F,t),s(e,_e,t),s(e,E,t),s(e,Ie,t),s(e,N,t),s(e,ke,t),m(V,e,t),s(e,Ge,t),s(e,S,t),s(e,Be,t),m(H,e,t),s(e,We,t),m(Q,e,t),s(e,xe,t),m(U,e,t),s(e,ve,t),s(e,z,t),s(e,Ae,t),s(e,L,t),s(e,Xe,t),s(e,q,t),s(e,$e,t),m(D,e,t),s(e,Re,t),m(P,e,t),s(e,Ye,t),s(e,K,t),s(e,Fe,t),s(e,O,t),s(e,Ee,t),s(e,ee,t),s(e,Ne,t),m(te,e,t),s(e,Ve,t),s(e,le,t),s(e,Se,t),m(se,e,t),s(e,He,t),s(e,Z,t),s(e,Qe,t),m(ae,e,t),s(e,ze,t),m(C,e,t),s(e,Le,t),s(e,ne,t),s(e,qe,t),s(e,ie,t),s(e,De,t),m(pe,e,t),s(e,Pe,t),s(e,_,t),s(e,Ke,t),m(ce,e,t),s(e,Oe,t),s(e,I,t),s(e,et,t),m(oe,e,t),s(e,tt,t),s(e,k,t),s(e,lt,t),m(re,e,t),s(e,st,t),s(e,me,t),at=!0},p(e,[t]){const Bt={};t&2&&(Bt.$$scope={dirty:t,ctx:e}),j.$set(Bt);const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),g.$set(Wt);const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),U.$set(xt);const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),C.$set(vt)},i(e){at||(d(G.$$.fragment,e),d(j.$$.fragment,e),d(x.$$.fragment,e),d(g.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(U.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(C.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),at=!0)},o(e){f(G.$$.fragment,e),f(j.$$.fragment,e),f(x.$$.fragment,e),f(g.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(Q.$$.fragment,e),f(U.$$.fragment,e),f(D.$$.fragment,e),f(P.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(C.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),at=!1},d(e){e&&(l(h),l(o),l(b),l(de),l(B),l(fe),l(ye),l(W),l(he),l(be),l(v),l(Je),l(A),l(we),l(je),l(X),l(ge),l($),l(Te),l(Ue),l(T),l(Ze),l(Ce),l(F),l(_e),l(E),l(Ie),l(N),l(ke),l(Ge),l(S),l(Be),l(We),l(xe),l(ve),l(z),l(Ae),l(L),l(Xe),l(q),l($e),l(Re),l(Ye),l(K),l(Fe),l(O),l(Ee),l(ee),l(Ne),l(Ve),l(le),l(Se),l(He),l(Z),l(Qe),l(ze),l(Le),l(ne),l(qe),l(ie),l(De),l(Pe),l(_),l(Ke),l(Oe),l(I),l(et),l(tt),l(k),l(lt),l(st),l(me)),l(i),y(G,e),y(j,e),y(x,e),y(g,e),y(R,e),y(Y,e),y(V,e),y(H,e),y(Q,e),y(U,e),y(D,e),y(P,e),y(te,e),y(se,e),y(ae,e),y(C,e),y(pe,e),y(ce,e),y(oe,e),y(re,e)}}}const Lt='{"title":"Pipeline callbacks","local":"pipeline-callbacks","sections":[{"title":"Official callbacks","local":"official-callbacks","sections":[],"depth":2},{"title":"Dynamic classifier-free guidance","local":"dynamic-classifier-free-guidance","sections":[],"depth":2},{"title":"Interrupt the diffusion process","local":"interrupt-the-diffusion-process","sections":[],"depth":2},{"title":"IP Adapter Cutoff","local":"ip-adapter-cutoff","sections":[],"depth":2},{"title":"Display image after each generation step","local":"display-image-after-each-generation-step","sections":[],"depth":2}],"depth":1}';function qt(J){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Rt{constructor(i){super(),Yt(this,i,qt,zt,Xt,{})}}export{tl as component};
