import{s as Lt,o as Dt,n as I}from"../chunks/scheduler.8c3d61f6.js";import{S as Pt,i as Kt,g as o,s as a,r as c,A as Ot,h as p,f as s,c as n,j as At,u as d,x as m,k as qt,y as ea,a as t,v as u,d as f,t as M,w as y}from"../chunks/index.da70eac4.js";import{T as g}from"../chunks/Tip.1d9b8c37.js";import{C as w}from"../chunks/CodeBlock.a9c4becf.js";import{H as U,E as la}from"../chunks/getInferenceSnippets.07305897.js";function sa(T){let i,h="Keep in mind these techniques may need to be adjusted depending on the model! For example, a transformer-based diffusion model may not benefit equally from these inference speed optimizations as a UNet-based model.";return{c(){i=o("p"),i.textContent=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-r6j6il"&&(i.textContent=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function ta(T){let i,h="Device placement is an experimental feature and the API may change. Only the <code>balanced</code> strategy is supported at the moment. We plan to support additional mapping strategies in the future.";return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1tuq9h4"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function aa(T){let i,h='Don’t move the pipeline to CUDA before calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, otherwise the amount of memory saved is only minimal (refer to this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more details). This is a stateful operation that installs hooks on the model.';return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1d1bxgj"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function na(T){let i,h='Keep in mind that if models are reused outside the pipeline after hookes have been installed (see <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more details), you need to run the entire pipeline and models in the expected order to properly offload them. This is a stateful operation that installs hooks on the model.';return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fx1eup"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function ia(T){let i,h="Group offloading may not work with all models if the forward implementation contains weight-dependent device casting of inputs because it may clash with group offloading’s device casting mechanism.";return{c(){i=o("p"),i.textContent=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-78t6ea"&&(i.textContent=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function oa(T){let i,h="When <code>use_stream=True</code> on VAEs with tiling enabled, make sure to do a dummy forward pass (possible with dummy inputs as well) before inference to avoid device mismatch errors. This may not work on all implementations, so feel free to open an issue if you encounter any problems.";return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1j8tvtw"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function pa(T){let i,h=`The offloading strategies can be combined with <a href="../quantization/overview.md">quantization</a> to enable further memory savings. For image generation, combining <a href="#model-offloading">quantization and model offloading</a> can often give the best trade-off between quality, speed, and memory. However, for video generation, as the models are more
compute-bound, <a href="#group-offloading">group-offloading</a> tends to be better. Group offloading provides considerable benefits when weight transfers can be overlapped with computation (must use streams). When applying group offloading with quantization on image generation models at typical resolutions (1024x1024, for example), it is usually not possible to <em>fully</em> overlap weight transfers if the compute kernel finishes faster, making it communication bound between CPU/GPU (due to device synchronizations).`;return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-cnadka"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function ra(T){let i,h='Layerwise casting may not work with all models if the forward implementation contains internal typecasting of weights. The current implementation of layerwise casting assumes the forward pass is independent of the weight precision and the input datatypes are always specified in <code>compute_dtype</code> (see <a href="https://github.com/huggingface/transformers/blob/7f5077e53682ca855afc826162b204ebf809f1f9/src/transformers/models/t5/modeling_t5.py#L294-L299" rel="nofollow">here</a> for an incompatible implementation).',r,J,Z='Layerwise casting may also fail on custom modeling implementations with <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a> layers. There are some checks available but they are not extensively tested or guaranteed to work in all cases.';return{c(){i=o("p"),i.innerHTML=h,r=a(),J=o("p"),J.innerHTML=Z},l(b){i=p(b,"P",{"data-svelte-h":!0}),m(i)!=="svelte-nfpqdo"&&(i.innerHTML=h),r=n(b),J=p(b,"P",{"data-svelte-h":!0}),m(J)!=="svelte-5074v9"&&(J.innerHTML=Z)},m(b,j){t(b,i,j),t(b,r,j),t(b,J,j)},p:I,d(b){b&&(s(i),s(r),s(J))}}}function ma(T){let i,h="Memory-efficient attention optimizes for memory usage <em>and</em> [inference speed](./fp16#scaled-dot-product-attention!";return{c(){i=o("p"),i.innerHTML=h},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1k0sy9z"&&(i.innerHTML=h)},m(r,J){t(r,i,J)},p:I,d(r){r&&s(i)}}}function ca(T){let i,h,r,J,Z,b,j,Fs='Modern diffusion models like <a href="../api/pipelines/flux">Flux</a> and <a href="../api/pipelines/wan">Wan</a> have billions of parameters that take up a lot of memory on your hardware for inference. This is challenging because common GPUs often don’t have sufficient memory. To overcome the memory limitations, you can use more than one GPU (if available), offload some of the pipeline components to the CPU, and more.',rl,X,As="This guide will show you how to reduce your memory usage.",ml,G,cl,R,dl,x,qs='If you have access to more than one GPU, there a few options for efficiently loading and distributing a large model across your hardware. These features are supported by the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> library, so make sure it is installed first.',ul,Y,fl,Q,Ml,H,Ls="Loading large checkpoints in several shards in useful because the shards are loaded one at a time. This keeps memory usage low, only requiring enough memory for the model size and the largest shard size. We recommend sharding when the fp32 checkpoint is greater than 5GB. The default shard size is 5GB.",yl,N,Ds='Shard a checkpoint in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a> with the <code>max_shard_size</code> parameter.',hl,E,Jl,S,Ps="Now you can use the sharded checkpoint, instead of the regular checkpoint, to save memory.",wl,z,Tl,F,bl,_,Ul,A,Ks="The <code>device_map</code> parameter controls how the model components in a pipeline are distributed across devices. The <code>balanced</code> device placement strategy evenly splits the pipeline across all available devices.",jl,q,Zl,L,Os="You can inspect a pipeline’s device map with <code>hf_device_map</code>.",gl,D,Il,P,et='The <code>device_map</code> parameter also works on the model-level. This is useful for loading large models, such as the Flux diffusion transformer which has 12.5B parameters. Instead of <code>balanced</code>, set it to <code>&quot;auto&quot;</code> to automatically distribute a model across the fastest device first before moving to slower devices. Refer to the <a href="../training/distributed_inference#model-sharding">Model sharding</a> docs for more details.',Gl,K,_l,O,lt="For more fine-grained control, pass a dictionary to enforce the maximum GPU memory to use on each device. If a device is not in <code>max_memory</code>, it is ignored and pipeline components won’t be distributed to it.",vl,ee,Wl,le,st="Diffusers uses the maxmium memory of all devices by default, but if they don’t fit on the GPUs, then you’ll need to use a single GPU and offload to the CPU with the methods below.",Cl,se,tt='<li><a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> only works on a single GPU but a very large model may not fit on it</li> <li><a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> may work but it is extremely slow and also limited to a single GPU</li>',Bl,te,at='Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> method to reset the <code>device_map</code>. This is necessary if you want to use methods like <code>.to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on a pipeline that was device-mapped.',Vl,ae,$l,ne,kl,ie,nt="VAE slicing saves memory by splitting large batches of inputs into a single batch of data and separately processing them. This method works best when generating more than one image at a time.",Xl,oe,it="For example, if you’re generating 4 images at once, decoding would increase peak activation memory by 4x. VAE slicing reduces this by only decoding 1 image at a time instead of all 4 images at once.",Rl,pe,ot='Call <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.enable_vae_slicing">enable_vae_slicing()</a> to enable sliced VAE. You can expect a small increase in performance when decoding multi-image batches and no performance impact for single-image batches.',xl,re,Yl,me,pt='<p>[!WARNING][AutoencoderKLWan](/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan) and <a href="/docs/diffusers/main/en/api/models/asymmetricautoencoderkl#diffusers.AsymmetricAutoencoderKL">AsymmetricAutoencoderKL</a> don’t support slicing.</p>',Ql,ce,Hl,de,rt="VAE tiling saves memory by dividing an image into smaller overlapping tiles instead of processing the entire image at once. This also reduces peak memory usage because the GPU is only processing a tile at a time.",Nl,ue,mt='Call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> to enable VAE tiling. The generated image may have some tone variation from tile-to-tile because they’re decoded separately, but there shouldn’t be any obvious seams between the tiles. Tiling is disabled for resolutions lower than a pre-specified (but configurable) limit. For example, this limit is 512x512 for the VAE in <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>.',El,fe,Sl,Me,ct='<p>[!WARNING][AutoencoderKLWan](/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan) and <a href="/docs/diffusers/main/en/api/models/asymmetricautoencoderkl#diffusers.AsymmetricAutoencoderKL">AsymmetricAutoencoderKL</a> don’t support tiling.</p>',zl,ye,Fl,he,dt="CPU offloading selectively moves weights from the GPU to the CPU. When a component is required, it is transferred to the GPU and when it isn’t required, it is moved to the CPU. This method works on submodules rather than whole models. It saves memory by avoiding storing the entire model on the GPU.",Al,Je,ut="CPU offloading dramatically reduces memory usage, but it is also <strong>extremely slow</strong> because submodules are passed back and forth multiple times between devices. It can often be impractical due to how slow it is.",ql,v,Ll,we,ft='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> to enable it on a pipeline.',Dl,Te,Pl,be,Kl,Ue,Mt='Model offloading moves entire models to the GPU instead of selectively moving <em>some</em> layers or model components. One of the main pipeline models, usually the text encoder, UNet, and VAE, is placed on the GPU while the other components are held on the CPU. Components like the UNet that run multiple times stays on the GPU until its completely finished and no longer needed. This eliminates the communication overhead of <a href="#cpu-offloading">CPU offloading</a> and makes model offloading a faster alternative. The tradeoff is memory savings won’t be as large.',Ol,W,es,je,yt='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to enable it on a pipeline.',ls,Ze,ss,ge,ht='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> also helps when you’re using the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.encode_prompt">encode_prompt()</a> method on its own to generate the text encoders hidden state.',ts,Ie,as,Ge,Jt='Group offloading moves groups of internal layers (<a href="https://pytorch.org/docs/stable/generated/torch.nn.ModuleList.html" rel="nofollow">torch.nn.ModuleList</a> or <a href="https://pytorch.org/docs/stable/generated/torch.nn.Sequential.html" rel="nofollow">torch.nn.Sequential</a>) to the CPU. It uses less memory than <a href="#model-offloading">model offloading</a> and it is faster than <a href="#cpu-offloading">CPU offloading</a> because it reduces communication overhead.',ns,C,is,_e,wt='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_group_offload">enable_group_offload()</a> to enable it for standard Diffusers model components that inherit from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. For other model components that don’t inherit from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>, such as a generic <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">torch.nn.Module</a>, use <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a> instead.',os,ve,Tt="The <code>offload_type</code> parameter can be set to <code>block_level</code> or <code>leaf_level</code>.",ps,We,bt='<li><code>block_level</code> offloads groups of layers based on the <code>num_blocks_per_group</code> parameter. For example, if <code>num_blocks_per_group=2</code> on a model with 40 layers, 2 layers are onloaded and offloaded at a time (20 total onloads/offloads). This drastically reduces memory requirements.</li> <li><code>leaf_level</code> offloads individual layers at the lowest level and is equivalent to <a href="#cpu-offloading">CPU offloading</a>. But it can be made faster if you use streams without giving up inference speed.</li>',rs,Ce,ms,Be,cs,Ve,Ut='The <code>use_stream</code> parameter can be activated for CUDA devices that support asynchronous data transfer streams to reduce overall execution time compared to <a href="#cpu-offloading">CPU offloading</a>. It overlaps data transfer and computation by using layer prefetching. The next layer to be executed is loaded onto the GPU while the current layer is still being executed. It can increase CPU memory significantly so ensure you have 2x the amount of memory as the model size.',ds,$e,jt='Set <code>record_stream=True</code> for more of a speedup at the cost of slightly increased memory usage. Refer to the <a href="https://pytorch.org/docs/stable/generated/torch.Tensor.record_stream.html" rel="nofollow">torch.Tensor.record_stream</a> docs to learn more.',us,B,fs,ke,Zt="If you’re using <code>block_level</code> group offloading with <code>use_stream</code> enabled, the <code>num_blocks_per_group</code> parameter should be set to <code>1</code>, otherwise a warning will be raised.",Ms,Xe,ys,Re,gt="The <code>low_cpu_mem_usage</code> parameter can be set to <code>True</code> to reduce CPU memory usage when using streams during group offloading. It is best for <code>leaf_level</code> offloading and when CPU memory is bottlenecked. Memory is saved by creating pinned tensors on the fly instead of pre-pinning them. However, this may increase overall execution time.",hs,V,Js,xe,ws,Ye,It="Layerwise casting stores weights in a smaller data format (for example, <code>torch.float8_e4m3fn</code> and <code>torch.float8_e5m2</code>) to use less memory and upcasts those weights to a higher precision like <code>torch.float16</code> or <code>torch.bfloat16</code> for computation. Certain layers (normalization and modulation related weights) are skipped because storing them in fp8 can degrade generation quality.",Ts,$,bs,Qe,Gt='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_layerwise_casting">enable_layerwise_casting()</a> to set the storage and computation datatypes.',Us,He,js,Ne,_t='The <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_layerwise_casting">apply_layerwise_casting()</a> method can also be used if you need more control and flexibility. It can be partially applied to model layers by calling it on specific internal modules. Use the <code>skip_modules_pattern</code> or <code>skip_modules_classes</code> parameters to specify modules to avoid, such as the normalization and modulation layers.',Zs,Ee,gs,Se,Is,ze,vt='<a href="https://pytorch.org/tutorials/intermediate/memory_format_tutorial.html" rel="nofollow">torch.channels_last</a> flips how tensors are stored from <code>(batch size, channels, height, width)</code> to <code>(batch size, heigh, width, channels)</code>. This aligns the tensors with how the hardware sequentially accesses the tensors stored in memory and avoids skipping around in memory to access the pixel values.',Gs,Fe,Wt="Not all operators currently support the channels-last format and may result in worst performance, but it is still worth trying.",_s,Ae,vs,qe,Ws,Le,Ct='<a href="https://pytorch.org/docs/stable/generated/torch.jit.trace.html" rel="nofollow">torch.jit.trace</a> records the operations a model performs on a sample input and creates a new, optimized representation of the model based on the recorded execution path. During tracing, the model is optimized to reduce overhead from Python and dynamic control flows and operations are fused together for more efficiency. The returned executable or <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptFunction.html" rel="nofollow">ScriptFunction</a> can be compiled.',Cs,De,Bs,Pe,Bt="Replace the pipeline’s UNet with the traced version.",Vs,Ke,$s,Oe,ks,k,Xs,el,Vt="The Transformers attention mechanism is memory-intensive, especially for long sequences, so you can try using different and more memory-efficient attention types.",Rs,ll,$t='By default, if PyTorch &gt;= 2.0 is installed, <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">scaled dot-product attention (SDPA)</a> is used. You don’t need to make any additional changes to your code.',xs,sl,kt='SDPA supports <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a> and <a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a> as well as a native C++ PyTorch implementation. It automatically selects the most optimal implementation based on your input.',Ys,tl,Xt='You can explicitly use xFormers with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> method.',Qs,al,Hs,nl,Rt='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.disable_xformers_memory_efficient_attention">disable_xformers_memory_efficient_attention()</a> to disable it.',Ns,il,Es,ol,Ss,pl,zs;return Z=new U({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),G=new g({props:{warning:!1,$$slots:{default:[sa]},$$scope:{ctx:T}}}),R=new U({props:{title:"Multiple GPUs",local:"multiple-gpus",headingTag:"h2"}}),Y=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install -U accelerate",wrap:!1}}),Q=new U({props:{title:"Sharded checkpoints",local:"sharded-checkpoints",headingTag:"h3"}}),E=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMEEpJTBBdW5ldC5zYXZlX3ByZXRyYWluZWQoJTIyc2R4bC11bmV0LXNoYXJkZWQlMjIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>
)
unet.save_pretrained(<span class="hljs-string">&quot;sdxl-unet-sharded&quot;</span>, max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>)`,wrap:!1}}),z=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnVzZXJuYW1lJTJGc2R4bC11bmV0LXNoYXJkZWQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;username/sdxl-unet-sharded&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    unet=unet,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),F=new U({props:{title:"Device placement",local:"device-placement",headingTag:"h3"}}),_=new g({props:{warning:!0,$$slots:{default:[ta]},$$scope:{ctx:T}}}),q=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>
)`,wrap:!1}}),D=new w({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCklMEElN0IndW5ldCclM0ElMjAxJTJDJTIwJ3ZhZSclM0ElMjAxJTJDJTIwJ3NhZmV0eV9jaGVja2VyJyUzQSUyMDAlMkMlMjAndGV4dF9lbmNvZGVyJyUzQSUyMDAlN0Q=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.hf_device_map)
{<span class="hljs-string">&#x27;unet&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;vae&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;safety_checker&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text_encoder&#x27;</span>: <span class="hljs-number">0</span>}`,wrap:!1}}),K=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),ee=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1heF9tZW1vcnklMjAlM0QlMjAlN0IwJTNBJTIyMUdCJTIyJTJDJTIwMSUzQSUyMjFHQiUyMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X21lbW9yeSUzRG1heF9tZW1vcnklMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

max_memory = {<span class="hljs-number">0</span>:<span class="hljs-string">&quot;1GB&quot;</span>, <span class="hljs-number">1</span>:<span class="hljs-string">&quot;1GB&quot;</span>}
pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory=max_memory
)`,wrap:!1}}),ae=new w({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),ne=new U({props:{title:"VAE slicing",local:"vae-slicing",headingTag:"h2"}}),re=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZWxpbmUoJTVCJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyME1hcnMlMjIlNUQqMzIpLmltYWdlcyU1QjAlNUQlMEFwcmludChmJTIyTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KiozJTNBLjJmJTdEJTIwR0IlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_vae_slicing()
pipeline([<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>]*<span class="hljs-number">32</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),ce=new U({props:{title:"VAE tiling",local:"vae-tiling",headingTag:"h2"}}),fe=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1zZHhsLWluaXQucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNSkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_vae_tiling()

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),ye=new U({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),v=new g({props:{warning:!0,$$slots:{default:[aa]},$$scope:{ctx:T}}}),Te=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyME1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBcHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMHJlc2VydmVkJTNBJTIwJTdCdG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTIwJTJGJTIwMTAyNCoqMyUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline.enable_sequential_cpu_offload()

pipeline(
    prompt=<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),be=new U({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),W=new g({props:{warning:!0,$$slots:{default:[na]},$$scope:{ctx:T}}}),Ze=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyME1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBcHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMHJlc2VydmVkJTNBJTIwJTdCdG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTIwJTJGJTIwMTAyNCoqMyUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16
)
pipline.enable_model_cpu_offload()

pipeline(
    prompt=<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),Ie=new U({props:{title:"Group offloading",local:"group-offloading",headingTag:"h2"}}),C=new g({props:{warning:!0,$$slots:{default:[ia]},$$scope:{ctx:T}}}),Ce=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
pipeline = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># Use the enable_group_offload method for Diffusers model implementations</span>
pipeline.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)
pipeline.vae.enable_group_offload(onload_device=onload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)

<span class="hljs-comment"># Use the apply_group_offloading method for other model components</span>
apply_group_offloading(pipeline.text_encoder, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;block_level&quot;</span>, num_blocks_per_group=<span class="hljs-number">2</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),Be=new U({props:{title:"CUDA stream",local:"cuda-stream",headingTag:"h3"}}),B=new g({props:{warning:!1,$$slots:{default:[oa]},$$scope:{ctx:T}}}),Xe=new w({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX2dyb3VwX29mZmxvYWQob25sb2FkX2RldmljZSUzRG9ubG9hZF9kZXZpY2UlMkMlMjBvZmZsb2FkX2RldmljZSUzRG9mZmxvYWRfZGV2aWNlJTJDJTIwb2ZmbG9hZF90eXBlJTNEJTIybGVhZl9sZXZlbCUyMiUyQyUyMHVzZV9zdHJlYW0lM0RUcnVlJTJDJTIwcmVjb3JkX3N0cmVhbSUzRFRydWUp",highlighted:'pipeline.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>, use_stream=<span class="hljs-literal">True</span>, record_stream=<span class="hljs-literal">True</span>)',wrap:!1}}),V=new g({props:{$$slots:{default:[pa]},$$scope:{ctx:T}}}),xe=new U({props:{title:"Layerwise casting",local:"layerwise-casting",headingTag:"h2"}}),$=new g({props:{warning:!0,$$slots:{default:[ra]},$$scope:{ctx:T}}}),He=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

transformer = CogVideoXTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16
)
transformer.enable_layerwise_casting(storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)

pipeline = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),Ee=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YVHJhbnNmb3JtZXIzRE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5ob29rcyUyMGltcG9ydCUyMGFwcGx5X2xheWVyd2lzZV9jYXN0aW5nJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBDb2dWaWRlb1hUcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMHNraXAlMjB0aGUlMjBub3JtYWxpemF0aW9uJTIwbGF5ZXIlMEFhcHBseV9sYXllcndpc2VfY2FzdGluZyglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2VfZHR5cGUlM0R0b3JjaC5mbG9hdDhfZTRtM2ZuJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwc2tpcF9tb2R1bGVzX2NsYXNzZXMlM0QlNUIlMjJub3JtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbm9uX2Jsb2NraW5nJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_layerwise_casting

transformer = CogVideoXTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># skip the normalization layer</span>
apply_layerwise_casting(
    transformer,
    storage_dtype=torch.float8_e4m3fn,
    compute_dtype=torch.bfloat16,
    skip_modules_classes=[<span class="hljs-string">&quot;norm&quot;</span>],
    non_blocking=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Se=new U({props:{title:"torch.channels_last",local:"torchchannelslast",headingTag:"h2"}}),Ae=new w({props:{code:"cHJpbnQocGlwZWxpbmUudW5ldC5jb252X291dC5zdGF0ZV9kaWN0KCklNUIlMjJ3ZWlnaHQlMjIlNUQuc3RyaWRlKCkpJTIwJTIwJTIzJTIwKDI4ODAlMkMlMjA5JTJDJTIwMyUyQyUyMDEpJTBBcGlwZWxpbmUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMjAlMjAlMjMlMjBpbi1wbGFjZSUyMG9wZXJhdGlvbiUwQXByaW50KCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipeline.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipeline.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),qe=new U({props:{title:"torch.jit.trace",local:"torchjittrace",headingTag:"h2"}}),De=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>

<span class="hljs-comment"># load sample inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipeline.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)

<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)

<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),Ke=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTIzJTIwZGVsJTIwcGlwZWxpbmUudW5ldCUwQWNsYXNzJTIwVHJhY2VkVU5ldCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluX2NoYW5uZWxzJTIwJTNEJTIwcGlwZS51bmV0LmNvbmZpZy5pbl9jaGFubmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGV2aWNlJTIwJTNEJTIwcGlwZS51bmV0LmRldmljZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwdW5ldF90cmFjZWQobGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwVU5ldDJEQ29uZGl0aW9uT3V0cHV0KHNhbXBsZSUzRHNhbXBsZSklMEElMEFwaXBlbGluZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)

<span class="hljs-comment"># del pipeline.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)

pipeline.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Oe=new U({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),k=new g({props:{warning:!1,$$slots:{default:[ma]},$$scope:{ctx:T}}}),al=new w({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHhmb3JtZXJzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-comment"># pip install xformers</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),il=new w({props:{code:"cGlwZWxpbmUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:"pipeline.disable_xformers_memory_efficient_attention()",wrap:!1}}),ol=new la({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){i=o("meta"),h=a(),r=o("p"),J=a(),c(Z.$$.fragment),b=a(),j=o("p"),j.innerHTML=Fs,rl=a(),X=o("p"),X.textContent=As,ml=a(),c(G.$$.fragment),cl=a(),c(R.$$.fragment),dl=a(),x=o("p"),x.innerHTML=qs,ul=a(),c(Y.$$.fragment),fl=a(),c(Q.$$.fragment),Ml=a(),H=o("p"),H.textContent=Ls,yl=a(),N=o("p"),N.innerHTML=Ds,hl=a(),c(E.$$.fragment),Jl=a(),S=o("p"),S.textContent=Ps,wl=a(),c(z.$$.fragment),Tl=a(),c(F.$$.fragment),bl=a(),c(_.$$.fragment),Ul=a(),A=o("p"),A.innerHTML=Ks,jl=a(),c(q.$$.fragment),Zl=a(),L=o("p"),L.innerHTML=Os,gl=a(),c(D.$$.fragment),Il=a(),P=o("p"),P.innerHTML=et,Gl=a(),c(K.$$.fragment),_l=a(),O=o("p"),O.innerHTML=lt,vl=a(),c(ee.$$.fragment),Wl=a(),le=o("p"),le.textContent=st,Cl=a(),se=o("ul"),se.innerHTML=tt,Bl=a(),te=o("p"),te.innerHTML=at,Vl=a(),c(ae.$$.fragment),$l=a(),c(ne.$$.fragment),kl=a(),ie=o("p"),ie.textContent=nt,Xl=a(),oe=o("p"),oe.textContent=it,Rl=a(),pe=o("p"),pe.innerHTML=ot,xl=a(),c(re.$$.fragment),Yl=a(),me=o("blockquote"),me.innerHTML=pt,Ql=a(),c(ce.$$.fragment),Hl=a(),de=o("p"),de.textContent=rt,Nl=a(),ue=o("p"),ue.innerHTML=mt,El=a(),c(fe.$$.fragment),Sl=a(),Me=o("blockquote"),Me.innerHTML=ct,zl=a(),c(ye.$$.fragment),Fl=a(),he=o("p"),he.textContent=dt,Al=a(),Je=o("p"),Je.innerHTML=ut,ql=a(),c(v.$$.fragment),Ll=a(),we=o("p"),we.innerHTML=ft,Dl=a(),c(Te.$$.fragment),Pl=a(),c(be.$$.fragment),Kl=a(),Ue=o("p"),Ue.innerHTML=Mt,Ol=a(),c(W.$$.fragment),es=a(),je=o("p"),je.innerHTML=yt,ls=a(),c(Ze.$$.fragment),ss=a(),ge=o("p"),ge.innerHTML=ht,ts=a(),c(Ie.$$.fragment),as=a(),Ge=o("p"),Ge.innerHTML=Jt,ns=a(),c(C.$$.fragment),is=a(),_e=o("p"),_e.innerHTML=wt,os=a(),ve=o("p"),ve.innerHTML=Tt,ps=a(),We=o("ul"),We.innerHTML=bt,rs=a(),c(Ce.$$.fragment),ms=a(),c(Be.$$.fragment),cs=a(),Ve=o("p"),Ve.innerHTML=Ut,ds=a(),$e=o("p"),$e.innerHTML=jt,us=a(),c(B.$$.fragment),fs=a(),ke=o("p"),ke.innerHTML=Zt,Ms=a(),c(Xe.$$.fragment),ys=a(),Re=o("p"),Re.innerHTML=gt,hs=a(),c(V.$$.fragment),Js=a(),c(xe.$$.fragment),ws=a(),Ye=o("p"),Ye.innerHTML=It,Ts=a(),c($.$$.fragment),bs=a(),Qe=o("p"),Qe.innerHTML=Gt,Us=a(),c(He.$$.fragment),js=a(),Ne=o("p"),Ne.innerHTML=_t,Zs=a(),c(Ee.$$.fragment),gs=a(),c(Se.$$.fragment),Is=a(),ze=o("p"),ze.innerHTML=vt,Gs=a(),Fe=o("p"),Fe.textContent=Wt,_s=a(),c(Ae.$$.fragment),vs=a(),c(qe.$$.fragment),Ws=a(),Le=o("p"),Le.innerHTML=Ct,Cs=a(),c(De.$$.fragment),Bs=a(),Pe=o("p"),Pe.textContent=Bt,Vs=a(),c(Ke.$$.fragment),$s=a(),c(Oe.$$.fragment),ks=a(),c(k.$$.fragment),Xs=a(),el=o("p"),el.textContent=Vt,Rs=a(),ll=o("p"),ll.innerHTML=$t,xs=a(),sl=o("p"),sl.innerHTML=kt,Ys=a(),tl=o("p"),tl.innerHTML=Xt,Qs=a(),c(al.$$.fragment),Hs=a(),nl=o("p"),nl.innerHTML=Rt,Ns=a(),c(il.$$.fragment),Es=a(),c(ol.$$.fragment),Ss=a(),pl=o("p"),this.h()},l(e){const l=Ot("svelte-u9bgzb",document.head);i=p(l,"META",{name:!0,content:!0}),l.forEach(s),h=n(e),r=p(e,"P",{}),At(r).forEach(s),J=n(e),d(Z.$$.fragment,e),b=n(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-11rtgo9"&&(j.innerHTML=Fs),rl=n(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-vxpcfq"&&(X.textContent=As),ml=n(e),d(G.$$.fragment,e),cl=n(e),d(R.$$.fragment,e),dl=n(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-646d08"&&(x.innerHTML=qs),ul=n(e),d(Y.$$.fragment,e),fl=n(e),d(Q.$$.fragment,e),Ml=n(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-z6beln"&&(H.textContent=Ls),yl=n(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-115ttl4"&&(N.innerHTML=Ds),hl=n(e),d(E.$$.fragment,e),Jl=n(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1f9wrc7"&&(S.textContent=Ps),wl=n(e),d(z.$$.fragment,e),Tl=n(e),d(F.$$.fragment,e),bl=n(e),d(_.$$.fragment,e),Ul=n(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-12t6vua"&&(A.innerHTML=Ks),jl=n(e),d(q.$$.fragment,e),Zl=n(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-cfrzyx"&&(L.innerHTML=Os),gl=n(e),d(D.$$.fragment,e),Il=n(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-5t2lvk"&&(P.innerHTML=et),Gl=n(e),d(K.$$.fragment,e),_l=n(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1tsnyo7"&&(O.innerHTML=lt),vl=n(e),d(ee.$$.fragment,e),Wl=n(e),le=p(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-whoqae"&&(le.textContent=st),Cl=n(e),se=p(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-5cwvqn"&&(se.innerHTML=tt),Bl=n(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-6e1s7a"&&(te.innerHTML=at),Vl=n(e),d(ae.$$.fragment,e),$l=n(e),d(ne.$$.fragment,e),kl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-d36gg7"&&(ie.textContent=nt),Xl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-5ay0zr"&&(oe.textContent=it),Rl=n(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1cuj0ld"&&(pe.innerHTML=ot),xl=n(e),d(re.$$.fragment,e),Yl=n(e),me=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),m(me)!=="svelte-p6iru5"&&(me.innerHTML=pt),Ql=n(e),d(ce.$$.fragment,e),Hl=n(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-vsq5zh"&&(de.textContent=rt),Nl=n(e),ue=p(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-a79yk8"&&(ue.innerHTML=mt),El=n(e),d(fe.$$.fragment,e),Sl=n(e),Me=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Me)!=="svelte-1ch13xh"&&(Me.innerHTML=ct),zl=n(e),d(ye.$$.fragment,e),Fl=n(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-nwk8qi"&&(he.textContent=dt),Al=n(e),Je=p(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1jssif2"&&(Je.innerHTML=ut),ql=n(e),d(v.$$.fragment,e),Ll=n(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-vdp76n"&&(we.innerHTML=ft),Dl=n(e),d(Te.$$.fragment,e),Pl=n(e),d(be.$$.fragment,e),Kl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-lwbzkf"&&(Ue.innerHTML=Mt),Ol=n(e),d(W.$$.fragment,e),es=n(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-t552fb"&&(je.innerHTML=yt),ls=n(e),d(Ze.$$.fragment,e),ss=n(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1ic7r11"&&(ge.innerHTML=ht),ts=n(e),d(Ie.$$.fragment,e),as=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-6x5rs4"&&(Ge.innerHTML=Jt),ns=n(e),d(C.$$.fragment,e),is=n(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-u1fru0"&&(_e.innerHTML=wt),os=n(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1agvgw7"&&(ve.innerHTML=Tt),ps=n(e),We=p(e,"UL",{"data-svelte-h":!0}),m(We)!=="svelte-8dkla6"&&(We.innerHTML=bt),rs=n(e),d(Ce.$$.fragment,e),ms=n(e),d(Be.$$.fragment,e),cs=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1ik3m1u"&&(Ve.innerHTML=Ut),ds=n(e),$e=p(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-f4wc5s"&&($e.innerHTML=jt),us=n(e),d(B.$$.fragment,e),fs=n(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-17oamma"&&(ke.innerHTML=Zt),Ms=n(e),d(Xe.$$.fragment,e),ys=n(e),Re=p(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1ixqgvf"&&(Re.innerHTML=gt),hs=n(e),d(V.$$.fragment,e),Js=n(e),d(xe.$$.fragment,e),ws=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1boiobn"&&(Ye.innerHTML=It),Ts=n(e),d($.$$.fragment,e),bs=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-19ytv0"&&(Qe.innerHTML=Gt),Us=n(e),d(He.$$.fragment,e),js=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1hmx68j"&&(Ne.innerHTML=_t),Zs=n(e),d(Ee.$$.fragment,e),gs=n(e),d(Se.$$.fragment,e),Is=n(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1tu261v"&&(ze.innerHTML=vt),Gs=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-dfwok5"&&(Fe.textContent=Wt),_s=n(e),d(Ae.$$.fragment,e),vs=n(e),d(qe.$$.fragment,e),Ws=n(e),Le=p(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-15jhfav"&&(Le.innerHTML=Ct),Cs=n(e),d(De.$$.fragment,e),Bs=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-16t9h37"&&(Pe.textContent=Bt),Vs=n(e),d(Ke.$$.fragment,e),$s=n(e),d(Oe.$$.fragment,e),ks=n(e),d(k.$$.fragment,e),Xs=n(e),el=p(e,"P",{"data-svelte-h":!0}),m(el)!=="svelte-8q1sue"&&(el.textContent=Vt),Rs=n(e),ll=p(e,"P",{"data-svelte-h":!0}),m(ll)!=="svelte-1idpc42"&&(ll.innerHTML=$t),xs=n(e),sl=p(e,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-4p44md"&&(sl.innerHTML=kt),Ys=n(e),tl=p(e,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-u62ci7"&&(tl.innerHTML=Xt),Qs=n(e),d(al.$$.fragment,e),Hs=n(e),nl=p(e,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-p2p9rw"&&(nl.innerHTML=Rt),Ns=n(e),d(il.$$.fragment,e),Es=n(e),d(ol.$$.fragment,e),Ss=n(e),pl=p(e,"P",{}),At(pl).forEach(s),this.h()},h(){qt(i,"name","hf:doc:metadata"),qt(i,"content",da)},m(e,l){ea(document.head,i),t(e,h,l),t(e,r,l),t(e,J,l),u(Z,e,l),t(e,b,l),t(e,j,l),t(e,rl,l),t(e,X,l),t(e,ml,l),u(G,e,l),t(e,cl,l),u(R,e,l),t(e,dl,l),t(e,x,l),t(e,ul,l),u(Y,e,l),t(e,fl,l),u(Q,e,l),t(e,Ml,l),t(e,H,l),t(e,yl,l),t(e,N,l),t(e,hl,l),u(E,e,l),t(e,Jl,l),t(e,S,l),t(e,wl,l),u(z,e,l),t(e,Tl,l),u(F,e,l),t(e,bl,l),u(_,e,l),t(e,Ul,l),t(e,A,l),t(e,jl,l),u(q,e,l),t(e,Zl,l),t(e,L,l),t(e,gl,l),u(D,e,l),t(e,Il,l),t(e,P,l),t(e,Gl,l),u(K,e,l),t(e,_l,l),t(e,O,l),t(e,vl,l),u(ee,e,l),t(e,Wl,l),t(e,le,l),t(e,Cl,l),t(e,se,l),t(e,Bl,l),t(e,te,l),t(e,Vl,l),u(ae,e,l),t(e,$l,l),u(ne,e,l),t(e,kl,l),t(e,ie,l),t(e,Xl,l),t(e,oe,l),t(e,Rl,l),t(e,pe,l),t(e,xl,l),u(re,e,l),t(e,Yl,l),t(e,me,l),t(e,Ql,l),u(ce,e,l),t(e,Hl,l),t(e,de,l),t(e,Nl,l),t(e,ue,l),t(e,El,l),u(fe,e,l),t(e,Sl,l),t(e,Me,l),t(e,zl,l),u(ye,e,l),t(e,Fl,l),t(e,he,l),t(e,Al,l),t(e,Je,l),t(e,ql,l),u(v,e,l),t(e,Ll,l),t(e,we,l),t(e,Dl,l),u(Te,e,l),t(e,Pl,l),u(be,e,l),t(e,Kl,l),t(e,Ue,l),t(e,Ol,l),u(W,e,l),t(e,es,l),t(e,je,l),t(e,ls,l),u(Ze,e,l),t(e,ss,l),t(e,ge,l),t(e,ts,l),u(Ie,e,l),t(e,as,l),t(e,Ge,l),t(e,ns,l),u(C,e,l),t(e,is,l),t(e,_e,l),t(e,os,l),t(e,ve,l),t(e,ps,l),t(e,We,l),t(e,rs,l),u(Ce,e,l),t(e,ms,l),u(Be,e,l),t(e,cs,l),t(e,Ve,l),t(e,ds,l),t(e,$e,l),t(e,us,l),u(B,e,l),t(e,fs,l),t(e,ke,l),t(e,Ms,l),u(Xe,e,l),t(e,ys,l),t(e,Re,l),t(e,hs,l),u(V,e,l),t(e,Js,l),u(xe,e,l),t(e,ws,l),t(e,Ye,l),t(e,Ts,l),u($,e,l),t(e,bs,l),t(e,Qe,l),t(e,Us,l),u(He,e,l),t(e,js,l),t(e,Ne,l),t(e,Zs,l),u(Ee,e,l),t(e,gs,l),u(Se,e,l),t(e,Is,l),t(e,ze,l),t(e,Gs,l),t(e,Fe,l),t(e,_s,l),u(Ae,e,l),t(e,vs,l),u(qe,e,l),t(e,Ws,l),t(e,Le,l),t(e,Cs,l),u(De,e,l),t(e,Bs,l),t(e,Pe,l),t(e,Vs,l),u(Ke,e,l),t(e,$s,l),u(Oe,e,l),t(e,ks,l),u(k,e,l),t(e,Xs,l),t(e,el,l),t(e,Rs,l),t(e,ll,l),t(e,xs,l),t(e,sl,l),t(e,Ys,l),t(e,tl,l),t(e,Qs,l),u(al,e,l),t(e,Hs,l),t(e,nl,l),t(e,Ns,l),u(il,e,l),t(e,Es,l),u(ol,e,l),t(e,Ss,l),t(e,pl,l),zs=!0},p(e,[l]){const xt={};l&2&&(xt.$$scope={dirty:l,ctx:e}),G.$set(xt);const Yt={};l&2&&(Yt.$$scope={dirty:l,ctx:e}),_.$set(Yt);const Qt={};l&2&&(Qt.$$scope={dirty:l,ctx:e}),v.$set(Qt);const Ht={};l&2&&(Ht.$$scope={dirty:l,ctx:e}),W.$set(Ht);const Nt={};l&2&&(Nt.$$scope={dirty:l,ctx:e}),C.$set(Nt);const Et={};l&2&&(Et.$$scope={dirty:l,ctx:e}),B.$set(Et);const St={};l&2&&(St.$$scope={dirty:l,ctx:e}),V.$set(St);const zt={};l&2&&(zt.$$scope={dirty:l,ctx:e}),$.$set(zt);const Ft={};l&2&&(Ft.$$scope={dirty:l,ctx:e}),k.$set(Ft)},i(e){zs||(f(Z.$$.fragment,e),f(G.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),f(Q.$$.fragment,e),f(E.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(_.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(v.$$.fragment,e),f(Te.$$.fragment,e),f(be.$$.fragment,e),f(W.$$.fragment,e),f(Ze.$$.fragment,e),f(Ie.$$.fragment,e),f(C.$$.fragment,e),f(Ce.$$.fragment,e),f(Be.$$.fragment,e),f(B.$$.fragment,e),f(Xe.$$.fragment,e),f(V.$$.fragment,e),f(xe.$$.fragment,e),f($.$$.fragment,e),f(He.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(qe.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(Oe.$$.fragment,e),f(k.$$.fragment,e),f(al.$$.fragment,e),f(il.$$.fragment,e),f(ol.$$.fragment,e),zs=!0)},o(e){M(Z.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(E.$$.fragment,e),M(z.$$.fragment,e),M(F.$$.fragment,e),M(_.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(ae.$$.fragment,e),M(ne.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(v.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(W.$$.fragment,e),M(Ze.$$.fragment,e),M(Ie.$$.fragment,e),M(C.$$.fragment,e),M(Ce.$$.fragment,e),M(Be.$$.fragment,e),M(B.$$.fragment,e),M(Xe.$$.fragment,e),M(V.$$.fragment,e),M(xe.$$.fragment,e),M($.$$.fragment,e),M(He.$$.fragment,e),M(Ee.$$.fragment,e),M(Se.$$.fragment,e),M(Ae.$$.fragment,e),M(qe.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(Oe.$$.fragment,e),M(k.$$.fragment,e),M(al.$$.fragment,e),M(il.$$.fragment,e),M(ol.$$.fragment,e),zs=!1},d(e){e&&(s(h),s(r),s(J),s(b),s(j),s(rl),s(X),s(ml),s(cl),s(dl),s(x),s(ul),s(fl),s(Ml),s(H),s(yl),s(N),s(hl),s(Jl),s(S),s(wl),s(Tl),s(bl),s(Ul),s(A),s(jl),s(Zl),s(L),s(gl),s(Il),s(P),s(Gl),s(_l),s(O),s(vl),s(Wl),s(le),s(Cl),s(se),s(Bl),s(te),s(Vl),s($l),s(kl),s(ie),s(Xl),s(oe),s(Rl),s(pe),s(xl),s(Yl),s(me),s(Ql),s(Hl),s(de),s(Nl),s(ue),s(El),s(Sl),s(Me),s(zl),s(Fl),s(he),s(Al),s(Je),s(ql),s(Ll),s(we),s(Dl),s(Pl),s(Kl),s(Ue),s(Ol),s(es),s(je),s(ls),s(ss),s(ge),s(ts),s(as),s(Ge),s(ns),s(is),s(_e),s(os),s(ve),s(ps),s(We),s(rs),s(ms),s(cs),s(Ve),s(ds),s($e),s(us),s(fs),s(ke),s(Ms),s(ys),s(Re),s(hs),s(Js),s(ws),s(Ye),s(Ts),s(bs),s(Qe),s(Us),s(js),s(Ne),s(Zs),s(gs),s(Is),s(ze),s(Gs),s(Fe),s(_s),s(vs),s(Ws),s(Le),s(Cs),s(Bs),s(Pe),s(Vs),s($s),s(ks),s(Xs),s(el),s(Rs),s(ll),s(xs),s(sl),s(Ys),s(tl),s(Qs),s(Hs),s(nl),s(Ns),s(Es),s(Ss),s(pl)),s(i),y(Z,e),y(G,e),y(R,e),y(Y,e),y(Q,e),y(E,e),y(z,e),y(F,e),y(_,e),y(q,e),y(D,e),y(K,e),y(ee,e),y(ae,e),y(ne,e),y(re,e),y(ce,e),y(fe,e),y(ye,e),y(v,e),y(Te,e),y(be,e),y(W,e),y(Ze,e),y(Ie,e),y(C,e),y(Ce,e),y(Be,e),y(B,e),y(Xe,e),y(V,e),y(xe,e),y($,e),y(He,e),y(Ee,e),y(Se,e),y(Ae,e),y(qe,e),y(De,e),y(Ke,e),y(Oe,e),y(k,e),y(al,e),y(il,e),y(ol,e)}}}const da='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Multiple GPUs","local":"multiple-gpus","sections":[{"title":"Sharded checkpoints","local":"sharded-checkpoints","sections":[],"depth":3},{"title":"Device placement","local":"device-placement","sections":[],"depth":3}],"depth":2},{"title":"VAE slicing","local":"vae-slicing","sections":[],"depth":2},{"title":"VAE tiling","local":"vae-tiling","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Group offloading","local":"group-offloading","sections":[{"title":"CUDA stream","local":"cuda-stream","sections":[],"depth":3}],"depth":2},{"title":"Layerwise casting","local":"layerwise-casting","sections":[],"depth":2},{"title":"torch.channels_last","local":"torchchannelslast","sections":[],"depth":2},{"title":"torch.jit.trace","local":"torchjittrace","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function ua(T){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends Pt{constructor(i){super(),Kt(this,i,ua,ca,Lt,{})}}export{wa as component};
